/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.context.airules.context;

import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.context.airules.AiRulesLLMBundle;
import com.intellij.ml.llm.context.airules.context.AiRuleChatAttachment;
import com.intellij.ml.llm.context.airules.context.AiRuleContextAttachmentKt;
import com.intellij.ml.llm.context.airules.context.AiRuleContextSource;
import com.intellij.ml.llm.context.airules.metadata.AiRuleType;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentBase;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ProjectFileContextEntity;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010 \u001a\u0004\u0018\u00010!H\u0096@\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\n\u00100\u001a\u0004\u0018\u00010\u0006H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0015R\u0014\u0010'\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u001aR\u0014\u0010,\u001a\u00020-X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u00061"}, d2={"Lcom/intellij/ml/llm/context/airules/context/AiRuleContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentBase;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ProjectFileContextEntity;", "project", "Lcom/intellij/openapi/project/Project;", "aiRuleFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "content", "Lcom/intellij/ml/llm/privacy/PSString;", "ruleType", "Lcom/intellij/ml/llm/context/airules/metadata/AiRuleType;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/context/airules/metadata/AiRuleType;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRuleType", "()Lcom/intellij/ml/llm/context/airules/metadata/AiRuleType;", "name", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "", "getName", "()Lcom/intellij/openapi/observable/properties/ObservableProperty;", "hint", "getHint", "tooltipText", "getTooltipText", "()Ljava/lang/String;", "popupPresentationText", "getPopupPresentationText", "icon", "Ljavax/swing/Icon;", "getIcon", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performAction", "", "isInMessage", "", "text", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "id", "getId", "attachedBy", "Lcom/intellij/ml/llm/context/ContextEntitySource;", "getAttachedBy", "()Lcom/intellij/ml/llm/context/ContextEntitySource;", "virtualFile", "intellij.ml.llm.context.airules"})
public final class AiRuleContextAttachment
extends ContextAttachmentBase
implements ProjectFileContextEntity {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile aiRuleFile;
    @NotNull
    private final PSString content;
    @NotNull
    private final AiRuleType ruleType;
    @NotNull
    private final ObservableProperty<String> name;
    @Nullable
    private final ObservableProperty<String> hint;
    @NotNull
    private final String tooltipText;
    @NotNull
    private final String popupPresentationText;
    @NotNull
    private final ObservableProperty<Icon> icon;
    @NotNull
    private final PSString text;
    @NotNull
    private final String id;
    @NotNull
    private final ContextEntitySource attachedBy;

    public AiRuleContextAttachment(@NotNull Project project2, @NotNull VirtualFile aiRuleFile, @NotNull PSString content2, @NotNull AiRuleType ruleType2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)aiRuleFile, (String)"aiRuleFile");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)((Object)ruleType2), (String)"ruleType");
        this.project = project2;
        this.aiRuleFile = aiRuleFile;
        this.content = content2;
        this.ruleType = ruleType2;
        this.name = (ObservableProperty)new AtomicProperty((Object)this.aiRuleFile.getName());
        this.hint = (ObservableProperty)new AtomicProperty((Object)AiRulesLLMBundle.message("ai.rule.attachment.hint", new Object[0]));
        this.tooltipText = AiRuleContextAttachmentKt.removeProjectPrefix(this.getProject(), this.aiRuleFile);
        String string = this.aiRuleFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.popupPresentationText = string;
        this.icon = (ObservableProperty)new AtomicProperty((Object)VirtualFilePresentation.getIcon((VirtualFile)this.aiRuleFile));
        this.text = this.content;
        String string2 = this.aiRuleFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        this.id = string2;
        this.attachedBy = (ContextEntitySource)((Object)new AiRuleContextSource(this.ruleType.retrieverType()));
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final AiRuleType getRuleType() {
        return this.ruleType;
    }

    @NotNull
    public ObservableProperty<String> getName() {
        return this.name;
    }

    @Nullable
    public ObservableProperty<String> getHint() {
        return this.hint;
    }

    @NotNull
    public String getTooltipText() {
        return this.tooltipText;
    }

    @NotNull
    public String getPopupPresentationText() {
        return this.popupPresentationText;
    }

    @NotNull
    public ObservableProperty<Icon> getIcon() {
        return this.icon;
    }

    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        return new AiRuleChatAttachment(this.getProject(), this.aiRuleFile, this.content, this.ruleType);
    }

    public void performAction(boolean isInMessage) {
        VirtualFile virtualFile2 = this.virtualFile();
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile file = virtualFile2;
        if (file.isValid()) {
            FileEditorManager.getInstance((Project)this.getProject()).openFile(file, true);
        }
    }

    @NotNull
    public PSString getText() {
        return this.text;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public ContextEntitySource getAttachedBy() {
        return this.attachedBy;
    }

    @Nullable
    public VirtualFile virtualFile() {
        return this.aiRuleFile;
    }
}

