/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.handler.provider.caches;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.ml.llm.daemon.insight.handler.InsightModel;
import com.intellij.ml.llm.daemon.insight.handler.request.InsightRequest;
import com.intellij.ml.llm.daemon.insight.handler.request.InsightWorkingRange;
import com.intellij.openapi.util.text.StringsKmp;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0003\u0017\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\nJ\u001c\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0006\u0010\u0016\u001a\u00020\u0014R$\u0010\u0004\u001a\u0018\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/provider/caches/InsightsSameFileCache;", "", "<init>", "()V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/ml/llm/daemon/insight/handler/provider/caches/InsightsSameFileCache$Value;", "createKey", "Lcom/intellij/ml/llm/daemon/insight/handler/provider/caches/InsightsSameFileCache$Key;", "request", "Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightRequest;", "getIfFullyCovered", "", "Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;", "key", "getPartial", "Lcom/intellij/ml/llm/daemon/insight/handler/provider/caches/InsightsSameFileCache$Partial;", "put", "", "newModels", "clear", "Key", "Value", "Partial", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nInsightsSameFileCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightsSameFileCache.kt\ncom/intellij/ml/llm/daemon/insight/handler/provider/caches/InsightsSameFileCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class InsightsSameFileCache {
    @NotNull
    private final Cache<Integer, Value> cache;

    public InsightsSameFileCache() {
        Cache cache = Caffeine.newBuilder().maximumSize(10L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.cache = cache;
    }

    @RequiresReadLock
    @NotNull
    public final Key createKey(@NotNull InsightRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        CharSequence charSequence = request2.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        return new Key(StringsKmp.stringHashCode((CharSequence)charSequence), request2.getWorkingRange());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final List<InsightModel> getIfFullyCovered(@NotNull Key key) {
        Value value2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Value value3 = (Value)this.cache.getIfPresent((Object)key.getHashcode());
        Value value4 = value3;
        if (value3 == null) return null;
        Value it = value2 = value4;
        boolean bl = false;
        if (!it.findUnmatched(key.getWorkingRange()).isEmpty()) return null;
        Value value5 = value2;
        value4 = value5;
        if (value5 == null) return null;
        List<InsightModel> list = value4.getModels();
        return list;
    }

    @NotNull
    public final Partial getPartial(@NotNull Key key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Value value2 = (Value)this.cache.getIfPresent((Object)key.getHashcode());
        if (value2 == null) {
            value2 = new Value(CollectionsKt.emptyList(), CollectionsKt.emptyList());
        }
        Value value3 = value2;
        return new Partial(value3.getModels(), value3.findUnmatched(key.getWorkingRange()));
    }

    public final void put(@NotNull Key key, @NotNull List<InsightModel> newModels) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(newModels, (String)"newModels");
        this.cache.asMap().merge(key.getHashcode(), new Value(newModels, CollectionsKt.listOf((Object)key.getWorkingRange())), (arg_0, arg_1) -> InsightsSameFileCache.put$lambda$2(InsightsSameFileCache::put$lambda$1, arg_0, arg_1));
    }

    public final void clear() {
        this.cache.invalidateAll();
    }

    private static final Value put$lambda$1(Value old, Value value2) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"new");
        return new Value(CollectionsKt.plus((Collection)old.getModels(), (Iterable)value2.getModels()), CollectionsKt.takeLast((List)CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)old.getRanges(), (Iterable)value2.getRanges())), (int)50));
    }

    private static final Value put$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return (Value)$tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/provider/caches/InsightsSameFileCache$Key;", "", "hashcode", "", "workingRange", "Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightWorkingRange;", "<init>", "(ILcom/intellij/ml/llm/daemon/insight/handler/request/InsightWorkingRange;)V", "getHashcode", "()I", "getWorkingRange", "()Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightWorkingRange;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.ml.llm.daemon"})
    public static final class Key {
        private final int hashcode;
        @NotNull
        private final InsightWorkingRange workingRange;

        public Key(int hashcode, @NotNull InsightWorkingRange workingRange) {
            Intrinsics.checkNotNullParameter((Object)workingRange, (String)"workingRange");
            this.hashcode = hashcode;
            this.workingRange = workingRange;
        }

        public final int getHashcode() {
            return this.hashcode;
        }

        @NotNull
        public final InsightWorkingRange getWorkingRange() {
            return this.workingRange;
        }

        public final int component1() {
            return this.hashcode;
        }

        @NotNull
        public final InsightWorkingRange component2() {
            return this.workingRange;
        }

        @NotNull
        public final Key copy(int hashcode, @NotNull InsightWorkingRange workingRange) {
            Intrinsics.checkNotNullParameter((Object)workingRange, (String)"workingRange");
            return new Key(hashcode, workingRange);
        }

        public static /* synthetic */ Key copy$default(Key key, int n, InsightWorkingRange insightWorkingRange, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = key.hashcode;
            }
            if ((n2 & 2) != 0) {
                insightWorkingRange = key.workingRange;
            }
            return key.copy(n, insightWorkingRange);
        }

        @NotNull
        public String toString() {
            return "Key(hashcode=" + this.hashcode + ", workingRange=" + this.workingRange + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.hashcode);
            result2 = result2 * 31 + this.workingRange.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key key = (Key)other;
            if (this.hashcode != key.hashcode) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.workingRange, (Object)key.workingRange);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/provider/caches/InsightsSameFileCache$Partial;", "", "covered", "", "Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;", "unmatched", "", "", "<init>", "(Ljava/util/List;Ljava/util/Set;)V", "getCovered", "()Ljava/util/List;", "getUnmatched", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.ml.llm.daemon"})
    public static final class Partial {
        @NotNull
        private final List<InsightModel> covered;
        @NotNull
        private final Set<Integer> unmatched;

        public Partial(@NotNull List<InsightModel> covered, @NotNull Set<Integer> unmatched) {
            Intrinsics.checkNotNullParameter(covered, (String)"covered");
            Intrinsics.checkNotNullParameter(unmatched, (String)"unmatched");
            this.covered = covered;
            this.unmatched = unmatched;
        }

        @NotNull
        public final List<InsightModel> getCovered() {
            return this.covered;
        }

        @NotNull
        public final Set<Integer> getUnmatched() {
            return this.unmatched;
        }

        @NotNull
        public final List<InsightModel> component1() {
            return this.covered;
        }

        @NotNull
        public final Set<Integer> component2() {
            return this.unmatched;
        }

        @NotNull
        public final Partial copy(@NotNull List<InsightModel> covered, @NotNull Set<Integer> unmatched) {
            Intrinsics.checkNotNullParameter(covered, (String)"covered");
            Intrinsics.checkNotNullParameter(unmatched, (String)"unmatched");
            return new Partial(covered, unmatched);
        }

        public static /* synthetic */ Partial copy$default(Partial partial, List list, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                list = partial.covered;
            }
            if ((n & 2) != 0) {
                set = partial.unmatched;
            }
            return partial.copy(list, set);
        }

        @NotNull
        public String toString() {
            return "Partial(covered=" + this.covered + ", unmatched=" + this.unmatched + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.covered).hashCode();
            result2 = result2 * 31 + ((Object)this.unmatched).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Partial)) {
                return false;
            }
            Partial partial = (Partial)other;
            if (!Intrinsics.areEqual(this.covered, partial.covered)) {
                return false;
            }
            return Intrinsics.areEqual(this.unmatched, partial.unmatched);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0006J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/provider/caches/InsightsSameFileCache$Value;", "", "models", "", "Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;", "ranges", "Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightWorkingRange;", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getModels", "()Ljava/util/List;", "getRanges", "findUnmatched", "", "", "range", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.ml.llm.daemon"})
    @SourceDebugExtension(value={"SMAP\nInsightsSameFileCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightsSameFileCache.kt\ncom/intellij/ml/llm/daemon/insight/handler/provider/caches/InsightsSameFileCache$Value\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n827#2:70\n855#2:71\n1761#2,3:72\n856#2:75\n*S KotlinDebug\n*F\n+ 1 InsightsSameFileCache.kt\ncom/intellij/ml/llm/daemon/insight/handler/provider/caches/InsightsSameFileCache$Value\n*L\n26#1:70\n26#1:71\n26#1:72,3\n26#1:75\n*E\n"})
    private static final class Value {
        @NotNull
        private final List<InsightModel> models;
        @NotNull
        private final List<InsightWorkingRange> ranges;

        public Value(@NotNull List<InsightModel> models, @NotNull List<InsightWorkingRange> ranges) {
            Intrinsics.checkNotNullParameter(models, (String)"models");
            Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
            this.models = models;
            this.ranges = ranges;
        }

        @NotNull
        public final List<InsightModel> getModels() {
            return this.models;
        }

        @NotNull
        public final List<InsightWorkingRange> getRanges() {
            return this.ranges;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<Integer> findUnmatched(@NotNull InsightWorkingRange range) {
            void $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Iterable $this$filterNot$iv = (Iterable)RangesKt.until((int)range.getFirstLine(), (int)range.getLastLine());
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                boolean bl;
                block4: {
                    int line = ((Number)element$iv$iv).intValue();
                    boolean bl2 = false;
                    Iterable $this$any$iv = this.ranges;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            InsightWorkingRange it = (InsightWorkingRange)element$iv;
                            boolean bl3 = false;
                            if (!it.containsLine(line)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        @NotNull
        public final List<InsightModel> component1() {
            return this.models;
        }

        @NotNull
        public final List<InsightWorkingRange> component2() {
            return this.ranges;
        }

        @NotNull
        public final Value copy(@NotNull List<InsightModel> models, @NotNull List<InsightWorkingRange> ranges) {
            Intrinsics.checkNotNullParameter(models, (String)"models");
            Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
            return new Value(models, ranges);
        }

        public static /* synthetic */ Value copy$default(Value value2, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = value2.models;
            }
            if ((n & 2) != 0) {
                list2 = value2.ranges;
            }
            return value2.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "Value(models=" + this.models + ", ranges=" + this.ranges + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.models).hashCode();
            result2 = result2 * 31 + ((Object)this.ranges).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Value)) {
                return false;
            }
            Value value2 = (Value)other;
            if (!Intrinsics.areEqual(this.models, value2.models)) {
                return false;
            }
            return Intrinsics.areEqual(this.ranges, value2.ranges);
        }
    }
}

