/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.domains.context;

import com.intellij.ml.llm.privacy.aiignore.AiIgnoreManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u0000 &2\u00020\u0001:\u0002%&B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003J\"\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u00032\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0010J\u001c\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u00032\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u0013J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000J\u001a\u0010\u001b\u001a\u00020\u00002\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0010J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010#\u001a\u00020$H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR)\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00100\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR#\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00130\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00000\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00000\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018\u00a8\u0006'"}, d2={"Lcom/intellij/ml/llm/domains/context/DomainItemContext;", "", "type", "", "id", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getType", "()Ljava/lang/String;", "getId", "genericProperties", "", "properties", "getProperties", "()Ljava/util/Map;", "mapProperties", "", "getMapProperties", "setProperties", "", "getSetProperties", "associatedContexts", "", "getAssociatedContexts", "()Ljava/util/Set;", "dependentContexts", "getDependentContexts", "with", "property", "value", "associatedContext", "withDependent", "equals", "", "other", "hashCode", "", "DomainItemPsiContext", "Companion", "intellij.ml.llm.domains"})
public class DomainItemContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String type;
    @NotNull
    private final String id;
    @NotNull
    private final Map<String, Object> genericProperties;
    @NotNull
    private final Map<String, String> properties;
    @NotNull
    private final Map<String, Map<String, String>> mapProperties;
    @NotNull
    private final Map<String, Set<Object>> setProperties;
    @NotNull
    private final Set<DomainItemContext> associatedContexts;
    @NotNull
    private final Set<DomainItemContext> dependentContexts;
    @JvmField
    @NotNull
    public static final DomainItemContext EMPTY = new DomainItemContext("EMPTY", "NO-ID");

    public DomainItemContext(@NotNull String type2, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.type = type2;
        this.id = id;
        this.genericProperties = new HashMap();
        this.properties = new HashMap();
        this.mapProperties = new HashMap();
        this.setProperties = new HashMap();
        this.associatedContexts = new HashSet();
        this.dependentContexts = new HashSet();
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final Map<String, String> getProperties() {
        return this.properties;
    }

    @NotNull
    public final Map<String, Map<String, String>> getMapProperties() {
        return this.mapProperties;
    }

    @NotNull
    public final Map<String, Set<Object>> getSetProperties() {
        return this.setProperties;
    }

    @NotNull
    public final Set<DomainItemContext> getAssociatedContexts() {
        return this.associatedContexts;
    }

    @NotNull
    public final Set<DomainItemContext> getDependentContexts() {
        return this.dependentContexts;
    }

    @NotNull
    public final DomainItemContext with(@NotNull String property, @Nullable String value2) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        String string = value2;
        if (string == null) {
            string = "";
        }
        this.properties.put(property, string);
        return this;
    }

    @NotNull
    public final DomainItemContext with(@NotNull String property, @NotNull Map<String, String> value2) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.mapProperties.put(property, value2);
        return this;
    }

    @NotNull
    public final DomainItemContext with(@NotNull String property, @NotNull Set<? extends Object> value2) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.setProperties.put(property, value2);
        return this;
    }

    @NotNull
    public final DomainItemContext with(@NotNull DomainItemContext associatedContext) {
        Intrinsics.checkNotNullParameter((Object)associatedContext, (String)"associatedContext");
        this.associatedContexts.add(associatedContext);
        return this;
    }

    @NotNull
    public final DomainItemContext withDependent(@NotNull DomainItemContext associatedContext) {
        Intrinsics.checkNotNullParameter((Object)associatedContext, (String)"associatedContext");
        this.dependentContexts.add(associatedContext);
        return this;
    }

    @NotNull
    public final DomainItemContext with(@NotNull Map<String, ? extends Object> properties) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        this.genericProperties.putAll(properties);
        return this;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DomainItemContext)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.type, (Object)((DomainItemContext)other).type)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.id, (Object)((DomainItemContext)other).id);
    }

    public int hashCode() {
        int result2 = this.type.hashCode();
        result2 = 31 * result2 + this.id.hashCode();
        return result2;
    }

    @JvmStatic
    @NotNull
    public static final DomainItemContext create(@NotNull String typeId, @NotNull String itemId) {
        return Companion.create(typeId, itemId);
    }

    @JvmStatic
    @NotNull
    public static final DomainItemContext create(@NotNull String typeId, @NotNull String itemId, @NotNull SmartPsiElementPointer<?> pointer) {
        return Companion.create(typeId, itemId, pointer);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007J$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/domains/context/DomainItemContext$Companion;", "", "<init>", "()V", "EMPTY", "Lcom/intellij/ml/llm/domains/context/DomainItemContext;", "create", "typeId", "", "itemId", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "intellij.ml.llm.domains"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DomainItemContext create(@NotNull String typeId, @NotNull String itemId) {
            Intrinsics.checkNotNullParameter((Object)typeId, (String)"typeId");
            Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
            return new DomainItemContext(typeId, itemId);
        }

        @JvmStatic
        @NotNull
        public final DomainItemContext create(@NotNull String typeId, @NotNull String itemId, @NotNull SmartPsiElementPointer<?> pointer) {
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)typeId, (String)"typeId");
                    Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
                    Intrinsics.checkNotNullParameter(pointer, (String)"pointer");
                    PsiElement element2 = pointer.getElement();
                    if (element2 == null) break block2;
                    Project project2 = element2.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                    AiIgnoreManager aiIgnoreManager = AiIgnoreManager.Companion.getInstance(project2);
                    VirtualFile virtualFile2 = element2.getContainingFile().getVirtualFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
                    if (!aiIgnoreManager.isIgnored(virtualFile2)) break block3;
                }
                return EMPTY;
            }
            return new DomainItemPsiContext(typeId, itemId, pointer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0015\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/domains/context/DomainItemContext$DomainItemPsiContext;", "Lcom/intellij/ml/llm/domains/context/DomainItemContext;", "type", "", "id", "psi", "Lcom/intellij/psi/SmartPsiElementPointer;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/psi/SmartPsiElementPointer;)V", "getPsi", "()Lcom/intellij/psi/SmartPsiElementPointer;", "intellij.ml.llm.domains"})
    public static final class DomainItemPsiContext
    extends DomainItemContext {
        @NotNull
        private final SmartPsiElementPointer<?> psi;

        public DomainItemPsiContext(@NotNull String type2, @NotNull String id, @NotNull SmartPsiElementPointer<?> psi) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(psi, (String)"psi");
            super(type2, id);
            this.psi = psi;
        }

        @NotNull
        public final SmartPsiElementPointer<?> getPsi() {
            return this.psi;
        }
    }
}

