/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.javascript.vue.generate.test;

import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPrompt;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPromptService;
import com.intellij.ml.llm.javascript.generate.test.JSTestPromptGenerator;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.SharedExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConcatenateBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0007H\u0017\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/javascript/vue/generate/test/VueTestPromptGenerator;", "Lcom/intellij/ml/llm/javascript/generate/test/JSTestPromptGenerator;", "elementForTests", "Lcom/intellij/psi/PsiElement;", "testFilePath", "Ljava/nio/file/Path;", "testFrameworkName", "Lcom/intellij/ml/llm/privacy/PSString;", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/nio/file/Path;Lcom/intellij/ml/llm/privacy/PSString;)V", "createPrompt", "intellij.ml.llm.javascript.vue"})
public final class VueTestPromptGenerator
extends JSTestPromptGenerator {
    public VueTestPromptGenerator(@NotNull PsiElement elementForTests, @NotNull Path testFilePath2, @Nullable PSString testFrameworkName) {
        Intrinsics.checkNotNullParameter((Object)elementForTests, (String)"elementForTests");
        Intrinsics.checkNotNullParameter((Object)testFilePath2, (String)"testFilePath");
        super(elementForTests, testFilePath2, testFrameworkName);
    }

    @Override
    @RequiresReadLock
    @NotNull
    public PSString createPrompt() {
        PSString pSString;
        PSString pSString2;
        PsiFile containingFile = this.getElementForTests().getContainingFile();
        Intrinsics.checkNotNull((Object)containingFile);
        PSString containingFileName = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)containingFile).getName();
        VirtualFile virtualFile2 = containingFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        PSString componentName = ExtensionsKtKt.getPrivacySafe(virtualFile2).getNameWithoutExtension();
        FileType fileType2 = containingFile.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileType(...)");
        FileType fileType3 = fileType2;
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{SharedExtensionsKtKt.getPrivacySafe((Path)this.getTestFilePath()).getNameWithoutExtension(), componentName};
        PSString pSString3 = ConstantsKt.getPrivacyConst((String)"Write `%s` test for the `%s` Vue component ").format(pSStringConvertibleArray);
        pSStringConvertibleArray = new PSStringConvertible[]{containingFileName};
        PSString command = pSString3.plus(ConstantsKt.getPrivacyConst((String)"which is placed in the `%s` file.").format(pSStringConvertibleArray));
        if (this.getTestFrameworkName() != null) {
            PSStringConvertible[] pSStringConvertibleArray2 = new PSStringConvertible[]{this.getTestFrameworkName()};
            pSString2 = ConstantsKt.getPrivacyConst((String)"\nUse `%s` javascript test framework").format(pSStringConvertibleArray2);
        } else {
            pSString2 = ConstantsKt.getPrivacyConst((String)"");
        }
        PSString testFrameWorkDescription = pSString2;
        Project project2 = this.getElementForTests().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        AISystemLibraryPrompt aISystemLibraryPrompt = AISystemLibraryPromptService.Companion.getInstance(project2).findPrompt("llm.testGeneration.vue");
        PSString customizablePrompt = aISystemLibraryPrompt != null && (pSString = aISystemLibraryPrompt.getContent()) != null ? pSString : ConstantsKt.getEMPTY();
        return PSStringKt.buildStringPrivacySafe(arg_0 -> VueTestPromptGenerator.createPrompt$lambda$0(fileType3, command, this, customizablePrompt, testFrameWorkDescription, arg_0)).trim();
    }

    private static final Unit createPrompt$lambda$0(FileType $fileType, PSString $command, VueTestPromptGenerator this$0, PSString $customizablePrompt, PSString $testFrameWorkDescription, ConcatenateBuilder $this$buildStringPrivacySafe) {
        Intrinsics.checkNotNullParameter((Object)$this$buildStringPrivacySafe, (String)"$this$buildStringPrivacySafe");
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{ExtensionsKtKt.getPrivacySafe($fileType).getName()};
        $this$buildStringPrivacySafe.appendLine(ConstantsKt.getPrivacyConst((String)"You are a rock-star frontend %s developer. You are working on the project with Vue JavaScript framework.").format(pSStringConvertibleArray));
        $this$buildStringPrivacySafe.appendLine($command);
        $this$buildStringPrivacySafe.appendLine(ConstantsKt.getPrivacyConst((String)"Guideline:"));
        $this$buildStringPrivacySafe.appendLine(this$0.getGuideline());
        if (((CharSequence)$customizablePrompt).length() > 0) {
            $this$buildStringPrivacySafe.appendLine($customizablePrompt);
        }
        $this$buildStringPrivacySafe.appendLine($testFrameWorkDescription);
        $this$buildStringPrivacySafe.appendLine(ConstantsKt.getPrivacyConst((String)"Here is the original code:"));
        $this$buildStringPrivacySafe.appendLine(ConstantsKt.getPrivacyConst((String)"```"));
        $this$buildStringPrivacySafe.appendLine(ExtensionsKtKt.getPrivacySafe(this$0.getElementForTests()).getText().plus(ConstantsKt.getPrivacyConst((String)"```")));
        return Unit.INSTANCE;
    }
}

