/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.jupyter.common.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.jupyter.common.utils.ExtensionsKt;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J!\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\fH$\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/jupyter/common/intentions/AbstractAIJupyterIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "<init>", "()V", "startInWriteAction", "", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "invoke", "", "processIntention", "file", "intellij.ml.llm.jupyter.common"})
public abstract class AbstractAIJupyterIntention
implements IntentionAction {
    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (!AIAssistantUIUtil.INSTANCE.isAuthedAndAllowed(project2)) {
            return false;
        }
        if (PrivacyPathCheckerKt.isAiIgnoreBlocked(project2, psiFile)) {
            return false;
        }
        return ExtensionsKt.isJupyterActionAvailable(psiFile);
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (!this.isAvailable(project2, editor2, psiFile)) {
            return;
        }
        this.processIntention(ExtensionsKt.getTopLevelEditor(editor2), psiFile);
    }

    protected abstract void processIntention(@NotNull Editor var1, @NotNull PsiFile var2);
}

