/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.jupyter.common.prompts;

import com.intellij.jupyter.core.jupyter.editor.outputs.JupyterOutputDataKeyExtractorKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutput;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputs;
import com.intellij.ml.llm.jupyter.common.privacy.JupyterOutputPrivacyWrapper;
import com.intellij.ml.llm.jupyter.common.prompts.NotebookTextDataRetriever;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.openapi.DocumentPrivacyWrapper;
import com.intellij.ml.llm.tokenizer.Tokenizer;
import com.intellij.ml.llm.tokenizer.TokenizerAccessPointService;
import com.intellij.ml.llm.tokenizer.fus.PromptSource;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellLinesUtilsKt;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJB\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0086@\u00a2\u0006\u0002\u0010\u0012J.\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0002\u0010\u0014J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u0014\u0010\u0018\u001a\u00020\u000b*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rH\u0002J \u0010\u001b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\r\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/jupyter/common/prompts/NotebookTextDataRetriever;", "", "<init>", "()V", "getCurrentlySelectedCellCodeAsPSString", "Lcom/intellij/ml/llm/privacy/PSString;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "getNotebookPrefixText", "", "interval", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "maxNotebookTextTokens", "", "maxLastCellOutputTokens", "originalCellText", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;IILjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getNotebookSuffixText", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCellInfo", "Lcom/intellij/ml/llm/jupyter/common/prompts/NotebookTextDataRetriever$CellInfo;", "ordinal", "getCellText", "Lcom/intellij/openapi/editor/Document;", "cellInterval", "getCellOutputAsText", "CellInfo", "intellij.ml.llm.jupyter.common"})
@SourceDebugExtension(value={"SMAP\nNotebookTextDataRetriever.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookTextDataRetriever.kt\ncom/intellij/ml/llm/jupyter/common/prompts/NotebookTextDataRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1563#2:168\n1634#2,3:169\n*S KotlinDebug\n*F\n+ 1 NotebookTextDataRetriever.kt\ncom/intellij/ml/llm/jupyter/common/prompts/NotebookTextDataRetriever\n*L\n56#1:168\n56#1:169,3\n*E\n"})
public final class NotebookTextDataRetriever {
    @NotNull
    public static final NotebookTextDataRetriever INSTANCE = new NotebookTextDataRetriever();

    private NotebookTextDataRetriever() {
    }

    @Nullable
    public final PSString getCurrentlySelectedCellCodeAsPSString(@NotNull Editor editor2, @NotNull Project project2) {
        PSString pSString;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        VirtualFile virtualFile2 = editor2.getVirtualFile();
        Intrinsics.checkNotNull((Object)virtualFile2);
        if (PrivacyPathCheckerKt.isAiIgnoreBlocked(project2, virtualFile2)) {
            return null;
        }
        NotebookCellSelectionModel selectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)editor2);
        if (selectionModel != null) {
            Document document2 = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
            DocumentPrivacyWrapper documentPrivacyWrapper = ExtensionsKtKt.privacySafe(document2, project2);
            NotebookCellLines.Interval interval = selectionModel.getPrimarySelectedCell();
            Document document3 = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"getDocument(...)");
            pSString = com.intellij.ml.llm.jupyter.common.privacy.ExtensionsKtKt.getContentText(documentPrivacyWrapper, interval, document3);
        } else {
            pSString = null;
        }
        return pSString;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getNotebookPrefixText(@NotNull Project project, @NotNull Editor editor, @NotNull NotebookCellLines.Interval interval, int maxNotebookTextTokens, int maxLastCellOutputTokens, @Nullable String originalCellText, @NotNull Continuation<? super String> $completion) {
        if (!($completion instanceof getNotebookPrefixText.1)) ** GOTO lbl-1000
        var22_8 = $completion;
        if ((var22_8.label & -2147483648) != 0) {
            var22_8.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ NotebookTextDataRetriever this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getNotebookPrefixText(null, null, null, 0, 0, null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var23_10 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = editor.getVirtualFile();
                Intrinsics.checkNotNull((Object)v0);
                if (PrivacyPathCheckerKt.isAiIgnoreBlocked(project, v0)) {
                    return "";
                }
                $continuation.L$0 = project;
                $continuation.L$1 = editor;
                $continuation.L$2 = interval;
                $continuation.L$3 = originalCellText;
                $continuation.I$0 = maxNotebookTextTokens;
                $continuation.I$1 = maxLastCellOutputTokens;
                $continuation.label = 1;
                v1 = TokenizerAccessPointService.Companion.getInstance().getTokenizer((Continuation<? super Tokenizer>)$continuation);
                if (v1 == var23_10) {
                    return var23_10;
                }
                ** GOTO lbl36
            }
            case 1: {
                maxLastCellOutputTokens = $continuation.I$1;
                maxNotebookTextTokens = $continuation.I$0;
                originalCellText = (String)$continuation.L$3;
                interval = (NotebookCellLines.Interval)$continuation.L$2;
                editor = (Editor)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl36:
                // 2 sources

                tokenizer = (Tokenizer)v1;
                $this$map$iv = (Iterable)new IntRange(0, interval.getOrdinal());
                $i$f$map = false;
                var12_15 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var15_20 = $this$mapTo$iv$iv.iterator();
                while (var15_20.hasNext()) {
                    var17_25 = item$iv$iv = ((IntIterator)var15_20).nextInt();
                    var20_27 = destination$iv$iv;
                    $i$a$-map-NotebookTextDataRetriever$getNotebookPrefixText$cellInfos$1 = false;
                    var20_27.add(NotebookTextDataRetriever.INSTANCE.getCellInfo(project, editor, (int)it));
                }
                cellInfos = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                if (originalCellText != null) {
                    lastCellInfo = (CellInfo)CollectionsKt.last((List)cellInfos);
                    cellInfos.set(cellInfos.size() - 1, new CellInfo("#%%\n" + originalCellText, originalCellText, lastCellInfo.getOutput()));
                }
                cellInfos.removeIf((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, getNotebookPrefixText$lambda$2(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Z)((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getNotebookPrefixText$lambda$1(com.intellij.ml.llm.jupyter.common.prompts.NotebookTextDataRetriever$CellInfo ), (Lcom/intellij/ml/llm/jupyter/common/prompts/NotebookTextDataRetriever$CellInfo;)Ljava/lang/Boolean;)()));
                if (cellInfos.isEmpty()) {
                    return "";
                }
                restTokens = maxNotebookTextTokens;
                restCells = cellInfos.size();
                tokensPerCell = restTokens / restCells;
                cellTexts = new ArrayList<E>();
                var15_21 = cellInfos.size() - 1;
                for (i = 0; i < var15_21; ++i) {
                    curCellText = ((CellInfo)cellInfos.get(i)).getTextWithLimit$intellij_ml_llm_jupyter_common(tokenizer, tokensPerCell);
                    cellTexts.add(curCellText);
                    tokensPerCell = (restTokens -= tokenizer.count(curCellText)) / --restCells;
                }
                lastCellText = ((CellInfo)CollectionsKt.last((List)cellInfos)).getTextWithOutputLimit$intellij_ml_llm_jupyter_common(tokenizer, maxLastCellOutputTokens);
                lastCellTokens = tokenizer.count(lastCellText);
                if (lastCellTokens <= restTokens) {
                    cellTexts.add(lastCellText);
                    return CollectionsKt.joinToString$default((Iterable)cellTexts, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                }
                if (lastCellTokens >= maxNotebookTextTokens) {
                    return ((CellInfo)CollectionsKt.last((List)cellInfos)).getTextWithLimit$intellij_ml_llm_jupyter_common(tokenizer, maxNotebookTextTokens);
                }
                difference = lastCellTokens - restTokens;
                i = 0;
                for (totalFirstTokens = 0; i < cellTexts.size() && totalFirstTokens < difference; totalFirstTokens += tokenizer.count((String)cellTexts.get(++i))) {
                }
                resCellTexts = cellTexts.subList(i, cellTexts.size());
                resCellTexts.add(lastCellText);
                return CollectionsKt.joinToString$default((Iterable)cellTexts, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object getNotebookPrefixText$default(NotebookTextDataRetriever notebookTextDataRetriever, Project project2, Editor editor2, NotebookCellLines.Interval interval, int n, int n2, String string, Continuation continuation, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            string = null;
        }
        return notebookTextDataRetriever.getNotebookPrefixText(project2, editor2, interval, n, n2, string, (Continuation<? super String>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getNotebookSuffixText(@NotNull Project project, @NotNull Editor editor, @NotNull NotebookCellLines.Interval interval, int maxNotebookTextTokens, @NotNull Continuation<? super String> $completion) {
        if (!($completion instanceof getNotebookSuffixText.1)) ** GOTO lbl-1000
        var10_6 = $completion;
        if ((var10_6.label & -2147483648) != 0) {
            var10_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ NotebookTextDataRetriever this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getNotebookSuffixText(null, null, null, 0, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = editor.getVirtualFile();
                Intrinsics.checkNotNull((Object)v0);
                if (PrivacyPathCheckerKt.isAiIgnoreBlocked(project, v0)) {
                    return "";
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$1 = editor;
                $continuation.L$2 = interval;
                $continuation.I$0 = maxNotebookTextTokens;
                $continuation.label = 1;
                v1 = TokenizerAccessPointService.Companion.getInstance().getTokenizer((Continuation<? super Tokenizer>)$continuation);
                if (v1 == var11_8) {
                    return var11_8;
                }
                ** GOTO lbl32
            }
            case 1: {
                maxNotebookTextTokens = $continuation.I$0;
                interval = (NotebookCellLines.Interval)$continuation.L$2;
                editor = (Editor)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl32:
                // 2 sources

                tokenizer = (Tokenizer)v1;
                suffixStartOffset = editor.getDocument().getLineEndOffset(interval.getLines().getLast());
                v2 = editor.getDocument().getText(new TextRange(suffixStartOffset, editor.getDocument().getTextLength()));
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getText(...)");
                text = v2;
                return tokenizer.trim(text, maxNotebookTextTokens, null);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final CellInfo getCellInfo(Project project2, Editor editor2, int ordinal) {
        NotebookCellLines.Interval cell = NotebookVisualizationUiUtilKt.getCellByOrdinal((Editor)editor2, (int)ordinal);
        Document document2 = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        String cellCode = this.getCellText(document2, cell);
        Document document3 = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"getDocument(...)");
        CharSequence content2 = NotebookCellLinesUtilsKt.getContentText((Document)document3, (NotebookCellLines.Interval)cell);
        PSString cellOutput = this.getCellOutputAsText(project2, editor2, cell);
        PSString pSString = cellOutput;
        return new CellInfo(cellCode, ((Object)content2).toString(), pSString != null ? (String)pSString.unwrap() : null);
    }

    private final String getCellText(Document $this$getCellText, NotebookCellLines.Interval cellInterval) {
        int last;
        int first = cellInterval.getLines().getFirst();
        if (first <= (last = cellInterval.getLines().getLast())) {
            String string = $this$getCellText.getText(new TextRange($this$getCellText.getLineStartOffset(first), $this$getCellText.getLineEndOffset(last)));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final PSString getCellOutputAsText(@NotNull Project project2, @NotNull Editor editor2, @NotNull NotebookCellLines.Interval cellInterval) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cellInterval, (String)"cellInterval");
        if (!(editor2 instanceof EditorImpl)) {
            return null;
        }
        JupyterOutputs jupyterOutputs = JupyterOutputDataKeyExtractorKt.getOutputsForIndex((Editor)editor2, (int)cellInterval.getOrdinal());
        if (jupyterOutputs == null) {
            return null;
        }
        JupyterOutputs outputs = jupyterOutputs;
        JupyterOutput jupyterOutput = (JupyterOutput)CollectionsKt.lastOrNull((List)outputs.getOutputs());
        Object object = jupyterOutput;
        if (jupyterOutput == null) return null;
        VirtualFile virtualFile2 = ((EditorImpl)editor2).getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        JupyterOutputPrivacyWrapper jupyterOutputPrivacyWrapper = com.intellij.ml.llm.jupyter.common.privacy.ExtensionsKtKt.privacySafe((JupyterOutput)object, project2, virtualFile2);
        object = jupyterOutputPrivacyWrapper;
        if (jupyterOutputPrivacyWrapper == null) return null;
        PSString pSString = ((JupyterOutputPrivacyWrapper)((Object)object)).getTextForCopy();
        return pSString;
    }

    private static final boolean getNotebookPrefixText$lambda$1(CellInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it.getContent()).length() == 0;
    }

    private static final boolean getNotebookPrefixText$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0003H\u0016J\u001d\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u001d\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0015J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/jupyter/common/prompts/NotebookTextDataRetriever$CellInfo;", "", "code", "", "content", "output", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCode", "()Ljava/lang/String;", "getContent", "getOutput", "toString", "getTextWithLimit", "tokenizer", "Lcom/intellij/ml/llm/tokenizer/Tokenizer;", "limit", "", "getTextWithLimit$intellij_ml_llm_jupyter_common", "getTextWithOutputLimit", "outputLimit", "getTextWithOutputLimit$intellij_ml_llm_jupyter_common", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "intellij.ml.llm.jupyter.common"})
    public static final class CellInfo {
        @NotNull
        private final String code;
        @NotNull
        private final String content;
        @Nullable
        private final String output;

        public CellInfo(@NotNull String code, @NotNull String content2, @Nullable String output2) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            this.code = code;
            this.content = content2;
            this.output = output2;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        @Nullable
        public final String getOutput() {
            return this.output;
        }

        @NotNull
        public String toString() {
            if (this.output == null) {
                return this.code + "\n";
            }
            return this.code + "\n-------\n" + this.output + "\n-------\n";
        }

        @NotNull
        public final String getTextWithLimit$intellij_ml_llm_jupyter_common(@NotNull Tokenizer tokenizer, int limit) {
            int outputTokens;
            Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
            int codeTokens = tokenizer.count(this.code);
            String string = this.output;
            if (string == null) {
                string = "";
            }
            if (codeTokens + (outputTokens = tokenizer.count(string)) <= limit) {
                return this.toString();
            }
            if (codeTokens >= limit || this.output == null) {
                return ((Object)StringsKt.reversed((CharSequence)tokenizer.trim(((Object)StringsKt.reversed((CharSequence)this.code)).toString(), limit, PromptSource.JUPYTER_DATA_RETRIEVER_CODE))).toString();
            }
            int restTokens = limit - codeTokens;
            return new CellInfo(this.code, this.content, tokenizer.trim(this.output, restTokens, PromptSource.JUPYTER_DATA_RETRIEVER_OUTPUT)).toString();
        }

        @NotNull
        public final String getTextWithOutputLimit$intellij_ml_llm_jupyter_common(@NotNull Tokenizer tokenizer, int outputLimit) {
            Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
            if (this.output == null) {
                return this.toString();
            }
            return new CellInfo(this.code, this.content, tokenizer.trim(this.output, outputLimit, PromptSource.JUPYTER_DATA_RETRIEVER_OUTPUT)).toString();
        }

        @NotNull
        public final String component1() {
            return this.code;
        }

        @NotNull
        public final String component2() {
            return this.content;
        }

        @Nullable
        public final String component3() {
            return this.output;
        }

        @NotNull
        public final CellInfo copy(@NotNull String code, @NotNull String content2, @Nullable String output2) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            return new CellInfo(code, content2, output2);
        }

        public static /* synthetic */ CellInfo copy$default(CellInfo cellInfo, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = cellInfo.code;
            }
            if ((n & 2) != 0) {
                string2 = cellInfo.content;
            }
            if ((n & 4) != 0) {
                string3 = cellInfo.output;
            }
            return cellInfo.copy(string, string2, string3);
        }

        public int hashCode() {
            int result2 = this.code.hashCode();
            result2 = result2 * 31 + this.content.hashCode();
            result2 = result2 * 31 + (this.output == null ? 0 : this.output.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CellInfo)) {
                return false;
            }
            CellInfo cellInfo = (CellInfo)other;
            if (!Intrinsics.areEqual((Object)this.code, (Object)cellInfo.code)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.content, (Object)cellInfo.content)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.output, (Object)cellInfo.output);
        }
    }
}

