/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.jupyter.common.prompts.retriever;

import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterDisplayDataOutput;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterErrorOutput;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutput;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputType;
import com.intellij.ml.llm.core.promptlog.CodeSnippet;
import com.intellij.ml.llm.core.promptlog.CodeSnippetFormatting;
import com.intellij.ml.llm.grazie.tasks.jupyter.common.model.JupyterAiCellOutput;
import com.intellij.ml.llm.grazie.tasks.jupyter.common.model.JupyterAiCellSnippet;
import com.intellij.ml.llm.grazie.tasks.jupyter.common.model.JupyterAiNotebookSnippet;
import com.intellij.ml.llm.jupyter.common.agent.privacy.IdeFormerSafeStringPrivacyWrapperKt;
import com.intellij.ml.llm.jupyter.common.prompts.utils.JupyterTrimUtils;
import com.intellij.ml.llm.tokenizer.Tokenizer;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.openapi.editor.Editor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/jupyter/common/prompts/retriever/JupyterNotebookRetriever;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getNotebook", "Lcom/intellij/ml/llm/grazie/tasks/jupyter/common/model/JupyterAiNotebookSnippet;", "tokenizer", "Lcom/intellij/ml/llm/tokenizer/Tokenizer;", "cellOutput", "Lcom/intellij/ml/llm/grazie/tasks/jupyter/common/model/JupyterAiCellOutput;", "cell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "getCellId", "", "Lcom/intellij/jupyter/core/jupyter/nbformat/CellId;", "index", "", "getOutputSnippet", "Lcom/intellij/ml/llm/core/promptlog/CodeSnippet;", "output", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterOutput;", "getSourceSnippet", "intellij.ml.llm.jupyter.common"})
@SourceDebugExtension(value={"SMAP\nJupyterNotebookRetriever.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterNotebookRetriever.kt\ncom/intellij/ml/llm/jupyter/common/prompts/retriever/JupyterNotebookRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1563#2:79\n1634#2,3:80\n1563#2:83\n1634#2,3:84\n*S KotlinDebug\n*F\n+ 1 JupyterNotebookRetriever.kt\ncom/intellij/ml/llm/jupyter/common/prompts/retriever/JupyterNotebookRetriever\n*L\n20#1:79\n20#1:80,3\n30#1:83\n30#1:84,3\n*E\n"})
public final class JupyterNotebookRetriever {
    @NotNull
    private final Editor editor;

    public JupyterNotebookRetriever(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JupyterAiNotebookSnippet getNotebook(@NotNull Tokenizer tokenizer) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        JupyterNotebook notebook = JupyterEditorExtensionsKt.getNotebookFile((Editor)this.editor).getNotebook();
        Iterable $this$map$iv = CollectionsKt.withIndex((Iterable)notebook.computeCells());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IndexedValue indexedValue = (IndexedValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int index = indexedValue.component1();
            JupyterCell cell = (JupyterCell)indexedValue.component2();
            CodeSnippet sourceSnippet = this.getSourceSnippet(cell);
            JupyterAiCellOutput output2 = this.cellOutput(cell, tokenizer);
            String id = this.getCellId(cell, index);
            collection.add(new JupyterAiCellSnippet(sourceSnippet, output2, IdeFormerSafeStringPrivacyWrapperKt.getPrivacySafe(id)));
        }
        List cells = (List)destination$iv$iv;
        String string = notebook.getLanguage().getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
        return new JupyterAiNotebookSnippet(cells, IdeFormerSafeStringPrivacyWrapperKt.getPrivacySafe(string));
    }

    /*
     * WARNING - void declaration
     */
    private final JupyterAiCellOutput cellOutput(JupyterCell cell, Tokenizer tokenizer) {
        List list;
        Object object = cell.getOutputs();
        if (object != null && (object = object.getOutputs()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void output2;
                JupyterOutput jupyterOutput = (JupyterOutput)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.getOutputSnippet(tokenizer, (JupyterOutput)output2));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List outputs = list;
        JupyterAiCellOutput output3 = new JupyterAiCellOutput(outputs);
        return output3;
    }

    private final String getCellId(JupyterCell cell, int index) {
        String cellId = cell.getId();
        if (cellId != null) {
            return cellId;
        }
        NotebookIntervalPointer interval = NotebookIntervalPointerFactory.Companion.get(this.editor).getForOrdinalIfExists(index);
        if (interval != null) {
            return String.valueOf(System.identityHashCode(interval));
        }
        return String.valueOf(index);
    }

    private final CodeSnippet getOutputSnippet(Tokenizer tokenizer, JupyterOutput output2) {
        String string;
        String type2 = switch (WhenMappings.$EnumSwitchMapping$0[output2.getOutputType().ordinal()]) {
            case 1 -> "";
            case 2 -> "";
            case 3 -> "";
            case 4 -> "error";
            default -> throw new NoWhenBranchMatchedException();
        };
        JupyterOutput jupyterOutput = output2;
        if (jupyterOutput instanceof JupyterErrorOutput) {
            string = CollectionsKt.joinToString$default((Iterable)((JupyterErrorOutput)output2).getTraceback(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        } else if (jupyterOutput instanceof JupyterDisplayDataOutput) {
            string = ((JupyterDisplayDataOutput)output2).getData().getTextPlain();
            if (string == null) {
                string = "";
            }
        } else {
            string = "";
        }
        String text2 = string;
        String trimmed = JupyterTrimUtils.INSTANCE.getMiddleTrimmedString(tokenizer, text2, 1000, 2000);
        return new CodeSnippet(IdeFormerSafeStringPrivacyWrapperKt.getPrivacySafe(trimmed), null, IdeFormerSafeStringPrivacyWrapperKt.getPrivacySafe(type2), CodeSnippetFormatting.TRIM_AND_ADD_BACKTICKS);
    }

    private final CodeSnippet getSourceSnippet(JupyterCell cell) {
        String language = switch (WhenMappings.$EnumSwitchMapping$1[cell.getCellType().ordinal()]) {
            case 1 -> "markdown";
            case 2 -> "sql";
            default -> "";
        };
        return new CodeSnippet(IdeFormerSafeStringPrivacyWrapperKt.getPrivacySafe(cell.getSource()), null, IdeFormerSafeStringPrivacyWrapperKt.getPrivacySafe(language), CodeSnippetFormatting.TRIM_AND_ADD_BACKTICKS, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[JupyterOutputType.values().length];
            try {
                nArray[JupyterOutputType.STREAM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterOutputType.DISPLAY_DATA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterOutputType.EXECUTE_RESULT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterOutputType.ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[JupyterCellType.values().length];
            try {
                nArray[JupyterCellType.MARKDOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterCellType.SQL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

