/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.kotlin.writeDocumentation;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.ml.llm.core.LLMDocumentationSupportWithBlockComments;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPrompt;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPromptService;
import com.intellij.ml.llm.grazie.tasks.documentation.WdPromptCustomization;
import com.intellij.ml.llm.kotlin.writeDocumentation.LLMKotlinDocumentationSupport$findNearestDocumentationTarget$;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.idea.kdoc.KDocElementFactory;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u001e\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J,\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010*\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010+\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010,\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010-\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006."}, d2={"Lcom/intellij/ml/llm/kotlin/writeDocumentation/LLMKotlinDocumentationSupport;", "Lcom/intellij/ml/llm/core/LLMDocumentationSupportWithBlockComments;", "<init>", "()V", "emptyDocumentation", "", "getEmptyDocumentation", "()Ljava/lang/String;", "commentStart", "getCommentStart", "commentEnd", "getCommentEnd", "useChatCodeContextProvider", "", "getDocComment", "Lcom/intellij/psi/PsiElement;", "element", "findExampleDoc", "Lkotlin/Pair;", "Lcom/intellij/ml/llm/privacy/PSString;", "documentationTarget", "updateDoc", "Lcom/intellij/openapi/editor/RangeMarker;", "editor", "Lcom/intellij/openapi/editor/Editor;", "documentationRange", "newDocText", "findDocTargetsInSelection", "", "Lcom/intellij/psi/PsiNameIdentifierOwner;", "root", "selectionModel", "Lcom/intellij/openapi/editor/SelectionModel;", "findNearestDocumentationTarget", "findNearestDocumentationTargetForCaret", "reformatDocumentation", "", "promptCustomization", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdPromptCustomization;", "project", "Lcom/intellij/openapi/project/Project;", "isMember", "isTypeBody", "isType", "isTypeBodyOrFile", "isDocumentableDeclaration", "intellij.ml.llm.kotlin"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nLLMKotlinDocumentationSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMKotlinDocumentationSupport.kt\ncom/intellij/ml/llm/kotlin/writeDocumentation/LLMKotlinDocumentationSupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n1#2:155\n477#3:156\n808#4,11:157\n774#4:168\n865#4,2:169\n2423#4,14:171\n*S KotlinDebug\n*F\n+ 1 LLMKotlinDocumentationSupport.kt\ncom/intellij/ml/llm/kotlin/writeDocumentation/LLMKotlinDocumentationSupport\n*L\n104#1:156\n113#1:157,11\n113#1:168\n113#1:169,2\n115#1:171,14\n*E\n"})
public final class LLMKotlinDocumentationSupport
implements LLMDocumentationSupportWithBlockComments {
    @NotNull
    public String getEmptyDocumentation() {
        return "/**\n*\n*/";
    }

    @NotNull
    public String getCommentStart() {
        return "/**";
    }

    @NotNull
    public String getCommentEnd() {
        return "*/";
    }

    public boolean useChatCodeContextProvider() {
        return true;
    }

    @Nullable
    public PsiElement getDocComment(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        KtDeclaration ktDeclaration = element2 instanceof KtDeclaration ? (KtDeclaration)element2 : null;
        return (PsiElement)(ktDeclaration != null ? ktDeclaration.getDocComment() : null);
    }

    @Nullable
    public Pair<PSString, PSString> findExampleDoc(@NotNull PsiElement documentationTarget) {
        Intrinsics.checkNotNullParameter((Object)documentationTarget, (String)"documentationTarget");
        return null;
    }

    @Nullable
    public RangeMarker updateDoc(@NotNull Editor editor2, @NotNull PsiElement documentationTarget, @Nullable RangeMarker documentationRange, @NotNull String newDocText) {
        RangeMarker rangeMarker;
        KDoc kDoc;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)documentationTarget, (String)"documentationTarget");
        Intrinsics.checkNotNullParameter((Object)newDocText, (String)"newDocText");
        KtDeclaration ktDeclaration = documentationTarget instanceof KtDeclaration ? (KtDeclaration)documentationTarget : null;
        if (ktDeclaration == null) {
            throw new IncorrectOperationException();
        }
        KtDeclaration kDeclaration = ktDeclaration;
        try {
            Project project2 = ((KtDeclaration)documentationTarget).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            kDoc = new KDocElementFactory(project2).createKDocFromText(newDocText);
        }
        catch (KotlinExceptionWithAttachments e) {
            RangeMarker rangeMarker2;
            KDoc kDoc2 = ((KtDeclaration)documentationTarget).getDocComment();
            if (kDoc2 != null && (kDoc2 = kDoc2.getTextRange()) != null) {
                KDoc it = kDoc2;
                boolean bl = false;
                rangeMarker2 = editor2.getDocument().createRangeMarker((TextRange)it);
            } else {
                rangeMarker2 = null;
            }
            return rangeMarker2;
        }
        KDoc docComment = kDoc;
        KDoc kDoc3 = ((KtDeclaration)documentationTarget).getDocComment();
        if (kDoc3 == null || (kDoc3 = kDoc3.replace((PsiElement)docComment)) == null) {
            LLMKotlinDocumentationSupport $this$updateDoc_u24lambda_u241 = this;
            boolean bl = false;
            if (documentationRange != null) {
                editor2.getDocument().replaceString(documentationRange.getStartOffset(), documentationRange.getEndOffset(), (CharSequence)newDocText);
                return documentationRange;
            }
            kDeclaration.addBefore((PsiElement)docComment, kDeclaration.getFirstChild());
            return editor2.getDocument().createRangeMarker(kDeclaration.getFirstChild().getTextRange());
        }
        KDoc kDoc4 = ((KtDeclaration)documentationTarget).getDocComment();
        if (kDoc4 != null && (kDoc4 = kDoc4.getTextRange()) != null) {
            KDoc it = kDoc4;
            boolean bl = false;
            rangeMarker = editor2.getDocument().createRangeMarker((TextRange)it);
        } else {
            rangeMarker = null;
        }
        return rangeMarker;
    }

    @NotNull
    public List<PsiNameIdentifierOwner> findDocTargetsInSelection(@NotNull PsiElement root, @NotNull SelectionModel selectionModel) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        List ret = new ArrayList();
        root.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(this, selectionModel, ret){
            final /* synthetic */ LLMKotlinDocumentationSupport this$0;
            final /* synthetic */ SelectionModel $selectionModel;
            final /* synthetic */ List<PsiNameIdentifierOwner> $ret;
            {
                this.this$0 = $receiver;
                this.$selectionModel = $selectionModel;
                this.$ret = $ret;
            }

            public void visitElement(PsiElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                if (element2 instanceof PsiNameIdentifierOwner && LLMKotlinDocumentationSupport.access$isDocumentableDeclaration(this.this$0, element2)) {
                    boolean crossesElementName;
                    int elementOffset = ((PsiNameIdentifierOwner)element2).getTextRange().getStartOffset();
                    PsiElement psiElement = ((PsiNameIdentifierOwner)element2).getNameIdentifier();
                    Integer elementNameOffset = psiElement != null && (psiElement = psiElement.getTextRange()) != null ? Integer.valueOf(psiElement.getStartOffset()) : null;
                    boolean crossesElementStart = this.$selectionModel.getSelectionStart() <= elementOffset && elementOffset <= this.$selectionModel.getSelectionEnd();
                    boolean bl = crossesElementName = elementNameOffset != null && this.$selectionModel.getSelectionStart() <= elementNameOffset && elementNameOffset <= this.$selectionModel.getSelectionEnd();
                    if (crossesElementStart || crossesElementName) {
                        this.$ret.add((PsiNameIdentifierOwner)element2);
                    }
                }
                super.visitElement(element2);
            }
        });
        if (!((Collection)ret).isEmpty()) {
            return ret;
        }
        PsiElement psiElement = CollectHighlightsUtil.findCommonParent((PsiElement)root, (int)selectionModel.getSelectionStart(), (int)selectionModel.getSelectionEnd());
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement commonParent = psiElement;
        PsiNameIdentifierOwner psiNameIdentifierOwner = this.findNearestDocumentationTarget(commonParent);
        if (psiNameIdentifierOwner == null) {
            return CollectionsKt.emptyList();
        }
        PsiNameIdentifierOwner closestNamedElement = psiNameIdentifierOwner;
        return CollectionsKt.listOf((Object)closestNamedElement);
    }

    @Nullable
    public PsiNameIdentifierOwner findNearestDocumentationTarget(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Sequence $this$filterIsInstance$iv = SequencesKt.filter((Sequence)PsiTreeUtilKt.parents((PsiElement)element2, (boolean)true), arg_0 -> LLMKotlinDocumentationSupport.findNearestDocumentationTarget$lambda$3(this, arg_0));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findNearestDocumentationTarget$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return (PsiNameIdentifierOwner)SequencesKt.firstOrNull((Sequence)sequence);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PsiNameIdentifierOwner findNearestDocumentationTargetForCaret(@NotNull Editor editor2) {
        Object v1;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        PsiElement psiElement = PsiUtilBase.getElementAtCaret((Editor)editor2);
        if (psiElement == null) {
            return null;
        }
        PsiElement element2 = psiElement;
        PsiNamedElement closestNamedElement = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiNamedElement.class, (boolean)false);
        int caretOffset = editor2.getCaretModel().getOffset();
        if (!(closestNamedElement instanceof KtFile)) {
            return this.findNearestDocumentationTarget(element2);
        }
        Iterable $this$filterIsInstance$iv = ((KtFile)closestNamedElement).getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiNameIdentifierOwner)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiNameIdentifierOwner it = (PsiNameIdentifierOwner)element$iv$iv;
            boolean bl = false;
            if (!(it.getTextRange().getStartOffset() >= caretOffset)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = minElem$iv;
            } else {
                PsiNameIdentifierOwner it = (PsiNameIdentifierOwner)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getTextRange().getStartOffset() - caretOffset;
                do {
                    Object e$iv = iterator$iv.next();
                    PsiNameIdentifierOwner it2 = (PsiNameIdentifierOwner)e$iv;
                    $i$a$-minByOrNull-LLMKotlinDocumentationSupport$findNearestDocumentationTargetForCaret$2 = false;
                    int v$iv = it2.getTextRange().getStartOffset() - caretOffset;
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = minElem$iv;
            }
        }
        return v1;
    }

    public void reformatDocumentation(@NotNull Editor editor2, @NotNull PsiElement documentationTarget) {
        int docCommentEndLine;
        int siblingEndLine;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)documentationTarget, (String)"documentationTarget");
        PsiElement psiElement = this.getDocComment(documentationTarget);
        if (psiElement == null) {
            return;
        }
        PsiElement docComment = psiElement;
        PsiElement psiElement2 = PsiTreeUtil.skipWhitespacesForward((PsiElement)docComment);
        if (psiElement2 == null) {
            return;
        }
        PsiElement nextSibling = psiElement2;
        if (nextSibling instanceof PsiComment && (siblingEndLine = editor2.getDocument().getLineNumber(((PsiComment)nextSibling).getTextRange().getEndOffset())) == (docCommentEndLine = editor2.getDocument().getLineNumber(docComment.getTextRange().getEndOffset()))) {
            Project project2 = documentationTarget.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            documentationTarget.addAfter(new KtPsiFactory(project2, false, 2, null).createNewLine(1), docComment);
        }
    }

    @Nullable
    public WdPromptCustomization promptCustomization(@NotNull Project project2) {
        WdPromptCustomization.User user;
        PSString pSString;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        AISystemLibraryPrompt aISystemLibraryPrompt = AISystemLibraryPromptService.Companion.getInstance(project2).findPrompt("AIAssistant.WriteDocumentation.Kotlin");
        if (aISystemLibraryPrompt != null && (pSString = aISystemLibraryPrompt.getContent()) != null) {
            PSString it = pSString;
            boolean bl = false;
            user = new WdPromptCustomization.User(it);
        } else {
            user = null;
        }
        return (WdPromptCustomization)user;
    }

    private final boolean isMember(PsiElement element2) {
        return element2 instanceof KtNamedDeclaration;
    }

    private final boolean isTypeBody(PsiElement element2) {
        return element2 instanceof KtClassBody;
    }

    private final boolean isType(PsiElement element2) {
        return element2 instanceof KtClass;
    }

    private final boolean isTypeBodyOrFile(PsiElement element2) {
        return this.isTypeBody(element2) || element2 instanceof KtFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDocumentableDeclaration(PsiElement element2) {
        if (!(element2 instanceof PsiNameIdentifierOwner)) {
            return false;
        }
        if (this.isMember(element2)) {
            PsiElement psiElement = ((PsiNameIdentifierOwner)element2).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
            if (this.isTypeBodyOrFile(psiElement)) return true;
        }
        if (!this.isType(element2)) return false;
        PsiElement psiElement = ((PsiNameIdentifierOwner)element2).getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
        if (!this.isTypeBodyOrFile(psiElement)) return false;
        return true;
    }

    private static final boolean findNearestDocumentationTarget$lambda$3(LLMKotlinDocumentationSupport this$0, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isDocumentableDeclaration(it);
    }

    public static final /* synthetic */ boolean access$isDocumentableDeclaration(LLMKotlinDocumentationSupport $this, PsiElement element2) {
        return $this.isDocumentableDeclaration(element2);
    }
}

