/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.mcp.client;

import com.intellij.ml.llm.mcp.client.McpBundle;
import com.intellij.ml.llm.mcp.client.McpClientRegistryException;
import com.intellij.ml.llm.mcp.client.McpClientRegistryImplKt;
import com.intellij.ml.llm.mcp.client.McpClientService;
import com.intellij.ml.llm.mcp.client.McpClientSystemRegistry;
import com.intellij.ml.llm.mcp.client.McpServerDescriptor;
import com.intellij.ml.llm.mcp.client.settings.McpApplicationServerCommandService;
import com.intellij.ml.llm.mcp.client.settings.McpConfigurable;
import com.intellij.ml.llm.mcp.client.settings.McpProjectServerCommandService;
import com.intellij.ml.llm.mcp.client.settings.McpServerCommand;
import com.intellij.ml.llm.mcp.client.settings.McpServerCommandServiceBase;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfigurationSource;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J*\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00072\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J$\u0010\u001b\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/mcp/client/McpClientRegistryImpl;", "Lcom/intellij/ml/llm/mcp/client/McpClientSystemRegistry;", "<init>", "()V", "getConfigurations", "", "", "Lcom/intellij/ml/llm/mcp/client/McpServerDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "addConfiguration", "descriptor", "updateConfiguration", "", "id", "removeConfiguration", "getConfigurationService", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerCommandServiceBase;", "validate", "configuration", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerCommand;", "registerConfiguration", "allowedToolsNames", "", "", "registerConfigurationWithoutPersistence", "Lcom/intellij/openapi/application/AccessToken;", "showSettingsChangedNotification", "added", "", "intellij.ml.llm.mcp"})
@SourceDebugExtension(value={"SMAP\nMcpClientRegistryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpClientRegistryImpl.kt\ncom/intellij/ml/llm/mcp/client/McpClientRegistryImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n1208#2,2:176\n1236#2,4:178\n1252#2,4:184\n1761#2,3:188\n463#3:182\n413#3:183\n1#4:191\n*S KotlinDebug\n*F\n+ 1 McpClientRegistryImpl.kt\ncom/intellij/ml/llm/mcp/client/McpClientRegistryImpl\n*L\n25#1:176,2\n25#1:178,4\n26#1:184,4\n38#1:188,3\n26#1:182\n26#1:183\n*E\n"})
public final class McpClientRegistryImpl
implements McpClientSystemRegistry {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Integer, McpServerDescriptor> getConfigurations(@Nullable Project project2) {
        void $this$mapValuesTo$iv$iv;
        Map map2;
        void $this$associateByTo$iv$iv;
        McpServerCommandServiceBase configurationService = this.getConfigurationService(project2);
        Iterable $this$associateBy$iv = configurationService.getCommands();
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            McpServerCommand mcpServerCommand = (McpServerCommand)element$iv$iv;
            map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getId(), element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        Map capacity$iv22 = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv2;
            boolean bl2 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map2 = map3;
            boolean bl3 = false;
            McpServerDescriptor mcpServerDescriptor = McpClientRegistryImplKt.toDescriptor((McpServerCommand)it.getValue());
            map2.put(k, mcpServerDescriptor);
        }
        return destination$iv$iv2;
    }

    @Override
    public int addConfiguration(@NotNull McpServerDescriptor descriptor2, @Nullable Project project2) {
        boolean bl;
        List<McpServerCommand> existingConfigurations;
        McpServerCommandServiceBase configurationService;
        McpServerCommand configuration;
        block4: {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            configuration = McpClientRegistryImplKt.toConfiguration(descriptor2);
            configuration.setEnabled(false);
            configuration.setSource(McpServerConfigurationSource.PLUGIN);
            this.validate(configuration);
            configurationService = this.getConfigurationService(project2);
            existingConfigurations = configurationService.getCommands();
            Iterable $this$any$iv = existingConfigurations;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    McpServerCommand it = (McpServerCommand)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)configuration.getName())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new McpClientRegistryException("Configuration with name " + configuration.getName() + " already exists");
        }
        configurationService.setCommands(CollectionsKt.plus((Collection)existingConfigurations, (Object)configuration), CollectionsKt.emptyList());
        McpClientRegistryImplKt.access$getLOG$p().debug("Added configuration: " + configuration);
        this.showSettingsChangedNotification(project2, configuration, true);
        return configuration.getId();
    }

    @Override
    public void updateConfiguration(int id, @NotNull McpServerDescriptor descriptor2, @Nullable Project project2) {
        Object v0;
        List existingConfigurations;
        McpServerCommandServiceBase configurationService;
        McpServerCommand configuration;
        block3: {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            configuration = McpClientRegistryImplKt.toConfiguration(descriptor2);
            configuration.setEnabled(false);
            configuration.setSource(McpServerConfigurationSource.PLUGIN);
            this.validate(configuration);
            configurationService = this.getConfigurationService(project2);
            existingConfigurations = CollectionsKt.toMutableList((Collection)configurationService.getCommands());
            Iterable iterable = existingConfigurations;
            for (Object t : iterable) {
                McpServerCommand it = (McpServerCommand)t;
                boolean bl = false;
                if (!(it.getId() == id)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        McpServerCommand mcpServerCommand = v0;
        if (mcpServerCommand == null) {
            throw new McpClientRegistryException("Configuration with id " + id + " not found");
        }
        McpServerCommand existingConfiguration = mcpServerCommand;
        if (!Intrinsics.areEqual(existingConfiguration.getClass(), configuration.getClass())) {
            throw new McpClientRegistryException("Cannot change configuration type");
        }
        existingConfiguration.copyFrom(configuration);
        configurationService.setCommands(existingConfigurations, CollectionsKt.emptyList());
        McpClientRegistryImplKt.access$getLOG$p().debug("Updated configuration: " + existingConfiguration);
        this.showSettingsChangedNotification(project2, existingConfiguration, false);
    }

    @Override
    public void removeConfiguration(int id, @Nullable Project project2) {
        Object v0;
        List<McpServerCommand> existingConfigurations;
        McpServerCommandServiceBase configurationService;
        block2: {
            configurationService = this.getConfigurationService(project2);
            existingConfigurations = configurationService.getCommands();
            Iterable iterable = existingConfigurations;
            for (Object t : iterable) {
                McpServerCommand it = (McpServerCommand)t;
                boolean bl = false;
                if (!(it.getId() == id)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        McpServerCommand mcpServerCommand = v0;
        if (mcpServerCommand == null) {
            throw new McpClientRegistryException("Configuration with id " + id + " not found");
        }
        McpServerCommand existingConfiguration = mcpServerCommand;
        configurationService.setCommands(CollectionsKt.minus((Iterable)existingConfigurations, (Object)existingConfiguration), CollectionsKt.emptyList());
        McpClientRegistryImplKt.access$getLOG$p().debug("Removed configuration: " + existingConfiguration);
    }

    private final McpServerCommandServiceBase getConfigurationService(Project project2) {
        return project2 == null ? (McpServerCommandServiceBase)McpApplicationServerCommandService.Companion.getInstance() : (McpServerCommandServiceBase)McpProjectServerCommandService.Companion.getInstance(project2);
    }

    private final void validate(McpServerCommand configuration) {
        if (StringsKt.isBlank((CharSequence)configuration.getName())) {
            throw new McpClientRegistryException("Name cannot be blank");
        }
    }

    @Override
    public void registerConfiguration(@NotNull McpServerDescriptor descriptor2, @Nullable List<String> allowedToolsNames, @Nullable Project project2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        McpServerCommand configuration = McpClientRegistryImplKt.toConfiguration(descriptor2);
        configuration.setEnabled(true);
        configuration.setSource(McpServerConfigurationSource.SYSTEM);
        configuration.setAllowedToolsNames(allowedToolsNames);
        this.validate(configuration);
        McpServerCommandServiceBase configurationService = this.getConfigurationService(project2);
        configurationService.setCommands(CollectionsKt.plus((Collection)configurationService.getCommands(), (Object)configuration), CollectionsKt.emptyList());
        McpClientRegistryImplKt.access$getLOG$p().debug("Registered configuration: " + configuration);
    }

    @Override
    @NotNull
    public AccessToken registerConfigurationWithoutPersistence(@NotNull Project project2, @NotNull McpServerDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        McpServerCommand configuration = McpClientRegistryImplKt.toConfiguration(descriptor2);
        configuration.setEnabled(true);
        configuration.setSource(McpServerConfigurationSource.SYSTEM);
        this.validate(configuration);
        AccessToken token = McpClientService.McpProjectClientService.Companion.getInstance(project2).registerClient$intellij_ml_llm_mcp(configuration);
        McpClientRegistryImplKt.access$getLOG$p().debug("Registered configuration without persistence: " + configuration);
        return token;
    }

    private final void showSettingsChangedNotification(Project project2, McpServerCommand configuration, boolean added) {
        String string;
        Object object;
        if (added) {
            object = new Object[]{configuration.getName()};
            string = McpBundle.message("ml.llm.mcp.settings.added.notification.description", (Object[])object);
        } else {
            object = new Object[]{configuration.getName()};
            string = McpBundle.message("ml.llm.mcp.settings.changed.notification.description", (Object[])object);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String description = string2;
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("MCP Client");
        String string3 = McpBundle.message("ml.llm.mcp.settings.changed.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        object = notificationGroup.createNotification(string3, description, NotificationType.INFORMATION).setDisplayId("mcp.client.settings.changed");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setDisplayId(...)");
        Notification notification2 = object;
        object = McpBundle.message("ml.llm.mcp.settings.changed.enable", new Object[0]);
        DumbAware dumbAware = new DumbAware(project2, configuration, notification2, (String)object){
            final /* synthetic */ Project $project;
            final /* synthetic */ McpServerCommand $configuration;
            final /* synthetic */ Notification $notification;
            {
                this.$project = $project;
                this.$configuration = $configuration;
                this.$notification = $notification;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                McpServerCommandServiceBase service = this.$project == null ? (McpServerCommandServiceBase)McpApplicationServerCommandService.Companion.getInstance() : (McpServerCommandServiceBase)McpProjectServerCommandService.Companion.getInstance(this.$project);
                List<McpServerCommand> configurations = service.getCommands();
                this.$configuration.setEnabled(true);
                service.setCommands(configurations, CollectionsKt.emptyList());
                this.$notification.expire();
            }
        };
        object = McpBundle.message("ml.llm.mcp.settings.changed.open.settings", new Object[0]);
        notification2.addAction((AnAction)dumbAware).addAction((AnAction)new DumbAware(project2, notification2, (String)object){
            final /* synthetic */ Project $project;
            final /* synthetic */ Notification $notification;
            {
                this.$project = $project;
                this.$notification = $notification;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ShowSettingsUtil.getInstance().showSettingsDialog(this.$project, McpConfigurable.class);
                this.$notification.expire();
            }
        });
        notification2.notify(project2);
    }

    static /* synthetic */ void showSettingsChangedNotification$default(McpClientRegistryImpl mcpClientRegistryImpl, Project project2, McpServerCommand mcpServerCommand, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        mcpClientRegistryImpl.showSettingsChangedNotification(project2, mcpServerCommand, bl);
    }
}

