/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.mcp.client.settings;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ml.llm.mcp.client.McpBundle;
import com.intellij.ml.llm.mcp.client.aie.AieBridgeService;
import com.intellij.ml.llm.mcp.client.aie.McpProvisioningServer;
import com.intellij.ml.llm.mcp.client.aie.McpProvisioningSettings;
import com.intellij.ml.llm.mcp.client.aie.StdioMcpProvisioningServerConfig;
import com.intellij.ml.llm.mcp.client.settings.McpHashEncryptionKt;
import com.intellij.ml.llm.mcp.client.settings.McpServerCommand;
import com.intellij.ml.llm.mcp.client.settings.McpServerCommandServiceBase;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfigurationSource;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service
@State(name="McpApplicationServerCommands", storages={@Storage(value="llm.mcpServers.xml", roamingType=RoamingType.LOCAL)})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eJ\u0006\u0010\u000f\u001a\u00020\u0007J$\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0018H\u0016J\b\u0010\u001b\u001a\u00020\u0011H\u0016J\b\u0010\u001c\u001a\u00020\u0011H\u0002J\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\b\u0010\u001f\u001a\u00020\u0011H\u0002J\u000e\u0010 \u001a\u0004\u0018\u00010\u0014*\u00020!H\u0002J\u000f\u0010\"\u001a\u0004\u0018\u00010\u001eH\u0001\u00a2\u0006\u0002\b#J\r\u0010$\u001a\u00020\u0011H\u0001\u00a2\u0006\u0002\b%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/ml/llm/mcp/client/settings/McpApplicationServerCommandService;", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerCommandServiceBase;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "value", "", "modifiable", "getModifiable", "()Z", "_validationFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "getValidationFlow", "Lkotlinx/coroutines/flow/SharedFlow;", "isValidated", "setCommands", "", "commands", "", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerCommand;", "levelChangedCommands", "", "getState", "Lorg/jdom/Element;", "loadState", "state", "noStateLoaded", "validateState", "calculateCommandsHash", "", "showHashMismatchError", "toCommand", "Lcom/intellij/ml/llm/mcp/client/aie/McpProvisioningServer;", "getCommandsHash", "getCommandsHash$intellij_ml_llm_mcp", "resetValidation", "resetValidation$intellij_ml_llm_mcp", "Companion", "intellij.ml.llm.mcp"})
@SourceDebugExtension(value={"SMAP\nMcpApplicationServerCommandService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpApplicationServerCommandService.kt\ncom/intellij/ml/llm/mcp/client/settings/McpApplicationServerCommandService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1056#2:201\n1#3:202\n*S KotlinDebug\n*F\n+ 1 McpApplicationServerCommandService.kt\ncom/intellij/ml/llm/mcp/client/settings/McpApplicationServerCommandService\n*L\n145#1:201\n*E\n"})
public final class McpApplicationServerCommandService
extends McpServerCommandServiceBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    private volatile boolean modifiable;
    @NotNull
    private final MutableStateFlow<Boolean> _validationFlow;
    @NotNull
    private static final String SETTINGS_HASH_KEY = "mcp.settings.hash";
    @NotNull
    private static final String NOTIFICATION_GROUP_ID = "MCP Client";
    @NotNull
    private static final String NOTIFICATION_ID_SETTING_ERROR = "mcp.client.settings.error";

    public McpApplicationServerCommandService(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        this.modifiable = true;
        this._validationFlow = StateFlowKt.MutableStateFlow((Object)false);
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ McpApplicationServerCommandService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)AieBridgeService.Companion.getInstance().getProvisioningSettings()), (Function2)((Function2)new Function2<McpProvisioningSettings, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ McpApplicationServerCommandService this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             * Could not resolve type clashes
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = (McpProvisioningSettings)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (settings == null) {
                                            return Unit.INSTANCE;
                                        }
                                        McpApplicationServerCommandService.access$setModifiable$p(this.this$0, settings.getAllowMcpServerManagement());
                                        var4_3 = settings.getServers();
                                        var5_4 = this.this$0;
                                        $i$f$mapNotNull = false;
                                        var7_7 = $this$mapNotNull$iv;
                                        destination$iv$iv = new ArrayList<E>();
                                        $i$f$mapNotNullTo = false;
                                        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                        $i$f$forEach = false;
                                        var12_17 /* !! */  = $this$forEach$iv$iv$iv.iterator();
                                        while (var12_17 /* !! */ .hasNext()) {
                                            element$iv$iv = element$iv$iv$iv = var12_17 /* !! */ .next();
                                            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                                            it = (McpProvisioningServer)element$iv$iv;
                                            $i$a$-mapNotNull-McpApplicationServerCommandService$1$1$provisioningCommands$1 = false;
                                            if (McpApplicationServerCommandService.access$toCommand(var5_4, it) == null) continue;
                                            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                                            destination$iv$iv.add(it$iv$iv);
                                        }
                                        provisioningCommands = (List)destination$iv$iv;
                                        oldCommands = this.this$0.getCommands();
                                        newCommands = new ArrayList<McpServerCommand>();
                                        for (McpServerCommand provisioningCommand : provisioningCommands) {
                                            $this$forEach$iv$iv$iv = oldCommands;
                                            for (Iterator<T> var12_17 : $this$forEach$iv$iv$iv) {
                                                it = (McpServerCommand)var12_17 /* !! */ ;
                                                $i$a$-find-McpApplicationServerCommandService$1$1$oldCommand$1 = false;
                                                if (!Intrinsics.areEqual((Object)it.getName(), (Object)provisioningCommand.getName())) continue;
                                                v0 /* !! */  = var12_17 /* !! */ ;
                                                ** GOTO lbl41
                                            }
                                            v0 /* !! */  = null;
lbl41:
                                            // 2 sources

                                            oldCommand = (McpServerCommand)v0 /* !! */ ;
                                            if (oldCommand != null) {
                                                enabled = oldCommand.getEnabled();
                                                newCommand = new McpServerCommand(oldCommand);
                                                newCommand.copyFrom(provisioningCommand);
                                                newCommand.setEnabled(enabled != false);
                                                v1 = newCommands.add(newCommand);
                                                continue;
                                            }
                                            v1 = newCommands.add(provisioningCommand);
                                        }
                                        if (!this.this$0.getModifiable()) ** GOTO lbl83
                                        if (provisioningCommands.isEmpty()) {
                                            McpApplicationServerCommandService.access$get_validationFlow$p(this.this$0).setValue((Object)Boxing.boxBoolean((boolean)true));
                                            return Unit.INSTANCE;
                                        }
                                        $i$f$mapNotNull = oldCommands;
                                        var21_32 = newCommands;
                                        $i$f$filter = false;
                                        oldCommand = $this$filter$iv;
                                        destination$iv$iv = new ArrayList<E>();
                                        $i$f$filterTo = false;
                                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                                            oldCommand = (McpServerCommand)element$iv$iv;
                                            $i$a$-filter-McpApplicationServerCommandService$1$1$1 = false;
                                            $this$none$iv = provisioningCommands;
                                            $i$f$none = false;
                                            if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) ** GOTO lbl69
                                            v2 = true;
                                            ** GOTO lbl77
lbl69:
                                            // 2 sources

                                            for (T element$iv : $this$none$iv) {
                                                it = (McpServerCommand)element$iv;
                                                $i$a$-none-McpApplicationServerCommandService$1$1$1$1 = false;
                                                if (!Intrinsics.areEqual((Object)it.getName(), (Object)oldCommand.getName())) continue;
                                                v2 = false;
                                                ** GOTO lbl77
                                            }
                                            v2 = true;
lbl77:
                                            // 3 sources

                                            if (!v2) continue;
                                            destination$iv$iv.add(element$iv$iv);
                                        }
                                        var21_32.addAll((List)destination$iv$iv);
lbl83:
                                        // 2 sources

                                        McpApplicationServerCommandService.access$setCommands$s787578648(this.this$0, newCommands, CollectionsKt.emptyList());
                                        McpApplicationServerCommandService.access$get_validationFlow$p(this.this$0).setValue((Object)Boxing.boxBoolean((boolean)true));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(McpProvisioningSettings p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final boolean getModifiable() {
        return this.modifiable;
    }

    @NotNull
    public final SharedFlow<Boolean> getValidationFlow() {
        return FlowKt.asSharedFlow((MutableSharedFlow)((MutableSharedFlow)this._validationFlow));
    }

    public final boolean isValidated() {
        return (Boolean)this._validationFlow.getValue();
    }

    @Override
    public void setCommands(@NotNull List<McpServerCommand> commands, @NotNull Collection<McpServerCommand> levelChangedCommands) {
        Intrinsics.checkNotNullParameter(commands, (String)"commands");
        Intrinsics.checkNotNullParameter(levelChangedCommands, (String)"levelChangedCommands");
        if (!this.modifiable) {
            if (!levelChangedCommands.isEmpty()) {
                return;
            }
            List<McpServerCommand> existingConfigurations = this.getCommands();
            if (existingConfigurations.size() != commands.size()) {
                return;
            }
            int n = ((Collection)existingConfigurations).size();
            for (int i = 0; i < n; ++i) {
                McpServerCommand newConfiguration;
                McpServerCommand existingConfiguration = existingConfigurations.get(i);
                if (existingConfiguration.isEquivalent(newConfiguration = commands.get(i))) continue;
                return;
            }
        }
        super.setCommands(commands, levelChangedCommands);
    }

    @Override
    @NotNull
    public Element getState() {
        Element element2 = super.getState();
        element2.setAttribute("modifiable", String.valueOf(this.modifiable));
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ McpApplicationServerCommandService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!this.this$0.getModifiable()) {
                            String hash = McpApplicationServerCommandService.access$calculateCommandsHash(this.this$0, this.this$0.getCommands());
                            String encryptedHash = McpHashEncryptionKt.encryptHash(hash);
                            PropertiesComponent.getInstance().setValue("mcp.settings.hash", encryptedHash);
                        } else {
                            PropertiesComponent.getInstance().setValue("mcp.settings.hash", null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return element2;
    }

    @Override
    public void loadState(@NotNull Element state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        super.loadState(state2);
        Object object = state2.getAttributeValue("modifiable");
        this.modifiable = object != null && (object = StringsKt.toBooleanStrictOrNull((String)object)) != null ? (Boolean)object : true;
        this.validateState();
    }

    public void noStateLoaded() {
        this.validateState();
    }

    private final void validateState() {
        String storedEncryptedHash = PropertiesComponent.getInstance().getValue(SETTINGS_HASH_KEY);
        if (storedEncryptedHash != null && !((Boolean)this._validationFlow.getValue()).booleanValue()) {
            String storedHash = McpHashEncryptionKt.decryptHash(storedEncryptedHash);
            String currentHash = this.calculateCommandsHash(this.getCommands());
            if (this.modifiable || storedHash == null || !Intrinsics.areEqual((Object)storedHash, (Object)currentHash)) {
                this.modifiable = false;
                super.setCommands(CollectionsKt.emptyList(), CollectionsKt.emptyList());
                this.showHashMismatchError();
            }
        }
        this._validationFlow.setValue((Object)true);
    }

    private final String calculateCommandsHash(List<McpServerCommand> commands) {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        Iterable $this$sortedBy$iv = commands;
        boolean $i$f$sortedBy = false;
        for (McpServerCommand command : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                McpServerCommand it = (McpServerCommand)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (McpServerCommand)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        })) {
            List<String> list;
            block4: {
                block3: {
                    String string = command.getName();
                    byte[] byArray = string.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    digest.update(byArray);
                    string = command.getProgramPath();
                    byte[] byArray2 = string.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
                    digest.update(byArray2);
                    string = command.getArguments();
                    byte[] byArray3 = string.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
                    digest.update(byArray3);
                    string = command.getWorkingDirectory();
                    byte[] byArray4 = string.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"getBytes(...)");
                    digest.update(byArray4);
                    String string2 = command.getEnvData().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    string = string2;
                    byte[] byArray5 = string.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"getBytes(...)");
                    digest.update(byArray5);
                    list = command.getAllowedToolsNames();
                    if (list == null || (list = list.toString()) == null) break block3;
                    List<String> list2 = list;
                    byte[] byArray6 = ((String)((Object)list2)).getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray6, (String)"getBytes(...)");
                    list = (List<String>)byArray6;
                    if (byArray6 != null) break block4;
                }
                list = (List<String>)new byte[0];
            }
            digest.update((byte[])list);
        }
        byte[] byArray = digest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, McpApplicationServerCommandService::calculateCommandsHash$lambda$1, (int)30, null);
    }

    private final void showHashMismatchError() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup(NOTIFICATION_GROUP_ID);
        String string = McpBundle.message("ml.llm.mcp.settings.error.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = McpBundle.message("ml.llm.mcp.settings.error.notification.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        notificationGroup.createNotification(string, string2, NotificationType.ERROR).setDisplayId(NOTIFICATION_ID_SETTING_ERROR).notify(null);
    }

    private final McpServerCommand toCommand(McpProvisioningServer $this$toCommand) {
        McpServerCommand mcpServerCommand;
        if ($this$toCommand.getConfig() instanceof StdioMcpProvisioningServerConfig) {
            Map map2;
            String string = $this$toCommand.getName();
            String string2 = ((StdioMcpProvisioningServerConfig)$this$toCommand.getConfig()).getCommand();
            List<String> list = ((StdioMcpProvisioningServerConfig)$this$toCommand.getConfig()).getArguments();
            if (list == null || (list = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)) == null) {
                list = "";
            }
            if ((map2 = ((StdioMcpProvisioningServerConfig)$this$toCommand.getConfig()).getEnvVariables()) == null) {
                map2 = MapsKt.emptyMap();
            }
            EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.create((Map)map2, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"create(...)");
            mcpServerCommand = new McpServerCommand(string, string2, (String)((Object)list), "", environmentVariablesData, false, McpServerConfigurationSource.AIE);
        } else {
            mcpServerCommand = null;
        }
        return mcpServerCommand;
    }

    @TestOnly
    @Nullable
    public final String getCommandsHash$intellij_ml_llm_mcp() {
        String string;
        String encryptedHash;
        String string2 = encryptedHash = PropertiesComponent.getInstance().getValue(SETTINGS_HASH_KEY);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = McpHashEncryptionKt.decryptHash(it);
        } else {
            string = null;
        }
        return string;
    }

    @TestOnly
    public final void resetValidation$intellij_ml_llm_mcp() {
        this._validationFlow.setValue((Object)false);
        for (McpServerCommand configuration : this.getCommands()) {
            this.fireCommandRemoved(configuration);
        }
    }

    private static final CharSequence calculateCommandsHash$lambda$1(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final McpApplicationServerCommandService getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ String access$calculateCommandsHash(McpApplicationServerCommandService $this, List commands) {
        return $this.calculateCommandsHash(commands);
    }

    public static final /* synthetic */ void access$setModifiable$p(McpApplicationServerCommandService $this, boolean bl) {
        $this.modifiable = bl;
    }

    public static final /* synthetic */ MutableStateFlow access$get_validationFlow$p(McpApplicationServerCommandService $this) {
        return $this._validationFlow;
    }

    public static final /* synthetic */ void access$setCommands$s787578648(McpApplicationServerCommandService $this, List commands, Collection levelChangedCommands) {
        super.setCommands(commands, levelChangedCommands);
    }

    public static final /* synthetic */ McpServerCommand access$toCommand(McpApplicationServerCommandService $this, McpProvisioningServer $receiver) {
        return $this.toCommand($receiver);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/mcp/client/settings/McpApplicationServerCommandService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/mcp/client/settings/McpApplicationServerCommandService;", "SETTINGS_HASH_KEY", "", "NOTIFICATION_GROUP_ID", "NOTIFICATION_ID_SETTING_ERROR", "intellij.ml.llm.mcp"})
    @SourceDebugExtension(value={"SMAP\nMcpApplicationServerCommandService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpApplicationServerCommandService.kt\ncom/intellij/ml/llm/mcp/client/settings/McpApplicationServerCommandService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,200:1\n40#2,3:201\n*S KotlinDebug\n*F\n+ 1 McpApplicationServerCommandService.kt\ncom/intellij/ml/llm/mcp/client/settings/McpApplicationServerCommandService$Companion\n*L\n27#1:201,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final McpApplicationServerCommandService getInstance() {
            boolean $i$f$service = false;
            Class<McpApplicationServerCommandService> serviceClass$iv = McpApplicationServerCommandService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (McpApplicationServerCommandService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

