/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.mcp.client.settings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ml.llm.mcp.client.McpBundle;
import com.intellij.ml.llm.mcp.client.settings.McpServerBean;
import com.intellij.ml.llm.mcp.client.settings.McpServerCommand;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfigurationSource;
import com.intellij.ml.llm.mcp.client.settings.McpServerEditPanelKt;
import com.intellij.ml.llm.mcp.client.settings.McpServersBean;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.observable.util.PropertyOperationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.validation.DialogValidation;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u00109\u001a\u0004\u0018\u0001002\u0006\u0010:\u001a\u00020;H\u0002J\u000e\u0010<\u001a\u00020,2\u0006\u0010\u0002\u001a\u00020\u0003J\u001e\u0010<\u001a\u00020,2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@J\u0012\u0010A\u001a\u0004\u0018\u0001002\u0006\u0010B\u001a\u00020#H\u0002J\u000e\u0010C\u001a\u0004\u0018\u000100*\u00020DH\u0002J\u0006\u0010E\u001a\u00020*R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u000f\"\u0004\b \u0010\u0011R \u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u001c\u0010/\u001a\u0004\u0018\u000100X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u0011\u00105\u001a\u000206\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108\u00a8\u0006F"}, d2={"Lcom/intellij/ml/llm/mcp/client/settings/McpServerEditPanel;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "nameField", "Lcom/intellij/ui/components/JBTextField;", "getNameField", "()Lcom/intellij/ui/components/JBTextField;", "setNameField", "(Lcom/intellij/ui/components/JBTextField;)V", "programField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "getProgramField", "()Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "setProgramField", "(Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;)V", "argumentsField", "Lcom/intellij/ui/RawCommandLineEditor;", "getArgumentsField", "()Lcom/intellij/ui/RawCommandLineEditor;", "setArgumentsField", "(Lcom/intellij/ui/RawCommandLineEditor;)V", "envComponent", "Lcom/intellij/execution/configuration/EnvironmentVariablesComponent;", "getEnvComponent", "()Lcom/intellij/execution/configuration/EnvironmentVariablesComponent;", "setEnvComponent", "(Lcom/intellij/execution/configuration/EnvironmentVariablesComponent;)V", "workingDirField", "getWorkingDirField", "setWorkingDirField", "switcher", "Lcom/intellij/openapi/ui/ComboBox;", "", "getSwitcher", "()Lcom/intellij/openapi/ui/ComboBox;", "setSwitcher", "(Lcom/intellij/openapi/ui/ComboBox;)V", "switcherProperty", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "editorCommand", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerCommand;", "getEditorCommand", "()Lcom/intellij/ml/llm/mcp/client/settings/McpServerCommand;", "setEditorCommand", "(Lcom/intellij/ml/llm/mcp/client/settings/McpServerCommand;)V", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "getPanel", "()Lcom/intellij/openapi/ui/DialogPanel;", "updateCommandFromJson", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "createEditor", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "document", "Lcom/intellij/openapi/editor/Document;", "parseCommand", "text", "asCommand", "Lcom/intellij/ml/llm/mcp/client/settings/McpServersBean;", "isJson", "intellij.ml.llm.mcp"})
public final class McpServerEditPanel {
    public JBTextField nameField;
    public TextFieldWithBrowseButton programField;
    public RawCommandLineEditor argumentsField;
    public EnvironmentVariablesComponent envComponent;
    public TextFieldWithBrowseButton workingDirField;
    public ComboBox<String> switcher;
    @NotNull
    private final AtomicProperty<Boolean> switcherProperty;
    @NotNull
    private final EditorEx editor;
    @Nullable
    private McpServerCommand editorCommand;
    @NotNull
    private final DialogPanel panel;

    public McpServerEditPanel(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.switcherProperty = new AtomicProperty((Object)true);
        this.editor = this.createEditor(project2);
        this.panel = BuilderKt.panel(arg_0 -> McpServerEditPanel.panel$lambda$11(this, project2, arg_0));
    }

    @NotNull
    public final JBTextField getNameField() {
        JBTextField jBTextField = this.nameField;
        if (jBTextField != null) {
            return jBTextField;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"nameField");
        return null;
    }

    public final void setNameField(@NotNull JBTextField jBTextField) {
        Intrinsics.checkNotNullParameter((Object)jBTextField, (String)"<set-?>");
        this.nameField = jBTextField;
    }

    @NotNull
    public final TextFieldWithBrowseButton getProgramField() {
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.programField;
        if (textFieldWithBrowseButton != null) {
            return textFieldWithBrowseButton;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"programField");
        return null;
    }

    public final void setProgramField(@NotNull TextFieldWithBrowseButton textFieldWithBrowseButton) {
        Intrinsics.checkNotNullParameter((Object)textFieldWithBrowseButton, (String)"<set-?>");
        this.programField = textFieldWithBrowseButton;
    }

    @NotNull
    public final RawCommandLineEditor getArgumentsField() {
        RawCommandLineEditor rawCommandLineEditor = this.argumentsField;
        if (rawCommandLineEditor != null) {
            return rawCommandLineEditor;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"argumentsField");
        return null;
    }

    public final void setArgumentsField(@NotNull RawCommandLineEditor rawCommandLineEditor) {
        Intrinsics.checkNotNullParameter((Object)rawCommandLineEditor, (String)"<set-?>");
        this.argumentsField = rawCommandLineEditor;
    }

    @NotNull
    public final EnvironmentVariablesComponent getEnvComponent() {
        EnvironmentVariablesComponent environmentVariablesComponent = this.envComponent;
        if (environmentVariablesComponent != null) {
            return environmentVariablesComponent;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"envComponent");
        return null;
    }

    public final void setEnvComponent(@NotNull EnvironmentVariablesComponent environmentVariablesComponent) {
        Intrinsics.checkNotNullParameter((Object)environmentVariablesComponent, (String)"<set-?>");
        this.envComponent = environmentVariablesComponent;
    }

    @NotNull
    public final TextFieldWithBrowseButton getWorkingDirField() {
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.workingDirField;
        if (textFieldWithBrowseButton != null) {
            return textFieldWithBrowseButton;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"workingDirField");
        return null;
    }

    public final void setWorkingDirField(@NotNull TextFieldWithBrowseButton textFieldWithBrowseButton) {
        Intrinsics.checkNotNullParameter((Object)textFieldWithBrowseButton, (String)"<set-?>");
        this.workingDirField = textFieldWithBrowseButton;
    }

    @NotNull
    public final ComboBox<String> getSwitcher() {
        ComboBox<String> comboBox = this.switcher;
        if (comboBox != null) {
            return comboBox;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"switcher");
        return null;
    }

    public final void setSwitcher(@NotNull ComboBox<String> comboBox) {
        Intrinsics.checkNotNullParameter(comboBox, (String)"<set-?>");
        this.switcher = comboBox;
    }

    @NotNull
    public final EditorEx getEditor() {
        return this.editor;
    }

    @Nullable
    public final McpServerCommand getEditorCommand() {
        return this.editorCommand;
    }

    public final void setEditorCommand(@Nullable McpServerCommand mcpServerCommand) {
        this.editorCommand = mcpServerCommand;
    }

    @NotNull
    public final DialogPanel getPanel() {
        return this.panel;
    }

    private final McpServerCommand updateCommandFromJson(DocumentEvent event) {
        McpServerCommand mcpServerCommand;
        String string = event.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        McpServerCommand mcpServerCommand2 = this.parseCommand(string);
        if (mcpServerCommand2 != null) {
            McpServerCommand mcpServerCommand3;
            McpServerCommand $this$updateCommandFromJson_u24lambda_u2412 = mcpServerCommand3 = mcpServerCommand2;
            boolean bl = false;
            String string2 = this.getWorkingDirField().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            $this$updateCommandFromJson_u24lambda_u2412.setWorkingDirectory(string2);
            mcpServerCommand = mcpServerCommand3;
        } else {
            mcpServerCommand = null;
        }
        return mcpServerCommand;
    }

    @NotNull
    public final EditorEx createEditor(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String text2 = "";
        FileType fileType2 = FileTypeManager.getInstance().getFileTypeByExtension("json");
        Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileTypeByExtension(...)");
        FileType fileType3 = fileType2;
        LightVirtualFile virtualFile2 = new LightVirtualFile("mcp." + fileType3.getDefaultExtension(), fileType3, (CharSequence)text2);
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile((VirtualFile)virtualFile2);
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile psiFile2 = psiFile;
        Document document2 = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile2);
        Intrinsics.checkNotNull((Object)document2);
        Document document3 = document2;
        EditorEx editor2 = this.createEditor(project2, (VirtualFile)virtualFile2, document3);
        return editor2;
    }

    @NotNull
    public final EditorEx createEditor(@NotNull Project project2, @NotNull VirtualFile virtualFile2, @NotNull Document document2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Editor editor2 = EditorFactory.getInstance().createEditor(document2, project2, virtualFile2, false, EditorKind.PREVIEW);
        Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx editor3 = (EditorEx)editor2;
        editor3.setFile(virtualFile2);
        EditorSettings $this$createEditor_u24lambda_u2413 = editor3.getSettings();
        boolean bl = false;
        $this$createEditor_u24lambda_u2413.setLineNumbersShown(false);
        $this$createEditor_u24lambda_u2413.setIndentGuidesShown(false);
        $this$createEditor_u24lambda_u2413.setFoldingOutlineShown(false);
        $this$createEditor_u24lambda_u2413.setAutoCodeFoldingEnabled(false);
        $this$createEditor_u24lambda_u2413.setLineMarkerAreaShown(false);
        $this$createEditor_u24lambda_u2413.setAdditionalLinesCount(7);
        $this$createEditor_u24lambda_u2413.setAdditionalColumnsCount(50);
        $this$createEditor_u24lambda_u2413.setCaretRowShown(false);
        $this$createEditor_u24lambda_u2413.setGutterIconsShown(false);
        editor3.getComponent().setPreferredSize(editor3.getComponent().getPreferredSize());
        editor3.getSettings().setAdditionalLinesCount(0);
        editor3.getSettings().setAdditionalColumnsCount(0);
        return editor3;
    }

    private final McpServerCommand parseCommand(String text2) {
        try {
            Gson gson = new GsonBuilder().create();
            McpServersBean serversBean = (McpServersBean)gson.fromJson(text2, McpServersBean.class);
            if (serversBean.getMcpServers() == null) {
                Object object = gson.fromJson(text2, McpServerEditPanelKt.access$getMAP_TO_BEAN_TYPE$p());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                Map map2 = (Map)object;
                serversBean = new McpServersBean(map2);
            }
            McpServersBean mcpServersBean = serversBean;
            Intrinsics.checkNotNull((Object)mcpServersBean);
            return this.asCommand(mcpServersBean);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private final McpServerCommand asCommand(McpServersBean $this$asCommand) {
        McpServerCommand mcpServerCommand;
        Map<String, McpServerBean> map2 = $this$asCommand.getMcpServers();
        if (map2 != null && (map2 = map2.entrySet()) != null && (map2 = (Map.Entry)CollectionsKt.firstOrNull((Iterable)((Iterable)((Object)map2)))) != null) {
            Map<String, McpServerBean> it = map2;
            boolean bl = false;
            mcpServerCommand = ((McpServerBean)it.getValue()).getCommand() == null ? null : new McpServerCommand((String)it.getKey(), (McpServerBean)it.getValue(), McpServerConfigurationSource.USER);
        } else {
            mcpServerCommand = null;
        }
        return mcpServerCommand;
    }

    public final boolean isJson() {
        return this.getSwitcher().getSelectedIndex() == 1;
    }

    private static final void panel$lambda$11$lambda$1$lambda$0(Project $project, McpServerEditPanel this$0, ActionEvent it) {
        PropertiesComponent.getInstance((Project)$project).setValue("llm.McpServerEditPanel.switcher", this$0.getSwitcher().getSelectedIndex(), 0);
        this$0.switcherProperty.set((Object)(!this$0.isJson() ? 1 : 0));
    }

    private static final Unit panel$lambda$11$lambda$1(McpServerEditPanel this$0, Project $project, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new String[]{McpBundle.message("ml.llm.mcp.server.command", new Object[0]), McpBundle.message("ml.llm.mcp.server.as.json", new Object[0])};
        this$0.setSwitcher((ComboBox<String>)((ComboBox)Row.comboBox$default((Row)$this$row, (Collection)CollectionsKt.listOf((Object[])objectArray), null, (int)2, null).getComponent()));
        this$0.getSwitcher().addActionListener(arg_0 -> McpServerEditPanel.panel$lambda$11$lambda$1$lambda$0($project, this$0, arg_0));
        int selected = PropertiesComponent.getInstance((Project)$project).getInt("llm.McpServerEditPanel.switcher", 0);
        if (selected < this$0.getSwitcher().getItemCount()) {
            this$0.getSwitcher().setSelectedIndex(selected);
        }
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$11$lambda$2(McpServerEditPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.setNameField((JBTextField)$this$row.textField().align((Align)AlignX.FILL.INSTANCE).getComponent());
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$11$lambda$3(McpServerEditPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.setProgramField((TextFieldWithBrowseButton)$this$row.cell((JComponent)new TextFieldWithBrowseButton()).align((Align)AlignX.FILL.INSTANCE).getComponent());
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$11$lambda$4(McpServerEditPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.setArgumentsField((RawCommandLineEditor)$this$row.cell((JComponent)new RawCommandLineEditor()).align((Align)AlignX.FILL.INSTANCE).getComponent());
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$11$lambda$6$lambda$5(EnvironmentVariablesComponent $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.remove((Component)$this$applyToComponent.getLabel());
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$11$lambda$6(McpServerEditPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.setEnvComponent((EnvironmentVariablesComponent)$this$row.cell((JComponent)new EnvironmentVariablesComponent()).align((Align)AlignX.FILL.INSTANCE).applyToComponent(McpServerEditPanel::panel$lambda$11$lambda$6$lambda$5).getComponent());
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$11$lambda$9$lambda$7(McpServerEditPanel this$0, Function0 validate) {
        Intrinsics.checkNotNullParameter((Object)validate, (String)"validate");
        this$0.editor.getDocument().addDocumentListener(new DocumentListener(this$0, (Function0<Unit>)validate){
            final /* synthetic */ McpServerEditPanel this$0;
            final /* synthetic */ Function0<Unit> $validate;
            {
                this.this$0 = $receiver;
                this.$validate = $validate;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.setEditorCommand(McpServerEditPanel.access$updateCommandFromJson(this.this$0, event));
                this.$validate.invoke();
            }
        });
        return Unit.INSTANCE;
    }

    private static final ValidationInfo panel$lambda$11$lambda$9$lambda$8(McpServerEditPanel this$0) {
        return this$0.isJson() && this$0.editorCommand == null ? new ValidationInfo(McpBundle.message("ml.llm.mcp.server.json.config.invalid", new Object[0]), this$0.editor.getComponent()) : null;
    }

    private static final Unit panel$lambda$11$lambda$9(McpServerEditPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JComponent jComponent = this$0.editor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        Cell cell = $this$row.cell(jComponent);
        String string = McpBundle.message("ml.llm.mcp.server.json.config", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        DialogValidation[] dialogValidationArray = new DialogValidation[]{() -> McpServerEditPanel.panel$lambda$11$lambda$9$lambda$8(this$0)};
        cell.label(McpServerEditPanelKt.access$withColon(string), LabelPosition.TOP).align(Align.FILL).validationRequestor(arg_0 -> McpServerEditPanel.panel$lambda$11$lambda$9$lambda$7(this$0, arg_0)).validation(dialogValidationArray);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$11$lambda$10(McpServerEditPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.setWorkingDirField((TextFieldWithBrowseButton)$this$row.cell((JComponent)new TextFieldWithBrowseButton()).align((Align)AlignX.FILL.INSTANCE).getComponent());
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$11(McpServerEditPanel this$0, Project $project, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> McpServerEditPanel.panel$lambda$11$lambda$1(this$0, $project, arg_0), (int)1, null);
        String string = McpBundle.message("ml.llm.mcp.server.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(McpServerEditPanelKt.access$withColon(string), arg_0 -> McpServerEditPanel.panel$lambda$11$lambda$2(this$0, arg_0)).visibleIf((ObservableProperty)this$0.switcherProperty);
        String string2 = McpBundle.message("ml.llm.mcp.server.command", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(McpServerEditPanelKt.access$withColon(string2), arg_0 -> McpServerEditPanel.panel$lambda$11$lambda$3(this$0, arg_0)).visibleIf((ObservableProperty)this$0.switcherProperty);
        String string3 = McpBundle.message("ml.llm.mcp.server.arguments", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$panel.row(McpServerEditPanelKt.access$withColon(string3), arg_0 -> McpServerEditPanel.panel$lambda$11$lambda$4(this$0, arg_0)).visibleIf((ObservableProperty)this$0.switcherProperty);
        String string4 = ExecutionBundle.message((String)"environment.variables.dialog.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        $this$panel.row(McpServerEditPanelKt.access$withColon(string4), arg_0 -> McpServerEditPanel.panel$lambda$11$lambda$6(this$0, arg_0)).visibleIf((ObservableProperty)this$0.switcherProperty);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> McpServerEditPanel.panel$lambda$11$lambda$9(this$0, arg_0), (int)1, null).resizableRow().visibleIf(PropertyOperationUtil.not((ObservableProperty)((ObservableProperty)this$0.switcherProperty)));
        String string5 = ExecutionBundle.message((String)"run.configuration.working.directory.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        $this$panel.row(string5, arg_0 -> McpServerEditPanel.panel$lambda$11$lambda$10(this$0, arg_0));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ McpServerCommand access$updateCommandFromJson(McpServerEditPanel $this, DocumentEvent event) {
        return $this.updateCommandFromJson(event);
    }
}

