/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.mcp.client.settings;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.mcp.client.McpBundle;
import com.intellij.ml.llm.mcp.client.McpClient;
import com.intellij.ml.llm.mcp.client.McpClientService;
import com.intellij.ml.llm.mcp.client.settings.ClaudeConfigImportAction;
import com.intellij.ml.llm.mcp.client.settings.ClaudeConfigImporter;
import com.intellij.ml.llm.mcp.client.settings.McpApplicationServerCommandService;
import com.intellij.ml.llm.mcp.client.settings.McpNotificationPanel;
import com.intellij.ml.llm.mcp.client.settings.McpProjectServerCommandService;
import com.intellij.ml.llm.mcp.client.settings.McpServerCommand;
import com.intellij.ml.llm.mcp.client.settings.McpServerCommandItem;
import com.intellij.ml.llm.mcp.client.settings.McpServerCommandLevel;
import com.intellij.ml.llm.mcp.client.settings.McpServerCommandServiceBase;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfigurationSource;
import com.intellij.ml.llm.mcp.client.settings.McpServerEditDialog;
import com.intellij.ml.llm.mcp.client.settings.McpServersPanel;
import com.intellij.ml.llm.mcp.client.settings.McpServersPanelKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UiScopeKt;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000g\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\u0013\b\u0000\u0018\u00002\u00020\u0001:\u0003,-.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\b\u0010\u001e\u001a\u00020\u001bH\u0002J\b\u0010\u001f\u001a\u00020\u001bH\u0002J\u0006\u0010 \u001a\u00020\u0016J\u0006\u0010!\u001a\u00020\u001bJ\u0006\u0010\"\u001a\u00020\u001bJ&\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0002J\u0006\u0010+\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\b0\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006/"}, d2={"Lcom/intellij/ml/llm/mcp/client/settings/McpServersPanel;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "tableModel", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerCommandItem;", "table", "Lcom/intellij/ui/table/TableView;", "kotlin.jvm.PlatformType", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "notificationWrapper", "Lcom/intellij/ui/components/panels/Wrapper;", "commandListener", "com/intellij/ml/llm/mcp/client/settings/McpServersPanel$commandListener$1", "Lcom/intellij/ml/llm/mcp/client/settings/McpServersPanel$commandListener$1;", "isModifiable", "", "getNotificationPanel", "Ljavax/swing/JPanel;", "modifiable", "setEmptyText", "", "addServer", "editServer", "removeServer", "updateTable", "isModified", "apply", "reset", "createItem", "command", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerCommand;", "level", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerCommandLevel;", "clients", "", "Lcom/intellij/ml/llm/mcp/client/McpClient;", "disposeUIResources", "AddServerAction", "EditServerAction", "RemoveServerAction", "intellij.ml.llm.mcp"})
@SourceDebugExtension(value={"SMAP\nMcpServersPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpServersPanel.kt\ncom/intellij/ml/llm/mcp/client/settings/McpServersPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,654:1\n1208#2,2:655\n1236#2,4:657\n1208#2,2:661\n1236#2,4:663\n1#3:667\n*S KotlinDebug\n*F\n+ 1 McpServersPanel.kt\ncom/intellij/ml/llm/mcp/client/settings/McpServersPanel\n*L\n231#1:655,2\n231#1:657,4\n232#1:661,2\n232#1:663,4\n*E\n"})
public final class McpServersPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final ListTableModel<McpServerCommandItem> tableModel;
    @NotNull
    private final TableView<McpServerCommandItem> table;
    @NotNull
    private final JComponent component;
    @NotNull
    private final Wrapper notificationWrapper;
    @NotNull
    private final commandListener.1 commandListener;

    public McpServersPanel(@NotNull Project project2) {
        ToolbarDecorator toolbarDecorator;
        ColumnInfo[] columnInfoArray;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        SpreadBuilder spreadBuilder = new SpreadBuilder(6);
        spreadBuilder.add((Object)McpServersPanelKt.access$createEnabledColumn());
        spreadBuilder.add((Object)McpServersPanelKt.access$createStatusColumn());
        spreadBuilder.add((Object)McpServersPanelKt.access$createNameColumn());
        spreadBuilder.add((Object)McpServersPanelKt.access$createCommandColumn());
        spreadBuilder.add((Object)McpServersPanelKt.access$createLevelColumn(!this.project.isDefault()));
        if (Registry.Companion.is("llm.mcp.client.show.server.source")) {
            ColumnInfo[] columnInfoArray2 = new ColumnInfo[]{McpServersPanelKt.access$createSourceColumn()};
            columnInfoArray = columnInfoArray2;
        } else {
            columnInfoArray = new ColumnInfo[]{};
        }
        spreadBuilder.addSpread((Object)columnInfoArray);
        this.tableModel = new ListTableModel((ColumnInfo[])spreadBuilder.toArray((Object[])new ColumnInfo[spreadBuilder.size()]));
        this.table = new TableView(this.tableModel);
        this.notificationWrapper = new Wrapper();
        this.commandListener = new McpServerCommandServiceBase.CommandChangeListener(this){
            private final AtomicBoolean reset;
            final /* synthetic */ McpServersPanel this$0;
            {
                this.this$0 = $receiver;
                this.reset = new AtomicBoolean(false);
            }

            public final AtomicBoolean getReset() {
                return this.reset;
            }

            public void commandsChanged() {
                if (this.reset.compareAndSet(false, true)) {
                    UIUtil.invokeLaterIfNeeded(() -> commandListener.1.commandsChanged$lambda$0(this, this.this$0));
                }
            }

            private static final void commandsChanged$lambda$0(commandListener.1 this$0, McpServersPanel this$1) {
                if (this$0.reset.compareAndSet(true, false)) {
                    this$1.reset();
                }
            }
        };
        McpApplicationServerCommandService.Companion.getInstance().addListener(this.commandListener);
        this.tableModel.setSortable(true);
        this.table.setShowGrid(false);
        TableUtil.setupCheckboxColumn((TableColumn)this.table.getColumnModel().getColumn(0), (int)0);
        JBTable.setupCheckboxShortcut((JTable)((JTable)this.table), (int)0);
        this.table.putClientProperty((Object)AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, (Object)true);
        ToolbarDecorator it = toolbarDecorator = ToolbarDecorator.createDecorator((JTable)((JTable)this.table)).setAddAction((AnActionButtonRunnable)new AddServerAction()).setEditAction((AnActionButtonRunnable)new EditServerAction()).setRemoveAction((AnActionButtonRunnable)new RemoveServerAction()).setAddActionUpdater(arg_0 -> McpServersPanel._init_$lambda$0(this, arg_0)).setEditActionUpdater(arg_0 -> McpServersPanel._init_$lambda$1(this, arg_0)).setRemoveActionUpdater(arg_0 -> McpServersPanel._init_$lambda$2(this, arg_0)).setMoveDownActionUpdater(arg_0 -> McpServersPanel._init_$lambda$3(this, arg_0)).setMoveUpActionUpdater(arg_0 -> McpServersPanel._init_$lambda$4(this, arg_0));
        boolean bl = false;
        if (!SystemInfo.isLinux) {
            AnAction[] anActionArray = new AnAction[]{new ClaudeConfigImportAction()};
            it.addExtraActions(anActionArray);
        }
        JPanel jPanel = toolbarDecorator.createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        JPanel tablePanel = jPanel;
        String labelText = "<html><b>" + McpBundle.message("ml.llm.mcp.settings.configurable", new Object[0]) + "</b></html>";
        DialogPanel header2 = BuilderKt.panel(arg_0 -> McpServersPanel._init_$lambda$8(labelText, arg_0));
        DialogPanel comment = BuilderKt.panel(arg_0 -> McpServersPanel._init_$lambda$12(this, arg_0));
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel((Component)tablePanel).addToTop((Component)header2).addToBottom((Component)comment);
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"addToBottom(...)");
        this.component = (JComponent)borderLayoutPanel;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    private final boolean isModifiable() {
        return McpApplicationServerCommandService.Companion.getInstance().getModifiable();
    }

    private final JPanel getNotificationPanel(boolean modifiable) {
        JPanel jPanel;
        if (modifiable) {
            String string = McpBundle.message("ml.llm.mcp.server.comment", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            jPanel = (JPanel)((Object)new McpNotificationPanel(string, EditorNotificationPanel.Status.Warning));
        } else {
            String string = McpBundle.message("ml.llm.mcp.server.configurations.not.editable", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            jPanel = (JPanel)((Object)new McpNotificationPanel(string, EditorNotificationPanel.Status.Info));
        }
        return jPanel;
    }

    private final void setEmptyText() {
        Shortcut shortcut;
        Object[] addAction;
        StatusText statusText = this.table.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"getEmptyText(...)");
        StatusText emptyText = statusText;
        emptyText.setText(McpBundle.message("ml.llm.mcp.server.no.configured", new Object[0]));
        boolean modifiable = this.isModifiable();
        this.notificationWrapper.setContent((JComponent)this.getNotificationPanel(modifiable));
        if (!modifiable) {
            return;
        }
        emptyText.appendSecondaryText(McpBundle.message("ml.llm.mcp.server.add", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, arg_0 -> McpServersPanel.setEmptyText$lambda$13(this, arg_0));
        Object[] objectArray = addAction = ActionManager.getInstance().getAction("NewElement");
        Shortcut shortcut2 = addAction != null && (objectArray = objectArray.getShortcutSet()) != null && (objectArray = objectArray.getShortcuts()) != null ? (Shortcut)ArraysKt.firstOrNull((Object[])objectArray) : (shortcut = null);
        if (shortcut != null) {
            emptyText.appendSecondaryText(" (" + KeymapUtil.getShortcutText((Shortcut)shortcut) + ")", StatusText.DEFAULT_ATTRIBUTES, null);
        }
        emptyText.appendLine(McpBundle.message("ml.llm.mcp.server.import.from.claude", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, arg_0 -> McpServersPanel.setEmptyText$lambda$14(this, arg_0));
    }

    private final void addServer() {
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.DEFAULT;
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"DEFAULT");
        McpServerCommand command = new McpServerCommand("", "", "", "", environmentVariablesData, true, McpServerConfigurationSource.USER);
        String string = McpBundle.message("ml.llm.mcp.server.new", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        McpServerEditDialog dialog2 = new McpServerEditDialog(this.project, string, command);
        if (dialog2.showAndGet()) {
            this.tableModel.addRow((Object)new McpServerCommandItem(command, McpServerCommandLevel.GLOBAL, null));
            this.updateTable();
        }
    }

    private final void editServer() {
        McpServerCommandItem mcpServerCommandItem = (McpServerCommandItem)this.table.getSelectedObject();
        if (mcpServerCommandItem == null) {
            return;
        }
        McpServerCommandItem item = mcpServerCommandItem;
        String string = McpBundle.message("ml.llm.mcp.server.edit", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        McpServerEditDialog dialog2 = new McpServerEditDialog(this.project, string, item.getCommand());
        if (dialog2.showAndGet()) {
            this.updateTable();
        }
    }

    private final void removeServer() {
        int[] selectedRows = this.table.getSelectedRows();
        Intrinsics.checkNotNull((Object)selectedRows);
        List list = ArraysKt.reversed((int[])selectedRows);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            int selectedRow = ((Number)list.get(i)).intValue();
            this.tableModel.removeRow(selectedRow);
        }
        this.updateTable();
    }

    private final void updateTable() {
        this.tableModel.fireTableDataChanged();
    }

    public final boolean isModified() {
        ArrayList<McpServerCommand> globalCommands = new ArrayList<McpServerCommand>();
        ArrayList<McpServerCommand> projectCommands = new ArrayList<McpServerCommand>();
        for (McpServerCommandItem item : this.tableModel.getItems()) {
            boolean bl = item.getLevel() == McpServerCommandLevel.GLOBAL ? globalCommands.add(item.getCommand()) : projectCommands.add(item.getCommand());
        }
        return !Intrinsics.areEqual(McpApplicationServerCommandService.Companion.getInstance().getCommands(), globalCommands) || !Intrinsics.areEqual(McpProjectServerCommandService.Companion.getInstance(this.project).getCommands(), projectCommands);
    }

    /*
     * WARNING - void declaration
     */
    public final void apply() {
        void $this$associateByTo$iv$iv;
        Map map2;
        void $this$associateByTo$iv$iv2;
        McpApplicationServerCommandService.Companion.getInstance().removeListener(this.commandListener);
        ArrayList<McpServerCommand> globalCommands = new ArrayList<McpServerCommand>();
        ArrayList<McpServerCommand> projectCommands = new ArrayList<McpServerCommand>();
        ArrayList<McpServerCommand> movedToGlobal = new ArrayList<McpServerCommand>();
        ArrayList<McpServerCommand> movedToProject = new ArrayList<McpServerCommand>();
        Iterable $this$associateBy$iv = McpApplicationServerCommandService.Companion.getInstance().getCommands();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
            void it;
            McpServerCommand mcpServerCommand = (McpServerCommand)element$iv$iv;
            map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getId(), element$iv$iv);
        }
        Map globalBefore = destination$iv$iv;
        Iterable $this$associateBy$iv2 = McpProjectServerCommandService.Companion.getInstance(this.project).getCommands();
        boolean $i$f$associateBy2 = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            McpServerCommand bl = (McpServerCommand)element$iv$iv;
            map2 = destination$iv$iv2;
            boolean bl2 = false;
            map2.put(it.getId(), element$iv$iv);
        }
        Map projectBefore = destination$iv$iv2;
        for (McpServerCommandItem item : this.tableModel.getItems()) {
            if (item.getLevel() == McpServerCommandLevel.GLOBAL) {
                globalCommands.add(item.getCommand());
                McpServerCommand commandBefore = (McpServerCommand)projectBefore.get(item.getCommand().getId());
                if (commandBefore == null) continue;
                movedToGlobal.add(commandBefore);
                continue;
            }
            projectCommands.add(item.getCommand());
            McpServerCommand commandBefore = (McpServerCommand)globalBefore.get(item.getCommand().getId());
            if (commandBefore == null) continue;
            movedToProject.add(commandBefore);
        }
        List moved = CollectionsKt.plus((Collection)movedToGlobal, (Iterable)movedToProject);
        McpApplicationServerCommandService.Companion.getInstance().setCommands((List<McpServerCommand>)globalCommands, moved);
        if (!this.project.isDefault()) {
            McpProjectServerCommandService.Companion.getInstance(this.project).setCommands((List<McpServerCommand>)projectCommands, moved);
        }
        McpApplicationServerCommandService.Companion.getInstance().addListener(this.commandListener);
        this.reset();
    }

    public final void reset() {
        List<McpClient> clients = McpClientService.Companion.getInstance().getClients(this.project);
        ArrayList<McpServerCommandItem> items2 = new ArrayList<McpServerCommandItem>();
        for (McpServerCommand command : McpApplicationServerCommandService.Companion.getInstance().getCommands()) {
            items2.add(this.createItem(command, McpServerCommandLevel.GLOBAL, clients));
        }
        for (McpServerCommand command : McpProjectServerCommandService.Companion.getInstance(this.project).getCommands()) {
            items2.add(this.createItem(command, McpServerCommandLevel.PROJECT, clients));
        }
        this.tableModel.setItems((List)items2);
        this.setEmptyText();
    }

    private final McpServerCommandItem createItem(McpServerCommand command, McpServerCommandLevel level, List<McpClient> clients) {
        Object v0;
        block2: {
            Iterable iterable = clients;
            for (Object t : iterable) {
                McpClient client2 = (McpClient)t;
                boolean bl = false;
                if (!(client2.getServerCommand().getId() == command.getId())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        McpClient client3 = v0;
        if (client3 != null) {
            UiScopeKt.launchOnceOnShow$default((Component)((Component)this.table), (String)"McpServersPanel", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(client3, this, null){
                int label;
                final /* synthetic */ McpClient $client;
                final /* synthetic */ McpServersPanel this$0;
                {
                    this.$client = $client;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.$client.getState().collect(new FlowCollector(this.this$0){
                                final /* synthetic */ McpServersPanel this$0;
                                {
                                    this.this$0 = $receiver;
                                }

                                public final Object emit(McpClient.State state2, Continuation<? super Unit> $completion) {
                                    McpServersPanel.access$updateTable(this.this$0);
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (object2 != object) throw new KotlinNothingValueException();
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            throw new KotlinNothingValueException();
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        return new McpServerCommandItem(new McpServerCommand(command), level, client3);
    }

    public final void disposeUIResources() {
        McpApplicationServerCommandService.Companion.getInstance().removeListener(this.commandListener);
        this.commandListener.getReset().set(false);
    }

    private static final boolean _init_$lambda$0(McpServersPanel this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isModifiable();
    }

    private static final boolean _init_$lambda$1(McpServersPanel this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isModifiable();
    }

    private static final boolean _init_$lambda$2(McpServersPanel this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isModifiable();
    }

    private static final boolean _init_$lambda$3(McpServersPanel this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isModifiable();
    }

    private static final boolean _init_$lambda$4(McpServersPanel this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isModifiable();
    }

    private static final Unit lambda$8$lambda$6(String $labelText, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label($labelText);
        Icon icon2 = AllIcons.General.Beta;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Beta");
        $this$row.icon(icon2);
        $this$row.bottomGap(BottomGap.NONE);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$8$lambda$7(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{"https://modelcontextprotocol.io/introduction", "https://github.com/modelcontextprotocol/servers"};
        String string = McpBundle.message("ml.llm.mcp.settings.configurable.comment", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.comment$default((Row)$this$row, (String)string, (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$8(String $labelText, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> McpServersPanel.lambda$8$lambda$6($labelText, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, McpServersPanel::lambda$8$lambda$7, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$12$lambda$11$lambda$10(Wrapper $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.putClientProperty((Object)DslComponentProperty.VISUAL_PADDINGS, (Object)UnscaledGaps.EMPTY);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit lambda$12$lambda$11(McpServersPanel this$0, Row $this$row) {
        void it;
        Wrapper wrapper;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Wrapper wrapper2 = wrapper = this$0.notificationWrapper;
        Row row = $this$row;
        boolean bl = false;
        it.setContent((JComponent)this$0.getNotificationPanel(this$0.isModifiable()));
        row.cell((JComponent)wrapper).align((Align)AlignX.FILL.INSTANCE).applyToComponent(McpServersPanel::lambda$12$lambda$11$lambda$10);
        $this$row.topGap(TopGap.SMALL);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$12(McpServersPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> McpServersPanel.lambda$12$lambda$11(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final void setEmptyText$lambda$13(McpServersPanel this$0, ActionEvent it) {
        this$0.addServer();
    }

    private static final void setEmptyText$lambda$14(McpServersPanel this$0, ActionEvent it) {
        new ClaudeConfigImporter().import((JTable)this$0.table);
    }

    public static final /* synthetic */ void access$updateTable(McpServersPanel $this) {
        $this.updateTable();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/mcp/client/settings/McpServersPanel$AddServerAction;", "Lcom/intellij/ui/AnActionButtonRunnable;", "<init>", "(Lcom/intellij/ml/llm/mcp/client/settings/McpServersPanel;)V", "run", "", "button", "Lcom/intellij/ui/AnActionButton;", "intellij.ml.llm.mcp"})
    private final class AddServerAction
    implements AnActionButtonRunnable {
        public void run(@NotNull AnActionButton button2) {
            Intrinsics.checkNotNullParameter((Object)button2, (String)"button");
            McpServersPanel.this.addServer();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/mcp/client/settings/McpServersPanel$EditServerAction;", "Lcom/intellij/ui/AnActionButtonRunnable;", "<init>", "(Lcom/intellij/ml/llm/mcp/client/settings/McpServersPanel;)V", "run", "", "button", "Lcom/intellij/ui/AnActionButton;", "intellij.ml.llm.mcp"})
    private final class EditServerAction
    implements AnActionButtonRunnable {
        public void run(@NotNull AnActionButton button2) {
            Intrinsics.checkNotNullParameter((Object)button2, (String)"button");
            McpServersPanel.this.editServer();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/mcp/client/settings/McpServersPanel$RemoveServerAction;", "Lcom/intellij/ui/AnActionButtonRunnable;", "<init>", "(Lcom/intellij/ml/llm/mcp/client/settings/McpServersPanel;)V", "run", "", "button", "Lcom/intellij/ui/AnActionButton;", "intellij.ml.llm.mcp"})
    private final class RemoveServerAction
    implements AnActionButtonRunnable {
        public void run(@NotNull AnActionButton button2) {
            Intrinsics.checkNotNullParameter((Object)button2, (String)"button");
            McpServersPanel.this.removeServer();
        }
    }
}

