/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.caches;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionLogger;
import com.intellij.ml.llm.nextEdits.caches.PartialHunkMatcher;
import com.intellij.ml.llm.nextEdits.context.NextEditContext;
import com.intellij.ml.llm.nextEdits.diffing.Hunk;
import com.intellij.ml.llm.nextEdits.diffing.TextDiff;
import com.intellij.ml.llm.nextEdits.diffing.TextDiffUtils;
import com.intellij.ml.llm.nextEdits.processing.NextEditProposal;
import com.intellij.ml.llm.nextEdits.processing.NextProposalEditsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0006\u0010\u0010\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/nextEdits/caches/NextEditCache;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger;", "cache", "", "Lcom/intellij/ml/llm/nextEdits/caches/NextEditCache$CacheEntry;", "put", "", "context", "Lcom/intellij/ml/llm/nextEdits/context/NextEditContext;", "proposal", "Lcom/intellij/ml/llm/nextEdits/processing/NextEditProposal$Rewrite;", "tryGet", "invalidate", "CacheEntry", "Companion", "intellij.ml.llm.nextEdits"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNextEditCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditCache.kt\ncom/intellij/ml/llm/nextEdits/caches/NextEditCache\n+ 2 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/DiagnosticLoggersKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n42#2:89\n14#3:90\n1#4:91\n295#5:92\n1761#5,3:93\n296#5:96\n*S KotlinDebug\n*F\n+ 1 NextEditCache.kt\ncom/intellij/ml/llm/nextEdits/caches/NextEditCache\n*L\n26#1:89\n26#1:90\n57#1:92\n58#1:93,3\n57#1:96\n*E\n"})
public final class NextEditCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MLCompletionLogger LOG;
    @NotNull
    private final Set<CacheEntry> cache;
    private static final long CACHE_SIZE = 10L;

    /*
     * WARNING - void declaration
     */
    public NextEditCache() {
        void it;
        NextEditCache $this$thisNextEditLogger$iv = this;
        boolean $i$f$thisNextEditLogger = false;
        boolean $i$f$logger22 = false;
        Logger logger = Logger.getInstance(NextEditCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = new MLCompletionLogger(logger, MLCompletionLogger.FeatureType.NextEdit);
        ConcurrentMap $i$f$logger22 = Caffeine.newBuilder().maximumSize(10L).build().asMap();
        NextEditCache nextEditCache = this;
        boolean bl = false;
        Set set = Collections.newSetFromMap((Map)it);
        Intrinsics.checkNotNullExpressionValue(set, (String)"let(...)");
        nextEditCache.cache = set;
    }

    public final void put(@NotNull NextEditContext context2, @NotNull NextEditProposal.Rewrite proposal2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)proposal2, (String)"proposal");
        this.cache.add(new CacheEntry(context2, proposal2));
    }

    @RequiresBackgroundThread
    @Nullable
    public final NextEditProposal.Rewrite tryGet(@NotNull NextEditContext context2) {
        Object v1;
        block6: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            ThreadingAssertions.assertBackgroundThread();
            Iterable $this$firstOrNull$iv = this.cache;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block5: {
                    CacheEntry cacheEntry = (CacheEntry)element$iv;
                    boolean bl2 = false;
                    Iterable $this$any$iv = cacheEntry.getDiff().getHunks();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            Hunk cacheHunk = (Hunk)element$iv2;
                            boolean bl3 = false;
                            if (!PartialHunkMatcher.INSTANCE.isMatch(cacheEntry.getCurrentFile().getContent(), CollectionsKt.emptyList(), cacheHunk, context2)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        CacheEntry cacheEntry = v1;
        if (cacheEntry == null) {
            return null;
        }
        CacheEntry matchedEntry = cacheEntry;
        this.LOG.debug(() -> NextEditCache.tryGet$lambda$3(matchedEntry));
        TextDiff diff2 = TextDiffUtils.INSTANCE.diff(context2.getCurrentFile().getContent(), matchedEntry.getAfter());
        return NextProposalEditsKt.fromDiff(NextEditProposal.Rewrite.Companion, diff2);
    }

    public final void invalidate() {
        this.cache.clear();
    }

    private static final String tryGet$lambda$3(CacheEntry $matchedEntry) {
        return "Cache hit for " + $matchedEntry.getCurrentFile().getPath();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/nextEdits/caches/NextEditCache$CacheEntry;", "", "context", "Lcom/intellij/ml/llm/nextEdits/context/NextEditContext;", "proposal", "Lcom/intellij/ml/llm/nextEdits/processing/NextEditProposal$Rewrite;", "<init>", "(Lcom/intellij/ml/llm/nextEdits/context/NextEditContext;Lcom/intellij/ml/llm/nextEdits/processing/NextEditProposal$Rewrite;)V", "getContext", "()Lcom/intellij/ml/llm/nextEdits/context/NextEditContext;", "getProposal", "()Lcom/intellij/ml/llm/nextEdits/processing/NextEditProposal$Rewrite;", "currentFile", "Lcom/intellij/ml/llm/nextEdits/context/NextEditContext$File;", "getCurrentFile", "()Lcom/intellij/ml/llm/nextEdits/context/NextEditContext$File;", "currentFile$delegate", "Lkotlin/Lazy;", "after", "", "getAfter", "()Ljava/lang/String;", "after$delegate", "diff", "Lcom/intellij/ml/llm/nextEdits/diffing/TextDiff;", "getDiff", "()Lcom/intellij/ml/llm/nextEdits/diffing/TextDiff;", "intellij.ml.llm.nextEdits"})
    private static final class CacheEntry {
        @NotNull
        private final NextEditContext context;
        @NotNull
        private final NextEditProposal.Rewrite proposal;
        @NotNull
        private final Lazy currentFile$delegate;
        @NotNull
        private final Lazy after$delegate;

        public CacheEntry(@NotNull NextEditContext context2, @NotNull NextEditProposal.Rewrite proposal2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)proposal2, (String)"proposal");
            this.context = context2;
            this.proposal = proposal2;
            this.currentFile$delegate = LazyKt.lazy(() -> CacheEntry.currentFile_delegate$lambda$0(this));
            this.after$delegate = LazyKt.lazy(() -> CacheEntry.after_delegate$lambda$1(this));
        }

        @NotNull
        public final NextEditContext getContext() {
            return this.context;
        }

        @NotNull
        public final NextEditProposal.Rewrite getProposal() {
            return this.proposal;
        }

        @NotNull
        public final NextEditContext.File getCurrentFile() {
            Lazy lazy = this.currentFile$delegate;
            return (NextEditContext.File)lazy.getValue();
        }

        @NotNull
        public final String getAfter() {
            Lazy lazy = this.after$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public final TextDiff getDiff() {
            return this.proposal.getDiff();
        }

        private static final NextEditContext.File currentFile_delegate$lambda$0(CacheEntry this$0) {
            return this$0.context.getCurrentFile();
        }

        private static final String after_delegate$lambda$1(CacheEntry this$0) {
            return TextDiffUtils.INSTANCE.merge(this$0.getCurrentFile().getContent(), this$0.getDiff());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/nextEdits/caches/NextEditCache$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/nextEdits/caches/NextEditCache;", "project", "Lcom/intellij/openapi/project/Project;", "CACHE_SIZE", "", "intellij.ml.llm.nextEdits"})
    @SourceDebugExtension(value={"SMAP\nNextEditCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditCache.kt\ncom/intellij/ml/llm/nextEdits/caches/NextEditCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,88:1\n30#2,2:89\n*S KotlinDebug\n*F\n+ 1 NextEditCache.kt\ncom/intellij/ml/llm/nextEdits/caches/NextEditCache$Companion\n*L\n80#1:89,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NextEditCache getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<NextEditCache> serviceClass$iv = NextEditCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (NextEditCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

