/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.editor;

import com.intellij.codeInsight.inline.completion.InlineCompletionHandler;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionLogger;
import com.intellij.ml.llm.nextEdits.completion.inline.CallNextEditOnInlineCompletionSelectionListener;
import com.intellij.ml.llm.nextEdits.completion.inline.sync.InlineCompletionSessionStateTracker;
import com.intellij.ml.llm.nextEdits.context.NextEditFilePath;
import com.intellij.ml.llm.nextEdits.context.NextEditFilePathForDocumentProvider;
import com.intellij.ml.llm.nextEdits.context.NextEditFilePathKt;
import com.intellij.ml.llm.nextEdits.listeners.CancelNextEditOnSelectionListener;
import com.intellij.ml.llm.nextEdits.listeners.NextEditCaretListener;
import com.intellij.ml.llm.nextEdits.listeners.NextEditDocumentListener;
import com.intellij.ml.llm.nextEdits.listeners.NextEditRefreshOnBlockInlayChangesListener;
import com.intellij.ml.llm.nextEdits.listeners.NextEditRefreshOnFoldingChangesListener;
import com.intellij.ml.llm.nextEdits.listeners.NextEditRefreshOnFontSizeChangesListener;
import com.intellij.ml.llm.nextEdits.logs.NextEditDetailedLogsService;
import com.intellij.ml.llm.nextEdits.request.IgnoredUtils;
import com.intellij.ml.llm.nextEdits.session.NextEditSessionManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorIdKt;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.EDT;
import java.beans.PropertyChangeListener;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\u0012*\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/nextEdits/editor/NextEditInstaller;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger;", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/Disposable;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "tryInstall", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "installInlineCompletionListeners", "", "icHandler", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionHandler;", "uninstall", "uninstallInlineCompletionListeners", "doTryInstall", "createDisposable", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "disposeWithEditorIfNeeded", "editorTypeSupported", "intellij.ml.llm.nextEdits"})
@SourceDebugExtension(value={"SMAP\nNextEditInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditInstaller.kt\ncom/intellij/ml/llm/nextEdits/editor/NextEditInstaller\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/DiagnosticLoggersKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,160:1\n1#2:161\n42#3:162\n14#4:163\n*S KotlinDebug\n*F\n+ 1 NextEditInstaller.kt\ncom/intellij/ml/llm/nextEdits/editor/NextEditInstaller\n*L\n32#1:162\n32#1:163\n*E\n"})
public final class NextEditInstaller {
    @NotNull
    public static final NextEditInstaller INSTANCE;
    @NotNull
    private static final MLCompletionLogger LOG;
    @NotNull
    private static final Key<Disposable> KEY;

    private NextEditInstaller() {
    }

    @RequiresEdt
    public final boolean tryInstall(@NotNull Editor editor2, @NotNull Project project2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (!EDT.isCurrentThreadEdt()) {
            LOG.error("Next Edit must be installed on EDT");
            return false;
        }
        try {
            bl = this.doTryInstall(editor2, project2);
        }
        catch (Exception e) {
            LOG.error("Failed to install Next Edit", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @RequiresEdt
    public final void installInlineCompletionListeners(@NotNull Editor editor2, @NotNull InlineCompletionHandler icHandler) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)icHandler, (String)"icHandler");
        if (!EDT.isCurrentThreadEdt()) {
            LOG.error("Next Edit inline completion listeners must be installed EDT");
            return;
        }
        try {
            InlineCompletionSessionStateTracker.Companion.install(editor2, icHandler);
            CallNextEditOnInlineCompletionSelectionListener.Companion.install(editor2, icHandler);
        }
        catch (Exception e) {
            LOG.error("Failed to install inline completion listeners for Next Edit", (Throwable)e);
        }
    }

    @RequiresEdt
    public final void uninstall(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (!EDT.isCurrentThreadEdt()) {
            LOG.error("Next Edit must be uninstalled on EDT");
            return;
        }
        try {
            Disposable disposable = (Disposable)editor2.getUserData(KEY);
            if (disposable != null) {
                Disposable it = disposable;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            editor2.putUserData(KEY, null);
        }
        catch (Exception e) {
            LOG.error("Failed to uninstall Next Edit", (Throwable)e);
        }
    }

    @RequiresEdt
    public final void uninstallInlineCompletionListeners(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (!EDT.isCurrentThreadEdt()) {
            LOG.error("Next Edit inline completion listeners must be uninstalled on EDT");
            return;
        }
        try {
            InlineCompletionSessionStateTracker.Companion.uninstall(editor2);
        }
        catch (Exception e) {
            LOG.error("Failed to uninstall inline completion listeners for Next Edit", (Throwable)e);
        }
    }

    private final boolean doTryInstall(Editor editor2, Project project2) {
        if (editor2.isDisposed() || project2.isDisposed() || !(editor2 instanceof EditorImpl) || !this.editorTypeSupported(editor2) || project2.isDefault()) {
            return false;
        }
        DocumentEx documentEx = ((EditorImpl)editor2).getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document2 = documentEx;
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile((Document)document2);
        if (virtualFile2 == null) {
            return false;
        }
        VirtualFile file = virtualFile2;
        if (IgnoredUtils.INSTANCE.isIgnored(file, project2)) {
            return false;
        }
        Disposable disposable = (Disposable)((EditorImpl)editor2).getUserData(KEY);
        if (disposable != null) {
            Disposable it = disposable;
            boolean bl = false;
            LOG.debug(() -> NextEditInstaller.doTryInstall$lambda$2$lambda$1(file));
            INSTANCE.uninstall(editor2);
        }
        Disposable disposable2 = this.createDisposable(editor2, file);
        NextEditSessionManager.Companion.install(editor2, project2);
        DisposerUtilKt.whenDisposed((Disposable)disposable2, () -> NextEditInstaller.doTryInstall$lambda$3(editor2));
        ((EditorImpl)editor2).getCaretModel().addCaretListener((CaretListener)new NextEditCaretListener(), disposable2);
        NextEditDetailedLogsService.Companion.getInstance();
        NextEditFilePath filePath = NextEditFilePathKt.getNextEditFilePath(file, project2);
        NextEditFilePathForDocumentProvider nextEditFilePathForDocumentProvider = NextEditFilePathForDocumentProvider.Companion.getInstance(project2);
        DocumentEx documentEx2 = ((EditorImpl)editor2).getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx2, (String)"getDocument(...)");
        nextEditFilePathForDocumentProvider.registerPath((Document)documentEx2, filePath);
        ((EditorImpl)editor2).getDocument().addDocumentListener((DocumentListener)new NextEditDocumentListener(editor2, project2, filePath), disposable2);
        ((EditorImpl)editor2).addPropertyChangeListener((PropertyChangeListener)new NextEditRefreshOnFontSizeChangesListener(editor2), disposable2);
        ((EditorImpl)editor2).getInlayModel().addListener((InlayModel.Listener)new NextEditRefreshOnBlockInlayChangesListener(), disposable2);
        ((EditorImpl)editor2).getFoldingModel().addListener((FoldingListener)new NextEditRefreshOnFoldingChangesListener(editor2), disposable2);
        ((EditorImpl)editor2).getSelectionModel().addSelectionListener((SelectionListener)new CancelNextEditOnSelectionListener(), disposable2);
        ((EditorImpl)editor2).putUserData(KEY, (Object)disposable2);
        return true;
    }

    private final Disposable createDisposable(Editor editor2, VirtualFile file) {
        Disposable disposable = Disposer.newDisposable((String)("Next Edit: file=" + file.getName() + ", id=" + EditorIdKt.editorIdOrNull((Editor)editor2) + "}"));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        this.disposeWithEditorIfNeeded(disposable2, editor2);
        return disposable2;
    }

    private final void disposeWithEditorIfNeeded(Disposable $this$disposeWithEditorIfNeeded, Editor editor2) {
        AtomicBoolean isDisposed = new AtomicBoolean(false);
        DisposerUtilKt.whenDisposed((Disposable)$this$disposeWithEditorIfNeeded, () -> NextEditInstaller.disposeWithEditorIfNeeded$lambda$4(isDisposed));
        EditorUtil.disposeWithEditor((Editor)editor2, () -> NextEditInstaller.disposeWithEditorIfNeeded$lambda$5(isDisposed, $this$disposeWithEditorIfNeeded));
    }

    private final boolean editorTypeSupported(Editor editor2) {
        boolean isTest = editor2.getEditorKind() == EditorKind.UNTYPED && ApplicationKt.getApplication().isUnitTestMode();
        return editor2.getEditorKind() == EditorKind.MAIN_EDITOR || isTest;
    }

    private static final String doTryInstall$lambda$2$lambda$1(VirtualFile $file) {
        return "Next Edit is going to be re-initialized for " + $file.getPath();
    }

    private static final Unit doTryInstall$lambda$3(Editor $editor) {
        NextEditSessionManager.Companion.uninstall($editor);
        return Unit.INSTANCE;
    }

    private static final Unit disposeWithEditorIfNeeded$lambda$4(AtomicBoolean $isDisposed) {
        $isDisposed.set(true);
        return Unit.INSTANCE;
    }

    private static final void disposeWithEditorIfNeeded$lambda$5(AtomicBoolean $isDisposed, Disposable $this_disposeWithEditorIfNeeded) {
        if ($isDisposed.compareAndSet(false, true)) {
            Disposer.dispose((Disposable)$this_disposeWithEditorIfNeeded);
        }
    }

    static {
        NextEditInstaller $this$thisNextEditLogger$iv = INSTANCE = new NextEditInstaller();
        boolean $i$f$thisNextEditLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NextEditInstaller.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = new MLCompletionLogger(logger, MLCompletionLogger.FeatureType.NextEdit);
        Key key = Key.create((String)"ml.llm.next.edit.disposable");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
    }
}

