/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.feedback;

import com.intellij.ml.llm.nextEdits.feedback.NextEditOptInSurveyDialog;
import com.intellij.ml.llm.nextEdits.feedback.NextEditSurveyConfig;
import com.intellij.ml.llm.nextEdits.feedback.NextEditSurveyStateComponent;
import com.intellij.ml.llm.nextEdits.feedback.SurveyConfigProvider;
import com.intellij.ml.llm.nextEdits.settings.NextEditSettingsControllerKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialog;
import com.intellij.platform.feedback.dialog.SystemDataJsonSerializable;
import com.intellij.platform.feedback.impl.notification.RequestFeedbackNotification;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/nextEdits/feedback/NextEditOptInSurveyConfig;", "Lcom/intellij/ml/llm/nextEdits/feedback/NextEditSurveyConfig;", "<init>", "()V", "surveyId", "", "getSurveyId", "()Ljava/lang/String;", "lastDayOfFeedbackCollection", "Lkotlinx/datetime/LocalDate;", "getLastDayOfFeedbackCollection", "()Lkotlinx/datetime/LocalDate;", "checkIdeIsSuitable", "", "checkExtraConditionSatisfied", "project", "Lcom/intellij/openapi/project/Project;", "createFeedbackDialog", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialog;", "Lcom/intellij/platform/feedback/dialog/SystemDataJsonSerializable;", "forTest", "createNotification", "Lcom/intellij/platform/feedback/impl/notification/RequestFeedbackNotification;", "updateStateAfterNotificationShowed", "", "intellij.ml.llm.nextEdits"})
public final class NextEditOptInSurveyConfig
extends NextEditSurveyConfig {
    @NotNull
    private final String surveyId;
    @NotNull
    private final LocalDate lastDayOfFeedbackCollection = new LocalDate(2025, 10, 1);

    public NextEditOptInSurveyConfig() {
        this.surveyId = "next_edit_optin_survey";
    }

    @NotNull
    public String getSurveyId() {
        return this.surveyId;
    }

    @NotNull
    public LocalDate getLastDayOfFeedbackCollection() {
        return this.lastDayOfFeedbackCollection;
    }

    public boolean checkIdeIsSuitable() {
        return NextEditSurveyStateComponent.Companion.getInstance().isTrackNotificationShownActive() && !NextEditSettingsControllerKt.isNextEditGloballyDisabled();
    }

    public boolean checkExtraConditionSatisfied(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (!this.checkIdeIsSuitable()) {
            return false;
        }
        NextEditSurveyStateComponent.State feedbackState = NextEditSurveyStateComponent.Companion.getInstance().getState();
        return !feedbackState.isNotificationShown() && feedbackState.getSessionsSeen() >= SurveyConfigProvider.INSTANCE.getSufficientSessionsToNotifyOptIn$intellij_ml_llm_nextEdits();
    }

    @NotNull
    public BlockBasedFeedbackDialog<? extends SystemDataJsonSerializable> createFeedbackDialog(@NotNull Project project2, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return new NextEditOptInSurveyDialog(project2, forTest);
    }

    @NotNull
    public RequestFeedbackNotification createNotification(@NotNull Project project2, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return new RequestFeedbackNotification("Next Edit Suggestions", "Next Edit Suggestions Feedback", "Help us improve the Next Edit feature by sharing your feedback");
    }

    public void updateStateAfterNotificationShowed(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        NextEditSurveyStateComponent.Companion.getInstance().fireTrackingNotificationShown();
    }
}

