/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.listeners;

import com.intellij.ml.llm.nextEdits.context.NextEditFilePath;
import com.intellij.ml.llm.nextEdits.context.NextEditFilePathForDocumentProvider;
import com.intellij.ml.llm.nextEdits.history.NextEditRecentFileChangesProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/nextEdits/listeners/NextEditPsiDocumentSynchronizerListener;", "Lcom/intellij/psi/impl/PsiDocumentTransactionListener;", "<init>", "()V", "transactionStarted", "", "document", "Lcom/intellij/openapi/editor/Document;", "psiFile", "Lcom/intellij/psi/PsiFile;", "transactionCompleted", "Companion", "intellij.ml.llm.nextEdits"})
public final class NextEditPsiDocumentSynchronizerListener
implements PsiDocumentTransactionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Long> LAST_MODIFICATION_STAMP_KEY;

    public void transactionStarted(@NotNull Document document2, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        document2.putUserData(LAST_MODIFICATION_STAMP_KEY, (Object)document2.getModificationStamp());
    }

    public void transactionCompleted(@NotNull Document document2, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Long l = (Long)document2.getUserData(LAST_MODIFICATION_STAMP_KEY);
        if (l == null) {
            return;
        }
        long lastDocumentModificationStamp = l;
        long currentModificationStamp = document2.getModificationStamp();
        if (lastDocumentModificationStamp != currentModificationStamp) {
            Project project2 = psiFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            NextEditFilePath path = NextEditFilePathForDocumentProvider.Companion.getInstance(project2).getPathOrNull(document2);
            if (path != null) {
                Project project3 = psiFile.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                NextEditRecentFileChangesProvider.Companion.getInstance(project3).modificationStampUpdated(path, currentModificationStamp);
            }
        }
        document2.putUserData(LAST_MODIFICATION_STAMP_KEY, null);
    }

    static {
        Key key = Key.create((String)"next.edit.last.psi.sync.modification.stamp");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        LAST_MODIFICATION_STAMP_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/nextEdits/listeners/NextEditPsiDocumentSynchronizerListener$Companion;", "", "<init>", "()V", "LAST_MODIFICATION_STAMP_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.ml.llm.nextEdits"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

