/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.services;

import com.intellij.codeInsight.inline.edit.InlineEditRequestExecutor;
import com.intellij.lang.Language;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionLogger;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditSessionEventsReporter;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditTriggerReason;
import com.intellij.ml.llm.nextEdits.UtilsKt;
import com.intellij.ml.llm.nextEdits.listeners.CaretEventType;
import com.intellij.ml.llm.nextEdits.pipeline.NextEditFilterPipeline;
import com.intellij.ml.llm.nextEdits.request.NextEditRequest;
import com.intellij.ml.llm.nextEdits.request.NextEditRequestKt;
import com.intellij.ml.llm.nextEdits.services.NextEditDebounceService;
import com.intellij.ml.llm.nextEdits.services.NextEditRequestService;
import com.intellij.ml.llm.nextEdits.services.NextEditSuggestion;
import com.intellij.ml.llm.nextEdits.services.NextEditSuggestionProvider;
import com.intellij.ml.llm.nextEdits.session.NextEditSessionProgress;
import com.intellij.ml.llm.nextEdits.ui.NextEditMagicWand;
import com.intellij.ml.llm.nextEdits.ui.NextEditViewModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.lang.invoke.LambdaMetafactory;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u0000 .2\u00020\u0001:\u0001.B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\b\u0010\u0010\u001a\u00020\u000bH\u0007J\u001d\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\b\u0016J\u000e\u0010\u0017\u001a\u00020\u000bH\u0087@\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u000bH\u0016J-\u0010\u001a\u001a\u00020\u000b2\u001e\u0010\u001b\u001a\u001a\b\u0001\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001cH\u0003\u00a2\u0006\u0002\u0010 J\u0016\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u001eH\u0082@\u00a2\u0006\u0002\u0010#J\u0016\u0010$\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u001eH\u0083@\u00a2\u0006\u0002\u0010#J\u0016\u0010%\u001a\u0004\u0018\u00010&*\u00020\r2\u0006\u0010'\u001a\u00020(H\u0003J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020-H\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/ml/llm/nextEdits/services/NextEditRequestService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "requestExecutor", "Lcom/intellij/codeInsight/inline/edit/InlineEditRequestExecutor;", "newRequest", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "triggerReason", "Lcom/intellij/ml/inline/completion/impl/diagnostic/NextEditTriggerReason;", "cancelRequests", "handleCaretEvent", "caretEvent", "Lcom/intellij/openapi/editor/event/CaretEvent;", "type", "Lcom/intellij/ml/llm/nextEdits/listeners/CaretEventType;", "handleCaretEvent$intellij_ml_llm_nextEdits", "awaitRequests", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "dispatchRequest", "requestFactory", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "Lcom/intellij/ml/llm/nextEdits/request/NextEditRequest;", "", "(Lkotlin/jvm/functions/Function1;)V", "handleRequest", "request", "(Lcom/intellij/ml/llm/nextEdits/request/NextEditRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleRequestUnsafe", "retrievePsiFile", "Lcom/intellij/psi/PsiFile;", "editorDataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getLanguage", "Lcom/intellij/lang/Language;", "file", "offset", "", "Companion", "intellij.ml.llm.nextEdits"})
@SourceDebugExtension(value={"SMAP\nNextEditRequestService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditRequestService.kt\ncom/intellij/ml/llm/nextEdits/services/NextEditRequestService\n+ 2 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger\n+ 3 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/DiagnosticLoggersKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,215:1\n106#2:216\n107#2,2:222\n95#3:217\n135#3,2:218\n137#3:221\n75#4:220\n42#5:224\n14#6:225\n*S KotlinDebug\n*F\n+ 1 NextEditRequestService.kt\ncom/intellij/ml/llm/nextEdits/services/NextEditRequestService\n*L\n185#1:216\n185#1:222,2\n185#1:217\n185#1:218,2\n185#1:221\n187#1:220\n210#1:224\n210#1:225\n*E\n"})
public final class NextEditRequestService
implements Disposable {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    @NotNull
    private final InlineEditRequestExecutor requestExecutor;
    @NotNull
    private static final MLCompletionLogger logger;

    public NextEditRequestService(@NotNull Project project2, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project2;
        this.requestExecutor = InlineEditRequestExecutor.Companion.create(scope);
    }

    @RequiresEdt
    public final void newRequest(@NotNull Editor editor2, @NotNull NextEditTriggerReason triggerReason) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)triggerReason, (String)"triggerReason");
        ThreadingAssertions.assertEventDispatchThread();
        if (!UtilsKt.isNextEditSupported(editor2)) {
            return;
        }
        if (editor2.isDisposed()) {
            logger.debug(NextEditRequestService::newRequest$lambda$0);
            return;
        }
        if (editor2.getVirtualFile() == null) {
            logger.debug(NextEditRequestService::newRequest$lambda$1);
            return;
        }
        if (editor2.getCaretModel().getCaretCount() != 1) {
            logger.debug(NextEditRequestService::newRequest$lambda$2);
            return;
        }
        NextEditRequest.LightweightEditorSnapshot editorSnapshot = (NextEditRequest.LightweightEditorSnapshot)ActionsKt.runReadAction(() -> NextEditRequestService.newRequest$lambda$3(editor2));
        DataContext dataContext2 = EditorUtil.getEditorDataContext((Editor)editor2);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getEditorDataContext(...)");
        DataContext editorDataContext = dataContext2;
        int caretOffset = editor2.getCaretModel().getOffset();
        long timestamp = System.currentTimeMillis();
        this.dispatchRequest((Function1<? super Continuation<? super NextEditRequest>, ? extends Object>)((Function1)new Function1<Continuation<? super NextEditRequest>, Object>(this, editor2, editorDataContext, caretOffset, editorSnapshot, timestamp, triggerReason, null){
            int label;
            final /* synthetic */ NextEditRequestService this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ DataContext $editorDataContext;
            final /* synthetic */ int $caretOffset;
            final /* synthetic */ NextEditRequest.LightweightEditorSnapshot $editorSnapshot;
            final /* synthetic */ long $timestamp;
            final /* synthetic */ NextEditTriggerReason $triggerReason;
            {
                this.this$0 = $receiver;
                this.$editor = $editor;
                this.$editorDataContext = $editorDataContext;
                this.$caretOffset = $caretOffset;
                this.$editorSnapshot = $editorSnapshot;
                this.$timestamp = $timestamp;
                this.$triggerReason = $triggerReason;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = NextEditDebounceService.Companion.getInstance().debounceRequest((Continuation<? super Unit>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.ml.llm.nextEdits.services.NextEditRequestService com.intellij.openapi.editor.Editor com.intellij.openapi.actionSystem.DataContext int com.intellij.ml.llm.nextEdits.request.NextEditRequest$LightweightEditorSnapshot long com.intellij.ml.inline.completion.impl.diagnostic.NextEditTriggerReason ), ()Lcom/intellij/ml/llm/nextEdits/request/NextEditRequest;)((NextEditRequestService)this.this$0, (Editor)this.$editor, (DataContext)this.$editorDataContext, (int)this.$caretOffset, (NextEditRequest.LightweightEditorSnapshot)this.$editorSnapshot, (long)this.$timestamp, (NextEditTriggerReason)this.$triggerReason), (Continuation)((Continuation)this));
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        return v1;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super NextEditRequest> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }

            private static final NextEditRequest invokeSuspend$lambda$0(NextEditRequestService this$0, Editor $editor, DataContext $editorDataContext, int $caretOffset, NextEditRequest.LightweightEditorSnapshot $editorSnapshot, long $timestamp, NextEditTriggerReason $triggerReason) {
                ProgressManager.checkCanceled();
                PsiFile psiFile = NextEditRequestService.access$retrievePsiFile(this$0, $editor, $editorDataContext);
                if (psiFile == null) {
                    return null;
                }
                PsiFile psiFile2 = psiFile;
                PsiUtilCore.ensureValid((PsiElement)((PsiElement)psiFile2));
                Language language = NextEditRequestService.access$getLanguage(this$0, psiFile2, $caretOffset);
                return new NextEditRequest($editor, psiFile2, language, $caretOffset, $editorSnapshot, $timestamp, $triggerReason);
            }
        }));
    }

    @RequiresEdt
    public final void cancelRequests() {
        ThreadingAssertions.assertEventDispatchThread();
        this.requestExecutor.cancelActiveRequest();
        logger.trace(NextEditRequestService::cancelRequests$lambda$4);
    }

    @RequiresEdt
    public final void handleCaretEvent$intellij_ml_llm_nextEdits(@NotNull CaretEvent caretEvent, @NotNull CaretEventType type2) {
        Intrinsics.checkNotNullParameter((Object)caretEvent, (String)"caretEvent");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        ThreadingAssertions.assertEventDispatchThread();
        switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: 
            case 2: {
                this.cancelRequests();
                break;
            }
            case 3: {
                if (caretEvent.getOldPosition().line == caretEvent.getNewPosition().line) break;
                this.cancelRequests();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @RequiresEdt
    @TestOnly
    @Nullable
    public final Object awaitRequests(@NotNull Continuation<? super Unit> $completion) {
        ThreadingAssertions.assertEventDispatchThread();
        Object object = this.requestExecutor.awaitActiveRequest($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public void dispose() {
        Disposer.dispose((Disposable)((Disposable)this.requestExecutor));
    }

    @RequiresEdt
    private final void dispatchRequest(Function1<? super Continuation<? super NextEditRequest>, ? extends Object> requestFactory) {
        ThreadingAssertions.assertEventDispatchThread();
        this.requestExecutor.switchRequest((Function1)dispatchRequest.1.INSTANCE, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(requestFactory, this, null){
            Object L$0;
            int label;
            final /* synthetic */ Function1<Continuation<? super NextEditRequest>, Object> $requestFactory;
            final /* synthetic */ NextEditRequestService this$0;
            {
                this.$requestFactory = $requestFactory;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = this.$requestFactory.invoke((Object)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((request = (NextEditRequest)v0) != null) {
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)request);
                            this.label = 2;
                            v1 = NextEditRequestService.access$handleRequest(this.this$0, request, (Continuation)this);
                            if (v1 == var3_2) {
                                return var3_2;
                            }
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        request = (NextEditRequest)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleRequest(NextEditRequest request, Continuation<? super Unit> $completion) {
        if (!($completion instanceof handleRequest.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ NextEditRequestService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return NextEditRequestService.access$handleRequest(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = request;
                $continuation.label = 1;
                v0 = NextEditRequestKt.checkValidity(request, (Continuation<? super Unit>)$continuation);
                ** if (v0 != var6_5) goto lbl19
lbl18:
                // 1 sources

                return var6_5;
lbl19:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                request = (NextEditRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.label = 2;
                v1 = NextEditMagicWand.Companion.getInstance().displayDuring(request.getEditor(), (Function1)new Function1<Continuation<? super Unit>, Object>(this, request, null){
                    int label;
                    final /* synthetic */ NextEditRequestService this$0;
                    final /* synthetic */ NextEditRequest $request;
                    {
                        this.this$0 = $receiver;
                        this.$request = $request;
                        super(1, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = NextEditRequestService.access$handleRequestUnsafe(this.this$0, this.$request, (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(Continuation<? super Unit> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }, $continuation);
                ** if (v1 != var6_5) goto lbl31
lbl30:
                // 1 sources

                return var6_5;
lbl31:
                // 1 sources

                ** GOTO lbl42
            }
            case 2: {
                request = (NextEditRequest)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                }
                catch (Throwable e) {
                    if (NextEditRequestService.logger.errorIfNotMessage(e)) ** GOTO lbl42
                    throw e;
                }
lbl42:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @RequiresBackgroundThread
    private final Object handleRequestUnsafe(NextEditRequest request, Continuation<? super Unit> $completion) {
        if (!($completion instanceof handleRequestUnsafe.1)) ** GOTO lbl-1000
        var25_3 = $completion;
        if ((var25_3.label & -2147483648) != 0) {
            var25_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                int I$4;
                int I$5;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ NextEditRequestService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return NextEditRequestService.access$handleRequestUnsafe(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var26_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                ThreadingAssertions.assertBackgroundThread();
                $continuation.L$0 = request;
                $continuation.label = 1;
                v0 = NextEditFilterPipeline.INSTANCE.isRequestPermitted(request, (Continuation<? super Boolean>)$continuation);
                if (v0 == var26_5) {
                    return var26_5;
                }
                ** GOTO lbl23
            }
            case 1: {
                request = (NextEditRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = request;
                $continuation.label = 2;
                v1 = NextEditRequestKt.checkValidity(request, (Continuation<? super Unit>)$continuation);
                if (v1 == var26_5) {
                    return var26_5;
                }
                ** GOTO lbl35
            }
            case 2: {
                request = (NextEditRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl35:
                // 2 sources

                reporter = NextEditSessionEventsReporter.Companion.of(request.getLanguage());
                reporter.onTriggered(request.getTriggerReason());
                $continuation.L$0 = request;
                $continuation.L$1 = reporter;
                $continuation.label = 3;
                v2 = NextEditSuggestionProvider.Companion.getAggregatedProvider(this.project).provideSuggestion(request, reporter, (Continuation<? super NextEditSuggestion>)$continuation);
                if (v2 == var26_5) {
                    return var26_5;
                }
                ** GOTO lbl49
            }
            case 3: {
                reporter = (NextEditSessionEventsReporter)$continuation.L$1;
                request = (NextEditRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl49:
                // 2 sources

                v3 = (NextEditSuggestion)v2;
                if (v3 == null) {
                    return Unit.INSTANCE;
                }
                requestResult = v3;
                $continuation.L$0 = request;
                $continuation.L$1 = reporter;
                $continuation.L$2 = requestResult;
                $continuation.label = 4;
                v4 = NextEditRequestKt.checkValidity(request, (Continuation<? super Unit>)$continuation);
                if (v4 == var26_5) {
                    return var26_5;
                }
                ** GOTO lbl67
            }
            case 4: {
                requestResult = (NextEditSuggestion)$continuation.L$2;
                reporter = (NextEditSessionEventsReporter)$continuation.L$1;
                request = (NextEditRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl67:
                // 2 sources

                $continuation.L$0 = request;
                $continuation.L$1 = reporter;
                $continuation.L$2 = requestResult;
                $continuation.label = 5;
                v5 = requestResult.toProgress(reporter, (Continuation<? super NextEditSessionProgress>)$continuation);
                if (v5 == var26_5) {
                    return var26_5;
                }
                ** GOTO lbl81
            }
            case 5: {
                requestResult = (NextEditSuggestion)$continuation.L$2;
                reporter = (NextEditSessionEventsReporter)$continuation.L$1;
                request = (NextEditRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl81:
                // 2 sources

                v6 = (NextEditSessionProgress)v5;
                if (v6 == null) {
                    return Unit.INSTANCE;
                }
                progress = v6;
                $continuation.L$0 = request;
                $continuation.L$1 = reporter;
                $continuation.L$2 = requestResult;
                $continuation.L$3 = progress;
                $continuation.label = 6;
                v7 = NextEditRequestKt.checkValidity(request, (Continuation<? super Unit>)$continuation);
                if (v7 == var26_5) {
                    return var26_5;
                }
                ** GOTO lbl101
            }
            case 6: {
                progress = (NextEditSessionProgress)$continuation.L$3;
                requestResult = (NextEditSuggestion)$continuation.L$2;
                reporter = (NextEditSessionEventsReporter)$continuation.L$1;
                request = (NextEditRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
lbl101:
                // 2 sources

                isValidSuggestion = (Function1)new Function1<Continuation<? super Boolean>, Object>(request, null){
                    int label;
                    final /* synthetic */ NextEditRequest $request;
                    {
                        this.$request = $request;
                        super(1, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = CoroutinesKt.readAction(() -> handleRequestUnsafe.isValidSuggestion.1.invokeSuspend$lambda$0(this.$request), (Continuation)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(Continuation<? super Boolean> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final boolean invokeSuspend$lambda$0(NextEditRequest $request) {
                        return $request.isValid();
                    }
                };
                var7_14 = NextEditRequestService.logger;
                actionName$iv = "Initialize UI session";
                $i$f$logActionTime = 0;
                $i$f$measureTimedValue = 0;
                $this$measureTimedValue$iv$iv$iv = TimeSource.Monotonic.INSTANCE;
                $i$f$measureTimedValue = 0;
                mark$iv$iv$iv = $this$measureTimedValue$iv$iv$iv.markNow-z9LOYto();
                $i$a$-measureTimedValue-MLCompletionLogger$logActionTime$1$iv = 0;
                $i$a$-logActionTime-NextEditRequestService$handleRequestUnsafe$2 = 0;
                var17_30 = (ComponentManager)this.project;
                var18_31 = $continuation;
                $i$f$serviceAsync = 0;
                Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$1 = reporter;
                $continuation.L$2 = requestResult;
                $continuation.L$3 = progress;
                $continuation.L$4 = isValidSuggestion;
                $continuation.L$5 = this_$iv;
                $continuation.L$6 = actionName$iv;
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)$this$measureTimedValue$iv$iv$iv);
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)$completion$iv);
                $continuation.I$0 = $i$f$logActionTime;
                $continuation.I$1 = $i$f$measureTimedValue;
                $continuation.I$2 = $i$f$measureTimedValue;
                $continuation.J$0 = mark$iv$iv$iv;
                $continuation.I$3 = $i$a$-measureTimedValue-MLCompletionLogger$logActionTime$1$iv;
                $continuation.I$4 = $i$a$-logActionTime-NextEditRequestService$handleRequestUnsafe$2;
                $continuation.I$5 = $i$f$serviceAsync;
                $continuation.label = 7;
                v8 = ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(NextEditViewModel.class, (Continuation)$completion$iv);
                if (v8 == var26_5) {
                    return var26_5;
                }
                ** GOTO lbl159
            }
            case 7: {
                $i$f$serviceAsync = $continuation.I$5;
                $i$a$-logActionTime-NextEditRequestService$handleRequestUnsafe$2 = $continuation.I$4;
                $i$a$-measureTimedValue-MLCompletionLogger$logActionTime$1$iv = $continuation.I$3;
                mark$iv$iv$iv = $continuation.J$0;
                $i$f$measureTimedValue = $continuation.I$2;
                $i$f$measureTimedValue = $continuation.I$1;
                $i$f$logActionTime = $continuation.I$0;
                $completion$iv = $continuation.L$9;
                $this$serviceAsync$iv = (ComponentManager)$continuation.L$8;
                $this$measureTimedValue$iv$iv$iv = (TimeSource.Monotonic)$continuation.L$7;
                actionName$iv = (String)$continuation.L$6;
                this_$iv = (MLCompletionLogger)$continuation.L$5;
                isValidSuggestion = (Function1)$continuation.L$4;
                progress = (NextEditSessionProgress)$continuation.L$3;
                requestResult = (NextEditSuggestion)$continuation.L$2;
                reporter = (NextEditSessionEventsReporter)$continuation.L$1;
                request = (NextEditRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v8 = $result;
lbl159:
                // 2 sources

                var20_35 = (NextEditViewModel)v8;
                var17_30 = requestResult.getEditor();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)reporter);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)requestResult);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)progress);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)isValidSuggestion);
                $continuation.L$5 = this_$iv;
                $continuation.L$6 = actionName$iv;
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)$this$measureTimedValue$iv$iv$iv);
                $continuation.L$8 = null;
                $continuation.L$9 = null;
                $continuation.I$0 = $i$f$logActionTime;
                $continuation.I$1 = $i$f$measureTimedValue;
                $continuation.I$2 = $i$f$measureTimedValue;
                $continuation.J$0 = mark$iv$iv$iv;
                $continuation.I$3 = $i$a$-measureTimedValue-MLCompletionLogger$logActionTime$1$iv;
                $continuation.I$4 = $i$a$-logActionTime-NextEditRequestService$handleRequestUnsafe$2;
                $continuation.label = 8;
                v9 = var20_35.newNextEditSession((Editor)var17_30, progress, reporter, (Function1<? super Continuation<? super Boolean>, ? extends Object>)isValidSuggestion, (Continuation<? super Unit>)$continuation);
                if (v9 == var26_5) {
                    return var26_5;
                }
                ** GOTO lbl199
            }
            case 8: {
                $i$a$-logActionTime-NextEditRequestService$handleRequestUnsafe$2 = $continuation.I$4;
                $i$a$-measureTimedValue-MLCompletionLogger$logActionTime$1$iv = $continuation.I$3;
                mark$iv$iv$iv = $continuation.J$0;
                $i$f$measureTimedValue = $continuation.I$2;
                $i$f$measureTimedValue = $continuation.I$1;
                $i$f$logActionTime = $continuation.I$0;
                $this$measureTimedValue$iv$iv$iv = (TimeSource.Monotonic)$continuation.L$7;
                actionName$iv = (String)$continuation.L$6;
                this_$iv = (MLCompletionLogger)$continuation.L$5;
                isValidSuggestion = (Function1)$continuation.L$4;
                progress = (NextEditSessionProgress)$continuation.L$3;
                requestResult = (NextEditSuggestion)$continuation.L$2;
                reporter = (NextEditSessionEventsReporter)$continuation.L$1;
                request = (NextEditRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v9 = $result;
lbl199:
                // 2 sources

                result$iv$iv$iv = Unit.INSTANCE;
                var21_36 = new TimedValue((Object)result$iv$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv$iv), null);
                value$iv = var21_36.component1();
                time$iv = var21_36.component2-UwyO8pc();
                this_$iv.logActionTime(actionName$iv, Duration.getInWholeMilliseconds-impl((long)time$iv));
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @RequiresReadLock
    private final PsiFile retrievePsiFile(Editor $this$retrievePsiFile, DataContext editorDataContext) {
        ThreadingAssertions.assertBackgroundThread();
        PsiFile psiFile = (PsiFile)editorDataContext.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            psiFile = PsiDocumentManager.getInstance((Project)this.project).getCachedPsiFile($this$retrievePsiFile.getDocument());
        }
        return psiFile;
    }

    @RequiresReadLock
    private final Language getLanguage(PsiFile file, int offset) {
        PsiFile psiFile = PsiUtilBase.getPsiFileAtOffset((PsiFile)file, (int)offset);
        if (psiFile == null || (psiFile = psiFile.getLanguage()) == null) {
            Language language = file.getLanguage();
            psiFile = language;
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        }
        return psiFile;
    }

    private static final String newRequest$lambda$0() {
        return "Editor is disposed. Not supported.";
    }

    private static final String newRequest$lambda$1() {
        return "Editor is not file-based. Not supported.";
    }

    private static final String newRequest$lambda$2() {
        return "Editor has more than one caret. Not supported.";
    }

    private static final NextEditRequest.LightweightEditorSnapshot newRequest$lambda$3(Editor $editor) {
        long l = $editor.getDocument().getModificationStamp();
        LogicalPosition logicalPosition = $editor.getCaretModel().getLogicalPosition();
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
        return new NextEditRequest.LightweightEditorSnapshot(l, logicalPosition);
    }

    private static final String cancelRequests$lambda$4() {
        return "Requests are cancelled.";
    }

    public static final /* synthetic */ PsiFile access$retrievePsiFile(NextEditRequestService $this, Editor $receiver, DataContext editorDataContext) {
        return $this.retrievePsiFile($receiver, editorDataContext);
    }

    public static final /* synthetic */ Language access$getLanguage(NextEditRequestService $this, PsiFile file, int offset) {
        return $this.getLanguage(file, offset);
    }

    public static final /* synthetic */ Object access$handleRequest(NextEditRequestService $this, NextEditRequest request2, Continuation $completion) {
        return $this.handleRequest(request2, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleRequestUnsafe(NextEditRequestService $this, NextEditRequest request2, Continuation $completion) {
        return $this.handleRequestUnsafe(request2, (Continuation<? super Unit>)$completion);
    }

    static {
        Companion $this$thisNextEditLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisNextEditLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        NextEditRequestService.logger = new MLCompletionLogger(logger, MLCompletionLogger.FeatureType.NextEdit);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/nextEdits/services/NextEditRequestService$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger;", "getInstance", "Lcom/intellij/ml/llm/nextEdits/services/NextEditRequestService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.nextEdits"})
    @SourceDebugExtension(value={"SMAP\nNextEditRequestService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditRequestService.kt\ncom/intellij/ml/llm/nextEdits/services/NextEditRequestService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,215:1\n30#2,2:216\n*S KotlinDebug\n*F\n+ 1 NextEditRequestService.kt\ncom/intellij/ml/llm/nextEdits/services/NextEditRequestService$Companion\n*L\n212#1:216,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NextEditRequestService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<NextEditRequestService> serviceClass$iv = NextEditRequestService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (NextEditRequestService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CaretEventType.values().length];
            try {
                nArray[CaretEventType.CARET_ADDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CaretEventType.CARET_REMOVED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CaretEventType.MOVEMENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

