/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.session;

import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionLogger;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditSessionEventsReporter;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditSessionFinishType;
import com.intellij.ml.llm.nextEdits.listeners.CaretEventType;
import com.intellij.ml.llm.nextEdits.logs.ExtKt;
import com.intellij.ml.llm.nextEdits.session.NextEditIntrusionModeController;
import com.intellij.ml.llm.nextEdits.session.NextEditSessionListener;
import com.intellij.ml.llm.nextEdits.session.NextEditSessionProgress;
import com.intellij.ml.llm.nextEdits.session.guarder.DocumentChangeGuardPurpose;
import com.intellij.ml.llm.nextEdits.session.guarder.Guarder;
import com.intellij.ml.llm.nextEdits.session.guarder.NextEditSessionSuppressionGuarder;
import com.intellij.ml.llm.nextEdits.session.guarder.NextEditSessionSuppressionGuarderKt;
import com.intellij.ml.llm.nextEdits.session.guarder.SuppressSessionGuardPurpose;
import com.intellij.ml.llm.nextEdits.session.step.NextEditSessionStep;
import com.intellij.ml.llm.nextEdits.session.step.UndoableCaretMoveAction;
import com.intellij.ml.llm.nextEdits.session.step.controller.NextEditStepController;
import com.intellij.ml.llm.nextEdits.settings.NextEditSettings;
import com.intellij.ml.llm.nextEdits.ui.display.NextEditDisplayManager;
import com.intellij.ml.llm.nextEdits.ui.display.NextEditDisplayParameters;
import com.intellij.ml.llm.nextEdits.ui.display.NextEditDisplayState;
import com.intellij.ml.llm.nextEdits.ui.refresh.NextEditViewRefreshManager;
import com.intellij.ml.llm.nextEdits.ui.refresh.NextEditViewRefreshReason;
import com.intellij.ml.llm.nextEdits.ui.util.NextEditEditorUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.ui.EDT;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 G2\u00020\u0001:\u0001GBJ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012!\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u000b\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&H\u0007J\b\u0010'\u001a\u00020(H\u0007J\b\u0010)\u001a\u00020\u0010H\u0007J\u000e\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020/J\b\u00100\u001a\u000201H\u0007J\b\u00102\u001a\u00020\u0010H\u0002J\u000e\u00103\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\fJ\b\u00104\u001a\u00020\u0010H\u0002J\b\u00105\u001a\u00020\u0010H\u0002J\u0010\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020\u00102\u0006\u0010:\u001a\u00020(H\u0002J\u0018\u0010;\u001a\u00020\u00102\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u000208H\u0003J\b\u0010?\u001a\u00020\u0010H\u0003J\u0010\u0010@\u001a\u00020\u00102\u0006\u0010A\u001a\u000201H\u0002J\b\u0010B\u001a\u00020\u0010H\u0016J\b\u0010C\u001a\u00020DH\u0002J\b\u0010E\u001a\u00020FH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/intellij/ml/llm/nextEdits/session/NextEditSession;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "progress", "Lcom/intellij/ml/llm/nextEdits/session/NextEditSessionProgress;", "reporter", "Lcom/intellij/ml/inline/completion/impl/diagnostic/NextEditSessionEventsReporter;", "autoDestroy", "Lkotlin/Function1;", "Lcom/intellij/ml/inline/completion/impl/diagnostic/NextEditSessionFinishType;", "Lkotlin/ParameterName;", "name", "finishType", "", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/nextEdits/session/NextEditSessionProgress;Lcom/intellij/ml/inline/completion/impl/diagnostic/NextEditSessionEventsReporter;Lkotlin/jvm/functions/Function1;)V", "suppressionGuarder", "Lcom/intellij/ml/llm/nextEdits/session/guarder/NextEditSessionSuppressionGuarder;", "ignoreDocumentChangesGuarder", "Lcom/intellij/ml/llm/nextEdits/session/guarder/Guarder;", "Lcom/intellij/ml/llm/nextEdits/session/guarder/DocumentChangeGuardPurpose;", "intrusionModeController", "Lcom/intellij/ml/llm/nextEdits/session/NextEditIntrusionModeController;", "displayManager", "Lcom/intellij/ml/llm/nextEdits/ui/display/NextEditDisplayManager;", "refreshManager", "Lcom/intellij/ml/llm/nextEdits/ui/refresh/NextEditViewRefreshManager;", "suppressIfNeeded", "purpose", "Lcom/intellij/ml/llm/nextEdits/session/guarder/SuppressSessionGuardPurpose;", "doMarkSuppressedByPurposeAndLog", "unsuppress", "doMarkUnsuppressedByPurposeAndLog", "refreshIfNeeded", "reason", "Lcom/intellij/ml/llm/nextEdits/ui/refresh/NextEditViewRefreshReason;", "isActive", "", "handleTab", "onDocumentEvent", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "onCaretEvent", "type", "Lcom/intellij/ml/llm/nextEdits/listeners/CaretEventType;", "getDisplayState", "Lcom/intellij/ml/llm/nextEdits/ui/display/NextEditDisplayState;", "startSession", "reportSessionFinished", "handleStepRepresentationUpdated", "doRefreshView", "doHandleJump", "stepController", "Lcom/intellij/ml/llm/nextEdits/session/step/controller/NextEditStepController;", "displayCurrentStepOrJump", "notifyIntrusionController", "acceptStep", "step", "Lcom/intellij/ml/llm/nextEdits/session/step/NextEditSessionStep;", "controller", "makeCurrentStepViewVisibleIfRendering", "onDisplayStateChanged", "newState", "dispose", "getCurrentDisplayParameters", "Lcom/intellij/ml/llm/nextEdits/ui/display/NextEditDisplayParameters;", "getCurrentEditRange", "Lcom/intellij/openapi/util/TextRange;", "Companion", "intellij.ml.llm.nextEdits"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNextEditSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditSession.kt\ncom/intellij/ml/llm/nextEdits/session/NextEditSession\n+ 2 Guarder.kt\ncom/intellij/ml/llm/nextEdits/session/guarder/Guarder$Companion\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/DiagnosticLoggersKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,405:1\n68#2:406\n19#3:407\n42#4:408\n14#5:409\n*S KotlinDebug\n*F\n+ 1 NextEditSession.kt\ncom/intellij/ml/llm/nextEdits/session/NextEditSession\n*L\n45#1:406\n363#1:407\n403#1:408\n403#1:409\n*E\n"})
public final class NextEditSession
implements Disposable {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    @NotNull
    private final NextEditSessionProgress progress;
    @NotNull
    private final NextEditSessionEventsReporter reporter;
    @NotNull
    private final Function1<NextEditSessionFinishType, Unit> autoDestroy;
    @NotNull
    private final NextEditSessionSuppressionGuarder suppressionGuarder;
    @NotNull
    private final Guarder<DocumentChangeGuardPurpose> ignoreDocumentChangesGuarder;
    @NotNull
    private final NextEditIntrusionModeController intrusionModeController;
    @NotNull
    private final NextEditDisplayManager displayManager;
    @NotNull
    private final NextEditViewRefreshManager refreshManager;
    @NotNull
    private static final MLCompletionLogger LOG;

    /*
     * WARNING - void declaration
     */
    public NextEditSession(@NotNull Editor editor2, @NotNull Project project2, @NotNull NextEditSessionProgress progress, @NotNull NextEditSessionEventsReporter reporter, @NotNull Function1<? super NextEditSessionFinishType, Unit> autoDestroy) {
        void assertions$iv;
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter(autoDestroy, (String)"autoDestroy");
        this.editor = editor2;
        this.project = project2;
        this.progress = progress;
        this.reporter = reporter;
        this.autoDestroy = autoDestroy;
        this.suppressionGuarder = new NextEditSessionSuppressionGuarder();
        Guarder.Companion companion = Guarder.Companion;
        String string = "Ignore document changes in session";
        Function0 function0 = NextEditSession::ignoreDocumentChangesGuarder$lambda$0;
        boolean $i$f$invoke = false;
        this.ignoreDocumentChangesGuarder = new Guarder<DocumentChangeGuardPurpose>((String)name$iv, (Function0<Boolean>)assertions$iv, DocumentChangeGuardPurpose.class);
        this.intrusionModeController = NextEditIntrusionModeController.Companion.of(this.editor, NextEditSettings.Companion.getInstance().getState().getPreviewMode());
        this.displayManager = new NextEditDisplayManager(this.ignoreDocumentChangesGuarder, (Function1<? super NextEditDisplayState, Unit>)((Function1)new Function1<NextEditDisplayState, Unit>((Object)this){

            public final void invoke(NextEditDisplayState p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                NextEditSession.access$onDisplayStateChanged((NextEditSession)this.receiver, p0);
            }
        }));
        this.refreshManager = new NextEditViewRefreshManager((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                NextEditSession.access$doRefreshView((NextEditSession)this.receiver);
            }
        }));
        this.startSession();
    }

    @RequiresEdt
    public final void suppressIfNeeded(@NotNull SuppressSessionGuardPurpose purpose) {
        Intrinsics.checkNotNullParameter((Object)((Object)purpose), (String)"purpose");
        NextEditDisplayState displayState = this.displayManager.getDisplayState();
        if (displayState instanceof NextEditDisplayState.StepShown) {
            NextEditStepController.SuppressHandlerType suppressHandlerType = ((NextEditDisplayState.StepShown)displayState).getStepController().getSuppressHandlerType(this.editor, this.project, purpose);
            switch (WhenMappings.$EnumSwitchMapping$0[suppressHandlerType.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.displayCurrentStepOrJump(false);
                    this.suppressionGuarder.suppressionSkipped(purpose);
                    return;
                }
                case 3: {
                    this.suppressionGuarder.suppressionSkipped(purpose);
                    return;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        boolean wasSuppressed = this.suppressionGuarder.isSuppressed();
        this.doMarkSuppressedByPurposeAndLog(purpose);
        if (!wasSuppressed) {
            this.displayManager.suppress();
        }
    }

    private final void doMarkSuppressedByPurposeAndLog(SuppressSessionGuardPurpose purpose) {
        boolean wasSuppressedByPurpose = this.suppressionGuarder.isSuppressed(purpose);
        boolean wasSuppressedByInline = NextEditSessionSuppressionGuarderKt.isSuppressedByAnyInlineCompletionReason(this.suppressionGuarder);
        this.suppressionGuarder.suppressed(purpose);
        if (!wasSuppressedByPurpose) {
            switch (WhenMappings.$EnumSwitchMapping$1[purpose.ordinal()]) {
                case 1: 
                case 2: {
                    if (wasSuppressedByInline) break;
                    this.reporter.onSuppressedByInline();
                    break;
                }
                case 3: {
                    this.reporter.onSuppressedByLookup();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.intrusionModeController.sessionSuppressed(purpose);
        }
    }

    @RequiresEdt
    public final void unsuppress(@NotNull SuppressSessionGuardPurpose purpose) {
        Intrinsics.checkNotNullParameter((Object)((Object)purpose), (String)"purpose");
        boolean wasSuppressed = this.suppressionGuarder.isSuppressed();
        this.doMarkUnsuppressedByPurposeAndLog(purpose);
        if (wasSuppressed && !this.suppressionGuarder.isSuppressed()) {
            this.displayCurrentStepOrJump(true);
        }
    }

    private final void doMarkUnsuppressedByPurposeAndLog(SuppressSessionGuardPurpose purpose) {
        boolean wasSuppressedByPurpose = this.suppressionGuarder.isSuppressed(purpose);
        boolean wasSuppressedByInline = NextEditSessionSuppressionGuarderKt.isSuppressedByAnyInlineCompletionReason(this.suppressionGuarder);
        this.suppressionGuarder.unsuppressed(purpose);
        if (wasSuppressedByPurpose && !this.suppressionGuarder.isSuppressed(purpose)) {
            switch (WhenMappings.$EnumSwitchMapping$1[purpose.ordinal()]) {
                case 1: 
                case 2: {
                    if (!wasSuppressedByInline || NextEditSessionSuppressionGuarderKt.isSuppressedByAnyInlineCompletionReason(this.suppressionGuarder)) break;
                    this.reporter.onUnsuppressedByInline();
                    break;
                }
                case 3: {
                    this.reporter.onUnsuppressedByLookup();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.intrusionModeController.sessionUnsuppressed(purpose);
        }
    }

    @RequiresEdt
    public final void refreshIfNeeded(@NotNull NextEditViewRefreshReason reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        ThreadingAssertions.assertEventDispatchThread();
        if (this.displayManager.isDisplayInProgress()) {
            return;
        }
        NextEditDisplayState displayState = this.displayManager.getDisplayState();
        if (!(displayState instanceof NextEditDisplayState.StepShown)) {
            return;
        }
        if (((NextEditDisplayState.StepShown)displayState).getStepController().shouldRefreshOn(this.editor, this.project, reason)) {
            this.refreshManager.scheduleRefresh();
        }
    }

    @RequiresEdt
    public final boolean isActive() {
        NextEditDisplayState state2 = this.displayManager.getDisplayState();
        return this.progress.isActive() && (state2 instanceof NextEditDisplayState.StepShown || state2 instanceof NextEditDisplayState.JumpShown);
    }

    /*
     * Enabled aggressive block sorting
     */
    @RequiresEdt
    @RequiresWriteLock
    public final void handleTab() {
        block8: {
            NextEditDisplayState state2;
            block9: {
                ThreadingAssertions.assertEventDispatchThread();
                ThreadingAssertions.assertWriteAccess();
                if (!this.progress.isActive()) {
                    return;
                }
                state2 = this.displayManager.getDisplayState();
                if (Intrinsics.areEqual((Object)state2, (Object)NextEditDisplayState.Empty.INSTANCE)) break block8;
                if (Intrinsics.areEqual((Object)state2, (Object)NextEditDisplayState.Suppressed.INSTANCE)) {
                    LOG.error("Shortcut mustn't be handled when session is suppressed.");
                    return;
                }
                if (!(state2 instanceof NextEditDisplayState.StepShown)) break block9;
                NextEditStepController stepController = ((NextEditDisplayState.StepShown)state2).getStepController();
                NextEditDisplayParameters viewParameters = this.getCurrentDisplayParameters();
                switch (WhenMappings.$EnumSwitchMapping$2[stepController.getKeyHandlerType(this.editor, this.project).ordinal()]) {
                    case 1: {
                        if (!NextEditEditorUtil.INSTANCE.isCorrespondingLineVisible(this.editor, viewParameters.getStartOffset())) {
                            stepController.makeVisible(this.editor, this.project);
                            return;
                        }
                        this.displayManager.undisplay();
                        this.acceptStep(this.progress.currentStep(), stepController);
                        this.intrusionModeController.stepAccepted();
                        this.progress.advance();
                        break block8;
                    }
                    case 2: {
                        this.doHandleJump(((NextEditDisplayState.StepShown)state2).getStepController());
                        break block8;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            if (!(state2 instanceof NextEditDisplayState.JumpShown)) {
                throw new NoWhenBranchMatchedException();
            }
            this.doHandleJump(((NextEditDisplayState.JumpShown)state2).getStepController());
            this.reporter.onJumpAccepted();
            this.intrusionModeController.jumpAccepted();
        }
        this.displayCurrentStepOrJump(true);
        this.makeCurrentStepViewVisibleIfRendering();
    }

    public final void onDocumentEvent(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.ignoreDocumentChangesGuarder.isGuarded()) {
            this.autoDestroy.invoke((Object)NextEditSessionFinishType.DOCUMENT_CHANGE);
        }
    }

    public final void onCaretEvent(@NotNull CaretEventType type2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        if (!this.progress.isActive()) {
            return;
        }
        ThreadingAssertions.assertEventDispatchThread();
        switch (WhenMappings.$EnumSwitchMapping$3[type2.ordinal()]) {
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.autoDestroy.invoke((Object)NextEditSessionFinishType.INCOMPATIBLE_CARET_CHANGE);
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (this.ignoreDocumentChangesGuarder.isGuarded()) {
            return;
        }
        if (!this.intrusionModeController.caretMoved(this.getCurrentEditRange())) {
            this.autoDestroy.invoke((Object)NextEditSessionFinishType.INCOMPATIBLE_CARET_CHANGE);
        } else if (this.isActive()) {
            this.displayCurrentStepOrJump(false);
        }
    }

    @TestOnly
    @NotNull
    public final NextEditDisplayState getDisplayState() {
        return this.displayManager.getDisplayState();
    }

    private final void startSession() {
        if (this.progress.isActive()) {
            NextEditSessionProgress.Listener progressListener2 = new NextEditSessionProgress.Listener(this){
                final /* synthetic */ NextEditSession this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onRepresentationUpdate() {
                    NextEditSession.access$handleStepRepresentationUpdated(this.this$0);
                }
            };
            this.progress.addListener(progressListener2);
        }
        this.displayCurrentStepOrJump(true);
    }

    public final void reportSessionFinished(@NotNull NextEditSessionFinishType finishType) {
        Intrinsics.checkNotNullParameter((Object)finishType, (String)"finishType");
        this.reporter.onSessionFinished(finishType);
        LOG.trace(() -> NextEditSession.reportSessionFinished$lambda$1(finishType));
    }

    private final void handleStepRepresentationUpdated() {
        ThreadingAssertions.assertEventDispatchThread();
        NextEditDisplayState state2 = this.displayManager.getDisplayState();
        if (!(Intrinsics.areEqual((Object)state2, (Object)NextEditDisplayState.Empty.INSTANCE) || Intrinsics.areEqual((Object)state2, (Object)NextEditDisplayState.Suppressed.INSTANCE) || state2 instanceof NextEditDisplayState.JumpShown)) {
            if (state2 instanceof NextEditDisplayState.StepShown) {
                NextEditStepController stepController = ((NextEditDisplayState.StepShown)state2).getStepController();
                NextEditStepController.RepresentationUpdateHandler updateResult = stepController.onRepresentationUpdated(this.editor, this.project);
                switch (WhenMappings.$EnumSwitchMapping$4[updateResult.ordinal()]) {
                    case 1: {
                        this.displayCurrentStepOrJump(false);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                LOG.trace(() -> NextEditSession.handleStepRepresentationUpdated$lambda$2(stepController, updateResult));
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void doRefreshView() {
        NextEditDisplayState nextEditDisplayState = this.displayManager.getDisplayState();
        if (nextEditDisplayState instanceof NextEditDisplayState.StepShown) {
            this.displayCurrentStepOrJump(false);
        } else if (!(nextEditDisplayState instanceof NextEditDisplayState.JumpShown || Intrinsics.areEqual((Object)nextEditDisplayState, (Object)NextEditDisplayState.Empty.INSTANCE) || Intrinsics.areEqual((Object)nextEditDisplayState, (Object)NextEditDisplayState.Suppressed.INSTANCE))) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void doHandleJump(NextEditStepController stepController) {
        int currentOffset;
        int offsetToJump = stepController.getOffsetToJump(this.editor, this.project);
        if (offsetToJump != (currentOffset = this.editor.getCaretModel().getOffset())) {
            this.ignoreDocumentChangesGuarder.withGuard((DocumentChangeGuardPurpose)((Enum)DocumentChangeGuardPurpose.JUMPING_TO_STEP), () -> NextEditSession.doHandleJump$lambda$3(this, offsetToJump));
            UndoableCaretMoveAction undoableAction = new UndoableCaretMoveAction(this.editor, currentOffset, offsetToJump);
            UndoManager.getInstance((Project)this.project).undoableActionPerformed((UndoableAction)undoableAction);
        }
        this.displayManager.undisplay();
    }

    private final void displayCurrentStepOrJump(boolean notifyIntrusionController) {
        if (this.progress.isActive()) {
            boolean success;
            if (notifyIntrusionController) {
                this.intrusionModeController.beforeNewViewShown(this.getCurrentEditRange());
            }
            if (!(success = this.displayManager.display(this.getCurrentDisplayParameters(), this.intrusionModeController.getIntrusionMode(), this.reporter))) {
                LOG.error("Failed to display step/jump view in the active progress. Session will be destroyed.");
                this.autoDestroy.invoke((Object)NextEditSessionFinishType.COULD_NOT_SHOW);
            }
        } else if (this.progress.isCompleted()) {
            this.autoDestroy.invoke((Object)NextEditSessionFinishType.ACCEPTED);
        } else {
            this.autoDestroy.invoke((Object)NextEditSessionFinishType.INACTIVE);
        }
    }

    @RequiresEdt
    @RequiresWriteLock
    private final void acceptStep(NextEditSessionStep step, NextEditStepController controller2) {
        this.ignoreDocumentChangesGuarder.withGuard((DocumentChangeGuardPurpose)((Enum)DocumentChangeGuardPurpose.ACCEPTING_STEP), () -> NextEditSession.acceptStep$lambda$4(this, step, controller2));
    }

    @RequiresEdt
    private final void makeCurrentStepViewVisibleIfRendering() {
        block2: {
            NextEditStepController viewController;
            ThreadingAssertions.assertEventDispatchThread();
            if (!this.isActive()) break block2;
            NextEditDisplayState $this$asSafely$iv = this.displayManager.getDisplayState();
            boolean $i$f$asSafely = false;
            NextEditDisplayState nextEditDisplayState = $this$asSafely$iv;
            if (!(nextEditDisplayState instanceof NextEditDisplayState.StepShown)) {
                nextEditDisplayState = null;
            }
            NextEditDisplayState.StepShown stepShown = (NextEditDisplayState.StepShown)nextEditDisplayState;
            NextEditStepController nextEditStepController = viewController = stepShown != null ? stepShown.getStepController() : null;
            if (nextEditStepController != null) {
                nextEditStepController.makeVisible(this.editor, this.project);
            }
        }
    }

    private final void onDisplayStateChanged(NextEditDisplayState newState) {
        ThreadingAssertions.assertEventDispatchThread();
        NextEditDisplayState nextEditDisplayState = newState;
        if (nextEditDisplayState instanceof NextEditDisplayState.StepShown) {
            ((NextEditSessionListener)this.project.getMessageBus().syncPublisher(NextEditSessionListener.Companion.getTOPIC())).afterStepShown(this.editor, this);
        } else if (nextEditDisplayState instanceof NextEditDisplayState.Suppressed) {
            ((NextEditSessionListener)this.project.getMessageBus().syncPublisher(NextEditSessionListener.Companion.getTOPIC())).afterSessionSuppressed(this.editor, this);
        } else if (nextEditDisplayState instanceof NextEditDisplayState.JumpShown) {
            ((NextEditSessionListener)this.project.getMessageBus().syncPublisher(NextEditSessionListener.Companion.getTOPIC())).afterJumpShown(this.editor, this);
        } else if (!(nextEditDisplayState instanceof NextEditDisplayState.Empty)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.progress);
        Disposer.dispose((Disposable)this.displayManager);
        Disposer.dispose((Disposable)this.refreshManager);
    }

    private final NextEditDisplayParameters getCurrentDisplayParameters() {
        return new NextEditDisplayParameters(this.progress.currentStep(), this.editor, this.project);
    }

    private final TextRange getCurrentEditRange() {
        return this.progress.currentStep().getCorrespondingRange();
    }

    private static final boolean ignoreDocumentChangesGuarder$lambda$0() {
        return EDT.isCurrentThreadEdt();
    }

    private static final String reportSessionFinished$lambda$1(NextEditSessionFinishType $finishType) {
        return "Session finished with " + $finishType;
    }

    private static final String handleStepRepresentationUpdated$lambda$2(NextEditStepController $stepController, NextEditStepController.RepresentationUpdateHandler $updateResult) {
        return "Step controller " + $stepController.getClass().getSimpleName() + " handled representation update: " + $updateResult.name();
    }

    private static final Unit doHandleJump$lambda$3(NextEditSession this$0, int $offsetToJump) {
        this$0.editor.getCaretModel().moveToOffset($offsetToJump);
        return Unit.INSTANCE;
    }

    private static final Unit acceptStep$lambda$4(NextEditSession this$0, NextEditSessionStep $step, NextEditStepController $controller) {
        ExtKt.onAccepted(this$0.reporter, $step, this$0.editor);
        $controller.accept(this$0.editor, this$0.project);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$handleStepRepresentationUpdated(NextEditSession $this) {
        $this.handleStepRepresentationUpdated();
    }

    public static final /* synthetic */ void access$onDisplayStateChanged(NextEditSession $this, NextEditDisplayState newState) {
        $this.onDisplayStateChanged(newState);
    }

    public static final /* synthetic */ void access$doRefreshView(NextEditSession $this) {
        $this.doRefreshView();
    }

    static {
        Companion $this$thisNextEditLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisNextEditLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = new MLCompletionLogger(logger, MLCompletionLogger.FeatureType.NextEdit);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/nextEdits/session/NextEditSession$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger;", "intellij.ml.llm.nextEdits"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;

        static {
            int[] nArray = new int[NextEditStepController.SuppressHandlerType.values().length];
            try {
                nArray[NextEditStepController.SuppressHandlerType.SUPPRESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditStepController.SuppressHandlerType.RERENDER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditStepController.SuppressHandlerType.DO_NOTHING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SuppressSessionGuardPurpose.values().length];
            try {
                nArray[SuppressSessionGuardPurpose.INLINE_COMPLETION_COMPUTING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SuppressSessionGuardPurpose.INLINE_COMPLETION_SHOWING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SuppressSessionGuardPurpose.LOOKUP_WINDOW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[NextEditStepController.KeyHandlerType.values().length];
            try {
                nArray[NextEditStepController.KeyHandlerType.ACCEPT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditStepController.KeyHandlerType.JUMP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[CaretEventType.values().length];
            try {
                nArray[CaretEventType.MOVEMENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CaretEventType.CARET_REMOVED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CaretEventType.CARET_ADDED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[NextEditStepController.RepresentationUpdateHandler.values().length];
            try {
                nArray[NextEditStepController.RepresentationUpdateHandler.RERENDER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditStepController.RepresentationUpdateHandler.PROCESSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditStepController.RepresentationUpdateHandler.DO_NOTHING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$4 = nArray;
        }
    }
}

