/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.settings;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.gdpr.DataSharingSettingsChangeListener;
import com.intellij.ml.inline.completion.NightlySupport;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionLogger;
import com.intellij.ml.llm.core.license.AiSubscriptionPlan;
import com.intellij.ml.llm.grazie.auth.GrazieAuthFacade;
import com.intellij.ml.llm.grazie.auth.GrazieAuthState;
import com.intellij.ml.llm.nextEdits.settings.NextEditSettings;
import com.intellij.ml.llm.nextEdits.settings.NextEditSettingsController;
import com.intellij.ml.llm.nextEdits.settings.NextEditSettingsControllerKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.util.coroutines.flow.FlowKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0017\u001a\u00020\u0007H\u0002J\f\u0010\u0018\u001a\u00020\u0007*\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u0007*\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\r\u0010\fR!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000f\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/llm/nextEdits/settings/NextEditSettingsController;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "isEnabled", "", "()Z", "dataSharingEnabled", "Lkotlinx/coroutines/flow/StateFlow;", "getDataSharingEnabled", "()Lkotlinx/coroutines/flow/StateFlow;", "isLicenseApplicable", "isLicenseApplicable$delegate", "Lkotlin/Lazy;", "tryEnableOrError", "", "mutableFusState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "getMutableFusState", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "mutableFusState$delegate", "updateAndReturnEnabledState", "isApplicableLicense", "Lcom/intellij/ml/llm/grazie/auth/GrazieAuthState$Authenticated;", "isJetBrainsEnterprise", "Companion", "intellij.ml.llm.nextEdits"})
@SourceDebugExtension(value={"SMAP\nNextEditSettingsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditSettingsController.kt\ncom/intellij/ml/llm/nextEdits/settings/NextEditSettingsController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/DiagnosticLoggersKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,129:1\n1#2:130\n42#3:131\n14#4:132\n*S KotlinDebug\n*F\n+ 1 NextEditSettingsController.kt\ncom/intellij/ml/llm/nextEdits/settings/NextEditSettingsController\n*L\n124#1:131\n124#1:132\n*E\n"})
public final class NextEditSettingsController {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Lazy isLicenseApplicable$delegate;
    @NotNull
    private final Lazy mutableFusState$delegate;
    @NotNull
    private static final MLCompletionLogger LOG;

    public NextEditSettingsController(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
        this.isLicenseApplicable$delegate = LazyKt.lazy(() -> NextEditSettingsController.isLicenseApplicable_delegate$lambda$1(this));
        this.mutableFusState$delegate = LazyKt.lazy(NextEditSettingsController::mutableFusState_delegate$lambda$3);
        this.updateAndReturnEnabledState();
        DataSharingSettingsChangeListener listener2 = new DataSharingSettingsChangeListener(this){
            final /* synthetic */ NextEditSettingsController this$0;
            {
                this.this$0 = $receiver;
            }

            public void consentWritten() {
                ApplicationKt.getApplication().invokeLater(() -> listener.1.consentWritten$lambda$0(this.this$0));
            }

            private static final void consentWritten$lambda$0(NextEditSettingsController this$0) {
                NextEditSettingsController.access$getMutableFusState(this$0).setValue((Object)NextEditSettingsControllerKt.access$computeFusState());
            }
        };
        ApplicationKt.getApplication().getMessageBus().connect(this.scope).subscribe(DataSharingSettingsChangeListener.TOPIC, (Object)listener2);
    }

    public final boolean isEnabled() {
        return !NextEditSettingsControllerKt.isNextEditGloballyDisabled() && this.updateAndReturnEnabledState();
    }

    @NotNull
    public final StateFlow<Boolean> getDataSharingEnabled() {
        return (StateFlow)this.getMutableFusState();
    }

    @NotNull
    public final StateFlow<Boolean> isLicenseApplicable() {
        Lazy lazy = this.isLicenseApplicable$delegate;
        return (StateFlow)lazy.getValue();
    }

    public final void tryEnableOrError() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isEnabled()) {
            return;
        }
        NextEditSettings.Companion.getInstance().getState().setEnabled(true);
        if (!this.isEnabled()) {
            GrazieAuthState it = (GrazieAuthState)GrazieAuthFacade.Companion.getInstance().getAuthState().getValue();
            MLCompletionLogger mLCompletionLogger = LOG;
            boolean bl = false;
            GrazieAuthState.Authenticated authenticated = it instanceof GrazieAuthState.Authenticated ? (GrazieAuthState.Authenticated)it : null;
            mLCompletionLogger.error(StringsKt.trimIndent((String)("\n          Failed to enable Next Edit Suggestions:\n            License=" + (AiSubscriptionPlan)(authenticated != null ? authenticated.getPlan() : null) + "\n            FUS state=" + NextEditSettingsControllerKt.access$computeFusState() + "\n            Disabled globally=" + NextEditSettingsControllerKt.isNextEditGloballyDisabled() + "\n            Settings=" + NextEditSettings.Companion.getInstance().getState() + "\n        ")));
            NextEditSettings.Companion.getInstance().getState().setEnabled(false);
        }
    }

    private final MutableStateFlow<Boolean> getMutableFusState() {
        Lazy lazy = this.mutableFusState$delegate;
        return (MutableStateFlow)lazy.getValue();
    }

    private final boolean updateAndReturnEnabledState() {
        NextEditSettings.State nextEditState = NextEditSettings.Companion.getInstance().getState();
        boolean fusCurrentlyEnabled = NextEditSettingsControllerKt.access$computeFusState();
        if (!fusCurrentlyEnabled) {
            nextEditState.setEnabled(false);
        }
        return nextEditState.getEnabled() && (Boolean)this.isLicenseApplicable().getValue() != false;
    }

    private final boolean isApplicableLicense(GrazieAuthState.Authenticated $this$isApplicableLicense) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$isApplicableLicense.getPlan().ordinal()]) {
            case 1 -> true;
            case 2 -> true;
            case 3 -> false;
            case 4 -> this.isJetBrainsEnterprise($this$isApplicableLicense);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean isJetBrainsEnterprise(GrazieAuthState.Authenticated $this$isJetBrainsEnterprise) {
        if (NightlySupport.INSTANCE.isNightlyOrUnitTest()) {
            return true;
        }
        if (ApplicationKt.getApplication().isInternal()) {
            return true;
        }
        return StringsKt.contains$default((CharSequence)$this$isJetBrainsEnterprise.getAuthContext().getApiUrl-W67EvMo(), (CharSequence)"tbe.labs.jb.gg", (boolean)false, (int)2, null);
    }

    private static final boolean isLicenseApplicable_delegate$lambda$1$lambda$0(NextEditSettingsController this$0, GrazieAuthState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof GrazieAuthState.Authenticated && this$0.isApplicableLicense((GrazieAuthState.Authenticated)it);
    }

    private static final StateFlow isLicenseApplicable_delegate$lambda$1(NextEditSettingsController this$0) {
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            return (StateFlow)StateFlowKt.MutableStateFlow((Object)true);
        }
        return FlowKt.mapStateIn$default((StateFlow)GrazieAuthFacade.Companion.getInstance().getAuthState(), (CoroutineScope)this$0.scope, null, arg_0 -> NextEditSettingsController.isLicenseApplicable_delegate$lambda$1$lambda$0(this$0, arg_0), (int)2, null);
    }

    private static final MutableStateFlow mutableFusState_delegate$lambda$3() {
        return StateFlowKt.MutableStateFlow((Object)NextEditSettingsControllerKt.access$computeFusState());
    }

    public static final /* synthetic */ MutableStateFlow access$getMutableFusState(NextEditSettingsController $this) {
        return $this.getMutableFusState();
    }

    static {
        Companion $this$thisNextEditLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisNextEditLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = new MLCompletionLogger(logger, MLCompletionLogger.FeatureType.NextEdit);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/nextEdits/settings/NextEditSettingsController$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger;", "getInstance", "Lcom/intellij/ml/llm/nextEdits/settings/NextEditSettingsController;", "intellij.ml.llm.nextEdits"})
    @SourceDebugExtension(value={"SMAP\nNextEditSettingsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditSettingsController.kt\ncom/intellij/ml/llm/nextEdits/settings/NextEditSettingsController$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,129:1\n40#2,3:130\n*S KotlinDebug\n*F\n+ 1 NextEditSettingsController.kt\ncom/intellij/ml/llm/nextEdits/settings/NextEditSettingsController$Companion\n*L\n126#1:130,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NextEditSettingsController getInstance() {
            boolean $i$f$service = false;
            Class<NextEditSettingsController> serviceClass$iv = NextEditSettingsController.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (NextEditSettingsController)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AiSubscriptionPlan.values().length];
            try {
                nArray[AiSubscriptionPlan.LITE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiSubscriptionPlan.PRO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiSubscriptionPlan.FREE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiSubscriptionPlan.ENTERPRISE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

