/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.ui.diff;

import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionLogger;
import com.intellij.ml.llm.nextEdits.editor.NextEditRenderingCustomizer;
import com.intellij.ml.llm.nextEdits.ui.inlay.NextEditInlineShortcutInlaysKt;
import com.intellij.ml.llm.nextEdits.ui.inlay.NextEditShortcutHint;
import com.intellij.ml.llm.nextEdits.ui.util.NextEditEditorUtil;
import com.intellij.ml.llm.nextEdits.ui.util.NextEditRenderingUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\b\u0007\u0018\u0000 &2\u00020\u0001:\u0003$%&B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0013H\u0002J\b\u0010\u0019\u001a\u00020\u0017H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\rH\u0002J\b\u0010\u001e\u001a\u00020\u0013H\u0016J \u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0001H\u0002J \u0010#\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0001H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/ml/llm/nextEdits/ui/diff/NextEditJumpView;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "editRange", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/util/TextRange;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getEditRange", "()Lcom/intellij/openapi/util/TextRange;", "currentLine", "", "editStartLine", "editEndLine", "hint", "Lcom/intellij/ml/llm/nextEdits/ui/diff/NextEditJumpView$ShownHint;", "show", "", "rerenderHintsIfNeeded", "renderHint", "placement", "Lcom/intellij/ml/llm/nextEdits/ui/diff/NextEditJumpView$HintPlacement;", "disposeHint", "getExpectedHintPlacement", "isEditRangeFirstLineWithinViewPort", "", "getActualOffsetToRenderHint", "initialOffset", "dispose", "highlightLines", "startOffset", "endOffset", "disposable", "highlightLineNumbersArea", "HintPlacement", "ShownHint", "Companion", "intellij.ml.llm.nextEdits"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNextEditJumpView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditJumpView.kt\ncom/intellij/ml/llm/nextEdits/ui/diff/NextEditJumpView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/DiagnosticLoggersKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,200:1\n1#2:201\n42#3:202\n14#4:203\n*S KotlinDebug\n*F\n+ 1 NextEditJumpView.kt\ncom/intellij/ml/llm/nextEdits/ui/diff/NextEditJumpView\n*L\n197#1:202\n197#1:203\n*E\n"})
public final class NextEditJumpView
implements Disposable {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Editor editor;
    @NotNull
    private final TextRange editRange;
    private final int currentLine;
    private final int editStartLine;
    private final int editEndLine;
    @Nullable
    private ShownHint hint;
    @NotNull
    private static final MLCompletionLogger LOG;

    public NextEditJumpView(@NotNull Editor editor2, @NotNull TextRange editRange) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)editRange, (String)"editRange");
        this.editor = editor2;
        this.editRange = editRange;
        this.currentLine = this.editor.getDocument().getLineNumber(this.editor.getCaretModel().getOffset());
        this.editStartLine = this.editor.getDocument().getLineNumber(this.editRange.getStartOffset());
        this.editEndLine = this.editor.getDocument().getLineNumber(Math.max(this.editRange.getEndOffset() - 1, this.editRange.getStartOffset()));
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final TextRange getEditRange() {
        return this.editRange;
    }

    public final void show() {
        if (this.hint != null) {
            LOG.error("the jump indicator is already shown.");
            return;
        }
        this.rerenderHintsIfNeeded();
        int startOffset = this.editRange.getStartOffset();
        int endOffset = Math.max(this.editRange.getEndOffset() - 1, this.editRange.getStartOffset());
        this.highlightLines(startOffset, endOffset, this);
        this.highlightLineNumbersArea(startOffset, endOffset, this);
        VisibleAreaListener visibleAreaListener = arg_0 -> NextEditJumpView.show$lambda$0(this, arg_0);
        this.editor.getScrollingModel().addVisibleAreaListener(visibleAreaListener, (Disposable)this);
    }

    private final void rerenderHintsIfNeeded() {
        HintPlacement currentPlacement = this.getExpectedHintPlacement();
        ShownHint shownHint = this.hint;
        if ((shownHint != null ? shownHint.getPlacement() : null) != currentPlacement) {
            this.renderHint(currentPlacement);
        }
    }

    private final void renderHint(HintPlacement placement) {
        this.disposeHint();
        int logicalOffset = switch (WhenMappings.$EnumSwitchMapping$0[placement.ordinal()]) {
            case 1 -> this.editor.getCaretModel().getOffset();
            case 2 -> this.editRange.getStartOffset();
            default -> throw new NoWhenBranchMatchedException();
        };
        int actualOffset = this.getActualOffsetToRenderHint(logicalOffset);
        if (this.editor.getFoldingModel().isOffsetCollapsed(actualOffset)) {
            actualOffset = this.getActualOffsetToRenderHint(this.editor.getCaretModel().getOffset());
        }
        List<Inlay<?>> inlays = NextEditInlineShortcutInlaysKt.renderShortcutHint(this.editor, actualOffset, NextEditShortcutHint.Review.INSTANCE);
        this.hint = new ShownHint(placement, inlays);
    }

    private final void disposeHint() {
        ShownHint shownHint = this.hint;
        if (shownHint != null) {
            ShownHint it = shownHint;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.hint = null;
    }

    private final HintPlacement getExpectedHintPlacement() {
        int n = this.editStartLine;
        int n2 = this.editEndLine;
        int n3 = this.currentLine;
        boolean bl = n <= n3 ? n3 <= n2 : false;
        if (bl) {
            return HintPlacement.OnFirstEditRangeLine;
        }
        return this.isEditRangeFirstLineWithinViewPort() ? HintPlacement.OnFirstEditRangeLine : HintPlacement.OnCurrentLine;
    }

    private final boolean isEditRangeFirstLineWithinViewPort() {
        return NextEditEditorUtil.INSTANCE.isCorrespondingLineVisible(this.editor, this.editRange.getStartOffset());
    }

    private final int getActualOffsetToRenderHint(int initialOffset) {
        int visualLine = this.editor.offsetToVisualLine(initialOffset, true);
        int lastVisualLineColumn = EditorUtil.getLastVisualLineColumnNumber((Editor)this.editor, (int)visualLine);
        VisualPosition visualLineEndPosition = new VisualPosition(visualLine, lastVisualLineColumn, false);
        return this.editor.visualPositionToOffset(visualLineEndPosition);
    }

    public void dispose() {
        this.disposeHint();
    }

    private final void highlightLines(int startOffset, int endOffset, Disposable disposable) {
        RangeHighlighter rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 30000, NextEditRenderingUtils.INSTANCE.getLineToEditMarkerAttributesForLines(this.editor), HighlighterTargetArea.LINES_IN_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        RangeHighlighter highlighter = rangeHighlighter;
        DisposerUtilKt.whenDisposed((Disposable)disposable, () -> NextEditJumpView.highlightLines$lambda$2(this, highlighter));
    }

    private final void highlightLineNumbersArea(int startOffset, int endOffset, Disposable disposable) {
        RangeHighlighter rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(this.getActualOffsetToRenderHint(startOffset), this.getActualOffsetToRenderHint(endOffset), 1000, null, HighlighterTargetArea.LINES_IN_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        RangeHighlighter highlighter = rangeHighlighter;
        Color lineNumbersAreaColor = NextEditRenderingUtils.INSTANCE.getLineToEditMarkerAttributesForLineNumbersArea(this.editor).getBackgroundColor();
        Color linesColor = NextEditRenderingUtils.INSTANCE.getLineToEditMarkerAttributesForLines(this.editor).getBackgroundColor();
        NextEditRenderingCustomizer renderingCustomizer = NextEditRenderingCustomizer.Companion.getOrDefault(this.editor);
        highlighter.setLineMarkerRenderer((LineMarkerRenderer)new LineMarkerRendererEx(renderingCustomizer, lineNumbersAreaColor, linesColor){
            final /* synthetic */ NextEditRenderingCustomizer $renderingCustomizer;
            final /* synthetic */ Color $lineNumbersAreaColor;
            final /* synthetic */ Color $linesColor;
            {
                this.$renderingCustomizer = $renderingCustomizer;
                this.$lineNumbersAreaColor = $lineNumbersAreaColor;
                this.$linesColor = $linesColor;
            }

            public LineMarkerRendererEx.Position getPosition() {
                return LineMarkerRendererEx.Position.CUSTOM;
            }

            public void paint(Editor editor2, Graphics g, Rectangle r) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                if (!(editor2 instanceof EditorEx) || !(g instanceof Graphics2D)) {
                    return;
                }
                int baseWidth = Math.min(r.width, Math.max(this.$renderingCustomizer.getGutterAreaOffsetToHighlight((EditorEx)editor2) - r.x, 0));
                ((Graphics2D)g).setColor(this.$lineNumbersAreaColor);
                ((Graphics2D)g).fill(new Rectangle(r.x, r.y, baseWidth, r.height));
                ((Graphics2D)g).setColor(this.$linesColor);
                if (baseWidth != r.width) {
                    ((Graphics2D)g).fill(new Rectangle(r.x + baseWidth, r.y, r.width - baseWidth, r.height));
                }
            }
        });
        DisposerUtilKt.whenDisposed((Disposable)disposable, () -> NextEditJumpView.highlightLineNumbersArea$lambda$3(this, highlighter));
    }

    private static final void show$lambda$0(NextEditJumpView this$0, VisibleAreaEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)event.getOldRectangle(), (Object)event.getNewRectangle())) {
            return;
        }
        this$0.rerenderHintsIfNeeded();
    }

    private static final Unit highlightLines$lambda$2(NextEditJumpView this$0, RangeHighlighter $highlighter) {
        this$0.editor.getMarkupModel().removeHighlighter($highlighter);
        return Unit.INSTANCE;
    }

    private static final Unit highlightLineNumbersArea$lambda$3(NextEditJumpView this$0, RangeHighlighter $highlighter) {
        this$0.editor.getMarkupModel().removeHighlighter($highlighter);
        return Unit.INSTANCE;
    }

    static {
        Companion $this$thisNextEditLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisNextEditLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = new MLCompletionLogger(logger, MLCompletionLogger.FeatureType.NextEdit);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/nextEdits/ui/diff/NextEditJumpView$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger;", "intellij.ml.llm.nextEdits"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/nextEdits/ui/diff/NextEditJumpView$HintPlacement;", "", "<init>", "(Ljava/lang/String;I)V", "OnCurrentLine", "OnFirstEditRangeLine", "intellij.ml.llm.nextEdits"})
    private static final class HintPlacement
    extends Enum<HintPlacement> {
        public static final /* enum */ HintPlacement OnCurrentLine = new HintPlacement();
        public static final /* enum */ HintPlacement OnFirstEditRangeLine = new HintPlacement();
        private static final /* synthetic */ HintPlacement[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static HintPlacement[] values() {
            return (HintPlacement[])$VALUES.clone();
        }

        public static HintPlacement valueOf(String value2) {
            return Enum.valueOf(HintPlacement.class, value2);
        }

        @NotNull
        public static EnumEntries<HintPlacement> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = hintPlacementArray = new HintPlacement[]{HintPlacement.OnCurrentLine, HintPlacement.OnFirstEditRangeLine};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/nextEdits/ui/diff/NextEditJumpView$ShownHint;", "Lcom/intellij/openapi/Disposable;", "placement", "Lcom/intellij/ml/llm/nextEdits/ui/diff/NextEditJumpView$HintPlacement;", "inlays", "", "Lcom/intellij/openapi/editor/Inlay;", "<init>", "(Lcom/intellij/ml/llm/nextEdits/ui/diff/NextEditJumpView$HintPlacement;Ljava/util/List;)V", "getPlacement", "()Lcom/intellij/ml/llm/nextEdits/ui/diff/NextEditJumpView$HintPlacement;", "getInlays", "()Ljava/util/List;", "dispose", "", "intellij.ml.llm.nextEdits"})
    @SourceDebugExtension(value={"SMAP\nNextEditJumpView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditJumpView.kt\ncom/intellij/ml/llm/nextEdits/ui/diff/NextEditJumpView$ShownHint\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n1869#2,2:201\n*S KotlinDebug\n*F\n+ 1 NextEditJumpView.kt\ncom/intellij/ml/llm/nextEdits/ui/diff/NextEditJumpView$ShownHint\n*L\n134#1:201,2\n*E\n"})
    private static final class ShownHint
    implements Disposable {
        @NotNull
        private final HintPlacement placement;
        @NotNull
        private final List<Inlay<?>> inlays;

        public ShownHint(@NotNull HintPlacement placement, @NotNull List<? extends Inlay<?>> inlays) {
            Intrinsics.checkNotNullParameter((Object)((Object)placement), (String)"placement");
            Intrinsics.checkNotNullParameter(inlays, (String)"inlays");
            this.placement = placement;
            this.inlays = inlays;
        }

        @NotNull
        public final HintPlacement getPlacement() {
            return this.placement;
        }

        @NotNull
        public final List<Inlay<?>> getInlays() {
            return this.inlays;
        }

        public void dispose() {
            Iterable $this$forEach$iv = this.inlays;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Inlay it = (Inlay)element$iv;
                boolean bl = false;
                Disposer.dispose((Disposable)((Disposable)it));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HintPlacement.values().length];
            try {
                nArray[HintPlacement.OnCurrentLine.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HintPlacement.OnFirstEditRangeLine.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

