/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.php.test.generation;

import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPrompt;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPromptService;
import com.intellij.ml.llm.php.privacy.ExtensionsKt;
import com.intellij.ml.llm.php.test.generation.PhpLLMGenerateTestsSupportKt;
import com.intellij.ml.llm.php.test.generation.PhpTestsContextProvider;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.extensions.SharedExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.psi.PsiNamedElementPrivacyWrapper;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConcatenateBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.phpunit.codeGeneration.PhpNewTestDialog;
import com.jetbrains.php.phpunit.codeGeneration.PhpTestDirectoryByPsrProviderKt;
import com.jetbrains.php.roots.PhpDirectoryByPsrProvider;
import com.jetbrains.php.testFramework.PhpTestCreateInfo;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J.\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0003J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0016\u0010\u001c\u001a\u00020\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\u0018\u0010 \u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010!\u001a\u00020\"*\u00020\"2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0005H\u0002R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/ml/llm/php/test/generation/PhpTestsPromptGenerator;", "", "<init>", "()V", "createPrompt", "Lcom/intellij/ml/llm/privacy/PSString;", "method", "Lcom/jetbrains/php/lang/psi/elements/Method;", "testFilePath", "Ljava/nio/file/Path;", "defaultGuideline", "PEST_ENGINE_GUIDELINE", "PHPUNIT_ENGINE_GUIDELINE", "testEngineGuideline", "testEngine", "Lcom/intellij/ml/llm/php/test/generation/PhpTestsContextProvider$TestEngine;", "testEnginePromptTitle", "engine", "methodName", "className", "getTestNamespace", "testDirectoryPath", "", "findExistingParent", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "getNamespaceGuideline", "namespace", "createRelatedClassesDescription", "relatedClasses", "", "Lcom/jetbrains/php/lang/psi/elements/PhpClass;", "getTargetNamespace", "appendGuideline", "Lcom/intellij/ml/llm/privacy/trustedStringBuilders/ConcatenateBuilder;", "namespaceGuideline", "intellij.ml.llm.php"})
@SourceDebugExtension(value={"SMAP\nPhpTestsPromptGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpTestsPromptGenerator.kt\ncom/intellij/ml/llm/php/test/generation/PhpTestsPromptGenerator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n608#2:162\n1#3:163\n*S KotlinDebug\n*F\n+ 1 PhpTestsPromptGenerator.kt\ncom/intellij/ml/llm/php/test/generation/PhpTestsPromptGenerator\n*L\n116#1:162\n*E\n"})
public final class PhpTestsPromptGenerator {
    @NotNull
    public static final PhpTestsPromptGenerator INSTANCE = new PhpTestsPromptGenerator();
    @NotNull
    private static final PSString defaultGuideline = ConstantsKt.getPrivacyConst((String)"\n  - Test file should be complete and compilable, without need for further actions.\n  - Ensure that each test focuses on a single use case to maintain clarity and readability.\n  - PHP test file MUST starts with php opening tag <?php\n").trimIndent();
    @NotNull
    private static final PSString PEST_ENGINE_GUIDELINE = ConstantsKt.getPrivacyConst((String)"\n  - Make sure to use Pest assertions (expect, toBe, etc.). Make sure you are not adding unnecessary PHPUnit imports.\n  - Try to make the test file as small as possible. Don't add unnecessary code.\n  - Use the \"test\" function to describe a test case.\n  - Do not import any functions from the Pest namespace or the Pest namespace itself.");
    @NotNull
    private static final PSString PHPUNIT_ENGINE_GUIDELINE = ConstantsKt.getPrivacyConst((String)"\n  - Write a description of the class and the method being tested.");

    private PhpTestsPromptGenerator() {
    }

    @NotNull
    public final PSString createPrompt(@NotNull Method method, @NotNull Path testFilePath2) {
        PSString pSString;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)testFilePath2, (String)"testFilePath");
        Collection<PhpClass> relatedClasses = PhpTestsContextProvider.INSTANCE.findRelatedClassesAndCleanUp(method);
        PSString relatedClassesDesc = this.createRelatedClassesDescription(relatedClasses);
        PhpClass containingClassContext = PhpTestsContextProvider.INSTANCE.prepareContainingClassContext(method);
        PSString mainClassDescription = PhpTestsContextProvider.INSTANCE.createDescription(containingClassContext);
        Object object = method.getContainingClass();
        PSString className = object != null && (object = ExtensionsKt.getPrivacySafe((PhpClass)object)) != null ? ((PsiNamedElementPrivacyWrapper)((Object)object)).getName() : null;
        PSString methodName = ExtensionsKt.getPrivacySafe((PhpNamedElement)method).getName();
        PSString targetNamespace = this.getTargetNamespace(method, testFilePath2);
        VirtualFileSystem virtualFileSystem = method.getContainingFile().getVirtualFile().getFileSystem();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"getFileSystem(...)");
        VirtualFileSystem fileSystem = virtualFileSystem;
        boolean isExistedTestFile = fileSystem.findFileByPath(((Object)testFilePath2).toString()) != null;
        PhpTestsContextProvider.TestEngine testEngine = isExistedTestFile ? null : PhpTestsContextProvider.INSTANCE.findPreferedTestEngine(method);
        PSString promptTitle = this.testEnginePromptTitle(testEngine, testFilePath2, methodName, className);
        PSString testEngineGuideline = this.testEngineGuideline(testEngine, testFilePath2);
        Project project2 = method.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        AISystemLibraryPrompt aISystemLibraryPrompt = AISystemLibraryPromptService.Companion.getInstance(project2).findPrompt("llm.testGeneration.php");
        PSString customPrompt = aISystemLibraryPrompt != null && (pSString = aISystemLibraryPrompt.getContent()) != null ? pSString : ConstantsKt.getEMPTY();
        return PSStringKt.buildStringPrivacySafe(arg_0 -> PhpTestsPromptGenerator.createPrompt$lambda$0(promptTitle, testEngineGuideline, targetNamespace, customPrompt, mainClassDescription, relatedClassesDesc, arg_0));
    }

    private final PSString testEngineGuideline(PhpTestsContextProvider.TestEngine testEngine, Path testFilePath2) {
        PSStringConvertible[] pSStringConvertibleArray;
        PhpTestsContextProvider.TestEngine testEngine2;
        block8: {
            block7: {
                testEngine2 = testEngine;
                if (testEngine2 == null) break block7;
                PhpTestsContextProvider.TestEngine it = testEngine2;
                boolean bl = false;
                PSStringConvertible[] pSStringConvertibleArray2 = new PSStringConvertible[]{SharedExtensionsKtKt.getPrivacySafe((Enum)testEngine).getName()};
                PSString pSString = ConstantsKt.getPrivacyConst((String)"- Use %s as a testing framework.").format(pSStringConvertibleArray2);
                testEngine2 = pSString;
                if (pSString != null) break block8;
            }
            pSStringConvertibleArray = new PSStringConvertible[]{SharedExtensionsKtKt.getPrivacySafe((Path)testFilePath2).getName()};
            testEngine2 = ConstantsKt.getPrivacyConst((String)"- Use the same testing framework that is already used in `%s` file.").format(pSStringConvertibleArray);
        }
        PhpTestsContextProvider.TestEngine frameworkIntro = testEngine2;
        PhpTestsContextProvider.TestEngine testEngine3 = testEngine;
        PSString mainPart = switch (testEngine3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[testEngine3.ordinal()]) {
            case 1, 2 -> PHPUNIT_ENGINE_GUIDELINE.trimIndent();
            case 3 -> PEST_ENGINE_GUIDELINE.trimIndent();
            case -1 -> {
                PSStringConvertible[] var7_5 = new PSStringConvertible[]{PHPUNIT_ENGINE_GUIDELINE.trimStart(), SharedExtensionsKtKt.getPrivacySafe((Path)testFilePath2).getNameWithoutExtension(), PEST_ENGINE_GUIDELINE.trimStart(), SharedExtensionsKtKt.getPrivacySafe((Path)testFilePath2).getName()};
                yield ConstantsKt.getPrivacyConst((String)"            \nIf the testing framework is PHPUnit:\n  %s\n  - Put new test methods inside the `%s` class.\"\nIf the testing framework is Pest:\n  %s\n  - Put new test function calls inside the `%s` file.\"\n      ").format(var7_5).trim();
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        pSStringConvertibleArray = new PSStringConvertible[]{frameworkIntro, mainPart};
        return ConstantsKt.getPrivacyConst((String)"\n%s\n%s\n    ").format(pSStringConvertibleArray).trim();
    }

    private final PSString testEnginePromptTitle(PhpTestsContextProvider.TestEngine engine, Path testFilePath2, PSString methodName, PSString className) {
        PSString pSString;
        if (engine != null) {
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{SharedExtensionsKtKt.getPrivacySafe((Path)testFilePath2).getNameWithoutExtension(), methodName, className};
            pSString = ConstantsKt.getPrivacyConst((String)"Write `%s` tests for the `%s` method in the `%s` class.").format(pSStringConvertibleArray);
        } else {
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{methodName, className};
            pSString = ConstantsKt.getPrivacyConst((String)"Write tests for the `%s` method in the `%s` class.").format(pSStringConvertibleArray);
        }
        return pSString;
    }

    @RequiresReadLock
    private final PSString getTestNamespace(Method method, String testDirectoryPath) {
        String sourceNamespace;
        PhpTestCreateInfo phpTestCreateInfo = PhpLLMGenerateTestsSupportKt.findTestCreateInfo(method);
        if (phpTestCreateInfo == null) {
            return null;
        }
        PhpTestCreateInfo testCreateInfo = phpTestCreateInfo;
        PhpClass phpClass = method.getContainingClass();
        if (phpClass == null) {
            return null;
        }
        PhpClass phpClass2 = phpClass;
        VirtualFile virtualFile2 = this.findExistingParent(testDirectoryPath);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile existedTestDirectory = virtualFile2;
        Project project2 = phpClass2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        PsiDirectory psiDirectory = phpClass2.getContainingFile().getParent();
        if (psiDirectory == null) {
            return null;
        }
        PsiDirectory sourceDir = psiDirectory;
        Sequence $this$sortedBy$iv = PhpTestDirectoryByPsrProviderKt.getSortedTestFolders((Project)project3, (PhpTestCreateInfo)testCreateInfo);
        boolean $i$f$sortedBy = false;
        SourceFolder sourceFolder = (SourceFolder)SequencesKt.firstOrNull((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SourceFolder it = (SourceFolder)a;
                boolean bl = false;
                String string = it.getPackagePrefix();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackagePrefix(...)");
                it = (SourceFolder)b;
                Comparable comparable = Boolean.valueOf(((CharSequence)string).length() == 0);
                bl = false;
                String string2 = it.getPackagePrefix();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPackagePrefix(...)");
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Boolean.valueOf(((CharSequence)string2).length() == 0));
            }
        }));
        if (sourceFolder == null) {
            return null;
        }
        SourceFolder testRootFolder = sourceFolder;
        String string = PhpDirectoryByPsrProvider.getFolderPrefix((SourceFolder)testRootFolder);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFolderPrefix(...)");
        String folderPrefix = string;
        String string2 = sourceNamespace = PhpLangUtil.toName((String)phpClass2.getNamespaceName());
        Intrinsics.checkNotNull((Object)string2);
        String string3 = testCreateInfo.getNamespaceWithoutPrefix(project3, sourceNamespace, string2, sourceDir.getVirtualFile());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getNamespaceWithoutPrefix(...)");
        String namespace2 = string3;
        String string4 = PhpNewTestDialog.getNamespaceWithTestPrefix((Project)project3, (String)folderPrefix, (PsiDirectory)sourceDir, (String)namespace2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getNamespaceWithTestPrefix(...)");
        String namespaceWithTestPrefix = string4;
        VirtualFile virtualFile3 = ProjectFileIndex.getInstance((Project)project3).getSourceRootForFile(existedTestDirectory);
        if (virtualFile3 == null) {
            return null;
        }
        VirtualFile testRoot = virtualFile3;
        return ExtensionsKt.getPrivacySafe(testCreateInfo).getTestNamespace(project3, testRoot, namespaceWithTestPrefix, sourceNamespace, testDirectoryPath);
    }

    private final VirtualFile findExistingParent(String path) {
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        VirtualFile directory = LocalFileSystem.getInstance().findFileByPath(path);
        VirtualFile virtualFile2 = directory;
        if (virtualFile2 == null) {
            String string = PathUtil.getParentPath((String)path);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParentPath(...)");
            virtualFile2 = this.findExistingParent(string);
        }
        return virtualFile2;
    }

    private final PSString getNamespaceGuideline(PSString namespace2) {
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{namespace2};
        return ConstantsKt.getPrivacyConst((String)"- Generated test class should be in namespace `%s`").format(pSStringConvertibleArray);
    }

    private final PSString createRelatedClassesDescription(Collection<? extends PhpClass> relatedClasses) {
        return PSStringKt.joinToString$default((Iterable)relatedClasses, (PrivacySafe)((PrivacySafe)ConstantsKt.getPrivacyConst((String)"\n\n")), null, null, (int)0, null, PhpTestsPromptGenerator::createRelatedClassesDescription$lambda$3, (int)30, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final PSString getTargetNamespace(Method method, Path testFilePath2) {
        PSString pSString;
        PSString pSString2 = this.getTestNamespace(method, ((Object)testFilePath2.getParent()).toString());
        if (pSString2 != null) {
            PSString pSString3;
            PSString pSString4;
            PSString it = pSString4 = pSString2;
            boolean bl = false;
            Object object = pSString3 = ((CharSequence)it).length() > 0 ? pSString4 : null;
            if (pSString3 != null) {
                PSString namespace2 = pSString3;
                boolean bl2 = false;
                pSString4 = INSTANCE.getNamespaceGuideline(namespace2);
                if (pSString4 != null) {
                    pSString = pSString4;
                    return pSString;
                }
            }
        }
        pSString = ConstantsKt.getPrivacyConst((String)"");
        return pSString;
    }

    private final ConcatenateBuilder appendGuideline(ConcatenateBuilder $this$appendGuideline, PSString testEngineGuideline, PSString namespaceGuideline) {
        ConcatenateBuilder $this$appendGuideline_u24lambda_u246 = $this$appendGuideline;
        boolean bl = false;
        $this$appendGuideline_u24lambda_u246.appendLine(ConstantsKt.getPrivacyConst((String)"Guideline:"));
        $this$appendGuideline_u24lambda_u246.appendLine(ConstantsKt.getPrivacyConst((String)"```"));
        $this$appendGuideline_u24lambda_u246.appendLine(defaultGuideline);
        $this$appendGuideline_u24lambda_u246.appendLine(testEngineGuideline);
        if (((CharSequence)namespaceGuideline).length() > 0) {
            $this$appendGuideline_u24lambda_u246.appendLine(namespaceGuideline);
        }
        return $this$appendGuideline_u24lambda_u246.appendLine(ConstantsKt.getPrivacyConst((String)"```"));
    }

    private static final Unit createPrompt$lambda$0(PSString $promptTitle, PSString $testEngineGuideline, PSString $targetNamespace, PSString $customPrompt, PSString $mainClassDescription, PSString $relatedClassesDesc, ConcatenateBuilder $this$buildStringPrivacySafe) {
        Intrinsics.checkNotNullParameter((Object)$this$buildStringPrivacySafe, (String)"$this$buildStringPrivacySafe");
        $this$buildStringPrivacySafe.appendLine($promptTitle);
        ConcatenateBuilder.appendLine$default((ConcatenateBuilder)$this$buildStringPrivacySafe, null, (int)1, null);
        INSTANCE.appendGuideline($this$buildStringPrivacySafe, $testEngineGuideline, $targetNamespace);
        if (((CharSequence)$customPrompt).length() > 0) {
            $this$buildStringPrivacySafe.appendLine($customPrompt);
        }
        $this$buildStringPrivacySafe.appendLine($mainClassDescription);
        $this$buildStringPrivacySafe.appendLine($relatedClassesDesc);
        return Unit.INSTANCE;
    }

    private static final PrivacySafe createRelatedClassesDescription$lambda$3(PhpClass it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (PrivacySafe)PhpTestsContextProvider.INSTANCE.createDescription(it);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PhpTestsContextProvider.TestEngine.values().length];
            try {
                nArray[PhpTestsContextProvider.TestEngine.PHPUnit.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhpTestsContextProvider.TestEngine.Codeception.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhpTestsContextProvider.TestEngine.Pest.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

