/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.privacy.extensions.psi;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExternalAiIgnoreAwarePrivacyWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/privacy/extensions/psi/PsiElementPrivacyWrapper;", "Lcom/intellij/ml/llm/privacy/extensions/ExternalAiIgnoreAwarePrivacyWrapper;", "obj", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "text", "Lcom/intellij/ml/llm/privacy/PSString;", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "dedentedText", "getDedentedText", "getDescription", "descriptionLocation", "Lcom/intellij/psi/ElementDescriptionLocation;", "intellij.ml.llm.privacy"})
@SourceDebugExtension(value={"SMAP\nPsiElementPrivacyWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiElementPrivacyWrapper.kt\ncom/intellij/ml/llm/privacy/extensions/psi/PsiElementPrivacyWrapper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,51:1\n24#2:52\n621#3,6:53\n*S KotlinDebug\n*F\n+ 1 PsiElementPrivacyWrapper.kt\ncom/intellij/ml/llm/privacy/extensions/psi/PsiElementPrivacyWrapper\n*L\n28#1:52\n39#1:53,6\n*E\n"})
public class PsiElementPrivacyWrapper
extends ExternalAiIgnoreAwarePrivacyWrapper {
    @NotNull
    private final PsiElement obj;
    @NotNull
    private final Project project;

    public PsiElementPrivacyWrapper(@NotNull PsiElement obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        this.obj = obj;
        Project project2 = this.obj.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        this.project = project2;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final PSString getText() {
        return this.redactingReadVia(this.obj, arg_0 -> PsiElementPrivacyWrapper._get_text_$lambda$0(this, arg_0)).toPSString();
    }

    @NotNull
    public final PSString getDedentedText() {
        return this.redactingReadVia(this.obj, arg_0 -> PsiElementPrivacyWrapper._get_dedentedText_$lambda$2(this, arg_0)).toPSString();
    }

    @NotNull
    public final PSString getDescription(@NotNull ElementDescriptionLocation descriptionLocation) {
        Intrinsics.checkNotNullParameter((Object)descriptionLocation, (String)"descriptionLocation");
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)this.obj, (ElementDescriptionLocation)descriptionLocation);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getElementDescription(...)");
        return this.promisedSafety(string);
    }

    private static final String _get_text_$lambda$0(PsiElementPrivacyWrapper this$0, PsiElement element2) {
        String string;
        PsiLanguageInjectionHost injectionHost;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (element2 instanceof PsiFile && (injectionHost = InjectedLanguageManager.getInstance((Project)((PsiFile)element2).getProject()).getInjectionHost(element2)) != null) {
            try {
                LiteralTextEscaper literalTextEscaper = injectionHost.createLiteralTextEscaper();
                Intrinsics.checkNotNullExpressionValue((Object)literalTextEscaper, (String)"createLiteralTextEscaper(...)");
                LiteralTextEscaper escaper = literalTextEscaper;
                TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)((PsiElement)injectionHost));
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
                TextRange textRange2 = textRange;
                StringBuilder builder = new StringBuilder();
                escaper.decode(textRange2, builder);
                String string2 = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                return string2;
            }
            catch (Exception e) {
                PsiElementPrivacyWrapper $this$thisLogger$iv = this$0;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(PsiElementPrivacyWrapper.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error((Throwable)e);
            }
        }
        if ((string = element2.getText()) == null) {
            string = "";
        }
        return string;
    }

    private static final String _get_dedentedText_$lambda$2(PsiElementPrivacyWrapper this$0, PsiElement it) {
        String string;
        block1: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string2 = this$0.obj.getContainingFile().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String string3 = string2;
            int n = 0;
            int n2 = this$0.obj.getTextRange().getStartOffset();
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            String $this$takeLastWhile$iv = string4;
            boolean $i$f$takeLastWhile = false;
            for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                char it2 = $this$takeLastWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (CharsKt.isWhitespace((char)it2) && it2 != '\n') continue;
                String string5 = $this$takeLastWhile$iv;
                int n3 = index$iv + 1;
                String string6 = string5.substring(n3);
                string = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                break block1;
            }
            string = string3;
        }
        String missingIndent = string;
        return StringsKt.trimIndent((String)(missingIndent + this$0.getText()));
    }
}

