/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.privacy.extensions.std;

import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExternalAiIgnoreAwarePrivacyWrapper;
import com.intellij.ml.llm.privacy.fileContentReaders.SourceFileBasedPrivacyReader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u000b2\b\b\u0002\u0010\u0014\u001a\u00020\u0015R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/privacy/extensions/std/FilePrivacyWrapper;", "Lcom/intellij/ml/llm/privacy/extensions/ExternalAiIgnoreAwarePrivacyWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "obj", "Ljava/io/File;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/io/File;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "name", "Lcom/intellij/ml/llm/privacy/PSString;", "getName", "()Lcom/intellij/ml/llm/privacy/PSString;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/Nullable;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "text", "charset", "Ljava/nio/charset/Charset;", "intellij.ml.llm.privacy"})
public final class FilePrivacyWrapper
extends ExternalAiIgnoreAwarePrivacyWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final File obj;
    @Nullable
    private final VirtualFile virtualFile;

    public FilePrivacyWrapper(@NotNull Project project2, @NotNull File obj) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        this.project = project2;
        this.obj = obj;
        this.virtualFile = LocalFileSystem.getInstance().findFileByIoFile(this.obj);
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final PSString getName() {
        String string = this.obj.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return this.promisedSafety(string);
    }

    @Nullable
    public final VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @NotNull
    public final PSString text(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return this.redactingReadVia(this.obj, new SourceFileBasedPrivacyReader<File, String>(this, charset){
            final /* synthetic */ FilePrivacyWrapper this$0;
            final /* synthetic */ Charset $charset;
            {
                this.this$0 = $receiver;
                this.$charset = $charset;
            }

            public SourceFileBasedPrivacyReader.SourceFileResult getSourceFile(File entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                return SourceFileBasedPrivacyReader.SourceFileResult.Companion.noSourceFileIfNull(this.this$0.getVirtualFile());
            }

            public String readContentsUnsafe(File entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                return FilesKt.readText((File)entity, (Charset)this.$charset);
            }
        }).toPSString();
    }

    public static /* synthetic */ PSString text$default(FilePrivacyWrapper filePrivacyWrapper, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return filePrivacyWrapper.text(charset);
    }
}

