/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.provider.openai;

import com.intellij.ml.llm.provider.openai.OpenAISettingsState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@State(name="OpenAISettings", storages={@Storage(value="llm.provider.openai.xml", roamingType=RoamingType.DISABLED, exportable=true)})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/provider/openai/OpenAISettingsManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/ml/llm/provider/openai/OpenAISettingsState;", "<init>", "()V", "state", "getState", "loadState", "", "value", "", "baseUrl", "getBaseUrl", "()Ljava/lang/String;", "setBaseUrl", "(Ljava/lang/String;)V", "", "isToolEnabled", "()Z", "setToolEnabled", "(Z)V", "intellij.ml.llm.provider.openai"})
public final class OpenAISettingsManager
implements PersistentStateComponent<OpenAISettingsState> {
    @NotNull
    private OpenAISettingsState state = new OpenAISettingsState();

    @NotNull
    public OpenAISettingsState getState() {
        return this.state;
    }

    public void loadState(@NotNull OpenAISettingsState state2) {
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        this.state = state2;
    }

    @NotNull
    public final String getBaseUrl() {
        String string = this.state.getBaseUrl();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final void setBaseUrl(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.state.setBaseUrl(((Object)StringsKt.trim((CharSequence)value2)).toString());
    }

    public final boolean isToolEnabled() {
        return Registry.Companion.is("llm.third.party.ai.providers.tools.enabled") && this.state.isToolEnabled();
    }

    public final void setToolEnabled(boolean value2) {
        this.state.setToolEnabled(value2);
    }
}

