/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.python;

import com.intellij.ml.llm.core.ContextInfo;
import com.intellij.ml.llm.core.LLMCodeCompletionUnderCommentSupport;
import com.intellij.ml.llm.python.context.PythonContextUtils;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.PyIndentUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/python/LLMPythonCodeCompletionUnderCommentSupport;", "Lcom/intellij/ml/llm/core/LLMCodeCompletionUnderCommentSupport;", "<init>", "()V", "getElementIndent", "", "element", "Lcom/intellij/psi/PsiElement;", "getEndCommentText", "getContextInfo", "Lcom/intellij/ml/llm/core/ContextInfo;", "comment", "Lcom/intellij/psi/PsiComment;", "getExampleText", "intellij.ml.llm.python"})
public final class LLMPythonCodeCompletionUnderCommentSupport
implements LLMCodeCompletionUnderCommentSupport {
    @NotNull
    public String getElementIndent(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        String string = PyIndentUtil.getElementIndent((PsiElement)element2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getElementIndent(...)");
        return string;
    }

    @NotNull
    public String getEndCommentText() {
        return "# end of the code completion";
    }

    @NotNull
    public ContextInfo getContextInfo(@NotNull PsiComment comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        PythonContextUtils.ContextInfo context2 = PythonContextUtils.getContextForElement$default(PythonContextUtils.INSTANCE, (PsiElement)comment, 0, 0, 6, null);
        return new ContextInfo((String)context2.getContext().unwrap(), (String)context2.getContext().unwrap(), "", context2.getIndent());
    }

    @NotNull
    public String getExampleText() {
        return "Q:\n```python\ndef foo():\n    x = 42 + 42\n    print(x)\n    # TODO: write me gcd algorithm here\n    # end of the code completion\n    return x + x\n```\nA:\n```python\ndef foo():\n    x = 42 + 42\n    print(x)\n    # TODO: write me gcd algorithm here\n    def gcd(a,b):\n        while(b):\n            a,b = b,a%b\n        return a\n    # end of the code completion\n    return x + x\n```\nQ:";
    }
}

