/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.python.intentions;

import com.intellij.lang.Language;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.LLMPromptsKt;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.core.settings.LLMProjectSettingsManager;
import com.intellij.ml.llm.intentions.conversion.FileConvertLanguageIntention;
import com.intellij.ml.llm.intentions.conversion.language.PasteConvertLanguage;
import com.intellij.ml.llm.intentions.conversion.language.PythonLang;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.ml.llm.python.PythonLLMBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PythonLanguage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/python/intentions/FileConvertJupyterToPythonIntention;", "Lcom/intellij/ml/llm/intentions/conversion/FileConvertLanguageIntention;", "targetLanguage", "Lcom/intellij/ml/llm/intentions/conversion/language/PasteConvertLanguage;", "<init>", "(Lcom/intellij/ml/llm/intentions/conversion/language/PasteConvertLanguage;)V", "getTargetLanguage", "()Lcom/intellij/ml/llm/intentions/conversion/language/PasteConvertLanguage;", "getFamilyName", "", "getText", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "intellij.ml.llm.python"})
public final class FileConvertJupyterToPythonIntention
extends FileConvertLanguageIntention {
    @NotNull
    private final PasteConvertLanguage targetLanguage;

    public FileConvertJupyterToPythonIntention(@NotNull PasteConvertLanguage targetLanguage) {
        Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
        this.targetLanguage = targetLanguage;
    }

    public /* synthetic */ FileConvertJupyterToPythonIntention(PasteConvertLanguage pasteConvertLanguage, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            pasteConvertLanguage = (PasteConvertLanguage)PythonLang.INSTANCE;
        }
        this(pasteConvertLanguage);
    }

    @NotNull
    public PasteConvertLanguage getTargetLanguage() {
        return this.targetLanguage;
    }

    @NotNull
    public String getFamilyName() {
        return LLMBundle.message((String)"intention.category.small.on.file", (Object[])new Object[0]);
    }

    @NotNull
    public String getText() {
        return PythonLLMBundle.message("intentions.jupyter.convert.to.python", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        PsiFile psiFile2 = psiFile;
        Language language = psiFile2 != null ? psiFile2.getLanguage() : null;
        PsiFile psiFile3 = psiFile;
        if (psiFile3 == null) return false;
        if (!psiFile3.isWritable()) return false;
        boolean bl = true;
        if (!bl) return false;
        String string = psiFile.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (StringsKt.isBlank((CharSequence)string)) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        if (editor2 == null) return false;
        if (LLMProjectSettingsManager.Companion.getInstance(project2).hasRemDevModeRestrictions()) return false;
        if (PrivacyPathCheckerKt.isAiIgnoreBlocked((PsiElement)psiFile)) return false;
        if (language == null) return false;
        if (language instanceof PythonLanguage) return false;
        if (!language.isKindOf((Language)PythonLanguage.INSTANCE)) {
            if (!Intrinsics.areEqual((Object)language.getDisplayName(), (Object)"Jupyter")) return false;
        }
        if (!AIAssistantUIUtil.INSTANCE.hasAvailableLlmProfileId(LLMPromptsKt.getCONVERSION_OF_FILE_PROMPT_ID())) return false;
        return true;
    }

    public FileConvertJupyterToPythonIntention() {
        this(null, 1, null);
    }
}

