/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.python.intentions.inline;

import com.intellij.ml.llm.errorExplanation.PsiUtilsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilBase;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyCompoundStatement;
import com.jetbrains.python.psi.PyDelStatement;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLoopStatement;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyYieldExpression;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\r\u001a\u00020\u0005*\u00020\u000eH\u0002J\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\u0016\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/python/intentions/inline/PythonConvertLoopToComprehensionUtils;", "", "<init>", "()V", "MAX_LOOP_LINES", "", "DISSALLOWED_IN_CHILDREN", "", "Ljava/lang/Class;", "Lcom/jetbrains/python/psi/PyElement;", "[Ljava/lang/Class;", "JUPYTER_CELL_SEPARATOR", "", "startOffsetStripNewLine", "Lcom/intellij/psi/PsiWhiteSpace;", "getRangeFromLineStart", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/psi/PsiElement;", "getLoopAtCaret", "Lcom/jetbrains/python/psi/PyLoopStatement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isSimpleLoop", "", "statement", "(Lcom/jetbrains/python/psi/PyLoopStatement;)Ljava/lang/Boolean;", "hasDisallowedChildren", "getContextRange", "psiElem", "(Lcom/intellij/psi/PsiElement;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.python"})
@SourceDebugExtension(value={"SMAP\nPythonConvertLoopToComprehensionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonConvertLoopToComprehensionUtils.kt\ncom/intellij/ml/llm/python/intentions/inline/PythonConvertLoopToComprehensionUtils\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,88:1\n158#2,6:89\n*S KotlinDebug\n*F\n+ 1 PythonConvertLoopToComprehensionUtils.kt\ncom/intellij/ml/llm/python/intentions/inline/PythonConvertLoopToComprehensionUtils\n*L\n37#1:89,6\n*E\n"})
public final class PythonConvertLoopToComprehensionUtils {
    @NotNull
    public static final PythonConvertLoopToComprehensionUtils INSTANCE = new PythonConvertLoopToComprehensionUtils();
    private static final int MAX_LOOP_LINES = 8;
    @NotNull
    private static final Class<? extends PyElement>[] DISSALLOWED_IN_CHILDREN;
    @NotNull
    private static final String JUPYTER_CELL_SEPARATOR = "#%%";

    private PythonConvertLoopToComprehensionUtils() {
    }

    private final int startOffsetStripNewLine(PsiWhiteSpace $this$startOffsetStripNewLine) {
        int n;
        block1: {
            String string = $this$startOffsetStripNewLine.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            CharSequence $this$indexOfFirst$iv = string;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(it != '\n')) continue;
                n = index$iv;
                break block1;
            }
            n = -1;
        }
        int n3 = n;
        int n4 = 0;
        int newLineLen = Math.max(n3, n4);
        return PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)$this$startOffsetStripNewLine)) + newLineLen;
    }

    @NotNull
    public final TextRange getRangeFromLineStart(@NotNull PsiElement $this$getRangeFromLineStart) {
        Intrinsics.checkNotNullParameter((Object)$this$getRangeFromLineStart, (String)"<this>");
        Document document2 = $this$getRangeFromLineStart.getContainingFile().getViewProvider().getDocument();
        if (document2 == null && (document2 = PsiDocumentManager.getInstance((Project)$this$getRangeFromLineStart.getProject()).getDocument($this$getRangeFromLineStart.getContainingFile())) == null) {
            TextRange textRange = $this$getRangeFromLineStart.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            return textRange;
        }
        Document document3 = document2;
        return new TextRange(document3.getLineStartOffset(PsiUtilsKt.getLineNumber((PsiElement)$this$getRangeFromLineStart, (boolean)true)), PsiTreeUtilKt.getEndOffset((PsiElement)$this$getRangeFromLineStart));
    }

    @Nullable
    public final PyLoopStatement getLoopAtCaret(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        PsiElement element2 = PsiUtilBase.getElementAtCaret((Editor)editor2);
        return (PyLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, PyLoopStatement.class);
    }

    @Nullable
    public final Boolean isSimpleLoop(@Nullable PyLoopStatement statement) {
        if (statement == null) {
            return null;
        }
        int lines2 = 1 + PsiUtilsKt.getLineNumber((PsiElement)((PsiElement)statement), (boolean)false) - PsiUtilsKt.getLineNumber((PsiElement)((PsiElement)statement), (boolean)true);
        if (lines2 > 8) {
            return false;
        }
        return !this.hasDisallowedChildren((PsiElement)statement);
    }

    private final boolean hasDisallowedChildren(PsiElement statement) {
        Class<? extends PyElement>[] classArray = DISSALLOWED_IN_CHILDREN;
        return PsiTreeUtil.findChildOfAnyType((PsiElement)statement, (Class[])Arrays.copyOf(classArray, classArray.length)) != null;
    }

    @Nullable
    public final Object getContextRange(@NotNull PsiElement psiElem, @NotNull Continuation<? super TextRange> $completion) {
        Class[] classArray = new Class[]{PyFunction.class, PyClass.class};
        PsiElement container2 = PsiTreeUtil.getParentOfType((PsiElement)psiElem, (Class[])classArray);
        if (container2 != null) {
            return CoroutinesKt.readAction(() -> PythonConvertLoopToComprehensionUtils.getContextRange$lambda$1(container2), $completion);
        }
        Ref.ObjectRef beginPsi = new Ref.ObjectRef();
        beginPsi.element = psiElem;
        while (((PsiElement)beginPsi.element).getPrevSibling() != null && !(((PsiElement)beginPsi.element).getPrevSibling() instanceof PyCompoundStatement)) {
            if (((PsiElement)beginPsi.element).getPrevSibling() instanceof PsiComment) {
                String string = ((PsiElement)beginPsi.element).getPrevSibling().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (StringsKt.startsWith$default((String)string, (String)JUPYTER_CELL_SEPARATOR, (boolean)false, (int)2, null)) break;
            }
            Intrinsics.checkNotNullExpressionValue((Object)((PsiElement)beginPsi.element).getPrevSibling(), (String)"getPrevSibling(...)");
            beginPsi.element = beginPsi.element;
        }
        if (beginPsi.element instanceof PsiWhiteSpace) {
            return new TextRange(this.startOffsetStripNewLine((PsiWhiteSpace)beginPsi.element), PsiTreeUtilKt.getEndOffset((PsiElement)psiElem));
        }
        return CoroutinesKt.readAction(() -> PythonConvertLoopToComprehensionUtils.getContextRange$lambda$2(beginPsi, psiElem), $completion);
    }

    private static final TextRange getContextRange$lambda$1(PsiElement $container) {
        return INSTANCE.getRangeFromLineStart($container);
    }

    private static final TextRange getContextRange$lambda$2(Ref.ObjectRef $beginPsi, PsiElement $psiElem) {
        return new TextRange(INSTANCE.getRangeFromLineStart((PsiElement)$beginPsi.element).getStartOffset(), PsiTreeUtilKt.getEndOffset((PsiElement)$psiElem));
    }

    static {
        Class[] classArray = new Class[]{PyReturnStatement.class, PyYieldExpression.class, PyDelStatement.class, PyFunction.class, PyClass.class, PyRaiseStatement.class, PyTryExceptStatement.class};
        DISSALLOWED_IN_CHILDREN = classArray;
    }
}

