/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.rider.csharp.docgen;

import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPrompt;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPromptService;
import com.intellij.ml.llm.grazie.tasks.documentation.WdPromptCustomization;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.rider.docgen.DocGenUtilKt;
import com.intellij.ml.llm.rider.docgen.RiderLLMDocumentationSupportBase;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/rider/csharp/docgen/CSharpLLMDocumentationSupport;", "Lcom/intellij/ml/llm/rider/docgen/RiderLLMDocumentationSupportBase;", "<init>", "()V", "emptyDocumentation", "", "getEmptyDocumentation", "()Ljava/lang/String;", "parameterTag", "Lcom/intellij/ml/llm/privacy/PSString;", "getParameterTag", "()Lcom/intellij/ml/llm/privacy/PSString;", "returnTag", "getReturnTag", "buildDocFromSuggestion", "suggestion", "containsCompleteDoc", "", "useChatCodeContextProvider", "promptCustomization", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdPromptCustomization;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.rider.csharp"})
public final class CSharpLLMDocumentationSupport
extends RiderLLMDocumentationSupportBase {
    @NotNull
    public String getEmptyDocumentation() {
        return "///";
    }

    @NotNull
    public PSString getParameterTag() {
        return ConstantsKt.getPrivacyConst((String)"<param>");
    }

    @NotNull
    public PSString getReturnTag() {
        return ConstantsKt.getPrivacyConst((String)"<return>");
    }

    @NotNull
    public String buildDocFromSuggestion(@NotNull String suggestion) {
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        return DocGenUtilKt.parseXmlCommentSuggestion(suggestion, this.getEmptyDocumentation()).getDocCode();
    }

    public boolean containsCompleteDoc(@NotNull String suggestion) {
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        return DocGenUtilKt.parseXmlCommentSuggestion(suggestion, this.getEmptyDocumentation()).isFinished();
    }

    public boolean useChatCodeContextProvider() {
        return true;
    }

    @Nullable
    public WdPromptCustomization promptCustomization(@NotNull Project project2) {
        WdPromptCustomization.User user;
        PSString pSString;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        AISystemLibraryPrompt aISystemLibraryPrompt = AISystemLibraryPromptService.Companion.getInstance(project2).findPrompt("AIAssistant.WriteDocumentation.CSharp");
        if (aISystemLibraryPrompt != null && (pSString = aISystemLibraryPrompt.getContent()) != null) {
            PSString it = pSString;
            boolean bl = false;
            user = new WdPromptCustomization.User(it);
        } else {
            user = null;
        }
        return (WdPromptCustomization)user;
    }
}

