/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.nextEdit;

import com.intellij.ml.llm.riderNext.latest.miniAiChat.nextActions.MiniChatNextAction;
import com.intellij.ml.llm.riderNext.latest.miniAiChat.nextActions.MiniChatNextActionManager;
import com.intellij.ml.llm.riderNext.latest.nextEdit.NextEditExecutor;
import com.intellij.ml.llm.riderNext.latest.nextEdit.NextEditExecutorKt;
import com.intellij.ml.llm.riderNext.latest.nextEdit.NextEditSuggestionActionListener;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\u000fJ\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/nextEdit/NextEditDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "Lcom/intellij/ml/llm/riderNext/latest/nextEdit/NextEditSuggestionActionListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "currentAction", "Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/nextActions/MiniChatNextAction;", "changesSinceLastSuggestion", "", "newLinesSinceLastSuggestion", "maxChanges", "maxNewLines", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "clearCurrentActionState", "onActionAdded", "action", "onActionRemoved", "intellij.ml.llm.riderNext.latest"})
@SourceDebugExtension(value={"SMAP\nNextEditDocumentListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditDocumentListener.kt\ncom/intellij/ml/llm/riderNext/latest/nextEdit/NextEditDocumentListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,46:1\n30#2,2:47\n*S KotlinDebug\n*F\n+ 1 NextEditDocumentListener.kt\ncom/intellij/ml/llm/riderNext/latest/nextEdit/NextEditDocumentListener\n*L\n28#1:47,2\n*E\n"})
public final class NextEditDocumentListener
implements DocumentListener,
NextEditSuggestionActionListener {
    @NotNull
    private final Project project;
    @Nullable
    private MiniChatNextAction currentAction;
    private int changesSinceLastSuggestion;
    private int newLinesSinceLastSuggestion;
    private final int maxChanges;
    private final int maxNewLines;

    public NextEditDocumentListener(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.maxChanges = 10;
        this.maxNewLines = 3;
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        int n;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MiniChatNextActionManager actionManager = MiniChatNextActionManager.Companion.getInstance(this.project);
        if (NextEditExecutorKt.getNextEditAction(actionManager) == null) {
            return;
        }
        CharSequence charSequence = event.getNewFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
        boolean newLinesInChange = StringsKt.contains$default((CharSequence)charSequence, (char)'\n', (boolean)false, (int)2, null);
        if (newLinesInChange) {
            n = this.newLinesSinceLastSuggestion;
            this.newLinesSinceLastSuggestion = n + 1;
        }
        n = this.changesSinceLastSuggestion;
        this.changesSinceLastSuggestion = n + 1;
        if (this.changesSinceLastSuggestion >= this.maxChanges || this.newLinesSinceLastSuggestion >= this.maxNewLines) {
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<NextEditExecutor> serviceClass$iv = NextEditExecutor.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((NextEditExecutor)object).clearCurrentSuggestion();
        }
    }

    public final void clearCurrentActionState() {
        this.currentAction = null;
        this.changesSinceLastSuggestion = 0;
        this.newLinesSinceLastSuggestion = 0;
    }

    @Override
    public void onActionAdded(@NotNull MiniChatNextAction action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        this.clearCurrentActionState();
    }

    @Override
    public void onActionRemoved(@NotNull MiniChatNextAction action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        this.clearCurrentActionState();
    }
}

