/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.recap.ai;

import ai.grazie.model.llm.prompt.LLMPromptID;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.riderNext.latest.recap.ai.RecapDiffPrivacyWrapper;
import com.intellij.ml.llm.riderNext.latest.recap.ai.RecapLLMRequest;
import com.intellij.ml.llm.riderNext.latest.recap.lvcs.RecapLVCSTimestamp;
import com.intellij.ml.llm.tokenizer.Tokenizer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0014J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/recap/ai/RecapLLMSummaryRequest;", "Lcom/intellij/ml/llm/riderNext/latest/recap/ai/RecapLLMRequest;", "diff", "Lcom/intellij/ml/llm/riderNext/latest/recap/ai/RecapDiffPrivacyWrapper;", "<init>", "(Lcom/intellij/ml/llm/riderNext/latest/recap/ai/RecapDiffPrivacyWrapper;)V", "getDiff", "()Lcom/intellij/ml/llm/riderNext/latest/recap/ai/RecapDiffPrivacyWrapper;", "promptId", "Lai/grazie/model/llm/prompt/LLMPromptID;", "getPromptId", "()Lai/grazie/model/llm/prompt/LLMPromptID;", "composeSystemPrompt", "Lcom/intellij/ml/llm/privacy/PSString;", "composeUserPrompt", "Lkotlin/Pair;", "Lcom/intellij/ml/llm/riderNext/latest/recap/lvcs/RecapLVCSTimestamp;", "tokenizer", "Lcom/intellij/ml/llm/tokenizer/Tokenizer;", "Companion", "intellij.ml.llm.riderNext.latest"})
public final class RecapLLMSummaryRequest
extends RecapLLMRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RecapDiffPrivacyWrapper diff;
    @NotNull
    public static final String SYSTEM_PROMPT = "\nYour task is to generate a HIGH-LEVEL summary of changes made in the project.\nThe summary MUST be described as several business logic tasks, that is related to the diffs below, grouped by the concrete changes summary.\nYou MUST include the latest diffs in the summary.\n\nSpecify the HIGH-LEVEL definition of task first, then details in bullet points.\nThe summary MUST be in about 5 bullet points. \nPlease, avoid using generic task definitions like \"Adding features\" or \"Fixing bugs\".\n\nYou MUST use past tense, e.g. \"<i>User</i> entity is added\" instead of \"Added <i>UserService</i> entity\".\n\nIt must exclude line numbers and other details.\nYou MUST wrap with <i></i> tag keywords, names of files and entities. You MUST NOT use any other highlights.\n\nSplit to short paragraphs with bullet points. \nYou MUST add <br> tag to the end of each paragraph.\nYou MUST NOT add backticks to response.\n\nExample:\n\n<b>New employees hiring process with salary calculation:</b><br>\n- <i>User</i> entity is added. Is applied to <i>EmployeeService</i> and <i>CoreDbProvider</i><br>\n- <i>NetIncome</i> calculates on fly in <i>FundReport</i> entity<br>\n\n<br/>\n\n<b>Non functional requirements is applied:</b><br>\n- <i>HTTP 403</i> on Unauthorized requests in <i>MainController</i><br>\n- Circut breaker to all HTTP requests<br>\n\n<br/>\n\n<b>Multiple addresses supported:</b><br>\n- <i>User</i> can have multiple <i>Addresses</i><br>\n- <i>AppendAddress</i> method to <i>UserService</i> service<br>\n    ";
    @NotNull
    public static final String USER_PROMPT = "\nSummarize the following diffs:\n%s\n";

    public RecapLLMSummaryRequest(@NotNull RecapDiffPrivacyWrapper diff2) {
        Intrinsics.checkNotNullParameter((Object)((Object)diff2), (String)"diff");
        this.diff = diff2;
    }

    @NotNull
    public final RecapDiffPrivacyWrapper getDiff() {
        return this.diff;
    }

    @Override
    @NotNull
    protected LLMPromptID getPromptId() {
        return new LLMPromptID("riderNext.recap.summary");
    }

    @Override
    @NotNull
    protected PSString composeSystemPrompt() {
        return ConstantsKt.getPrivacyConst((String)SYSTEM_PROMPT);
    }

    @Override
    @NotNull
    protected Pair<PSString, RecapLVCSTimestamp> composeUserPrompt(@NotNull Tokenizer tokenizer) {
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        int userTokens = tokenizer.count(USER_PROMPT);
        int systemTokens = tokenizer.count(SYSTEM_PROMPT);
        Pair<PSString, RecapLVCSTimestamp> pair = this.diff.getDiff(userTokens + systemTokens);
        PSString diffString = (PSString)pair.component1();
        RecapLVCSTimestamp timestamp = (RecapLVCSTimestamp)pair.component2();
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{diffString};
        PSString prompt2 = ConstantsKt.getPrivacyConst((String)USER_PROMPT).format(pSStringConvertibleArray);
        return new Pair((Object)prompt2, (Object)timestamp);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/recap/ai/RecapLLMSummaryRequest$Companion;", "", "<init>", "()V", "SYSTEM_PROMPT", "", "USER_PROMPT", "intellij.ml.llm.riderNext.latest"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

