/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.sql.formatting;

import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConcatenateBuilder;
import com.intellij.ml.llm.sql.SqlLLMBundle;
import com.intellij.ml.llm.sql.formatting.SqlAiFormatExamples;
import com.intellij.ml.llm.sql.formatting.SqlAiStatementAnalyser;
import com.intellij.ml.llm.sql.formatting.SqlAiStatementCategory;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.project.ProjectKt;
import com.intellij.project.ProjectStoreOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 >2\u00020\u0001:\u0002>?B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u001cJ\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u001cJ\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u001fJ\u0015\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\"J\u0010\u0010#\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010$\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00150&2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(H\u0002J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00150&2\u0006\u0010*\u001a\u00020+2\u0006\u0010'\u001a\u00020(H\u0002J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00150&2\u0006\u0010-\u001a\u00020(H\u0002J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020(0/2\u0006\u00100\u001a\u00020(H\u0002J\u001d\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u000205H\u0000\u00a2\u0006\u0002\b6J \u00107\u001a\u0002022\u0006\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u000205H\u0080@\u00a2\u0006\u0004\b8\u00109J\u0018\u0010:\u001a\u00020\u00172\u0006\u0010;\u001a\u00020\u00172\u0006\u00104\u001a\u000205H\u0002J\f\u0010<\u001a\u000202*\u00020=H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006@"}, d2={"Lcom/intellij/ml/llm/sql/formatting/SqlAiFormatExamples;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "enabledForProject", "", "getEnabledForProject$intellij_ml_llm_sql", "()Z", "exampleDirectoryPath", "Ljava/nio/file/Path;", "getExampleDirectoryPath$intellij_ml_llm_sql", "()Ljava/nio/file/Path;", "getExampleTextForStatement", "Lcom/intellij/ml/llm/privacy/PSString;", "statement", "Lcom/intellij/sql/psi/SqlStatement;", "dialectId", "", "getApplicableExampleFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "findApplicableExampleFile", "getProjectExampleFile", "getProjectExampleFile$intellij_ml_llm_sql", "path", "getProjectExampleFilePath", "getProjectExampleFilePath$intellij_ml_llm_sql", "checkExampleExists", "f", "checkExampleExists$intellij_ml_llm_sql", "makeProjectExampleFilePath", "getPersonalExampleFile", "getExampleStatementsForStatement", "Lcom/intellij/util/containers/JBIterable;", "exampleRootElement", "Lcom/intellij/psi/PsiElement;", "getExampleStatementsForStatementCategory", "category", "Lcom/intellij/ml/llm/sql/formatting/SqlAiStatementCategory;", "getFileStatements", "rootElement", "listPsiElementApplicableChildren", "", "element", "openExampleFileInEditorInBG", "", "exampleFilePath", "dialect", "Lcom/intellij/lang/Language;", "openExampleFileInEditorInBG$intellij_ml_llm_sql", "openExampleFileInEditor", "openExampleFileInEditor$intellij_ml_llm_sql", "(Ljava/nio/file/Path;Lcom/intellij/lang/Language;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "commentText", "text", "moveCaretDown", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Companion", "StatementCandidate", "intellij.ml.llm.sql"})
@SourceDebugExtension(value={"SMAP\nSqlAiFormatExamples.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlAiFormatExamples.kt\ncom/intellij/ml/llm/sql/formatting/SqlAiFormatExamples\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,222:1\n1#2:223\n75#3:224\n*S KotlinDebug\n*F\n+ 1 SqlAiFormatExamples.kt\ncom/intellij/ml/llm/sql/formatting/SqlAiFormatExamples\n*L\n198#1:224\n*E\n"})
public final class SqlAiFormatExamples {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    private final boolean enabledForProject;
    @Nullable
    private final Path exampleDirectoryPath;
    @NotNull
    public static final String ourExamplesSubdirectoryName = "examples4AI";
    @NotNull
    public static final String ourExamplesSuffix = "-example.sql";

    public SqlAiFormatExamples(@NotNull Project project2, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project2;
        this.coroutineScope = coroutineScope;
        if (this.project instanceof ProjectStoreOwner) {
            Path dotIdeaPath = ((ProjectStoreOwner)this.project).getComponentStore().getDirectoryStorePath();
            Path path = dotIdeaPath;
            this.exampleDirectoryPath = path != null && (path = path.resolve("codeStyles")) != null ? path.resolve(ourExamplesSubdirectoryName) : null;
            this.enabledForProject = this.exampleDirectoryPath != null;
        } else {
            this.enabledForProject = false;
            this.exampleDirectoryPath = null;
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean getEnabledForProject$intellij_ml_llm_sql() {
        return this.enabledForProject;
    }

    @Nullable
    public final Path getExampleDirectoryPath$intellij_ml_llm_sql() {
        return this.exampleDirectoryPath;
    }

    @Nullable
    public final PSString getExampleTextForStatement(@NotNull SqlStatement statement, @NotNull String dialectId) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)dialectId, (String)"dialectId");
        VirtualFile virtualFile2 = this.getApplicableExampleFile(dialectId);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile exampleFile = virtualFile2;
        Document document2 = VirtualFileUtil.findDocument((VirtualFile)exampleFile);
        if (document2 == null) {
            return null;
        }
        Document exampleDocument = document2;
        PsiFile psiFile = VirtualFileUtil.findPsiFile((VirtualFile)exampleFile, (Project)this.project);
        if (psiFile == null) {
            return null;
        }
        PsiFile exampleRoot = psiFile;
        JBIterable<SqlStatement> statements = this.getExampleStatementsForStatement(statement, (PsiElement)exampleRoot);
        if (statements.isEmpty()) {
            return null;
        }
        ConcatenateBuilder b = new ConcatenateBuilder(null, 1, null);
        for (SqlStatement stmt : statements) {
            Intrinsics.checkNotNull((Object)stmt);
            int beg = PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)stmt));
            int end = PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)stmt));
            b.append(ExtensionsKtKt.privacySafe(exampleDocument, this.project).getText(), beg, end);
            ConcatenateBuilder.appendLine$default((ConcatenateBuilder)ConcatenateBuilder.appendLine$default((ConcatenateBuilder)b, null, (int)1, null), null, (int)1, null);
        }
        return b.toPSString();
    }

    @Nullable
    public final VirtualFile getApplicableExampleFile(@NotNull String dialectId) {
        Intrinsics.checkNotNullParameter((Object)dialectId, (String)"dialectId");
        Path path = this.findApplicableExampleFile(dialectId);
        if (path == null) {
            return null;
        }
        Path formatExampleFilePath = path;
        return LocalFileSystem.getInstance().findFileByNioFile(formatExampleFilePath);
    }

    private final Path findApplicableExampleFile(String dialectId) {
        boolean nonGeneric = !Intrinsics.areEqual((Object)dialectId, (Object)"GenericSQL");
        Path f = null;
        if (ProjectKt.isDirectoryBased((Project)this.project)) {
            if (nonGeneric && (f = this.getProjectExampleFilePath$intellij_ml_llm_sql(dialectId)) != null) {
                return f;
            }
            f = this.getProjectExampleFilePath$intellij_ml_llm_sql("GenericSQL");
            if (f != null) {
                return f;
            }
        }
        if (nonGeneric && (f = this.getPersonalExampleFile(dialectId)) != null) {
            return f;
        }
        f = this.getPersonalExampleFile("GenericSQL");
        return f;
    }

    @Nullable
    public final VirtualFile getProjectExampleFile$intellij_ml_llm_sql(@NotNull String dialectId) {
        Intrinsics.checkNotNullParameter((Object)dialectId, (String)"dialectId");
        Path path = this.getProjectExampleFilePath$intellij_ml_llm_sql(dialectId);
        if (path == null) {
            return null;
        }
        Path path2 = path;
        return this.getProjectExampleFile$intellij_ml_llm_sql(path2);
    }

    @Nullable
    public final VirtualFile getProjectExampleFile$intellij_ml_llm_sql(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return LocalFileSystem.getInstance().findFileByNioFile(path);
    }

    @Nullable
    public final Path getProjectExampleFilePath$intellij_ml_llm_sql(@NotNull String dialectId) {
        Path f;
        Path path;
        Intrinsics.checkNotNullParameter((Object)dialectId, (String)"dialectId");
        Path path2 = this.makeProjectExampleFilePath(dialectId);
        if (path2 == null) {
            return null;
        }
        Path p0 = path = (f = path2);
        boolean bl = false;
        return this.checkExampleExists$intellij_ml_llm_sql(p0) ? path : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean checkExampleExists$intellij_ml_llm_sql(@NotNull Path f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(f, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isRegularFile(f, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) return false;
        if (!Files.isReadable(f)) return false;
        return true;
    }

    @Nullable
    public final Path makeProjectExampleFilePath(@NotNull String dialectId) {
        Intrinsics.checkNotNullParameter((Object)dialectId, (String)"dialectId");
        Path path = this.exampleDirectoryPath;
        if (path == null) {
            return null;
        }
        Path dirPath = path;
        String exampleFileName = dialectId + ourExamplesSuffix;
        Path f = dirPath.resolve(exampleFileName);
        return f;
    }

    private final Path getPersonalExampleFile(String dialectId) {
        return null;
    }

    private final JBIterable<SqlStatement> getExampleStatementsForStatement(SqlStatement statement, PsiElement exampleRootElement) {
        SqlAiStatementCategory category = SqlAiStatementAnalyser.INSTANCE.analyzeStatement(statement);
        return this.getExampleStatementsForStatementCategory(category, exampleRootElement);
    }

    private final JBIterable<SqlStatement> getExampleStatementsForStatementCategory(SqlAiStatementCategory category, PsiElement exampleRootElement) {
        JBIterable jBIterable = this.getFileStatements(exampleRootElement).transform(arg_0 -> SqlAiFormatExamples.getExampleStatementsForStatementCategory$lambda$1(arg_0 -> SqlAiFormatExamples.getExampleStatementsForStatementCategory$lambda$0(category, arg_0), arg_0)).sort((arg_0, arg_1) -> SqlAiFormatExamples.getExampleStatementsForStatementCategory$lambda$3(SqlAiFormatExamples::getExampleStatementsForStatementCategory$lambda$2, arg_0, arg_1)).take(7).transform(arg_0 -> SqlAiFormatExamples.getExampleStatementsForStatementCategory$lambda$5(SqlAiFormatExamples::getExampleStatementsForStatementCategory$lambda$4, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"transform(...)");
        return jBIterable;
    }

    private final JBIterable<SqlStatement> getFileStatements(PsiElement rootElement) {
        JBIterable jBIterable = TreeTraversal.PRE_ORDER_DFS.traversal((Object)rootElement, arg_0 -> SqlAiFormatExamples.getFileStatements$lambda$6((Function1)new Function1<PsiElement, Iterable<? extends PsiElement>>((Object)this){

            public final Iterable<PsiElement> invoke(PsiElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return SqlAiFormatExamples.access$listPsiElementApplicableChildren((SqlAiFormatExamples)this.receiver, p0);
            }
        }, arg_0)).filter(SqlStatement.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return jBIterable;
    }

    private final Iterable<PsiElement> listPsiElementApplicableChildren(PsiElement element2) {
        Iterable iterable;
        if (element2 instanceof SqlStatement) {
            iterable = SetsKt.emptySet();
        } else {
            PsiElement[] psiElementArray = element2.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            iterable = ArraysKt.asIterable((Object[])psiElementArray);
        }
        return iterable;
    }

    public final void openExampleFileInEditorInBG$intellij_ml_llm_sql(@NotNull Path exampleFilePath, @NotNull Language dialect) {
        Intrinsics.checkNotNullParameter((Object)exampleFilePath, (String)"exampleFilePath");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, exampleFilePath, dialect, null){
            int label;
            final /* synthetic */ SqlAiFormatExamples this$0;
            final /* synthetic */ Path $exampleFilePath;
            final /* synthetic */ Language $dialect;
            {
                this.this$0 = $receiver;
                this.$exampleFilePath = $exampleFilePath;
                this.$dialect = $dialect;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.openExampleFileInEditor$intellij_ml_llm_sql(this.$exampleFilePath, this.$dialect, (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object openExampleFileInEditor$intellij_ml_llm_sql(@NotNull Path exampleFilePath, @NotNull Language dialect, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof openExampleFileInEditor.1)) ** GOTO lbl-1000
        var11_4 = $completion;
        if ((var11_4.label & -2147483648) != 0) {
            var11_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ SqlAiFormatExamples this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.openExampleFileInEditor$intellij_ml_llm_sql(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = LocalFileSystem.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(...)");
                lfs = v0;
                justCreated = new Ref.BooleanRef();
                if (!Files.notExists(exampleFilePath, new LinkOption[0])) ** GOTO lbl42
                introduction = new Ref.ObjectRef();
                introduction.element = SqlLLMBundle.message("ai.FormatExampleFile.introduction.text", new Object[0]);
                introduction.element = this.commentText((String)introduction.element, dialect);
                parentPath = exampleFilePath.getParent();
                $continuation.L$0 = exampleFilePath;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)dialect);
                $continuation.L$2 = lfs;
                $continuation.L$3 = justCreated;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)introduction);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)parentPath);
                $continuation.label = 1;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(parentPath, exampleFilePath, (Ref.ObjectRef<String>)introduction, justCreated, null){
                    int label;
                    final /* synthetic */ Path $parentPath;
                    final /* synthetic */ Path $exampleFilePath;
                    final /* synthetic */ Ref.ObjectRef<String> $introduction;
                    final /* synthetic */ Ref.BooleanRef $justCreated;
                    {
                        this.$parentPath = $parentPath;
                        this.$exampleFilePath = $exampleFilePath;
                        this.$introduction = $introduction;
                        this.$justCreated = $justCreated;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                Files.createDirectories(this.$parentPath, new FileAttribute[0]);
                                OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE_NEW};
                                Files.writeString(this.$exampleFilePath, (CharSequence)this.$introduction.element, Charsets.UTF_8, openOptionArray);
                                this.$justCreated.element = true;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl41
            }
            case 1: {
                parentPath = (Path)$continuation.L$5;
                introduction = (Ref.ObjectRef)$continuation.L$4;
                justCreated = (Ref.BooleanRef)$continuation.L$3;
                lfs = (LocalFileSystem)$continuation.L$2;
                dialect = (Language)$continuation.L$1;
                exampleFilePath = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl41:
                // 2 sources

                lfs.refreshNioFiles((Iterable)SetsKt.setOf((Object)exampleFilePath));
lbl42:
                // 2 sources

                if ((virtualFile = lfs.findFileByNioFile(exampleFilePath)) == null) {
                    return Unit.INSTANCE;
                }
                virtualFile.setWritable(true);
                $this$serviceAsync$iv = (ComponentManager)this.project;
                $i$f$serviceAsync = 0;
                Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)exampleFilePath);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)dialect);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)lfs);
                $continuation.L$3 = justCreated;
                $continuation.L$4 = virtualFile;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv);
                $continuation.I$0 = $i$f$serviceAsync;
                $continuation.label = 2;
                v2 = ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(FileEditorManager.class, (Continuation)$continuation);
                if (v2 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl71
            }
            case 2: {
                $i$f$serviceAsync = $continuation.I$0;
                $this$serviceAsync$iv = (ComponentManager)$continuation.L$5;
                virtualFile = (VirtualFile)$continuation.L$4;
                justCreated = (Ref.BooleanRef)$continuation.L$3;
                lfs = (LocalFileSystem)$continuation.L$2;
                dialect = (Language)$continuation.L$1;
                exampleFilePath = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl71:
                // 2 sources

                editorManager = (FileEditorManager)v2;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)exampleFilePath);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)dialect);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)lfs);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)justCreated);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)virtualFile);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)editorManager);
                $continuation.label = 3;
                v3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(editorManager, virtualFile, justCreated, this, null){
                    int label;
                    final /* synthetic */ FileEditorManager $editorManager;
                    final /* synthetic */ VirtualFile $virtualFile;
                    final /* synthetic */ Ref.BooleanRef $justCreated;
                    final /* synthetic */ SqlAiFormatExamples this$0;
                    {
                        this.$editorManager = $editorManager;
                        this.$virtualFile = $virtualFile;
                        this.$justCreated = $justCreated;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                FileEditor fileEditor;
                                ResultKt.throwOnFailure((Object)$result);
                                Object[] objectArray = this.$editorManager.openFile(this.$virtualFile, true);
                                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"openFile(...)");
                                Object[] fileEditors = objectArray;
                                if (this.$justCreated.element && (fileEditor = (FileEditor)ArraysKt.firstOrNull((Object[])fileEditors)) != null) {
                                    SqlAiFormatExamples.access$moveCaretDown(this.this$0, fileEditor);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v3 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl92
            }
            case 3: {
                editorManager = (FileEditorManager)$continuation.L$5;
                virtualFile = (VirtualFile)$continuation.L$4;
                justCreated = (Ref.BooleanRef)$continuation.L$3;
                lfs = (LocalFileSystem)$continuation.L$2;
                dialect = (Language)$continuation.L$1;
                exampleFilePath = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl92:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String commentText(String text2, Language dialect) {
        String prefix = "--  ";
        if (dialect instanceof SqlLanguageDialect) {
            String string = ((Commenter)LanguageCommenters.INSTANCE.forLanguage(dialect)).getLineCommentPrefix();
            if (string == null) {
                string = prefix;
            }
            prefix = string;
        }
        return prefix + StringsKt.replace$default((String)text2, (String)"\n", (String)("\n" + prefix), (boolean)false, (int)4, null) + "\n\n";
    }

    private final void moveCaretDown(FileEditor $this$moveCaretDown) {
        if ($this$moveCaretDown instanceof TextEditor) {
            Editor editor2 = ((TextEditor)$this$moveCaretDown).getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
            Editor editor3 = editor2;
            int n = editor3.getDocument().getLineCount();
            editor3.getCaretModel().moveToLogicalPosition(new LogicalPosition(n - 1, 0));
        }
    }

    private static final StatementCandidate getExampleStatementsForStatementCategory$lambda$0(SqlAiStatementCategory $category, SqlStatement s) {
        Intrinsics.checkNotNull((Object)s);
        return new StatementCandidate(s, $category.distanceTo(SqlAiStatementAnalyser.INSTANCE.analyzeStatement(s)));
    }

    private static final StatementCandidate getExampleStatementsForStatementCategory$lambda$1(Function1 $tmp0, Object p0) {
        return (StatementCandidate)$tmp0.invoke(p0);
    }

    private static final int getExampleStatementsForStatementCategory$lambda$2(StatementCandidate c1, StatementCandidate c2) {
        return c1.getDistance() - c2.getDistance();
    }

    private static final int getExampleStatementsForStatementCategory$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final SqlStatement getExampleStatementsForStatementCategory$lambda$4(StatementCandidate it) {
        return it.getStatement();
    }

    private static final SqlStatement getExampleStatementsForStatementCategory$lambda$5(Function1 $tmp0, Object p0) {
        return (SqlStatement)$tmp0.invoke(p0);
    }

    private static final Iterable getFileStatements$lambda$6(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Iterable access$listPsiElementApplicableChildren(SqlAiFormatExamples $this, PsiElement element2) {
        return $this.listPsiElementApplicableChildren(element2);
    }

    public static final /* synthetic */ void access$moveCaretDown(SqlAiFormatExamples $this, FileEditor $receiver) {
        $this.moveCaretDown($receiver);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/sql/formatting/SqlAiFormatExamples$Companion;", "", "<init>", "()V", "ourExamplesSubdirectoryName", "", "ourExamplesSuffix", "intellij.ml.llm.sql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/sql/formatting/SqlAiFormatExamples$StatementCandidate;", "", "statement", "Lcom/intellij/sql/psi/SqlStatement;", "distance", "", "<init>", "(Lcom/intellij/sql/psi/SqlStatement;I)V", "getStatement", "()Lcom/intellij/sql/psi/SqlStatement;", "getDistance", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.ml.llm.sql"})
    public static final class StatementCandidate {
        @NotNull
        private final SqlStatement statement;
        private final int distance;

        public StatementCandidate(@NotNull SqlStatement statement, int distance) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            this.statement = statement;
            this.distance = distance;
        }

        @NotNull
        public final SqlStatement getStatement() {
            return this.statement;
        }

        public final int getDistance() {
            return this.distance;
        }

        @NotNull
        public final SqlStatement component1() {
            return this.statement;
        }

        public final int component2() {
            return this.distance;
        }

        @NotNull
        public final StatementCandidate copy(@NotNull SqlStatement statement, int distance) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            return new StatementCandidate(statement, distance);
        }

        public static /* synthetic */ StatementCandidate copy$default(StatementCandidate statementCandidate, SqlStatement sqlStatement, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                sqlStatement = statementCandidate.statement;
            }
            if ((n2 & 2) != 0) {
                n = statementCandidate.distance;
            }
            return statementCandidate.copy(sqlStatement, n);
        }

        @NotNull
        public String toString() {
            return "StatementCandidate(statement=" + this.statement + ", distance=" + this.distance + ")";
        }

        public int hashCode() {
            int result2 = this.statement.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.distance);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StatementCandidate)) {
                return false;
            }
            StatementCandidate statementCandidate = (StatementCandidate)other;
            if (!Intrinsics.areEqual((Object)this.statement, (Object)statementCandidate.statement)) {
                return false;
            }
            return this.distance == statementCandidate.distance;
        }
    }
}

