/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.tasks;

import ai.grazie.model.llm.chat.v5.LLMChat;
import ai.grazie.model.llm.chat.v5.LLMChatAssistantMessage;
import ai.grazie.model.llm.chat.v5.LLMChatAssistantMessageText;
import ai.grazie.model.llm.chat.v5.LLMChatAssistantMessageTool;
import ai.grazie.model.llm.chat.v5.LLMChatFunctionMessage;
import ai.grazie.model.llm.chat.v5.LLMChatMediaMessage;
import ai.grazie.model.llm.chat.v5.LLMChatMessage;
import ai.grazie.model.llm.chat.v5.LLMChatReasoningMessage;
import ai.grazie.model.llm.chat.v5.LLMChatSystemMessage;
import ai.grazie.model.llm.chat.v5.LLMChatToolMessage;
import ai.grazie.model.llm.chat.v5.LLMChatUserMessage;
import ai.grazie.model.llm.parameters.LLMParameters;
import ai.grazie.utils.attributes.Attributes;
import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0004\u00a8\u0006\u0005"}, d2={"customTemperatureParameters", "Lai/grazie/utils/attributes/Attributes;", "stringify", "", "Lai/grazie/model/llm/chat/v5/LLMChat;", "intellij.ml.llm.tasks"})
public final class UtilsKt {
    @NotNull
    public static final Attributes customTemperatureParameters() {
        if (Registry.Companion.is("llm.request.override.default.temperature")) {
            return new Attributes().put((Attributes.Key)LLMParameters.INSTANCE.getTemperature(), (Attributes.Value)new Attributes.Value.Double(Registry.Companion.doubleValue("llm.request.custom.temperature.value"), null, 2, null));
        }
        return Attributes.Companion.getEmpty();
    }

    @NotNull
    public static final String stringify(@NotNull LLMChat $this$stringify) {
        Intrinsics.checkNotNullParameter((Object)$this$stringify, (String)"<this>");
        return ArraysKt.joinToString$default((Object[])$this$stringify.getMessages(), (CharSequence)"\n\n", null, null, (int)0, null, UtilsKt::stringify$lambda$0, (int)30, null);
    }

    private static final CharSequence stringify$lambda$0(LLMChatMessage it) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LLMChatMessage lLMChatMessage = it;
        if (lLMChatMessage instanceof LLMChatUserMessage) {
            charSequence = "User: " + ((LLMChatUserMessage)it).getContent();
        } else if (lLMChatMessage instanceof LLMChatAssistantMessage) {
            charSequence = "AI Assistant: " + ((LLMChatAssistantMessage)it).getContent() + ", functionCall: " + ((LLMChatAssistantMessage)it).getFunctionCall();
        } else if (lLMChatMessage instanceof LLMChatSystemMessage) {
            charSequence = "System: " + ((LLMChatSystemMessage)it).getContent();
        } else if (lLMChatMessage instanceof LLMChatFunctionMessage) {
            charSequence = "Function: " + ((LLMChatFunctionMessage)it).getContent() + ", functionName: " + ((LLMChatFunctionMessage)it).getFunctionName();
        } else if (lLMChatMessage instanceof LLMChatAssistantMessageText) {
            charSequence = "AI Assistant: " + ((LLMChatAssistantMessageText)it).getContent();
        } else if (lLMChatMessage instanceof LLMChatAssistantMessageTool) {
            charSequence = "Tool: " + ((LLMChatAssistantMessageTool)it).getContent() + ", toolName: " + ((LLMChatAssistantMessageTool)it).getToolName();
        } else if (lLMChatMessage instanceof LLMChatToolMessage) {
            charSequence = "Tool result: " + ((LLMChatToolMessage)it).getContent() + ", toolName: " + ((LLMChatToolMessage)it).getToolName();
        } else if (lLMChatMessage instanceof LLMChatMediaMessage) {
            String string = ((LLMChatMediaMessage)it).getContent();
            charSequence = "Media: " + ((LLMChatMediaMessage)it).getMediaType() + ", contentSize: " + (string != null ? Integer.valueOf(string.length()) : null);
        } else if (lLMChatMessage instanceof LLMChatReasoningMessage) {
            charSequence = "Reasoning: " + ((LLMChatReasoningMessage)it).getSummary() + ", contentSize: " + ((LLMChatReasoningMessage)it).getContent().length();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return charSequence;
    }
}

