/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.tokenizer;

import ai.grazie.model.llm.chat.v5.LLMChat;
import ai.grazie.model.llm.chat.v5.LLMChatMessage;
import ai.grazie.model.llm.tokens.LLMTokenCounter;
import ai.grazie.utils.attributes.Attributes;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.ml.llm.tokenizer.Tokenizer;
import com.intellij.ml.llm.tokenizer.TrimTokenizer;
import com.intellij.ml.llm.tokenizer.fus.PromptSource;
import com.intellij.ml.llm.tokenizer.fus.TokenizerLimitLogger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0002\u0010\u0017J\"\u0010\u0018\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\"\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\"\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u00072\b\u0010\u001f\u001a\u0004\u0018\u00010\u001bH\u0002J\u0014\u0010 \u001a\u00020!2\n\u0010\"\u001a\u00060#j\u0002`$H\u0002J \u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J \u0010(\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00072\b\u0010\u001f\u001a\u0004\u0018\u00010\u001bJ*\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\b\u0010\u001f\u001a\u0004\u0018\u00010\u001bJ*\u0010+\u001a\u0004\u0018\u00010*2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010,\u001a\u00020*2\u0006\u0010\u0019\u001a\u00020\u00072\b\u0010\u001f\u001a\u0004\u0018\u00010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/ml/llm/tokenizer/Tokenizer;", "Lcom/intellij/ml/llm/tokenizer/TrimTokenizer;", "counter", "Lai/grazie/model/llm/tokens/LLMTokenCounter;", "<init>", "(Lai/grazie/model/llm/tokens/LLMTokenCounter;)V", "count", "", "text", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getAdjuster", "Lai/grazie/model/llm/tokens/LLMTokenCounter$Adjuster;", "countTokensInChat", "chat", "Lai/grazie/model/llm/chat/v5/LLMChat;", "parameters", "Lai/grazie/utils/attributes/Attributes;", "(Lai/grazie/model/llm/chat/v5/LLMChat;Lai/grazie/utils/attributes/Attributes;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "countTokensInMessage", "message", "Lai/grazie/model/llm/chat/v5/LLMChatMessage;", "(Lai/grazie/model/llm/chat/v5/LLMChatMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "trim", "limit", "promptSource", "Lcom/intellij/ml/llm/tokenizer/fus/PromptSource;", "trimFromReader", "reader", "Ljava/io/Reader;", "source", "trimBuilderToLastWord", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "findLastFittingIndex", "line", "currentSum", "trimEnd", "trimRangeAroundLine", "Lcom/intellij/openapi/util/TextRange;", "trimRangeAroundSelection", "selection", "intellij.ml.llm.tokenizer"})
@SourceDebugExtension(value={"SMAP\nTokenizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Tokenizer.kt\ncom/intellij/ml/llm/tokenizer/Tokenizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n1#2:207\n*E\n"})
public final class Tokenizer
implements TrimTokenizer {
    @NotNull
    private final LLMTokenCounter counter;

    public Tokenizer(@NotNull LLMTokenCounter counter) {
        Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
        this.counter = counter;
    }

    public final int count(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return this.counter.count(text2);
    }

    public final int count(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        int sum = 0;
        int charsRead = 0;
        InputStream inputStream = virtualFile2.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader2 = new InputStreamReader(inputStream2, charset);
        int n = 8192;
        BufferedReader reader3 = reader2 instanceof BufferedReader ? (BufferedReader)reader2 : new BufferedReader(reader2, n);
        int lengthToRead = 80;
        char[] buffer = new char[lengthToRead];
        while (true) {
            int n2;
            int it = n2 = reader3.read(buffer, 0, lengthToRead);
            boolean bl = false;
            charsRead = it;
            if (n2 == -1) break;
            if (charsRead <= 0) continue;
            sum += this.count(new String(buffer, 0, charsRead));
        }
        return sum;
    }

    @NotNull
    public final LLMTokenCounter.Adjuster getAdjuster() {
        return this.counter.getAdjuster();
    }

    @Nullable
    public final Object countTokensInChat(@NotNull LLMChat chat, @NotNull Attributes parameters, @NotNull Continuation<? super Integer> $completion) {
        return this.counter.countContextTokens(chat, parameters, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object countTokensInMessage(@NotNull LLMChatMessage message, @NotNull Continuation<? super Integer> $completion) {
        if (!($completion instanceof countTokensInMessage.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ Tokenizer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.countTokensInMessage(null, (Continuation<? super Integer>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = message;
                $continuation.label = 1;
                v0 = this.counter.count(message, (Continuation)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                message = (LLMChatMessage)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                return Boxing.boxInt((int)(((Number)v0).intValue() + ((Number)this.counter.getAdjuster().getMessage().invoke((Object)message)).intValue()));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @NotNull
    public String trim(@NotNull String text2, int limit, @Nullable PromptSource promptSource) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return this.trimFromReader(new StringReader(text2), limit, promptSource);
    }

    @Override
    @NotNull
    public String trim(@NotNull VirtualFile virtualFile2, int limit, @Nullable PromptSource promptSource) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        InputStream inputStream = virtualFile2.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader2 = new InputStreamReader(inputStream2, charset);
        int n = 8192;
        return this.trimFromReader(reader2 instanceof BufferedReader ? (BufferedReader)reader2 : new BufferedReader(reader2, n), limit, promptSource);
    }

    private final String trimFromReader(Reader reader2, int limit, PromptSource source) {
        int sum = 0;
        int lengthToRead = 80;
        int charsRead = 0;
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[lengthToRead];
        while (true) {
            int n;
            int it = n = reader2.read(buffer, 0, lengthToRead);
            boolean bl = false;
            charsRead = it;
            if (n == -1) break;
            String chunk = new String(buffer, 0, charsRead);
            int tokens2 = this.count(chunk);
            if (sum + tokens2 > limit) {
                int lastIndex = this.findLastFittingIndex(chunk, sum, limit);
                if (lastIndex > 0) {
                    builder.append(StringsKt.take((String)chunk, (int)lastIndex));
                } else {
                    this.trimBuilderToLastWord(builder);
                }
                if (source == null) break;
                TokenizerLimitLogger.fireLimitExceeded(source, -1, builder.length(), limit, false);
                break;
            }
            builder.append(chunk);
            sum += tokens2;
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void trimBuilderToLastWord(StringBuilder builder) {
        int lastWordEnd;
        if (((CharSequence)builder).length() == 0) {
            return;
        }
        for (lastWordEnd = builder.length() - 1; lastWordEnd >= 0 && !CharsKt.isWhitespace((char)builder.charAt(lastWordEnd)); --lastWordEnd) {
        }
        builder.setLength(Math.max(0, lastWordEnd + 1));
    }

    private final int findLastFittingIndex(String line, int currentSum, int limit) {
        MatchResult match;
        int wordEnd;
        int wordTokens;
        Regex regex = new Regex("(\\s+|,+)");
        int lastIdx = 0;
        Iterator iterator = Regex.findAll$default((Regex)regex, (CharSequence)line, (int)0, (int)2, null).iterator();
        while (iterator.hasNext() && currentSum + (wordTokens = this.count(StringsKt.take((String)line, (int)(wordEnd = (match = (MatchResult)iterator.next()).getRange().getLast())))) <= limit) {
            lastIdx = wordEnd;
        }
        return lastIdx;
    }

    @NotNull
    public final String trimEnd(@NotNull String text2, int limit, @Nullable PromptSource source) {
        String line;
        int tokens2;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        int sum = 0;
        int offset = 0;
        String[] stringArray = new String[]{"\n"};
        Iterator iterator = CollectionsKt.reversed((Iterable)StringsKt.split$default((CharSequence)text2, (String[])stringArray, (boolean)false, (int)0, (int)6, null)).iterator();
        while (iterator.hasNext() && sum + (tokens2 = this.count(line = (String)iterator.next()) + 1) <= limit) {
            offset += line.length() + 1;
            sum += tokens2;
        }
        int newSize = Math.min(text2.length(), offset);
        if (newSize != text2.length() && source != null) {
            TokenizerLimitLogger.fireLimitExceeded(source, text2.length(), newSize, limit, false);
        }
        String string = text2.substring(text2.length() - newSize, text2.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @Nullable
    public final TextRange trimRangeAroundLine(@NotNull String text2, int line, int limit, @Nullable PromptSource source) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        LineOffsets lineOffsets = LineOffsetsUtil.create((CharSequence)text2);
        Intrinsics.checkNotNullExpressionValue((Object)lineOffsets, (String)"create(...)");
        LineOffsets lineOffset = lineOffsets;
        return this.trimRangeAroundSelection(text2, new TextRange(lineOffset.getLineStart(line), lineOffset.getLineEnd(line)), limit, source);
    }

    @Nullable
    public final TextRange trimRangeAroundSelection(@NotNull String text2, @NotNull TextRange selection, int limit, @Nullable PromptSource source) {
        TextRange truncatedRange;
        int n;
        int i;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        int startOffset = selection.getStartOffset();
        int endOffset = selection.getEndOffset();
        String string = text2.substring(startOffset, endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        int sum = this.count(string);
        if (sum > limit) {
            return null;
        }
        String[] stringArray = new String[]{"\n"};
        List lines2 = StringsKt.split$default((CharSequence)text2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        int lineCount = lines2.size();
        LineOffsets lineOffsets = LineOffsetsUtil.create((CharSequence)text2);
        Intrinsics.checkNotNullExpressionValue((Object)lineOffsets, (String)"create(...)");
        LineOffsets lineOffset = lineOffsets;
        int startOffsetLineNumber = lineOffset.getLineNumber(startOffset);
        int endOffsetLineNumber = lineOffset.getLineNumber(endOffset);
        String string2 = text2.substring(lineOffset.getLineStart(startOffsetLineNumber), selection.getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String textOnLineBeforeSelection = string2;
        int tokensBeforeSelection = this.count(textOnLineBeforeSelection);
        if (sum + tokensBeforeSelection < limit) {
            startOffset -= textOnLineBeforeSelection.length() + 1;
            sum += tokensBeforeSelection;
        }
        String string3 = text2.substring(selection.getEndOffset(), lineOffset.getLineEnd(endOffsetLineNumber));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String textOnLineAfterSelection = string3;
        int tokensAfterSelection = this.count(textOnLineAfterSelection);
        if (sum + tokensAfterSelection < limit) {
            endOffset += textOnLineAfterSelection.length() + 1;
            sum += tokensAfterSelection;
        }
        if ((i = 1) <= (n = Math.max(startOffsetLineNumber, lineCount - endOffsetLineNumber))) {
            while (true) {
                if (startOffsetLineNumber - i >= 0) {
                    int tokensLineBefore = this.count((String)lines2.get(startOffsetLineNumber - i)) + 1;
                    if (sum + tokensLineBefore > limit) break;
                    startOffset -= ((String)lines2.get(startOffsetLineNumber - i)).length() + 1;
                    sum += tokensLineBefore;
                }
                if (endOffsetLineNumber + i < lineCount) {
                    int tokensAfterBefore = this.count((String)lines2.get(endOffsetLineNumber + i)) + 1;
                    if (sum + tokensAfterBefore > limit) break;
                    endOffset += ((String)lines2.get(endOffsetLineNumber + i)).length() + 1;
                    sum += tokensAfterBefore;
                }
                if (i == n) break;
                ++i;
            }
        }
        if (!Intrinsics.areEqual((Object)(truncatedRange = new TextRange(Math.max(0, startOffset), Math.min(text2.length(), endOffset))), (Object)selection) && source != null) {
            TokenizerLimitLogger.fireLimitExceeded(source, selection.getLength(), truncatedRange.getLength(), limit, false);
        }
        return truncatedRange;
    }
}

