/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.chatInputLanguage.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.completion.chat.ChatReferenceCompletionProvider;
import com.intellij.ml.llm.core.chat.services.AIAssistantServiceScope;
import com.intellij.ml.llm.vcs.chatInputLanguage.completion.ChatInputCommitCompletionProviderKt;
import com.intellij.ml.llm.vcs.chatInputLanguage.extensions.ChatInputCommitReferenceKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.GitCommit;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitLogUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/vcs/chatInputLanguage/completion/ChatInputCommitCompletionProvider;", "Lcom/intellij/ml/llm/completion/chat/ChatReferenceCompletionProvider;", "<init>", "()V", "referenceType", "", "getReferenceType", "()Ljava/lang/String;", "addCompletions", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "CommitInsertHandler", "intellij.ml.llm.vcs"})
public final class ChatInputCommitCompletionProvider
extends ChatReferenceCompletionProvider {
    @NotNull
    private final String referenceType;

    public ChatInputCommitCompletionProvider() {
        this.referenceType = "commit";
    }

    @NotNull
    public String getReferenceType() {
        return this.referenceType;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Project project2 = parameters.getPosition().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        CoroutineScope scope = AIAssistantServiceScope.Companion.getScope(project3);
        CompletionResultSet completionResultSet = result2.caseInsensitive();
        Intrinsics.checkNotNullExpressionValue((Object)completionResultSet, (String)"caseInsensitive(...)");
        CompletionResultSet result3 = completionResultSet;
        PrefixMatcher prefixMatcher = result3.getPrefixMatcher();
        Intrinsics.checkNotNullExpressionValue((Object)prefixMatcher, (String)"getPrefixMatcher(...)");
        PrefixMatcher matcher = prefixMatcher;
        Job fetchCommitsJob2 = BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project3, matcher, result3, this, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ PrefixMatcher $matcher;
            final /* synthetic */ CompletionResultSet $result;
            final /* synthetic */ ChatInputCommitCompletionProvider this$0;
            {
                this.$project = $project;
                this.$matcher = $matcher;
                this.$result = $result;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$project, this.$matcher, this.$result, this.this$0, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ PrefixMatcher $matcher;
                            final /* synthetic */ CompletionResultSet $result;
                            final /* synthetic */ ChatInputCommitCompletionProvider this$0;
                            {
                                this.$project = $project;
                                this.$matcher = $matcher;
                                this.$result = $result;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        int limit = Registry.Companion.intValue("ide.completion.variant.limit");
                                        for (VcsRoot root : ProjectLevelVcsManager.getInstance((Project)this.$project).getAllVcsRoots()) {
                                            void $this$coroutineScope;
                                            BuildersKt.launch$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$matcher, limit, this.$project, root, this.$result, this.this$0, null){
                                                int label;
                                                final /* synthetic */ PrefixMatcher $matcher;
                                                final /* synthetic */ int $limit;
                                                final /* synthetic */ Project $project;
                                                final /* synthetic */ VcsRoot $root;
                                                final /* synthetic */ CompletionResultSet $result;
                                                final /* synthetic */ ChatInputCommitCompletionProvider this$0;
                                                {
                                                    this.$matcher = $matcher;
                                                    this.$limit = $limit;
                                                    this.$project = $project;
                                                    this.$root = $root;
                                                    this.$result = $result;
                                                    this.this$0 = $receiver;
                                                    super(2, $completion);
                                                }

                                                public final Object invokeSuspend(Object $result) {
                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            String string = this.$matcher.getPrefix();
                                                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPrefix(...)");
                                                            int batchSize = ((CharSequence)string).length() == 0 ? 100 : 1000;
                                                            int fetchedCommits = 0;
                                                            int reportedCommits = 0;
                                                            while (reportedCommits < this.$limit) {
                                                                Object object;
                                                                try {
                                                                    String[] stringArray = new String[]{"--skip=" + fetchedCommits, "--max-count=" + batchSize};
                                                                    object = GitLogUtil.collectMetadata((Project)this.$project, (VirtualFile)this.$root.getPath(), (String[])stringArray).getCommits();
                                                                    Intrinsics.checkNotNull((Object)object);
                                                                }
                                                                catch (VcsException e) {
                                                                    ChatInputCommitCompletionProviderKt.access$getLOG$p().debug("Failed to collect git commits", (Throwable)e);
                                                                    object = CollectionsKt.emptyList();
                                                                }
                                                                List commits2 = object;
                                                                if (commits2.isEmpty()) break;
                                                                fetchedCommits += commits2.size();
                                                                for (VcsCommitMetadata commit : commits2) {
                                                                    LookupElement lookupElement;
                                                                    double priority = -reportedCommits;
                                                                    Intrinsics.checkNotNull((Object)commit);
                                                                    Intrinsics.checkNotNullExpressionValue((Object)PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)ChatInputCommitCompletionProvider.access$addCompletions$createLookupElement(this.$project, this.this$0, commit)), (double)priority), (String)"withPriority(...)");
                                                                    if (!this.$matcher.prefixMatches(lookupElement)) continue;
                                                                    this.$matcher.prefixMatches(lookupElement);
                                                                    this.$result.addElement(lookupElement);
                                                                    ++reportedCommits;
                                                                }
                                                            }
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (int)3, null);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(fetchCommitsJob2, null){
            Object L$0;
            int label;
            final /* synthetic */ Job $fetchCommitsJob;
            {
                this.$fetchCommitsJob = $fetchCommitsJob;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$fetchCommitsJob.join((Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Object object3;
                        Object object2;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (CancellationException e) {
                            this.L$0 = e;
                            this.label = 2;
                            object3 = JobKt.cancelAndJoin((Job)this.$fetchCommitsJob, (Continuation)((Continuation)this));
                            if (object3 != object) throw e;
                            return object;
                        }
                    }
                    case 2: {
                        CancellationException e = (CancellationException)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw e;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final LookupElementBuilder addCompletions$createLookupElement(Project project2, ChatInputCommitCompletionProvider this$0, VcsCommitMetadata metadata) {
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)metadata, (String)((Hash)metadata.getId()).toShortString()).withIcon(AllIcons.Vcs.CommitNode).withTypeText(metadata.getSubject()).withInsertHandler((InsertHandler)new CommitInsertHandler(project2, metadata)).withLookupString("#" + this$0.getReferenceType() + ":" + ((Hash)metadata.getId()).toShortString()).withLookupString("#" + this$0.getReferenceType() + ":" + metadata.getSubject()).withLookupString("@" + this$0.getReferenceType() + ":" + ((Hash)metadata.getId()).toShortString()).withLookupString("@" + this$0.getReferenceType() + ":" + metadata.getSubject());
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withLookupString(...)");
        return lookupElementBuilder;
    }

    public static final /* synthetic */ LookupElementBuilder access$addCompletions$createLookupElement(Project project2, ChatInputCommitCompletionProvider this$0, VcsCommitMetadata metadata) {
        return ChatInputCommitCompletionProvider.addCompletions$createLookupElement(project2, this$0, metadata);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/vcs/chatInputLanguage/completion/ChatInputCommitCompletionProvider$CommitInsertHandler;", "Lcom/intellij/ml/llm/completion/chat/ChatReferenceCompletionProvider$ChatReferenceInsertionHandler;", "project", "Lcom/intellij/openapi/project/Project;", "metadata", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/VcsCommitMetadata;)V", "referenceType", "", "getReferenceType", "()Ljava/lang/String;", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "getCommitFromItsMetadata", "Lgit4idea/GitCommit;", "intellij.ml.llm.vcs"})
    private static final class CommitInsertHandler
    implements ChatReferenceCompletionProvider.ChatReferenceInsertionHandler {
        @NotNull
        private final Project project;
        @NotNull
        private final VcsCommitMetadata metadata;
        @NotNull
        private final String referenceType;

        public CommitInsertHandler(@NotNull Project project2, @NotNull VcsCommitMetadata metadata) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
            this.project = project2;
            this.metadata = metadata;
            this.referenceType = "commit";
        }

        @NotNull
        public String getReferenceType() {
            return this.referenceType;
        }

        public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            super.handleInsert(context2, item);
            PsiFile psiFile = context2.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
            PsiFile psiFile2 = psiFile;
            ConcurrentHashMap<String, Ref<GitCommit>> concurrentHashMap = ChatInputCommitReferenceKt.getReferencedCommits(psiFile2);
            if (concurrentHashMap == null) {
                return;
            }
            ConcurrentHashMap<String, Ref<GitCommit>> referencedCommitMap = concurrentHashMap;
            Application application = ApplicationManager.getApplication();
            application.executeOnPooledThread(() -> CommitInsertHandler.handleInsert$lambda$0(this, referencedCommitMap));
        }

        private final GitCommit getCommitFromItsMetadata() {
            Ref.ObjectRef gitCommit = new Ref.ObjectRef();
            GitLogUtil.readFullDetailsForHashes((Project)this.project, (VirtualFile)this.metadata.getRoot(), (List)CollectionsKt.listOf((Object)((Hash)this.metadata.getId()).asString()), (GitCommitRequirements)GitCommitRequirements.DEFAULT, arg_0 -> CommitInsertHandler.getCommitFromItsMetadata$lambda$2(arg_0 -> CommitInsertHandler.getCommitFromItsMetadata$lambda$1(gitCommit, arg_0), arg_0));
            return (GitCommit)gitCommit.element;
        }

        private static final void handleInsert$lambda$0(CommitInsertHandler this$0, ConcurrentHashMap $referencedCommitMap) {
            GitCommit commit = this$0.getCommitFromItsMetadata();
            if (commit != null) {
                ((Map)$referencedCommitMap).put(((Hash)this$0.metadata.getId()).toShortString(), new Ref((Object)commit));
            }
        }

        private static final Unit getCommitFromItsMetadata$lambda$1(Ref.ObjectRef $gitCommit, GitCommit it) {
            $gitCommit.element = it;
            return Unit.INSTANCE;
        }

        private static final void getCommitFromItsMetadata$lambda$2(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }
    }
}

