/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.markdown;

import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.ml.llm.core.statistics.CommonLoggerServiceKt;
import com.intellij.ml.llm.core.statistics.CompositeStatisticsIdeActivity;
import com.intellij.ml.llm.core.statistics.ScoreResult;
import com.intellij.ml.llm.vcs.LLMVcsBundle;
import com.intellij.ml.llm.vcs.markdown.VcsLogLinkProvider;
import com.intellij.ml.llm.vcs.summary.GenerateCommitSummary;
import com.intellij.ml.llm.vcs.summary.GenerateCommitSummaryLogUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.TabGroupId;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogRangeFilter;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcsUtil.VcsUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.extensions.MarkdownBrowserPreviewExtension;
import org.intellij.plugins.markdown.ui.preview.BrowserPipe;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000I\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002*\u0001\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002Jt\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\f2\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00142\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00142\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00142\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00142\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/vcs/markdown/VcsLogLinkProvider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "<init>", "(Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;)V", "handler", "com/intellij/ml/llm/vcs/markdown/VcsLogLinkProvider$handler$1", "Lcom/intellij/ml/llm/vcs/markdown/VcsLogLinkProvider$handler$1;", "openVcsLogByURL", "", "link", "", "createFilterCollection", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "project", "Lcom/intellij/openapi/project/Project;", "author", "email", "pathParameters", "", "rangeParameters", "hashParameters", "rootParameters", "dateParameters", "", "dispose", "", "Provider", "intellij.ml.llm.vcs.markdown"})
@SourceDebugExtension(value={"SMAP\nVcsLogLinkProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogLinkProvider.kt\ncom/intellij/ml/llm/vcs/markdown/VcsLogLinkProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1563#2:134\n1634#2,3:135\n1563#2:138\n1634#2,2:139\n1636#2:142\n1563#2:143\n1634#2,3:144\n1#3:141\n*S KotlinDebug\n*F\n+ 1 VcsLogLinkProvider.kt\ncom/intellij/ml/llm/vcs/markdown/VcsLogLinkProvider\n*L\n101#1:134\n101#1:135,3\n105#1:138\n105#1:139,2\n105#1:142\n113#1:143\n113#1:144,3\n*E\n"})
public final class VcsLogLinkProvider
implements MarkdownBrowserPreviewExtension {
    @NotNull
    private final MarkdownHtmlPanel panel;
    @NotNull
    private final handler.1 handler;

    public VcsLogLinkProvider(@NotNull MarkdownHtmlPanel panel2) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        this.panel = panel2;
        this.handler = new BrowserPipe.Handler(this){
            final /* synthetic */ VcsLogLinkProvider this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean processMessageReceived(String data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return VcsLogLinkProvider.access$openVcsLogByURL(this.this$0, data);
            }
        };
        BrowserPipe browserPipe = this.panel.getBrowserPipe();
        if (browserPipe != null) {
            browserPipe.subscribe("openLink", (BrowserPipe.Handler)this.handler);
        }
        Disposer.register((Disposable)((Disposable)this), () -> VcsLogLinkProvider._init_$lambda$0(this));
        if (this.panel instanceof MarkdownHtmlPanelEx) {
            ((MarkdownHtmlPanelEx)this.panel).putUserData(MarkdownHtmlPanelEx.Companion.getDO_NOT_USE_LINK_OPENER(), (Object)true);
        }
    }

    private final boolean openVcsLogByURL(String link2) {
        if (!Registry.Companion.is("markdown.open.vcs.log.link")) {
            return true;
        }
        URI uri = URI.create(link2);
        if (!Intrinsics.areEqual((Object)uri.getScheme(), (Object)"vcs") || !Intrinsics.areEqual((Object)uri.getAuthority(), (Object)"open_log")) {
            return true;
        }
        Map parameters = new QueryStringDecoder(uri).parameters();
        List list = (List)parameters.get("user");
        String author = list != null ? (String)CollectionsKt.first((List)list) : null;
        List list2 = (List)parameters.get("email");
        String email = list2 != null ? (String)CollectionsKt.first((List)list2) : null;
        Object object = (List)parameters.get("tab_id");
        if (object == null || (object = (String)CollectionsKt.first((List)object)) == null) {
            return true;
        }
        Object tabId = object;
        List rangeParameters = (List)parameters.get(VcsLogFilterCollection.RANGE_FILTER.getName());
        List hashParameters = (List)parameters.get(VcsLogFilterCollection.HASH_FILTER.getName());
        List pathParameters = (List)parameters.get(VcsLogFilterCollection.STRUCTURE_FILTER.getName());
        List rootParameters = (List)parameters.get(VcsLogFilterCollection.ROOT_FILTER.getName());
        List dateParameters = (List)parameters.get(VcsLogFilterCollection.DATE_FILTER.getName());
        Object object2 = (List)parameters.get("generated_message_length");
        if (object2 == null || (object2 = (String)CollectionsKt.first((List)object2)) == null) {
            return true;
        }
        int generatedMessageLength = Integer.parseInt((String)object2);
        Project project2 = this.panel.getProject();
        if (project2 == null) {
            return true;
        }
        Project project3 = project2;
        CompositeStatisticsIdeActivity compositeStatisticsIdeActivity = GenerateCommitSummary.Companion.getActivity(project3);
        if (compositeStatisticsIdeActivity == null) {
            return true;
        }
        CompositeStatisticsIdeActivity activity2 = compositeStatisticsIdeActivity;
        activity2.scored(ScoreResult.YES, () -> VcsLogLinkProvider.openVcsLogByURL$lambda$1(author, email, generatedMessageLength));
        VcsLogFilterCollection filterCollection = this.createFilterCollection(project3, author, email, pathParameters, rangeParameters, hashParameters, rootParameters, dateParameters);
        ActionsKt.runInEdt$default(null, () -> VcsLogLinkProvider.openVcsLogByURL$lambda$2(project3, filterCollection, (String)tabId), (int)1, null);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final VcsLogFilterCollection createFilterCollection(Project project2, String author, String email, List<String> pathParameters, List<String> rangeParameters, List<String> hashParameters, List<String> rootParameters, List<String> dateParameters) {
        VcsLogDateFilter vcsLogDateFilter;
        VcsLogRootFilter vcsLogRootFilter;
        VcsLogStructureFilter vcsLogStructureFilter;
        VcsLogUserFilter vcsLogUserFilter;
        VcsLogRangeFilter vcsLogRangeFilter;
        VcsLogHashFilter vcsLogHashFilter;
        List list;
        Iterable logRange;
        List list2;
        Object object;
        Iterable destination$iv$iv;
        VcsLogObjectsFactory factory = (VcsLogObjectsFactory)project2.getService(VcsLogObjectsFactory.class);
        VcsUser user = author != null && email != null ? factory.createUser(author, email) : null;
        List<String> list3 = pathParameters;
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List<String> paths = list3;
            boolean bl = false;
            Object object2 = new String[]{","};
            object2 = StringsKt.split$default((CharSequence)((CharSequence)CollectionsKt.first(paths)), (String[])object2, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            void var17_24 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Iterator item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)((Object)item$iv$iv);
                object = destination$iv$iv;
                boolean bl2 = false;
                object.add(VcsUtil.getFilePath((String)it, (boolean)true));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        List paths = list2;
        List<String> list4 = rangeParameters;
        if (list4 != null) {
            void $this$mapTo$iv$iv;
            List<String> range = list4;
            boolean bl = false;
            Iterable $this$map$iv = range;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                object = (String)item$iv$iv;
                Collection bl2 = destination$iv$iv2;
                boolean bl3 = false;
                String[] stringArray = new String[]{".."};
                List it = StringsKt.split$default((CharSequence)((CharSequence)((Object)logRange)), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean bl4 = false;
                bl2.add(new VcsLogRangeFilter.RefRange((String)CollectionsKt.first((List)it), (String)CollectionsKt.last((List)it)));
            }
            list = (List)destination$iv$iv2;
        } else {
            list = null;
        }
        List ranges = list;
        List<String> list5 = hashParameters;
        if (list5 != null) {
            List<String> it = list5;
            boolean bl = false;
            vcsLogHashFilter = VcsLogFilterObject.fromHashes((Collection)it);
        } else {
            vcsLogHashFilter = null;
        }
        VcsLogHashFilter hashFilter = vcsLogHashFilter;
        List list6 = ranges;
        if (list6 != null) {
            List it = list6;
            boolean bl = false;
            vcsLogRangeFilter = VcsLogFilterObject.fromRange(ranges);
        } else {
            vcsLogRangeFilter = null;
        }
        VcsLogRangeFilter rangeFilter = vcsLogRangeFilter;
        VcsUser vcsUser = user;
        if (vcsUser != null) {
            VcsUser it = vcsUser;
            boolean bl = false;
            vcsLogUserFilter = VcsLogFilterObject.fromUser$default((VcsUser)it, null, (int)2, null);
        } else {
            vcsLogUserFilter = null;
        }
        VcsLogUserFilter userFilter = vcsLogUserFilter;
        List list7 = paths;
        if (list7 != null) {
            List it = list7;
            boolean bl = false;
            vcsLogStructureFilter = VcsLogFilterObject.fromPaths((Collection)it);
        } else {
            vcsLogStructureFilter = null;
        }
        VcsLogStructureFilter structureFilter = vcsLogStructureFilter;
        List<String> list8 = rootParameters;
        if (list8 != null) {
            void $this$mapTo$iv$iv;
            List<String> roots = list8;
            boolean bl = false;
            Iterable $this$map$iv = roots;
            boolean $i$f$map = false;
            logRange = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String bl4 = (String)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl5 = false;
                VirtualFile virtualFile2 = VfsUtil.findFile((Path)Path.of((String)it, new String[0]), (boolean)false);
                Intrinsics.checkNotNull((Object)virtualFile2);
                collection.add(virtualFile2);
            }
            vcsLogRootFilter = VcsLogFilterObject.fromRoots((Collection)((List)destination$iv$iv3));
        } else {
            vcsLogRootFilter = null;
        }
        VcsLogRootFilter rootFilter = vcsLogRootFilter;
        List<String> list9 = dateParameters;
        if (list9 != null) {
            Date date;
            Date date2;
            List<String> date3 = list9;
            boolean bl = false;
            String[] stringArray = new String[]{","};
            List list10 = StringsKt.split$default((CharSequence)((CharSequence)CollectionsKt.first(date3)), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean bl6 = false;
            Long l = StringsKt.toLongOrNull((String)((String)CollectionsKt.first((List)list10)));
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl7 = false;
                date2 = new Date(it);
            } else {
                date2 = null;
            }
            Long l2 = StringsKt.toLongOrNull((String)((String)CollectionsKt.last((List)list10)));
            if (l2 != null) {
                long it = ((Number)l2).longValue();
                Date date4 = date2;
                boolean bl8 = false;
                date = new Date(it);
                date2 = date4;
            } else {
                date = null;
            }
            vcsLogDateFilter = VcsLogFilterObject.fromDates((Date)date2, date);
        } else {
            vcsLogDateFilter = null;
        }
        VcsLogDateFilter dateFilter = vcsLogDateFilter;
        VcsLogFilter[] vcsLogFilterArray = new VcsLogFilter[]{rangeFilter, hashFilter, userFilter, structureFilter, dateFilter, rootFilter};
        return VcsLogFilterObject.collection((VcsLogFilter[])vcsLogFilterArray);
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0(VcsLogLinkProvider this$0) {
        block0: {
            BrowserPipe browserPipe = this$0.panel.getBrowserPipe();
            if (browserPipe == null) break block0;
            browserPipe.removeSubscription("openLink", (BrowserPipe.Handler)this$0.handler);
        }
    }

    private static final List openVcsLogByURL$lambda$1(String $author, String $email, int $generatedMessageLength) {
        Object[] objectArray = new EventPair[]{CommonLoggerServiceKt.getALL_SUMMARY_VCS_NAVIGATED().with((Object)($author == null && $email == null ? 1 : 0))};
        CollectionsKt.arrayListOf((Object[])objectArray);
        objectArray = new EventPair[]{CommonLoggerServiceKt.getGENERATED_SUMMARY_MESSAGE_LENGTH().with((Object)$generatedMessageLength)};
        return CollectionsKt.arrayListOf((Object[])objectArray);
    }

    private static final Unit openVcsLogByURL$lambda$2(Project $project, VcsLogFilterCollection $filterCollection, String $tabId) {
        GenerateCommitSummaryLogUi.INSTANCE.createLogUi($project, true, $filterCollection, new TabGroupId($tabId, LLMVcsBundle.messagePointer("action.ai.generated.summary.tab.name", new Object[0]), false, 4, null));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$openVcsLogByURL(VcsLogLinkProvider $this, String link2) {
        return $this.openVcsLogByURL(link2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/vcs/markdown/VcsLogLinkProvider$Provider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Provider;", "<init>", "()V", "createBrowserExtension", "Lcom/intellij/ml/llm/vcs/markdown/VcsLogLinkProvider;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "intellij.ml.llm.vcs.markdown"})
    public static final class Provider
    implements MarkdownBrowserPreviewExtension.Provider {
        @Nullable
        public VcsLogLinkProvider createBrowserExtension(@NotNull MarkdownHtmlPanel panel2) {
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            VirtualFile virtualFile2 = panel2.getVirtualFile();
            if (!(virtualFile2 != null ? Intrinsics.areEqual((Object)virtualFile2.getUserData(GenerateCommitSummary.Companion.getSUMMARY_LLM_MARKDOWN_EDITOR()), (Object)true) : false)) {
                return null;
            }
            return new VcsLogLinkProvider(panel2);
        }
    }
}

