/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.actions;

import com.intellij.codeWithMe.ClientId;
import com.intellij.llmInstaller.api.AiToolWindowService;
import com.intellij.ml.llm.core.AIAContainerPanelFacade;
import com.intellij.ml.llm.core.AIAContentFacade;
import com.intellij.ml.llm.core.settings.LLMSettingsManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.FontSizeModel;
import com.intellij.ui.FontSizePopup;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/core/chat/actions/AIAssistantToolwindowScale;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIAssistantToolwindowScale.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantToolwindowScale.kt\ncom/intellij/ml/llm/core/chat/actions/AIAssistantToolwindowScale\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,34:1\n30#2,2:35\n40#3,3:37\n*S KotlinDebug\n*F\n+ 1 AIAssistantToolwindowScale.kt\ncom/intellij/ml/llm/core/chat/actions/AIAssistantToolwindowScale\n*L\n18#1:35,2\n30#1:37,3\n*E\n"})
public final class AIAssistantToolwindowScale
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ToolWindow toolWindow = this.getToolWindow(e);
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        ComponentManager $this$service$iv = (ComponentManager)application;
        boolean $i$f$service = false;
        Class<LLMSettingsManager> serviceClass$iv = LLMSettingsManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        FontSizeModel fontSizeModel = (FontSizeModel)((LLMSettingsManager)object).getState().getToolwindowScaleModel();
        JComponent jComponent = toolWindow2.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        FontSizePopup.showFontSizePopup((FontSizeModel)fontSizeModel, (JComponent)jComponent);
    }

    public void update(@NotNull AnActionEvent e) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            AIAContainerPanelFacade aIAContainerPanelFacade = AIAContentFacade.Companion.getInstance(project).getPanel();
            if (aIAContainerPanelFacade == null) break block1;
            aIAContainerPanelFacade.isChatPanelActive();
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    private final ToolWindow getToolWindow(AnActionEvent e) {
        boolean $i$f$service = false;
        Class<AiToolWindowService> serviceClass$iv = AiToolWindowService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        return ((AiToolWindowService)object).getToolWindow(project);
    }
}

