/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.actions.codeSnippet;

import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.lang.Language;
import com.intellij.ml.llm.core.chat.messages.ChatMessage;
import com.intellij.ml.llm.core.chat.services.paste.CodeSnippetCopyPastePostProcessor;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.statistics.fus.AIAssistantChatEventLogger;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/core/chat/actions/codeSnippet/AIAssistantCopyToClipboardAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getTransferableData", "Ljava/awt/datatransfer/Transferable;", "text", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.chat"})
public final class AIAssistantCopyToClipboardAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
        Object object = editor;
        if (object == null || (object = object.getDocument()) == null || (object = object.getText()) == null) {
            return;
        }
        Object text2 = object;
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        CopyPasteManager.getInstance().setContents(this.getTransferableData((String)text2, editor, project2));
        ChatMessage message = (ChatMessage)e.getDataContext().getData(ChatMessage.Companion.getKey());
        ChatSession chatSession2 = (ChatSession)e.getDataContext().getData(ChatSession.Companion.getCurrentSession());
        if (message != null && chatSession2 != null) {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
            Language language = psiFile != null ? psiFile.getLanguage() : null;
            AIAssistantChatEventLogger.logCodeCopiedEvent(e.getProject(), chatSession2, message, language, AIAssistantChatEventLogger.CodeCopiedSource.BUTTON);
        }
    }

    private final Transferable getTransferableData(String text2, Editor editor, Project project) {
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        CodeSnippetCopyPastePostProcessor codeSnippetCopyPastePostProcessor = new CodeSnippetCopyPastePostProcessor();
        PsiFile psiFile = file;
        Intrinsics.checkNotNull((Object)psiFile);
        int[] nArray = new int[]{0};
        int[] nArray2 = nArray;
        nArray = new int[]{text2.length()};
        List<TextBlockTransferableData> data2 = codeSnippetCopyPastePostProcessor.collectTransferableData(psiFile, editor, nArray2, nArray);
        return (Transferable)new TextBlockTransferable(text2, (Collection)data2, new RawText(text2));
    }
}

