/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.actions.codeSnippet.createFile;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ml.llm.core.chat.actions.AIAssistantProjectViewLocationProvider;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/core/chat/actions/codeSnippet/createFile/AIAssistantCreateFileUtils;", "", "<init>", "()V", "getContainingDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "isInUserSourceCode", "", "virtualFile", "intellij.ml.llm.chat"})
public final class AIAssistantCreateFileUtils {
    @NotNull
    public static final AIAssistantCreateFileUtils INSTANCE = new AIAssistantCreateFileUtils();

    private AIAssistantCreateFileUtils() {
    }

    @Nullable
    public final VirtualFile getContainingDirectory(@NotNull Project project) {
        PsiFile psiFile;
        Editor projectOpenEditor;
        AbstractProjectViewPane projectViewPane;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        for (AIAssistantProjectViewLocationProvider extension : AIAssistantProjectViewLocationProvider.Companion.getEP_NAME().getExtensionList()) {
            VirtualFile location = extension.getLocation(project);
            if (location == null || PrivacyPathCheckerKt.isAiIgnoreBlocked((Project)project, (VirtualFile)location)) continue;
            return location;
        }
        ProjectView projectView = ProjectView.getInstance((Project)project);
        Object object = projectViewPane = projectView != null ? projectView.getCurrentProjectViewPane() : null;
        if (projectViewPane != null) {
            VirtualFile directoryProjectView;
            TreePath treePath = projectViewPane.getSelectedPath();
            Object selectedNode = treePath != null ? treePath.getLastPathComponent() : null;
            Object object2 = selectedNode;
            if (object2 instanceof AbstractTreeNode) {
                userObject = ((AbstractTreeNode)selectedNode).getValue();
                v3 = userObject instanceof VirtualDirectoryImpl ? (VirtualFile)userObject : (userObject instanceof VirtualFile ? ((VirtualFile)userObject).getParent() : null);
            } else if (object2 instanceof DefaultMutableTreeNode) {
                userObject = ((DefaultMutableTreeNode)selectedNode).getUserObject();
                if (userObject instanceof PsiDirectoryNode) {
                    v3 = ((PsiDirectoryNode)userObject).getVirtualFile();
                } else if (userObject instanceof PsiFileNode) {
                    VirtualFile virtualFile2 = ((PsiFileNode)userObject).getVirtualFile();
                    v3 = virtualFile2 != null ? virtualFile2.getParent() : null;
                } else {
                    v3 = null;
                }
            } else {
                v3 = directoryProjectView = null;
            }
            if (directoryProjectView != null && !PrivacyPathCheckerKt.isAiIgnoreBlocked((Project)project, (VirtualFile)directoryProjectView) && (selectedNode instanceof AbstractTreeNode || this.isInUserSourceCode(directoryProjectView, project))) {
                return directoryProjectView;
            }
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        Object object3 = projectOpenEditor = fileEditorManager != null ? fileEditorManager.getSelectedTextEditor() : null;
        if (projectOpenEditor != null && (psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(projectOpenEditor.getDocument())) != null && !PrivacyPathCheckerKt.isAiIgnoreBlocked((Project)project, (PsiFile)psiFile)) {
            VirtualFile virtualFile3 = psiFile.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getVirtualFile(...)");
            if (this.isInUserSourceCode(virtualFile3, project)) {
                return psiFile.getVirtualFile().getParent();
            }
        }
        return ProjectUtil.guessProjectDir((Project)project);
    }

    private final boolean isInUserSourceCode(VirtualFile virtualFile2, Project project) {
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex projectFileIndex2 = projectFileIndex;
        return projectFileIndex2.isInProject(virtualFile2) && !projectFileIndex2.isInLibrary(virtualFile2);
    }
}

