/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.context.providers;

import com.intellij.ml.llm.core.chat.context.ChatContextItem;
import com.intellij.ml.llm.core.chat.context.DumbAwareChatContextProvider;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.extensions.SharedExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.std.LocalDatePrivacyWrapper;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.util.NightlyRegistryUtils;
import com.intellij.openapi.project.Project;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/core/chat/context/providers/CurrentDateContextProvider;", "Lcom/intellij/ml/llm/core/chat/context/DumbAwareChatContextProvider;", "<init>", "()V", "isApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "chatSession", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "collect", "", "Lcom/intellij/ml/llm/core/chat/context/ChatContextItem;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/core/chat/session/ChatSession;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.chat"})
public final class CurrentDateContextProvider
implements DumbAwareChatContextProvider {
    @Override
    public boolean isApplicable(@NotNull Project project, @NotNull ChatSession chatSession2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)chatSession2, (String)"chatSession");
        if (NightlyRegistryUtils.INSTANCE.isEnabled("llm.chat.system.prompt.v2")) {
            return false;
        }
        return NightlyRegistryUtils.INSTANCE.isEnabled("llm.chat.context.current.date.enabled");
    }

    @Override
    @Nullable
    public Object collect(@NotNull Project project, @NotNull ChatSession chatSession2, @NotNull Continuation<? super List<ChatContextItem>> $completion) {
        String string = Reflection.getOrCreateKotlinClass(CurrentDateContextProvider.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        String identity = string;
        LocalDate localDate = LocalDate.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"now(...)");
        LocalDatePrivacyWrapper localDatePrivacyWrapper = SharedExtensionsKtKt.getPrivacySafe((LocalDate)localDate);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE;
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ISO_LOCAL_DATE");
        PSString currentDate = localDatePrivacyWrapper.format(dateTimeFormatter);
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{currentDate};
        return CollectionsKt.listOf((Object)new ChatContextItem(identity, ConstantsKt.getPrivacyConst((String)"Current date: %s").format(pSStringConvertibleArray), null, 4, null));
    }
}

