/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.context.renderer;

import com.intellij.ml.llm.context.RetrievalSession;
import com.intellij.ml.llm.core.chat.attachments.CurrentFileChatAttachment;
import com.intellij.ml.llm.core.chat.context.ContextItemRenderer;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/core/chat/context/renderer/CurrentFileChatAttachmentRenderer;", "Lcom/intellij/ml/llm/core/chat/context/ContextItemRenderer;", "Lcom/intellij/ml/llm/core/chat/attachments/CurrentFileChatAttachment;", "<init>", "()V", "isSupported", "", "item", "", "render", "Lcom/intellij/ml/llm/privacy/PSString;", "retrievalSession", "Lcom/intellij/ml/llm/context/RetrievalSession;", "intellij.ml.llm.chat"})
public final class CurrentFileChatAttachmentRenderer
implements ContextItemRenderer<CurrentFileChatAttachment> {
    @Override
    public boolean isSupported(@NotNull Object item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return item instanceof CurrentFileChatAttachment;
    }

    @Override
    @NotNull
    public PSString render(@NotNull RetrievalSession retrievalSession, @NotNull CurrentFileChatAttachment item) {
        PSString pSString;
        PSStringConvertible[] pSStringConvertibleArray;
        PSString fileName;
        Intrinsics.checkNotNullParameter((Object)retrievalSession, (String)"retrievalSession");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        VirtualFilePointer virtualFilePointer = item.getVirtualFilePointer();
        PSString pSString2 = virtualFilePointer != null && (virtualFilePointer = virtualFilePointer.getFile()) != null && (virtualFilePointer = ExtensionsKtKt.getPrivacySafe((VirtualFile)virtualFilePointer)) != null ? virtualFilePointer.getName() : (fileName = null);
        if (fileName != null && ((CharSequence)fileName).length() > 0) {
            pSStringConvertibleArray = new PSStringConvertible[]{fileName};
            pSString = ConstantsKt.getPrivacyConst((String)"%s (file currently opened in the editor)").format(pSStringConvertibleArray);
        } else {
            pSString = item.getName();
        }
        PSString caption = pSString;
        pSStringConvertibleArray = new PSStringConvertible[]{caption, item.getText()};
        return ConstantsKt.getPrivacyConst((String)"*%s*:\n%s").format(pSStringConvertibleArray);
    }
}

