/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.context.selection;

import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.context.selection.SelectionChatAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentBase;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentSource;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ProjectFileContextEntity;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 K2\u00020\u00012\u00020\u0002:\u0001KBe\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0013\u0010\u0014B\u0011\b\u0016\u0012\u0006\u0010\u0015\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0016J\u000e\u0010:\u001a\u00020;H\u0096@\u00a2\u0006\u0002\u0010<J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0016J\b\u0010(\u001a\u00020)H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\t\u001a\u0004\u0018\u00010\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0014\u0010\n\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010%\u001a\u0004\b#\u0010$R\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010%\u001a\u0004\b&\u0010$R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001cR\u001b\u0010(\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b*\u0010+R\u001f\u0010.\u001a\r\u0012\u0004\u0012\u00020\b0/\u00a2\u0006\u0002\b0X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u001f\u00103\u001a\r\u0012\u0004\u0012\u00020\b0/\u00a2\u0006\u0002\b0X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00102R\u000e\u00105\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u00106\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u001cR\u0014\u00108\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u001cR\u001a\u0010=\u001a\b\u0012\u0004\u0012\u00020\f0/X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u00102R\u0019\u0010C\u001a\u00070\u000e\u00a2\u0006\u0002\b0X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010\"R\u0014\u0010E\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010\u001cR\u0014\u0010G\u001a\u00020HX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010J\u00a8\u0006L"}, d2={"Lcom/intellij/ml/llm/core/chat/context/selection/SelectionContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentBase;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ProjectFileContextEntity;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "attachmentName", "", "additionalHint", "editorId", "attachmentIcon", "Ljavax/swing/Icon;", "selectedText", "Lcom/intellij/ml/llm/privacy/PSString;", "start", "", "end", "chatSessionUid", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;Lcom/intellij/ml/llm/privacy/PSString;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;)V", "originalAttachment", "(Lcom/intellij/ml/llm/core/chat/context/selection/SelectionContextAttachment;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getAttachmentName", "()Ljava/lang/String;", "getAdditionalHint", "getEditorId", "getAttachmentIcon", "()Ljavax/swing/Icon;", "getSelectedText", "()Lcom/intellij/ml/llm/privacy/PSString;", "getStart", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getEnd", "getChatSessionUid", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "virtualFile$delegate", "Lkotlin/Lazy;", "name", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "()Lcom/intellij/openapi/observable/properties/ObservableProperty;", "hint", "getHint", "ellipse", "tooltipText", "getTooltipText", "popupPresentationText", "getPopupPresentationText", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "icon", "getIcon", "performAction", "", "isInMessage", "", "text", "getText", "id", "getId", "attachedBy", "Lcom/intellij/ml/llm/context/ContextEntitySource;", "getAttachedBy", "()Lcom/intellij/ml/llm/context/ContextEntitySource;", "Companion", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nSelectionContextAttachment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionContextAttachment.kt\ncom/intellij/ml/llm/core/chat/context/selection/SelectionContextAttachment\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1#2:124\n774#3:125\n865#3,2:126\n*S KotlinDebug\n*F\n+ 1 SelectionContextAttachment.kt\ncom/intellij/ml/llm/core/chat/context/selection/SelectionContextAttachment\n*L\n93#1:125\n93#1:126,2\n*E\n"})
public final class SelectionContextAttachment
extends ContextAttachmentBase
implements ProjectFileContextEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final Editor editor;
    @NotNull
    private final String attachmentName;
    @Nullable
    private final String additionalHint;
    @NotNull
    private final String editorId;
    @Nullable
    private final Icon attachmentIcon;
    @NotNull
    private final PSString selectedText;
    @Nullable
    private final Integer start;
    @Nullable
    private final Integer end;
    @Nullable
    private final String chatSessionUid;
    @NotNull
    private final Lazy virtualFile$delegate;
    @NotNull
    private final ObservableProperty<String> name;
    @NotNull
    private final ObservableProperty<String> hint;
    @NotNull
    private final String ellipse;
    @NotNull
    private final String tooltipText;
    @NotNull
    private final String popupPresentationText;
    @NotNull
    private final ObservableProperty<Icon> icon;
    @NotNull
    private final PSString text;
    @NotNull
    private final String id;
    @NotNull
    private final ContextEntitySource attachedBy;
    @NotNull
    public static final String ID = "CONSOLE_SELECTION_VIA_RETRIEVER";
    private static final int MAX_TOOLTIP_LENGTH = 80;
    private static final int MAX_ADDITIONAL_HINT_LENGTH = 15;

    /*
     * WARNING - void declaration
     */
    public SelectionContextAttachment(@NotNull Project project, @Nullable Editor editor, @NotNull String attachmentName, @Nullable String additionalHint, @NotNull String editorId, @Nullable Icon attachmentIcon, @NotNull PSString selectedText, @Nullable Integer start2, @Nullable Integer end, @Nullable String chatSessionUid) {
        void $this$filterTo$iv$iv;
        void text2;
        String[] it;
        String $this$hint_u24lambda_u242;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)attachmentName, (String)"attachmentName");
        Intrinsics.checkNotNullParameter((Object)editorId, (String)"editorId");
        Intrinsics.checkNotNullParameter((Object)selectedText, (String)"selectedText");
        this.project = project;
        this.editor = editor;
        this.attachmentName = attachmentName;
        this.additionalHint = additionalHint;
        this.editorId = editorId;
        this.attachmentIcon = attachmentIcon;
        this.selectedText = selectedText;
        this.start = start2;
        this.end = end;
        this.chatSessionUid = chatSessionUid;
        this.virtualFile$delegate = LazyKt.lazy(() -> SelectionContextAttachment.virtualFile_delegate$lambda$0(this));
        this.name = (ObservableProperty)new AtomicProperty((Object)this.attachmentName);
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        SelectionContextAttachment selectionContextAttachment = this;
        boolean bl = false;
        if (this.additionalHint != null) {
            String string;
            String string2 = this.additionalHint;
            void var15_16 = $this$hint_u24lambda_u242;
            boolean bl2 = false;
            if (it.length() > 15) {
                String string3 = it.substring(0, 15);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                string = string3 + "\u2026";
            } else {
                string = it;
            }
            var15_16.append(string);
            ((StringBuilder)((Object)$this$hint_u24lambda_u242)).append(" ");
        }
        StringBuilder stringBuilder3 = this.start == null || this.end == null ? ((StringBuilder)((Object)$this$hint_u24lambda_u242)).append(this.selectedText.length()) : ((StringBuilder)((Object)$this$hint_u24lambda_u242)).append(this.start + "-" + this.end);
        String string = stringBuilder.toString();
        selectionContextAttachment.hint = (ObservableProperty)new AtomicProperty((Object)string);
        this.ellipse = "\u2026";
        $this$hint_u24lambda_u242 = ((Object)StringsKt.trim((CharSequence)((String)this.selectedText.unwrap()))).toString();
        selectionContextAttachment = this;
        boolean bl3 = false;
        it = new String[]{"\n"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)((CharSequence)text2), (String[])it, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable bl2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it2 = (String)element$iv$iv;
            boolean bl4 = false;
            boolean bl5 = !StringsKt.isBlank((CharSequence)it2);
            if (!bl5) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List lines = (List)destination$iv$iv;
        String linesContent = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)lines, (int)2), (CharSequence)"<br>", null, null, (int)0, null, arg_0 -> SelectionContextAttachment.tooltipText$lambda$5$lambda$4(this, arg_0), (int)30, null);
        String finalContent = lines.size() > 2 && !StringsKt.endsWith$default((String)linesContent, (String)this.ellipse, (boolean)false, (int)2, null) ? linesContent + this.ellipse : linesContent;
        selectionContextAttachment.tooltipText = "<html><b>" + this.getName().get() + "</b><br>" + finalContent + "</html>";
        this.popupPresentationText = "";
        Icon icon = this.attachmentIcon;
        if (icon == null) {
            Icon icon2 = AllIcons.FileTypes.Custom;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Custom");
        }
        this.icon = (ObservableProperty)new AtomicProperty((Object)icon);
        this.text = this.selectedText;
        this.id = ID + this.editorId;
        this.attachedBy = ContextAttachmentSource.SelectionRetriever.INSTANCE;
    }

    public /* synthetic */ SelectionContextAttachment(Project project, Editor editor, String string, String string2, String string3, Icon icon, PSString pSString, Integer n, Integer n2, String string4, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x200) != 0) {
            string4 = null;
        }
        this(project, editor, string, string2, string3, icon, pSString, n, n2, string4);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Nullable
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    protected final String getAttachmentName() {
        return this.attachmentName;
    }

    @Nullable
    protected final String getAdditionalHint() {
        return this.additionalHint;
    }

    @NotNull
    protected final String getEditorId() {
        return this.editorId;
    }

    @Nullable
    protected final Icon getAttachmentIcon() {
        return this.attachmentIcon;
    }

    @NotNull
    protected final PSString getSelectedText() {
        return this.selectedText;
    }

    @Nullable
    protected final Integer getStart() {
        return this.start;
    }

    @Nullable
    protected final Integer getEnd() {
        return this.end;
    }

    @Nullable
    public final String getChatSessionUid() {
        return this.chatSessionUid;
    }

    public SelectionContextAttachment(@NotNull SelectionContextAttachment originalAttachment) {
        Intrinsics.checkNotNullParameter((Object)originalAttachment, (String)"originalAttachment");
        this(originalAttachment.getProject(), originalAttachment.editor, (String)originalAttachment.getName().get(), (String)originalAttachment.getHint().get(), originalAttachment.editorId, (Icon)originalAttachment.getIcon().get(), originalAttachment.getText(), originalAttachment.start, originalAttachment.end, originalAttachment.chatSessionUid);
    }

    private final VirtualFile getVirtualFile() {
        Lazy lazy = this.virtualFile$delegate;
        return (VirtualFile)lazy.getValue();
    }

    @Override
    @NotNull
    public ObservableProperty<String> getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ObservableProperty<String> getHint() {
        return this.hint;
    }

    @Override
    @NotNull
    public String getTooltipText() {
        return this.tooltipText;
    }

    @Override
    @NotNull
    public String getPopupPresentationText() {
        return this.popupPresentationText;
    }

    @Override
    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        return new SelectionChatAttachment(this.getProject(), this.editor, this.attachmentName, this.additionalHint, this.editorId, this.attachmentIcon, this.selectedText, this.start, this.end, this.chatSessionUid);
    }

    @Override
    @NotNull
    public ObservableProperty<Icon> getIcon() {
        return this.icon;
    }

    @Override
    public void performAction(boolean isInMessage) {
        if (this.getVirtualFile().isValid()) {
            FileEditorManager.getInstance((Project)this.getProject()).openFile(this.getVirtualFile(), true);
        }
    }

    @Override
    @NotNull
    public PSString getText() {
        return this.text;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public ContextEntitySource getAttachedBy() {
        return this.attachedBy;
    }

    @Override
    @NotNull
    public VirtualFile virtualFile() {
        return this.getVirtualFile();
    }

    private static final VirtualFile virtualFile_delegate$lambda$0(SelectionContextAttachment this$0) {
        Editor editor = this$0.editor;
        if (editor == null || (editor = editor.getVirtualFile()) == null) {
            editor = (VirtualFile)new LightVirtualFile(this$0.attachmentName + " " + this$0.additionalHint, this$0.selectedText.unwrap());
        }
        return editor;
    }

    private static final CharSequence tooltipText$lambda$5$lambda$4(SelectionContextAttachment this$0, String it) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.length() > 80) {
            String string = it.substring(0, 80);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            charSequence = string + this$0.ellipse;
        } else {
            charSequence = it;
        }
        return charSequence;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/core/chat/context/selection/SelectionContextAttachment$Companion;", "", "<init>", "()V", "ID", "", "MAX_TOOLTIP_LENGTH", "", "MAX_ADDITIONAL_HINT_LENGTH", "intellij.ml.llm.chat"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

