/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.messages;

import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.VisibleChatAttachment;
import com.intellij.ml.llm.core.chat.messages.ChatMessage;
import com.intellij.ml.llm.core.chat.messages.CompletableMessage;
import com.intellij.ml.llm.core.chat.messages.MessageState;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a\u0010\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003\u001a\u0010\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001*\u00020\u0003\u001a\u0010\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\u0003\u001a\u0010\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007*\u00020\u0003\u001a\u0010\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0007*\u00020\u0003\u001a\u0010\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u0007*\u00020\u0003\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\n\u00a8\u0006\u000f"}, d2={"getStateFlow", "Lkotlinx/coroutines/flow/Flow;", "Lcom/intellij/ml/llm/core/chat/messages/MessageState;", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessage;", "getTextAndUpdatesFlow", "", "visibleAttachments", "", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "contextAttachments", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachment;", "automaticallyCollectedContextAttachments", "manuallyAttachedContextAttachments", "isAutomaticallyCollected", "", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nChatMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatMessage.kt\ncom/intellij/ml/llm/core/chat/messages/ChatMessageKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,121:1\n774#2:122\n865#2,2:123\n808#2,11:125\n1563#2:136\n1634#2,3:137\n774#2:140\n865#2,2:141\n774#2:143\n865#2,2:144\n19#3:146\n*S KotlinDebug\n*F\n+ 1 ChatMessage.kt\ncom/intellij/ml/llm/core/chat/messages/ChatMessageKt\n*L\n104#1:122\n104#1:123,2\n108#1:125,11\n108#1:136\n108#1:137,3\n112#1:140\n112#1:141,2\n116#1:143\n116#1:144,2\n120#1:146\n*E\n"})
public final class ChatMessageKt {
    @NotNull
    public static final Flow<MessageState> getStateFlow(@NotNull ChatMessage $this$getStateFlow) {
        Intrinsics.checkNotNullParameter((Object)$this$getStateFlow, (String)"<this>");
        return $this$getStateFlow instanceof CompletableMessage ? ((CompletableMessage)$this$getStateFlow).getStateFlow() : FlowKt.flowOf((Object)$this$getStateFlow.getState());
    }

    @NotNull
    public static final Flow<String> getTextAndUpdatesFlow(@NotNull ChatMessage $this$getTextAndUpdatesFlow) {
        Intrinsics.checkNotNullParameter((Object)$this$getTextAndUpdatesFlow, (String)"<this>");
        return $this$getTextAndUpdatesFlow instanceof CompletableMessage ? ((CompletableMessage)$this$getTextAndUpdatesFlow).getTextAndUpdatesFlow() : FlowKt.flowOf((Object)$this$getTextAndUpdatesFlow.getText().unwrap());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ChatAttachment> visibleAttachments(@NotNull ChatMessage $this$visibleAttachments) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$visibleAttachments, (String)"<this>");
        Iterable $this$filter$iv = $this$visibleAttachments.getAttachments();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ChatAttachment it = (ChatAttachment)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == ChatAttachment.Kind.Visible)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ContextAttachment> contextAttachments(@NotNull ChatMessage $this$contextAttachments) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$contextAttachments, (String)"<this>");
        Iterable $this$filterIsInstance$iv = $this$contextAttachments.getAttachments();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof VisibleChatAttachment)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VisibleChatAttachment visibleChatAttachment = (VisibleChatAttachment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toContextAttachment());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ContextAttachment> automaticallyCollectedContextAttachments(@NotNull ChatMessage $this$automaticallyCollectedContextAttachments) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$automaticallyCollectedContextAttachments, (String)"<this>");
        Iterable $this$filter$iv = ChatMessageKt.contextAttachments($this$automaticallyCollectedContextAttachments);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ContextAttachment it = (ContextAttachment)element$iv$iv;
            boolean bl = false;
            if (!ChatMessageKt.isAutomaticallyCollected(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ContextAttachment> manuallyAttachedContextAttachments(@NotNull ChatMessage $this$manuallyAttachedContextAttachments) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$manuallyAttachedContextAttachments, (String)"<this>");
        Iterable $this$filter$iv = ChatMessageKt.contextAttachments($this$manuallyAttachedContextAttachments);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ContextAttachment it = (ContextAttachment)element$iv$iv;
            boolean bl = false;
            if (!(!ChatMessageKt.isAutomaticallyCollected(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isAutomaticallyCollected(@NotNull ContextAttachment $this$isAutomaticallyCollected) {
        Intrinsics.checkNotNullParameter((Object)$this$isAutomaticallyCollected, (String)"<this>");
        ContextEntitySource $this$asSafely$iv = $this$isAutomaticallyCollected.getAttachedBy();
        boolean $i$f$asSafely = false;
        ContextEntitySource contextEntitySource = $this$asSafely$iv;
        if (!(contextEntitySource instanceof ContextAttachmentSource)) {
            contextEntitySource = null;
        }
        ContextAttachmentSource contextAttachmentSource = (ContextAttachmentSource)contextEntitySource;
        return contextAttachmentSource != null ? contextAttachmentSource.isAutomaticallyCollected() : false;
    }
}

