/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.messages.impl;

import ai.grazie.model.llm.prompt.LLMPromptID;
import com.intellij.lang.Language;
import com.intellij.ml.llm.context.ContextEntity;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.messages.ChatMessageAuthor;
import com.intellij.ml.llm.core.chat.messages.ChatMessageRating;
import com.intellij.ml.llm.core.chat.messages.MessageState;
import com.intellij.ml.llm.core.chat.messages.ReadyState;
import com.intellij.ml.llm.core.chat.messages.UserMessage;
import com.intellij.ml.llm.core.chat.messages.impl.AbstractChatMessage;
import com.intellij.ml.llm.core.chat.messages.impl.FunctionCall;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.models.api.AiChatMediaMessage;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B}\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\u0012\b\u0002\u0010\u0013\u001a\f\u0012\u0004\u0012\u00020\u00150\u0014j\u0002`\u0016\u0012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\t\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0018\u00103\u001a\u0002042\u0010\u00105\u001a\f\u0012\u0004\u0012\u00020\u00150\u0014j\u0002`\u0016J\u0018\u00106\u001a\u0002042\u0010\u00107\u001a\f\u0012\u0004\u0012\u00020\u00150\u0014j\u0002`\u0016J\u0016\u0010G\u001a\u0002042\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\b\u0010H\u001a\u000204H\u0016R\u0014\u0010\u0007\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\r\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001b\u0010\u0013\u001a\f\u0012\u0004\u0012\u00020\u00150\u0014j\u0002`\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001e\u0010-\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00150\u0014j\u0002`\u00160.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010/\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00150\u0014j\u0002`\u001600X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u00108\u001a\b\u0012\u0004\u0012\u00020\n09X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010:\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u001eR\u0014\u0010<\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\u001eR\u0014\u0010>\u001a\u00020?X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u001a\u0010B\u001a\b\u0012\u0004\u0012\u00020C09X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010*R\u001a\u0010E\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010*\u00a8\u0006I"}, d2={"Lcom/intellij/ml/llm/core/chat/messages/impl/UserMessageImpl;", "Lcom/intellij/ml/llm/core/chat/messages/impl/AbstractChatMessage;", "Lcom/intellij/ml/llm/core/chat/messages/UserMessage;", "chat", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "formattedDisplayText", "Lcom/intellij/ml/llm/privacy/PSString;", "formattedText", "initialAttachments", "", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "uid", "", "rating", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessageRating;", "markupLanguage", "Lcom/intellij/lang/Language;", "promptId", "Lai/grazie/model/llm/prompt/LLMPromptID;", "initialContext", "", "Lcom/intellij/ml/llm/context/ContextEntity;", "Lcom/intellij/ml/llm/context/ContextEntities;", "media", "Lcom/intellij/ml/llm/core/models/api/AiChatMediaMessage;", "messageInfo", "Lcom/intellij/openapi/util/UserDataHolder;", "<init>", "(Lcom/intellij/ml/llm/core/chat/session/ChatSession;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Ljava/util/List;Ljava/lang/String;Lcom/intellij/ml/llm/core/chat/messages/ChatMessageRating;Lcom/intellij/lang/Language;Lai/grazie/model/llm/prompt/LLMPromptID;Ljava/lang/Iterable;Ljava/util/List;Lcom/intellij/openapi/util/UserDataHolder;)V", "getFormattedText", "()Lcom/intellij/ml/llm/privacy/PSString;", "getRating", "()Lcom/intellij/ml/llm/core/chat/messages/ChatMessageRating;", "setRating", "(Lcom/intellij/ml/llm/core/chat/messages/ChatMessageRating;)V", "getMarkupLanguage", "()Lcom/intellij/lang/Language;", "getPromptId", "()Lai/grazie/model/llm/prompt/LLMPromptID;", "getInitialContext", "()Ljava/lang/Iterable;", "getMedia", "()Ljava/util/List;", "getMessageInfo", "()Lcom/intellij/openapi/util/UserDataHolder;", "_contextFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "contextFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getContextFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "setContextEntities", "", "newContext", "addContextEntities", "contextEntities", "_attachments", "", "displayText", "getDisplayText", "text", "getText", "state", "Lcom/intellij/ml/llm/core/chat/messages/MessageState;", "getState", "()Lcom/intellij/ml/llm/core/chat/messages/MessageState;", "functionCalls", "Lcom/intellij/ml/llm/core/chat/messages/impl/FunctionCall;", "getFunctionCalls", "attachments", "getAttachments", "addAttachments", "clearAttachments", "intellij.ml.llm.chat"})
public final class UserMessageImpl
extends AbstractChatMessage
implements UserMessage {
    @NotNull
    private final PSString formattedText;
    @NotNull
    private ChatMessageRating rating;
    @Nullable
    private final Language markupLanguage;
    @Nullable
    private final LLMPromptID promptId;
    @NotNull
    private final Iterable<ContextEntity> initialContext;
    @NotNull
    private final List<AiChatMediaMessage> media;
    @NotNull
    private final UserDataHolder messageInfo;
    @NotNull
    private final MutableStateFlow<Iterable<ContextEntity>> _contextFlow;
    @NotNull
    private final StateFlow<Iterable<ContextEntity>> contextFlow;
    @NotNull
    private final List<ChatAttachment> _attachments;
    @NotNull
    private final PSString displayText;
    @NotNull
    private final PSString text;
    @NotNull
    private final MessageState state;
    @NotNull
    private final List<FunctionCall> functionCalls;

    public UserMessageImpl(@NotNull ChatSession chat, @NotNull PSString formattedDisplayText, @NotNull PSString formattedText, @NotNull List<? extends ChatAttachment> initialAttachments, @NotNull String uid, @NotNull ChatMessageRating rating, @Nullable Language markupLanguage, @Nullable LLMPromptID promptId, @NotNull Iterable<? extends ContextEntity> initialContext, @NotNull List<AiChatMediaMessage> media, @NotNull UserDataHolder messageInfo) {
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter((Object)formattedDisplayText, (String)"formattedDisplayText");
        Intrinsics.checkNotNullParameter((Object)formattedText, (String)"formattedText");
        Intrinsics.checkNotNullParameter(initialAttachments, (String)"initialAttachments");
        Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
        Intrinsics.checkNotNullParameter((Object)((Object)rating), (String)"rating");
        Intrinsics.checkNotNullParameter(initialContext, (String)"initialContext");
        Intrinsics.checkNotNullParameter(media, (String)"media");
        Intrinsics.checkNotNullParameter((Object)messageInfo, (String)"messageInfo");
        super(chat, uid, ChatMessageAuthor.User);
        this.formattedText = formattedText;
        this.rating = rating;
        this.markupLanguage = markupLanguage;
        this.promptId = promptId;
        this.initialContext = initialContext;
        this.media = media;
        this.messageInfo = messageInfo;
        this._contextFlow = StateFlowKt.MutableStateFlow(this.initialContext);
        this.contextFlow = FlowKt.asStateFlow(this._contextFlow);
        this._attachments = CollectionsKt.toMutableList((Collection)initialAttachments);
        this.displayText = formattedDisplayText.toPSString();
        this.text = this.getFormattedText().toPSString();
        this.state = ReadyState.INSTANCE;
        this.functionCalls = new ArrayList();
    }

    public /* synthetic */ UserMessageImpl(ChatSession chatSession2, PSString pSString, PSString pSString2, List list, String string, ChatMessageRating chatMessageRating, Language language, LLMPromptID lLMPromptID, Iterable iterable, List list2, UserDataHolder userDataHolder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            iterable = new ArrayList();
        }
        if ((n & 0x400) != 0) {
            userDataHolder = (UserDataHolder)new UserDataHolderBase();
        }
        this(chatSession2, pSString, pSString2, list, string, chatMessageRating, language, lLMPromptID, iterable, list2, userDataHolder);
    }

    @Override
    @NotNull
    public PSString getFormattedText() {
        return this.formattedText;
    }

    @Override
    @NotNull
    public ChatMessageRating getRating() {
        return this.rating;
    }

    @Override
    public void setRating(@NotNull ChatMessageRating chatMessageRating) {
        Intrinsics.checkNotNullParameter((Object)((Object)chatMessageRating), (String)"<set-?>");
        this.rating = chatMessageRating;
    }

    @Override
    @Nullable
    public Language getMarkupLanguage() {
        return this.markupLanguage;
    }

    @Override
    @Nullable
    public LLMPromptID getPromptId() {
        return this.promptId;
    }

    @NotNull
    public final Iterable<ContextEntity> getInitialContext() {
        return this.initialContext;
    }

    @Override
    @NotNull
    public List<AiChatMediaMessage> getMedia() {
        return this.media;
    }

    @Override
    @NotNull
    public UserDataHolder getMessageInfo() {
        return this.messageInfo;
    }

    @Override
    @NotNull
    public StateFlow<Iterable<ContextEntity>> getContextFlow() {
        return this.contextFlow;
    }

    public final void setContextEntities(@NotNull Iterable<? extends ContextEntity> newContext) {
        Intrinsics.checkNotNullParameter(newContext, (String)"newContext");
        this._contextFlow.setValue(newContext);
    }

    public final void addContextEntities(@NotNull Iterable<? extends ContextEntity> contextEntities) {
        Intrinsics.checkNotNullParameter(contextEntities, (String)"contextEntities");
        List contextEntitiesList = new ArrayList();
        CollectionsKt.addAll((Collection)contextEntitiesList, (Iterable)((Iterable)this._contextFlow.getValue()));
        CollectionsKt.addAll((Collection)contextEntitiesList, contextEntities);
        this._contextFlow.setValue((Object)contextEntitiesList);
    }

    @Override
    @NotNull
    public PSString getDisplayText() {
        return this.displayText;
    }

    @Override
    @NotNull
    public PSString getText() {
        return this.text;
    }

    @Override
    @NotNull
    public MessageState getState() {
        return this.state;
    }

    @Override
    @NotNull
    public List<FunctionCall> getFunctionCalls() {
        return this.functionCalls;
    }

    @Override
    @NotNull
    public List<ChatAttachment> getAttachments() {
        return this._attachments;
    }

    @Override
    public void addAttachments(@NotNull List<? extends ChatAttachment> attachments) {
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        this._attachments.addAll((Collection<ChatAttachment>)attachments);
    }

    @Override
    public void clearAttachments() {
        this._attachments.clear();
    }
}

