/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.parts;

import com.intellij.ml.llm.core.chat.messages.MarkdownChatMessage;
import com.intellij.ml.llm.core.chat.messages.UserMessage;
import com.intellij.ml.llm.core.chat.parts.MessagePart;
import com.intellij.ml.llm.core.chat.parts.MessagePartContext;
import com.intellij.ml.llm.core.chat.parts.MessagePartFactory;
import com.intellij.ml.llm.core.chat.parts.MessagePartFactoryKt;
import com.intellij.ml.llm.core.chat.parts.RangeNotFound;
import com.intellij.ml.llm.core.chat.parts.SnippetFileNamePart;
import com.intellij.ml.llm.core.chat.parts.SnippetFileNamePartKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Range;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/core/chat/parts/SnippetFileNamePartFactory;", "Lcom/intellij/ml/llm/core/chat/parts/MessagePartFactory;", "<init>", "()V", "isApplicable", "", "context", "Lcom/intellij/ml/llm/core/chat/parts/MessagePartContext;", "getStartMarkerIndex", "Lcom/intellij/util/Range;", "", "Lcom/intellij/ml/llm/core/chat/parts/MessagePartRange;", "text", "", "getEndMarkerIndex", "currentPart", "Lcom/intellij/ml/llm/core/chat/parts/MessagePart;", "createMessagePart", "intellij.ml.llm.chat"})
public final class SnippetFileNamePartFactory
implements MessagePartFactory {
    @Override
    public boolean isApplicable(@NotNull MessagePartContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Registry.Companion.is("llm.chat.tag.snippets.with.file.names") && context.getMessage() instanceof MarkdownChatMessage && !(context.getMessage() instanceof UserMessage);
    }

    @Override
    @NotNull
    public Range<Integer> getStartMarkerIndex(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return MessagePartFactoryKt.markerRange(text2, (String)SnippetFileNamePartKt.getSNIPPET_NAME_START().unwrap());
    }

    @Override
    @NotNull
    public Range<Integer> getEndMarkerIndex(@Nullable MessagePart currentPart, @NotNull String text2) {
        int endIndex;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        String tag = (String)SnippetFileNamePartKt.getSNIPPET_NAME_END().unwrap();
        int index = StringsKt.indexOf$default((CharSequence)text2, (String)tag, (int)0, (boolean)false, (int)6, null);
        if (index < 0) {
            return RangeNotFound.INSTANCE;
        }
        for (endIndex = index + tag.length(); endIndex < text2.length() && CharsKt.isWhitespace((char)text2.charAt(endIndex)); ++endIndex) {
        }
        return new Range((Comparable)Integer.valueOf(index), (Comparable)Integer.valueOf(endIndex));
    }

    @Override
    @NotNull
    public MessagePart createMessagePart(@NotNull MessagePartContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new SnippetFileNamePart(context.getMessage());
    }
}

