/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.promptLibrary.core.modelView;

import com.intellij.ml.llm.core.chat.promptLibrary.AICustomizablePrompt;
import com.intellij.ml.llm.core.chat.promptLibrary.core.modelView.AILibraryPromptModelView;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPrompt;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPromptService;
import com.intellij.ml.llm.core.promptLibrary.variables.AIAssistantPromptLibraryVariable;
import com.intellij.ml.llm.privacy.PSString;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001f\u0010\f\u001a\r\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0016\u0010\u0018\u001a\u00070\t\u00a2\u0006\u0002\b\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000bR\u0016\u0010\u001a\u001a\u00070\t\u00a2\u0006\u0002\b\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000bR\u0011\u0010\u001d\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lcom/intellij/ml/llm/core/chat/promptLibrary/core/modelView/AISystemPromptModelView;", "Lcom/intellij/ml/llm/core/chat/promptLibrary/core/modelView/AILibraryPromptModelView;", "prompt", "Lcom/intellij/ml/llm/core/chat/promptLibrary/core/systemPrompts/AISystemLibraryPrompt;", "<init>", "(Lcom/intellij/ml/llm/core/chat/promptLibrary/core/systemPrompts/AISystemLibraryPrompt;)V", "customization", "Lcom/intellij/ml/llm/core/chat/promptLibrary/AICustomizablePrompt;", "id", "", "getId", "()Ljava/lang/String;", "name", "Lkotlinx/coroutines/flow/StateFlow;", "Lorg/jetbrains/annotations/Nls;", "getName", "()Lkotlinx/coroutines/flow/StateFlow;", "content", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/ml/llm/privacy/PSString;", "getContent", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "isDefault", "", "groupName", "getGroupName", "displayDescription", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "getDisplayDescription", "defaultPrompt", "getDefaultPrompt", "()Lcom/intellij/ml/llm/privacy/PSString;", "variables", "", "Lcom/intellij/ml/llm/core/promptLibrary/variables/AIAssistantPromptLibraryVariable;", "getVariables", "()Ljava/util/List;", "intellij.ml.llm.chat"})
public final class AISystemPromptModelView
implements AILibraryPromptModelView {
    @NotNull
    private final AICustomizablePrompt customization;
    @NotNull
    private final String id;
    @NotNull
    private final StateFlow<String> name;
    @NotNull
    private final MutableStateFlow<PSString> content;
    @NotNull
    private final MutableStateFlow<Boolean> isDefault;
    @NotNull
    private final String groupName;
    @NotNull
    private final String displayDescription;
    @NotNull
    private final PSString defaultPrompt;
    @NotNull
    private final List<AIAssistantPromptLibraryVariable> variables;

    public AISystemPromptModelView(@NotNull AISystemLibraryPrompt prompt2) {
        Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
        AICustomizablePrompt aICustomizablePrompt = AICustomizablePrompt.Companion.getCustomizablePrompt(prompt2.getId());
        if (aICustomizablePrompt == null) {
            throw new IllegalStateException();
        }
        this.customization = aICustomizablePrompt;
        this.id = prompt2.getId();
        this.name = FlowKt.asStateFlow((MutableStateFlow)StateFlowKt.MutableStateFlow((Object)this.customization.getDisplayName()));
        this.content = StateFlowKt.MutableStateFlow((Object)prompt2.getContent());
        this.isDefault = StateFlowKt.MutableStateFlow((Object)AISystemLibraryPromptService.Companion.isDefault(prompt2));
        this.groupName = this.customization.getGroupName();
        this.displayDescription = this.customization.getDetailedDescription();
        this.defaultPrompt = this.customization.getDefaultPrompt();
        this.variables = this.customization.getPromptVariables();
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public StateFlow<String> getName() {
        return this.name;
    }

    @Override
    @NotNull
    public MutableStateFlow<PSString> getContent() {
        return this.content;
    }

    @NotNull
    public final MutableStateFlow<Boolean> isDefault() {
        return this.isDefault;
    }

    @NotNull
    public final String getGroupName() {
        return this.groupName;
    }

    @NotNull
    public final String getDisplayDescription() {
        return this.displayDescription;
    }

    @NotNull
    public final PSString getDefaultPrompt() {
        return this.defaultPrompt;
    }

    @NotNull
    public final List<AIAssistantPromptLibraryVariable> getVariables() {
        return this.variables;
    }
}

