/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat;

import com.intellij.markdown.utils.MarkdownToHtmlConverterKt;
import com.intellij.ml.llm.core.chat.ui.chat.MessagePartView;
import com.intellij.ml.llm.core.chat.ui.chat.TextPartView;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.text.html.HTML;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0004\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0001\u001a\u0018\u0010\b\u001a\u00020\t*\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\r\u001a\u00020\t*\u00060\nj\u0002`\u000b2\u0006\u0010\u000e\u001a\u00020\u0001H\u0002\u001a\f\u0010\u000f\u001a\u00020\u0001*\u00020\u0010H\u0002\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u001a\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\u00020\u0015H\u0002\u001a\u0012\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\u00020\u0015H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"PART_MARKER", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "chatConvertMarkdownToHtml", "textPartView", "Lcom/intellij/ml/llm/core/chat/ui/chat/TextPartView;", "markdownText", "wrapWithMarkersIfNeeded", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "text", "appendMarker", "marker", "getLastLineIndent", "", "extractConsideringMarkers", "html", "fixHtmlNumberedListIfNeeded", "Lkotlin/sequences/Sequence;", "Lorg/jsoup/nodes/Node;", "parentsSequence", "siblingsSequence", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nChatMarkdownConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatMarkdownConverter.kt\ncom/intellij/ml/llm/core/chat/ui/chat/ChatMarkdownConverterKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,120:1\n1869#2,2:121\n295#2,2:123\n967#2,7:126\n1#3:125\n14#4:133\n*S KotlinDebug\n*F\n+ 1 ChatMarkdownConverter.kt\ncom/intellij/ml/llm/core/chat/ui/chat/ChatMarkdownConverterKt\n*L\n25#1:121,2\n87#1:123,2\n106#1:126,7\n15#1:133\n*E\n"})
public final class ChatMarkdownConverterKt {
    @NotNull
    private static final String PART_MARKER = "TEXT_PART_VIEW_START";
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final String chatConvertMarkdownToHtml(@Nullable TextPartView textPartView, @NlsSafe @NotNull String markdownText) {
        MessagePartView previousTextPartView;
        Intrinsics.checkNotNullParameter((Object)markdownText, (String)"markdownText");
        List previousViews = new ArrayList();
        TextPartView textPartView2 = textPartView;
        MessagePartView messagePartView = previousTextPartView = textPartView2 != null ? textPartView2.getPrevious() : null;
        while (previousTextPartView != null) {
            previousViews.add(0, previousTextPartView);
            previousTextPartView = previousTextPartView.getPrevious();
        }
        StringBuilder preparedMarkdownText = new StringBuilder();
        Iterable $this$forEach$iv = previousViews;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MessagePartView partView = (MessagePartView)element$iv;
            boolean bl = false;
            if (!(((CharSequence)preparedMarkdownText).length() == 0) && !StringsKt.endsWith$default((CharSequence)preparedMarkdownText, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                preparedMarkdownText.append("\n");
            }
            preparedMarkdownText.append(partView.getPart().getTextContent());
        }
        ChatMarkdownConverterKt.wrapWithMarkersIfNeeded(preparedMarkdownText, markdownText);
        try {
            String string;
            String string2 = preparedMarkdownText.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String html = string = MarkdownToHtmlConverterKt.convertMarkdownToHtml((String)string2);
            boolean bl = false;
            String string3 = ChatMarkdownConverterKt.extractConsideringMarkers(html);
            if (string3 != null) {
                String it = string3;
                boolean bl2 = false;
                return it;
            }
        }
        catch (Throwable e) {
            LOG.error("Failed to convert Markdown to HTML", e);
        }
        return MarkdownToHtmlConverterKt.convertMarkdownToHtml((String)markdownText);
    }

    private static final void wrapWithMarkersIfNeeded(StringBuilder $this$wrapWithMarkersIfNeeded, String text2) {
        if (((CharSequence)$this$wrapWithMarkersIfNeeded).length() == 0) {
            $this$wrapWithMarkersIfNeeded.append(text2);
            return;
        }
        ChatMarkdownConverterKt.appendMarker($this$wrapWithMarkersIfNeeded, "```\n  TEXT_PART_VIEW_START\n```");
        $this$wrapWithMarkersIfNeeded.append(text2);
    }

    private static final void appendMarker(StringBuilder $this$appendMarker, String marker) {
        String indent = ChatMarkdownConverterKt.getLastLineIndent($this$appendMarker);
        if (!StringsKt.endsWith$default((CharSequence)$this$appendMarker, (CharSequence)"\n", (boolean)false, (int)2, null)) {
            $this$appendMarker.append("\n");
        }
        $this$appendMarker.append(StringsKt.prependIndent((String)marker, (String)indent)).append("\n");
    }

    private static final String getLastLineIndent(CharSequence $this$getLastLineIndent) {
        if ($this$getLastLineIndent.length() == 0) {
            return "";
        }
        int startOfLastLine = StringsKt.lastIndexOf$default((CharSequence)$this$getLastLineIndent, (char)'\n', (int)($this$getLastLineIndent.length() - (StringsKt.endsWith$default((CharSequence)$this$getLastLineIndent, (CharSequence)"\n", (boolean)false, (int)2, null) ? 2 : 1)), (boolean)false, (int)4, null) + 1;
        int indentSize = 0;
        int n = $this$getLastLineIndent.length();
        for (int i = startOfLastLine; i < n && Character.isWhitespace($this$getLastLineIndent.charAt(i)); ++i) {
            ++indentSize;
        }
        return StringsKt.repeat((CharSequence)" ", (int)indentSize);
    }

    private static final String extractConsideringMarkers(String html) {
        if (StringsKt.contains$default((CharSequence)html, (CharSequence)PART_MARKER, (boolean)false, (int)2, null)) {
            Object v3;
            block4: {
                Document document = Jsoup.parse((String)html);
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
                Document jsoupHtml = document;
                Elements elements = jsoupHtml.getElementsByTag(HTML.Tag.CODE.toString());
                Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"getElementsByTag(...)");
                Elements targetNodes = elements;
                Iterable $this$firstOrNull$iv = (Iterable)targetNodes;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Element it = (Element)element$iv;
                    boolean bl = false;
                    String string = it.text();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
                    String trimmedContent = ((Object)StringsKt.trim((CharSequence)string)).toString();
                    if (!Intrinsics.areEqual((Object)trimmedContent, (Object)PART_MARKER)) continue;
                    v3 = element$iv;
                    break block4;
                }
                v3 = null;
            }
            Element element = v3;
            if (element == null) {
                return null;
            }
            Element markerNode = element;
            List list = SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.mapNotNull(ChatMarkdownConverterKt.parentsSequence((Node)markerNode), ChatMarkdownConverterKt::extractConsideringMarkers$lambda$4), ChatMarkdownConverterKt::extractConsideringMarkers$lambda$5));
            Collection p0 = list;
            boolean bl = false;
            List list2 = !p0.isEmpty() ? list : null;
            if (list2 == null) {
                return null;
            }
            List contentNodes = list2;
            String extractedHtml = CollectionsKt.joinToString$default((Iterable)contentNodes, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            LOG.trace(extractedHtml);
            return extractedHtml;
        }
        return html;
    }

    private static final Sequence<Node> fixHtmlNumberedListIfNeeded(Sequence<? extends Node> $this$fixHtmlNumberedListIfNeeded) {
        Object object;
        Node li;
        block11: {
            block10: {
                Node it;
                Object object2;
                block9: {
                    block8: {
                        Node node;
                        object2 = (Node)SequencesKt.firstOrNull($this$fixHtmlNumberedListIfNeeded);
                        if (object2 == null) break block8;
                        it = node = object2;
                        boolean bl = false;
                        object2 = it.nameIs(HTML.Tag.LI.toString()) ? node : null;
                        if (object2 != null) break block9;
                    }
                    return $this$fixHtmlNumberedListIfNeeded;
                }
                li = object2;
                object = li.parent();
                if (object == null) break block10;
                Node it2 = it = object;
                boolean bl = false;
                object = it2.nameIs(HTML.Tag.OL.toString()) ? it : null;
                if (object != null) break block11;
            }
            return $this$fixHtmlNumberedListIfNeeded;
        }
        Node ol = object;
        List list = ol.childNodes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"childNodes(...)");
        Iterable $this$takeWhile$iv = list;
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            Node it = (Node)item$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)li))) break;
            list$iv.add(item$iv);
        }
        int liIndex = ((Collection)list$iv).size() + 1;
        Attributes attrs = new Attributes();
        if (liIndex > 1) {
            attrs.put(new Attribute("start", String.valueOf(liIndex)));
        }
        Element newWrappingOL = new Element(Tag.valueOf((String)"ol"), null, attrs);
        newWrappingOL.appendChildren((Collection)SequencesKt.toList($this$fixHtmlNumberedListIfNeeded));
        return SequencesKt.sequenceOf((Object)newWrappingOL);
    }

    private static final Sequence<Node> parentsSequence(Node $this$parentsSequence) {
        return SequencesKt.generateSequence((Object)$this$parentsSequence, ChatMarkdownConverterKt::parentsSequence$lambda$9);
    }

    private static final Sequence<Node> siblingsSequence(Node $this$siblingsSequence) {
        return SequencesKt.generateSequence((Object)$this$siblingsSequence, ChatMarkdownConverterKt::siblingsSequence$lambda$10);
    }

    private static final Node extractConsideringMarkers$lambda$4(Node it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.nextSibling();
    }

    private static final Sequence extractConsideringMarkers$lambda$5(Node it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ChatMarkdownConverterKt.fixHtmlNumberedListIfNeeded(ChatMarkdownConverterKt.siblingsSequence(it));
    }

    private static final Node parentsSequence$lambda$9(Node it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.parent();
    }

    private static final Node siblingsSequence$lambda$10(Node it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.nextSibling();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TextPartView.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

