/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat;

import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.core.chat.ui.AIAssistantColors;
import com.intellij.ml.llm.core.chat.ui.chat.ScrollPaneWithFollowButtonKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.util.ui.MacUIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import javax.swing.Icon;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/ScrollPaneFollowButton;", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "scrollPane", "Ljavax/swing/JScrollPane;", "<init>", "(Ljavax/swing/JScrollPane;)V", "getScrollPane", "()Ljavax/swing/JScrollPane;", "paintComponent", "", "g", "Ljava/awt/Graphics;", "updateButtonVisibility", "intellij.ml.llm.chat"})
final class ScrollPaneFollowButton
extends ActionButton {
    @NotNull
    private final JScrollPane scrollPane;

    public ScrollPaneFollowButton(final @NotNull JScrollPane scrollPane) {
        Intrinsics.checkNotNullParameter((Object)scrollPane, (String)"scrollPane");
        Icon icon = AllIcons.Chooser.Bottom;
        super(new AnAction(icon){

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                scrollPane.getVerticalScrollBar().setValue(scrollPane.getVerticalScrollBar().getMaximum());
            }
        }, null, "unknown", ScrollPaneFollowButton::_init_$lambda$0);
        this.scrollPane = scrollPane;
        this.scrollPane.getViewport().addChangeListener(arg_0 -> ScrollPaneFollowButton._init_$lambda$1(this, arg_0));
        this.setOpaque(false);
        this.updateButtonVisibility();
    }

    @NotNull
    public final JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            int diameter = ScrollPaneWithFollowButtonKt.access$getScaledDiameter();
            g2.setColor((Color)AIAssistantColors.INSTANCE.getUSER_MESSAGE_BACKGROUND$intellij_ml_llm_chat());
            g2.fillOval(0, 0, diameter, diameter);
            g2.setColor((Color)AIAssistantColors.INSTANCE.getHELP_BROWSER_USER_MESSAGE_SNIPPET_BORDER$intellij_ml_llm_chat());
            g2.drawOval(0, 0, diameter - 1, diameter - 1);
            Ellipse2D.Double circle = new Ellipse2D.Double(0.0, 0.0, diameter, diameter);
            g2.clip(circle);
            super.paintComponent((Graphics)g2);
        }
        finally {
            g2.dispose();
        }
    }

    private final void updateButtonVisibility() {
        JScrollBar scrollBar = this.scrollPane.getVerticalScrollBar();
        this.setVisible(scrollBar.getMaximum() > scrollBar.getVisibleAmount() && scrollBar.getValue() < scrollBar.getMaximum() - scrollBar.getVisibleAmount() - 60);
    }

    private static final Dimension _init_$lambda$0() {
        return new Dimension(28, 28);
    }

    private static final void _init_$lambda$1(ScrollPaneFollowButton this$0, ChangeEvent it) {
        this$0.updateButtonVisibility();
    }
}

