/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context.attachments;

import ai.grazie.model.cloud.ContentType;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.core.chat.context.web.WebSearchAttachmentIconBuilder;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.AiChatMediaCacheService;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.AiChatMediaCacheServiceKt;
import com.intellij.ml.llm.core.models.api.AiChatMediaMessage;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import io.ktor.util.Base64Kt;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.time.Duration;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.vfs.IfsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\u0013J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0010\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0018\u001a\u00020\fH\u0082@\u00a2\u0006\u0002\u0010\u0013J$\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 \u0018\u00010\u001e2\u0006\u0010\u0018\u001a\u00020\fH\u0082@\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\n\u001a\u0018\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b\r\u0012\t\u0012\u00070\u000e\u00a2\u0006\u0002\b\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/AiChatMediaCacheService;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/AiChatMediaCacheService$MediaCache;", "getMediaCache", "virtualFile", "getIcon", "Ljavax/swing/Icon;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMedia", "", "Lcom/intellij/ml/llm/core/models/api/AiChatMediaMessage;", "buildIcon", "file", "buildMedia", "MAX_IMAGE_SIZE", "", "MAX_RESOLUTION", "prepareImage", "Lkotlin/Pair;", "", "Lai/grazie/model/cloud/ContentType;", "MediaCache", "intellij.ml.llm.chat"})
public final class AiChatMediaCacheService {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Cache<VirtualFile, MediaCache> cache;
    private final int MAX_IMAGE_SIZE;
    private final int MAX_RESOLUTION;

    public AiChatMediaCacheService(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        Cache cache2 = Caffeine.newBuilder().maximumSize(100L).expireAfterAccess(Duration.ofMinutes(1L)).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"build(...)");
        this.cache = cache2;
        this.MAX_IMAGE_SIZE = 0x300000;
        this.MAX_RESOLUTION = 1000;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    private final MediaCache getMediaCache(VirtualFile virtualFile2) {
        Object object = this.cache.get((Object)virtualFile2, arg_0 -> AiChatMediaCacheService.getMediaCache$lambda$3(arg_0 -> AiChatMediaCacheService.getMediaCache$lambda$2(virtualFile2, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (MediaCache)object;
    }

    @Nullable
    public final Object getIcon(@NotNull VirtualFile virtualFile2, @NotNull Continuation<? super Icon> $completion) {
        return FlowKt.first(this.getMediaCache(virtualFile2).getIcon(), $completion);
    }

    @Nullable
    public final Object getMedia(@NotNull VirtualFile virtualFile2, @NotNull Continuation<? super List<AiChatMediaMessage>> $completion) {
        return FlowKt.first(this.getMediaCache(virtualFile2).getPreparedMedia(), $completion);
    }

    private final Icon buildIcon(VirtualFile file) {
        BufferedImage bufferedImage;
        try {
            bufferedImage = IfsUtil.getImage((VirtualFile)file);
        }
        catch (FileTooBigException fileTooBigException) {
            bufferedImage = null;
        }
        BufferedImage image = bufferedImage;
        if (image == null) {
            Icon icon = file.getFileType().getIcon();
            if (icon == null) {
                Icon icon2 = AllIcons.FileTypes.Unknown;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Unknown");
                return icon2;
            }
            return icon;
        }
        Icon imageIcon = WebSearchAttachmentIconBuilder.INSTANCE.buildIcon(image, true);
        return imageIcon;
    }

    /*
     * Unable to fully structure code
     */
    private final Object buildMedia(VirtualFile file, Continuation<? super List<AiChatMediaMessage>> $completion) {
        if (!($completion instanceof buildMedia.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AiChatMediaCacheService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AiChatMediaCacheService.access$buildMedia(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!file.isValid()) {
                    return CollectionsKt.emptyList();
                }
                if (file.isDirectory()) {
                    return CollectionsKt.emptyList();
                }
                if (!ImageFileTypeManager.getInstance().isImage(file)) break;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)file);
                $continuation.label = 1;
                v0 = this.prepareImage(file, (Continuation<? super Pair<byte[], ContentType>>)$continuation);
                if (v0 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                file = (VirtualFile)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                v1 = (Pair)v0;
                if (v1 == null) {
                    return CollectionsKt.emptyList();
                }
                var3_6 = v1;
                image = (byte[])var3_6.component1();
                contentType = (ContentType)var3_6.component2();
                data = Base64Kt.encodeBase64((byte[])image);
                message = new AiChatMediaMessage(contentType, data);
                return CollectionsKt.listOf((Object)message);
            }
        }
        return CollectionsKt.emptyList();
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object prepareImage(VirtualFile file, Continuation<? super Pair<byte[], ContentType>> $completion) {
        ContentType contentType = AiChatMediaCacheServiceKt.mediaContentType(file);
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends byte[], ? extends ContentType>>, Object>(file, this, contentType, null){
            int label;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ AiChatMediaCacheService this$0;
            final /* synthetic */ ContentType $contentType;
            {
                this.$file = $file;
                this.this$0 = $receiver;
                this.$contentType = $contentType;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Pair pair;
                        ResultKt.throwOnFailure((Object)$result);
                        long fileSize = this.$file.getLength();
                        if (fileSize < (long)AiChatMediaCacheService.access$getMAX_IMAGE_SIZE$p(this.this$0) && this.$contentType != null) {
                            return TuplesKt.to((Object)VirtualFileUtil.readBytes((VirtualFile)this.$file), (Object)this.$contentType);
                        }
                        if (VirtualFileUtil.isTooLarge((VirtualFile)this.$file)) {
                            return null;
                        }
                        BufferedImage bufferedImage = IfsUtil.getImage((VirtualFile)this.$file);
                        if (bufferedImage == null) {
                            return null;
                        }
                        BufferedImage originalImage = bufferedImage;
                        if (originalImage.getWidth() > AiChatMediaCacheService.access$getMAX_RESOLUTION$p(this.this$0) || originalImage.getHeight() > AiChatMediaCacheService.access$getMAX_RESOLUTION$p(this.this$0)) {
                            double ratio = (double)originalImage.getWidth() / (double)originalImage.getHeight();
                            int newWidth = 0;
                            int newHeight = 0;
                            if (originalImage.getWidth() > originalImage.getHeight()) {
                                newWidth = AiChatMediaCacheService.access$getMAX_RESOLUTION$p(this.this$0);
                                newHeight = (int)((double)AiChatMediaCacheService.access$getMAX_RESOLUTION$p(this.this$0) / ratio);
                            } else {
                                newHeight = AiChatMediaCacheService.access$getMAX_RESOLUTION$p(this.this$0);
                                newWidth = (int)((double)AiChatMediaCacheService.access$getMAX_RESOLUTION$p(this.this$0) * ratio);
                            }
                            pair = TuplesKt.to((Object)Boxing.boxInt((int)newWidth), (Object)Boxing.boxInt((int)newHeight));
                        } else {
                            pair = TuplesKt.to((Object)Boxing.boxInt((int)originalImage.getWidth()), (Object)Boxing.boxInt((int)originalImage.getHeight()));
                        }
                        Pair pair2 = pair;
                        int width = ((Number)pair2.component1()).intValue();
                        int height = ((Number)pair2.component2()).intValue();
                        BufferedImage resized = new BufferedImage(width, height, 1);
                        Graphics2D g2d = resized.createGraphics();
                        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        g2d.drawImage(originalImage, 0, 0, width, height, null);
                        g2d.dispose();
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)resized, "JPEG", byteArrayOutputStream);
                        byte[] data2 = byteArrayOutputStream.toByteArray();
                        if (data2.length > AiChatMediaCacheService.access$getMAX_IMAGE_SIZE$p(this.this$0)) {
                            throw new IllegalStateException("Image is too large");
                        }
                        return TuplesKt.to((Object)data2, (Object)ContentType.Image.INSTANCE.getJPEG());
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Pair<byte[], ContentType>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private static final MediaCache getMediaCache$lambda$2(VirtualFile $virtualFile, AiChatMediaCacheService this$0, VirtualFile key) {
        MutableSharedFlow mutableSharedFlow;
        MutableSharedFlow mutableSharedFlow2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        MutableSharedFlow it = mutableSharedFlow2 = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, null, (int)6, null);
        boolean bl = false;
        BuildersKt.launch$default((CoroutineScope)this$0.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((MutableSharedFlow<Icon>)it, this$0, $virtualFile, null){
            int label;
            final /* synthetic */ MutableSharedFlow<Icon> $it;
            final /* synthetic */ AiChatMediaCacheService this$0;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.$it = $it;
                this.this$0 = $receiver;
                this.$virtualFile = $virtualFile;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$it.emit((Object)AiChatMediaCacheService.access$buildIcon(this.this$0, this.$virtualFile), (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        MutableSharedFlow iconFlow2 = mutableSharedFlow2;
        MutableSharedFlow it2 = mutableSharedFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, null, (int)6, null);
        boolean bl2 = false;
        BuildersKt.launch$default((CoroutineScope)this$0.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((MutableSharedFlow<List<AiChatMediaMessage>>)it2, this$0, $virtualFile, null){
            Object L$0;
            int label;
            final /* synthetic */ MutableSharedFlow<List<AiChatMediaMessage>> $it;
            final /* synthetic */ AiChatMediaCacheService this$0;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.$it = $it;
                this.this$0 = $receiver;
                this.$virtualFile = $virtualFile;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = var2_3 = this.$it;
                        this.label = 1;
                        v0 = AiChatMediaCacheService.access$buildMedia(this.this$0, this.$virtualFile, (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        var2_3 = (MutableSharedFlow<List<AiChatMediaMessage>>)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 2;
                        v1 = var2_3.emit(v0, (Continuation)this);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        MutableSharedFlow mediaFlow2 = mutableSharedFlow;
        return new MediaCache($virtualFile, (Flow<? extends Icon>)((Flow)iconFlow2), (Flow<? extends List<AiChatMediaMessage>>)((Flow)mediaFlow2));
    }

    private static final MediaCache getMediaCache$lambda$3(Function1 $tmp0, Object p0) {
        return (MediaCache)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Object access$buildMedia(AiChatMediaCacheService $this, VirtualFile file, Continuation $completion) {
        return $this.buildMedia(file, (Continuation<? super List<AiChatMediaMessage>>)$completion);
    }

    public static final /* synthetic */ Object access$prepareImage(AiChatMediaCacheService $this, VirtualFile file, Continuation $completion) {
        return $this.prepareImage(file, (Continuation<? super Pair<byte[], ContentType>>)$completion);
    }

    public static final /* synthetic */ int access$getMAX_IMAGE_SIZE$p(AiChatMediaCacheService $this) {
        return $this.MAX_IMAGE_SIZE;
    }

    public static final /* synthetic */ int access$getMAX_RESOLUTION$p(AiChatMediaCacheService $this) {
        return $this.MAX_RESOLUTION;
    }

    public static final /* synthetic */ Icon access$buildIcon(AiChatMediaCacheService $this, VirtualFile file) {
        return $this.buildIcon(file);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u0015\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005H\u00c6\u0003J9\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/AiChatMediaCacheService$MediaCache;", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "icon", "Lkotlinx/coroutines/flow/Flow;", "Ljavax/swing/Icon;", "preparedMedia", "", "Lcom/intellij/ml/llm/core/models/api/AiChatMediaMessage;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlinx/coroutines/flow/Flow;Lkotlinx/coroutines/flow/Flow;)V", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getIcon", "()Lkotlinx/coroutines/flow/Flow;", "getPreparedMedia", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.chat"})
    private static final class MediaCache {
        @NotNull
        private final VirtualFile virtualFile;
        @NotNull
        private final Flow<Icon> icon;
        @NotNull
        private final Flow<List<AiChatMediaMessage>> preparedMedia;

        public MediaCache(@NotNull VirtualFile virtualFile2, @NotNull Flow<? extends Icon> icon, @NotNull Flow<? extends List<AiChatMediaMessage>> preparedMedia) {
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            Intrinsics.checkNotNullParameter(icon, (String)"icon");
            Intrinsics.checkNotNullParameter(preparedMedia, (String)"preparedMedia");
            this.virtualFile = virtualFile2;
            this.icon = icon;
            this.preparedMedia = preparedMedia;
        }

        @NotNull
        public final VirtualFile getVirtualFile() {
            return this.virtualFile;
        }

        @NotNull
        public final Flow<Icon> getIcon() {
            return this.icon;
        }

        @NotNull
        public final Flow<List<AiChatMediaMessage>> getPreparedMedia() {
            return this.preparedMedia;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.virtualFile;
        }

        @NotNull
        public final Flow<Icon> component2() {
            return this.icon;
        }

        @NotNull
        public final Flow<List<AiChatMediaMessage>> component3() {
            return this.preparedMedia;
        }

        @NotNull
        public final MediaCache copy(@NotNull VirtualFile virtualFile2, @NotNull Flow<? extends Icon> icon, @NotNull Flow<? extends List<AiChatMediaMessage>> preparedMedia) {
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            Intrinsics.checkNotNullParameter(icon, (String)"icon");
            Intrinsics.checkNotNullParameter(preparedMedia, (String)"preparedMedia");
            return new MediaCache(virtualFile2, icon, preparedMedia);
        }

        public static /* synthetic */ MediaCache copy$default(MediaCache mediaCache, VirtualFile virtualFile2, Flow flow, Flow flow2, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile2 = mediaCache.virtualFile;
            }
            if ((n & 2) != 0) {
                flow = mediaCache.icon;
            }
            if ((n & 4) != 0) {
                flow2 = mediaCache.preparedMedia;
            }
            return mediaCache.copy(virtualFile2, flow, flow2);
        }

        @NotNull
        public String toString() {
            return "MediaCache(virtualFile=" + this.virtualFile + ", icon=" + this.icon + ", preparedMedia=" + this.preparedMedia + ")";
        }

        public int hashCode() {
            int result2 = this.virtualFile.hashCode();
            result2 = result2 * 31 + this.icon.hashCode();
            result2 = result2 * 31 + this.preparedMedia.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MediaCache)) {
                return false;
            }
            MediaCache mediaCache = (MediaCache)other;
            if (!Intrinsics.areEqual((Object)this.virtualFile, (Object)mediaCache.virtualFile)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.icon, mediaCache.icon)) {
                return false;
            }
            return Intrinsics.areEqual(this.preparedMedia, mediaCache.preparedMedia);
        }
    }
}

