/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context.attachments;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.FileChatAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.AiChatMediaCacheService;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentBase;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.FileContextAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ProjectFileContextEntity;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.UtilKt;
import com.intellij.ml.llm.core.models.api.AiChatMediaMessage;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.PSStringOperatorsKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.BinaryLightVirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.intellij.images.fileTypes.impl.ImageFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 G2\u00020\u00012\u00020\u0002:\u0002GHB6\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0015\b\u0002\u0010\t\u001a\u000f\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0002\b\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\n\u00100\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u00101\u001a\u0004\u0018\u00010\u0006H\u0082@\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u0004\u0018\u000104H\u0096@\u00a2\u0006\u0002\u00102J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u000206H\u0016J\u0013\u0010:\u001a\u0002062\b\u0010;\u001a\u0004\u0018\u00010<H\u0096\u0002J\b\u0010=\u001a\u00020>H\u0016J\b\u0010?\u001a\u00020\u000bH\u0016J\b\u0010@\u001a\u000206H\u0004J\u0016\u0010A\u001a\u0002062\u0006\u0010\u0005\u001a\u00020\u0006H\u0082@\u00a2\u0006\u0002\u0010BJ\u0014\u0010C\u001a\b\u0012\u0004\u0012\u00020E0DH\u0096@\u00a2\u0006\u0002\u00102J\u000e\u0010F\u001a\u000204H\u0084@\u00a2\u0006\u0002\u00102R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R!\u0010\t\u001a\u000f\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0002\b\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001f\u0010\u0017\u001a\r\u0012\t\u0012\u00070\u000b\u00a2\u0006\u0002\b\f0\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010!R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001aR\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010!R\u0016\u0010.\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010!R\u001a\u00105\u001a\b\u0012\u0004\u0012\u0002060\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u001a\u00a8\u0006I"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/FileContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentBase;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ProjectFileContextEntity;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "attachedBy", "Lcom/intellij/ml/llm/context/ContextEntitySource;", "hint", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/ml/llm/context/ContextEntitySource;Lcom/intellij/openapi/observable/properties/ObservableProperty;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getAttachedBy", "()Lcom/intellij/ml/llm/context/ContextEntitySource;", "getHint", "()Lcom/intellij/openapi/observable/properties/ObservableProperty;", "name", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "getName", "()Lcom/intellij/openapi/observable/properties/AtomicProperty;", "text", "Lcom/intellij/ml/llm/privacy/PSString;", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "id", "getId", "()Ljava/lang/String;", "popupPresentationText", "getPopupPresentationText", "icon", "Ljavax/swing/Icon;", "getIcon", "mediaService", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/AiChatMediaCacheService;", "fileCopyFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/FileContextAttachment$FileCopyState;", "tooltipText", "getTooltipText", "popupHintText", "getPopupHintText", "virtualFile", "waitForVirtualFileCopyOrNull", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "isVisible", "", "performAction", "", "isInMessage", "equals", "other", "", "hashCode", "", "toString", "isMedia", "isOutOfProject", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createMediaMessages", "", "Lcom/intellij/ml/llm/core/models/api/AiChatMediaMessage;", "createMediaAttachment", "Companion", "FileCopyState", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nFileContextAttachment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileContextAttachment.kt\ncom/intellij/ml/llm/core/chat/ui/chat/context/attachments/FileContextAttachment\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n30#2,2:238\n1#3:240\n*S KotlinDebug\n*F\n+ 1 FileContextAttachment.kt\ncom/intellij/ml/llm/core/chat/ui/chat/context/attachments/FileContextAttachment\n*L\n83#1:238,2\n*E\n"})
public class FileContextAttachment
extends ContextAttachmentBase
implements ProjectFileContextEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final ContextEntitySource attachedBy;
    @Nullable
    private final ObservableProperty<String> hint;
    @NotNull
    private final AtomicProperty<String> name;
    @NotNull
    private final String popupPresentationText;
    @NotNull
    private final AtomicProperty<Icon> icon;
    @NotNull
    private final AiChatMediaCacheService mediaService;
    @NotNull
    private final MutableStateFlow<FileCopyState> fileCopyFlow;
    @NotNull
    private final AtomicProperty<Boolean> isVisible;

    public FileContextAttachment(@NotNull Project project, @NotNull VirtualFile file, @NotNull ContextEntitySource attachedBy, @Nullable ObservableProperty<String> hint) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)attachedBy, (String)"attachedBy");
        this.project = project;
        this.file = file;
        this.attachedBy = attachedBy;
        this.hint = hint;
        this.name = new AtomicProperty((Object)this.file.getName());
        String string = this.file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.popupPresentationText = string;
        Icon icon = this.file.getFileType().getIcon();
        if (icon == null) {
            Icon icon2 = AllIcons.FileTypes.Unknown;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Unknown");
        }
        this.icon = new AtomicProperty((Object)icon);
        ComponentManager $this$service$iv = (ComponentManager)this.getProject();
        boolean $i$f$service = false;
        Class<AiChatMediaCacheService> serviceClass$iv = AiChatMediaCacheService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.mediaService = (AiChatMediaCacheService)object;
        this.fileCopyFlow = StateFlowKt.MutableStateFlow((Object)FileCopyState.NotReady.INSTANCE);
        BuildersKt.launch$default((CoroutineScope)this.mediaService.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ FileContextAttachment this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!this.this$0.getFile().isValid() || !this.this$0.isMedia()) break;
                        this.label = 1;
                        v0 = FileContextAttachment.access$isOutOfProject(this.this$0, this.this$0.getFile(), (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        if (!((Boolean)v0).booleanValue()) break;
                        v1 = this.this$0.getFile().contentsToByteArray();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"contentsToByteArray(...)");
                        content = v1;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)content);
                        this.label = 2;
                        v2 = FileContextAttachment.access$getFileCopyFlow$p(this.this$0).emit((Object)new FileCopyState.Ready((VirtualFile)new BinaryLightVirtualFile(this.this$0.getFile().getName(), (FileType)ImageFileType.INSTANCE, content)), (Continuation)this);
                        ** if (v2 != var3_2) goto lbl25
lbl24:
                        // 1 sources

                        return var3_2;
lbl25:
                        // 1 sources

                        ** GOTO lbl53
                    }
                    case 2: {
                        content = (byte[])this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                            ** GOTO lbl53
                        }
                        catch (FileTooBigException <unused var>) {
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)<unused var>);
                            this.label = 3;
                            v3 = FileContextAttachment.access$getFileCopyFlow$p(this.this$0).emit((Object)FileCopyState.NotSaved.INSTANCE, (Continuation)this);
                            if (v3 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl53
                        }
                    }
                    case 3: {
                        <unused var> = (FileTooBigException)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
                        ** GOTO lbl53
                    }
                }
                this.label = 4;
                v4 = FileContextAttachment.access$getFileCopyFlow$p(this.this$0).emit((Object)FileCopyState.NotSaved.INSTANCE, (Continuation)this);
                if (v4 == var3_2) {
                    return var3_2;
                }
                ** GOTO lbl53
                {
                    case 4: {
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl53:
                        // 6 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        if (this.isMedia()) {
            BuildersKt.launch$default((CoroutineScope)this.mediaService.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                int label;
                final /* synthetic */ FileContextAttachment this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.L$0 = var2_3 = this.this$0.getIcon();
                            this.label = 1;
                            v0 = FileContextAttachment.access$getMediaService$p(this.this$0).getIcon(this.this$0.getFile(), (Continuation<? super Icon>)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl15
                        }
                        case 1: {
                            var2_3 = (AtomicProperty<Icon>)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl15:
                            // 2 sources

                            var2_3.set(v0);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        this.isVisible = new AtomicProperty((Object)true);
    }

    public /* synthetic */ FileContextAttachment(Project project, VirtualFile virtualFile2, ContextEntitySource contextEntitySource, ObservableProperty observableProperty, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            observableProperty = null;
        }
        this(project, virtualFile2, contextEntitySource, (ObservableProperty<String>)observableProperty);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public ContextEntitySource getAttachedBy() {
        return this.attachedBy;
    }

    @Override
    @Nullable
    public ObservableProperty<String> getHint() {
        return this.hint;
    }

    @NotNull
    public AtomicProperty<String> getName() {
        return this.name;
    }

    @Override
    @NotNull
    public PSString getText() {
        return (PSString)ActionsKt.runReadAction(() -> FileContextAttachment._get_text_$lambda$0(this));
    }

    @NotNull
    public String getId() {
        Object object;
        if (this.file instanceof LightVirtualFileBase) {
            object = ((LightVirtualFileBase)this.file).getPath() + ":" + ((LightVirtualFileBase)this.file).getLength();
        } else {
            String string = this.file.getPath();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        }
        return object;
    }

    @Override
    @NotNull
    public String getPopupPresentationText() {
        return this.popupPresentationText;
    }

    @NotNull
    public AtomicProperty<Icon> getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getTooltipText() {
        return UtilKt.toProjectRelativePath(this.getProject(), this.virtualFile());
    }

    @Override
    @Nullable
    public String getPopupHintText() {
        return this.getTooltipText();
    }

    @Override
    @Nullable
    public VirtualFile virtualFile() {
        VirtualFile virtualFile2;
        VirtualFile it = virtualFile2 = this.file;
        boolean bl = false;
        Object object = it.isValid() ? virtualFile2 : null;
        if (object == null) {
            Object object2 = this.fileCopyFlow.getValue();
            FileCopyState.Ready ready = object2 instanceof FileCopyState.Ready ? (FileCopyState.Ready)object2 : null;
            object = ready != null ? ready.getFileCopy() : null;
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    private final Object waitForVirtualFileCopyOrNull(Continuation<? super VirtualFile> $completion) {
        if (!($completion instanceof waitForVirtualFileCopyOrNull.1)) ** GOTO lbl-1000
        var6_2 = $completion;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ FileContextAttachment this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return FileContextAttachment.access$waitForVirtualFileCopyOrNull(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = FlowKt.first((Flow)((Flow)this.fileCopyFlow), (Function2)((Function2)new Function2<FileCopyState, Continuation<? super Boolean>, Object>(null){
                    int label;
                    /* synthetic */ Object L$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        FileCopyState fileCopyState = (FileCopyState)this.L$0;
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void it;
                                ResultKt.throwOnFailure((Object)$result);
                                return Boxing.boxBoolean((!(it instanceof FileCopyState.NotReady) ? 1 : 0) != 0);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(FileCopyState p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                it = (FileCopyState)v0;
                $i$a$-let-FileContextAttachment$waitForVirtualFileCopyOrNull$3 = false;
                var2_7 = it instanceof FileCopyState.Ready ? (FileCopyState.Ready)it : null;
                return var2_7 != null ? var2_7.getFileCopy() : null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        return FileContextAttachment.createChatAttachment$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object createChatAttachment$suspendImpl(FileContextAttachment $this, Continuation<? super ChatAttachment> $completion) {
        if (!($completion instanceof createChatAttachment.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ FileContextAttachment this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return FileContextAttachment.createChatAttachment$suspendImpl(this.this$0, (Continuation<? super ChatAttachment>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!$this.isMedia()) break;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.label = 1;
                v0 = $this.createMediaAttachment((Continuation<? super ChatAttachment>)$continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                $this = (FileContextAttachment)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                return v0;
            }
        }
        $continuation.L$0 = $this;
        $continuation.label = 2;
        v1 = $this.waitForVirtualFileCopyOrNull((Continuation<? super VirtualFile>)$continuation);
        if (v1 == var6_4) {
            return var6_4;
        }
        ** GOTO lbl34
        {
            case 2: {
                $this = (FileContextAttachment)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl34:
                // 2 sources

                if ((v2 = (VirtualFile)v1) == null && (v2 = $this.virtualFile()) == null) {
                    return null;
                }
                virtualFile = v2;
                language = LanguageUtil.getFileLanguage((VirtualFile)virtualFile);
                v3 = $this.getProject();
                v4 = ExtensionsKtKt.getPrivacySafe((VirtualFile)virtualFile).getName();
                v5 = language;
                if (v5 == null || (v5 = ExtensionsKtKt.getPrivacySafe((Language)v5)) == null || (v5 = v5.getDisplayName()) == null || (v5 = v5.lowercase()) == null) {
                    v5 = ConstantsKt.getEMPTY();
                }
                return new FileChatAttachment(v3, virtualFile, v4, PSStringOperatorsKt.wrapCodeIntoMarkdownSnippet((PSString)v5, (PSString)$this.getText()), $this.getText(), language, ChatAttachment.Kind.Visible, $this.getAttachedBy());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public AtomicProperty<Boolean> isVisible() {
        return this.isVisible;
    }

    @Override
    public void performAction(boolean isInMessage) {
        VirtualFile virtualFile2 = this.virtualFile();
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile file = virtualFile2;
        if (file.isValid()) {
            FileEditorManager.getInstance((Project)this.getProject()).openFile(file, true);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.ml.llm.core.chat.ui.chat.context.attachments.FileContextAttachment");
        FileContextAttachment cfr_ignored_0 = (FileContextAttachment)other;
        if (!Intrinsics.areEqual((Object)this.getProject(), (Object)((FileContextAttachment)other).getProject())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.file, (Object)((FileContextAttachment)other).file)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getAttachedBy(), (Object)((FileContextAttachment)other).getAttachedBy())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getId(), (Object)((FileContextAttachment)other).getId());
    }

    public int hashCode() {
        int result2 = this.getProject().hashCode();
        result2 = 31 * result2 + this.file.hashCode();
        result2 = 31 * result2 + this.getAttachedBy().hashCode();
        result2 = 31 * result2 + this.getId().hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return "FileContextAttachment(file=" + this.file.getName() + ", attachedBy=" + this.getAttachedBy() + ", id='" + this.getId() + "')";
    }

    protected final boolean isMedia() {
        return FileTypeRegistry.getInstance().isFileOfType(this.file, (FileType)ImageFileType.INSTANCE);
    }

    private final Object isOutOfProject(VirtualFile file, Continuation<? super Boolean> $completion) {
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex index = projectFileIndex;
        return CoroutinesKt.readAction(() -> FileContextAttachment.isOutOfProject$lambda$3(index, file), $completion);
    }

    @Override
    @Nullable
    public Object createMediaMessages(@NotNull Continuation<? super List<AiChatMediaMessage>> $completion) {
        return FileContextAttachment.createMediaMessages$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object createMediaMessages$suspendImpl(FileContextAttachment $this, Continuation<? super List<AiChatMediaMessage>> $completion) {
        if (!$this.isMedia()) {
            return CollectionsKt.emptyList();
        }
        return $this.mediaService.getMedia($this.file, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected final Object createMediaAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        if (!($completion instanceof createMediaAttachment.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ FileContextAttachment this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createMediaAttachment((Continuation<? super ChatAttachment>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.waitForVirtualFileCopyOrNull((Continuation<? super VirtualFile>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                if ((v1 = (VirtualFile)v0) == null && (v1 = this.virtualFile()) == null) {
                    throw new IllegalStateException("Media file was not found: " + this.file.getPath());
                }
                virtualFile = v1;
                return new FileChatAttachment(this.getProject(), virtualFile, ExtensionsKtKt.getPrivacySafe((VirtualFile)virtualFile).getName(), ConstantsKt.getEMPTY(), ConstantsKt.getEMPTY(), null, ChatAttachment.Kind.Visible, this.getAttachedBy());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final PSString _get_text_$lambda$0(FileContextAttachment this$0) {
        PSString pSString;
        VirtualFile virtualFile2 = this$0.virtualFile();
        if (virtualFile2 == null) {
            return ConstantsKt.getPrivacyConst((String)"");
        }
        VirtualFile virtualFile3 = virtualFile2;
        if (!virtualFile3.isValid()) {
            return ConstantsKt.getPrivacyConst((String)"");
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager fileDocManager = fileDocumentManager;
        if (fileDocManager.isFileModified(virtualFile3)) {
            pSString = fileDocManager.getDocument(virtualFile3, this$0.getProject());
            if (pSString == null || (pSString = ExtensionsKtKt.privacySafe((Document)pSString, (Project)this$0.getProject())) == null || (pSString = pSString.getText()) == null) {
                pSString = ConstantsKt.getPrivacyConst((String)"");
            }
        } else {
            pSString = ExtensionsKtKt.privacySafe((VirtualFile)virtualFile3, (Project)this$0.getProject()).readText();
        }
        return pSString;
    }

    private static final boolean isOutOfProject$lambda$3(ProjectFileIndex $index, VirtualFile $file) {
        return !$index.isInContent($file) && !$index.isInLibraryClasses($file) && !$index.isInLibrarySource($file);
    }

    public static final /* synthetic */ Object access$waitForVirtualFileCopyOrNull(FileContextAttachment $this, Continuation $completion) {
        return $this.waitForVirtualFileCopyOrNull((Continuation<? super VirtualFile>)$completion);
    }

    public static final /* synthetic */ Object access$isOutOfProject(FileContextAttachment $this, VirtualFile file, Continuation $completion) {
        return $this.isOutOfProject(file, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ MutableStateFlow access$getFileCopyFlow$p(FileContextAttachment $this) {
        return $this.fileCopyFlow;
    }

    public static final /* synthetic */ AiChatMediaCacheService access$getMediaService$p(FileContextAttachment $this) {
        return $this.mediaService;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/FileContextAttachment$Companion;", "", "<init>", "()V", "isAllowedToAddImages", "", "intellij.ml.llm.chat"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAllowedToAddImages() {
            return Registry.Companion.is("llm.chat.context.images.enabled") || ApplicationManager.getApplication().isInternal();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/FileContextAttachment$FileCopyState;", "", "NotReady", "Ready", "NotSaved", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/FileContextAttachment$FileCopyState$NotReady;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/FileContextAttachment$FileCopyState$NotSaved;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/FileContextAttachment$FileCopyState$Ready;", "intellij.ml.llm.chat"})
    private static interface FileCopyState {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/FileContextAttachment$FileCopyState$NotReady;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/FileContextAttachment$FileCopyState;", "<init>", "()V", "intellij.ml.llm.chat"})
        public static final class NotReady
        implements FileCopyState {
            @NotNull
            public static final NotReady INSTANCE = new NotReady();

            private NotReady() {
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/FileContextAttachment$FileCopyState$NotSaved;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/FileContextAttachment$FileCopyState;", "<init>", "()V", "intellij.ml.llm.chat"})
        public static final class NotSaved
        implements FileCopyState {
            @NotNull
            public static final NotSaved INSTANCE = new NotSaved();

            private NotSaved() {
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/FileContextAttachment$FileCopyState$Ready;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/FileContextAttachment$FileCopyState;", "fileCopy", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFileCopy", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.ml.llm.chat"})
        public static final class Ready
        implements FileCopyState {
            @NotNull
            private final VirtualFile fileCopy;

            public Ready(@NotNull VirtualFile fileCopy) {
                Intrinsics.checkNotNullParameter((Object)fileCopy, (String)"fileCopy");
                this.fileCopy = fileCopy;
            }

            @NotNull
            public final VirtualFile getFileCopy() {
                return this.fileCopy;
            }

            @NotNull
            public final VirtualFile component1() {
                return this.fileCopy;
            }

            @NotNull
            public final Ready copy(@NotNull VirtualFile fileCopy) {
                Intrinsics.checkNotNullParameter((Object)fileCopy, (String)"fileCopy");
                return new Ready(fileCopy);
            }

            public static /* synthetic */ Ready copy$default(Ready ready, VirtualFile virtualFile2, int n, Object object) {
                if ((n & 1) != 0) {
                    virtualFile2 = ready.fileCopy;
                }
                return ready.copy(virtualFile2);
            }

            @NotNull
            public String toString() {
                return "Ready(fileCopy=" + this.fileCopy + ")";
            }

            public int hashCode() {
                return this.fileCopy.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Ready)) {
                    return false;
                }
                Ready ready = (Ready)other;
                return Intrinsics.areEqual((Object)this.fileCopy, (Object)ready.fileCopy);
            }
        }
    }
}

