/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context.attachments;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.SelectionChatAttachment;
import com.intellij.ml.llm.core.chat.services.AIAssistantServiceScope;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentBase;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentSource;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ProjectFileContextEntity;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.PSStringOperatorsKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.testFramework.LightVirtualFile;
import java.lang.invoke.LambdaMetafactory;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 92\u00020\u00012\u00020\u0002:\u00019B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010/\u001a\u000200H\u0096@\u00a2\u0006\u0002\u00101J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\n\u00106\u001a\u0004\u0018\u000107H\u0016J\b\u00108\u001a\u00020\u0015H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u001a\u0010\u001e\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020\u0015X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0017R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0017\u00a8\u0006:"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/SelectionContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentBase;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ProjectFileContextEntity;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startPosition", "", "endPosition", "selectedText", "Lcom/intellij/ml/llm/privacy/PSString;", "attachedBy", "Lcom/intellij/ml/llm/context/ContextEntitySource;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;IILcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/context/ContextEntitySource;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getAttachedBy", "()Lcom/intellij/ml/llm/context/ContextEntitySource;", "id", "", "getId", "()Ljava/lang/String;", "name", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "getName", "()Lcom/intellij/openapi/observable/properties/AtomicProperty;", "hint", "getHint", "text", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "setText", "(Lcom/intellij/ml/llm/privacy/PSString;)V", "language", "Lcom/intellij/lang/Language;", "popupPresentationText", "getPopupPresentationText", "icon", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "Ljavax/swing/Icon;", "getIcon", "()Lcom/intellij/openapi/observable/properties/ObservableProperty;", "fileName", "tooltipText", "getTooltipText", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performAction", "", "isInMessage", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "calculateHint", "Companion", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nSelectionContextAttachment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionContextAttachment.kt\ncom/intellij/ml/llm/core/chat/ui/chat/context/attachments/SelectionContextAttachment\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public final class SelectionContextAttachment
extends ContextAttachmentBase
implements ProjectFileContextEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    private final int startPosition;
    private final int endPosition;
    @NotNull
    private final PSString selectedText;
    @NotNull
    private final ContextEntitySource attachedBy;
    @NotNull
    private final AtomicProperty<String> name;
    @NotNull
    private final AtomicProperty<String> hint;
    @NotNull
    private PSString text;
    @Nullable
    private Language language;
    @NotNull
    private final String popupPresentationText;
    @NotNull
    private final String fileName;
    @NotNull
    private static final String PREFIX = "Selection";
    @NotNull
    public static final String ID = "CURRENT_SELECTION_VIA_RETRIEVER";

    public SelectionContextAttachment(@NotNull Project project, @NotNull Editor editor, int startPosition, int endPosition, @NotNull PSString selectedText, @NotNull ContextEntitySource attachedBy) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)selectedText, (String)"selectedText");
        Intrinsics.checkNotNullParameter((Object)attachedBy, (String)"attachedBy");
        this.project = project;
        this.editor = editor;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.selectedText = selectedText;
        this.attachedBy = attachedBy;
        this.name = new AtomicProperty((Object)PREFIX);
        this.hint = new AtomicProperty((Object)this.calculateHint());
        this.text = this.selectedText;
        this.popupPresentationText = "Current selection";
        VirtualFile virtualFile2 = this.editor.getVirtualFile();
        Intrinsics.checkNotNull((Object)virtualFile2);
        String string = virtualFile2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.fileName = string;
    }

    public /* synthetic */ SelectionContextAttachment(Project project, Editor editor, int n, int n2, PSString pSString, ContextEntitySource contextEntitySource, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x20) != 0) {
            contextEntitySource = ContextAttachmentSource.CurrentSelectionRetriever.INSTANCE;
        }
        this(project, editor, n, n2, pSString, contextEntitySource);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public ContextEntitySource getAttachedBy() {
        return this.attachedBy;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public AtomicProperty<String> getName() {
        return this.name;
    }

    @NotNull
    public AtomicProperty<String> getHint() {
        return this.hint;
    }

    @Override
    @NotNull
    public PSString getText() {
        return this.text;
    }

    public void setText(@NotNull PSString pSString) {
        Intrinsics.checkNotNullParameter((Object)pSString, (String)"<set-?>");
        this.text = pSString;
    }

    @Override
    @NotNull
    public String getPopupPresentationText() {
        return this.popupPresentationText;
    }

    @Override
    @NotNull
    public ObservableProperty<Icon> getIcon() {
        return (ObservableProperty)new AtomicProperty((Object)AllIcons.FileTypes.Custom);
    }

    @Override
    @NotNull
    public String getTooltipText() {
        return this.fileName + " " + this.startPosition + "-" + this.endPosition;
    }

    @Override
    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        Project project = this.getProject();
        PSString pSString = ConstantsKt.getPrivacyConst((String)PREFIX);
        Language language = this.language;
        if (language == null || (language = ExtensionsKtKt.getPrivacySafe((Language)language)) == null || (language = language.getDisplayName()) == null || (language = language.lowercase()) == null) {
            language = ConstantsKt.getEMPTY();
        }
        return new SelectionChatAttachment(project, this.editor, this.startPosition, this.endPosition, pSString, PSStringOperatorsKt.wrapCodeIntoMarkdownSnippet((PSString)language, (PSString)this.getText()), this.language, this.getAttachedBy(), ChatAttachment.Kind.Visible);
    }

    @Override
    public void performAction(boolean isInMessage) {
        VirtualFile file = this.editor.getVirtualFile();
        if (isInMessage) {
            BuildersKt.launch$default((CoroutineScope)AIAssistantServiceScope.Companion.getScope(this.getProject()), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ SelectionContextAttachment this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = SelectionContextAttachment.access$getEditor$p(this.this$0).getVirtualFile();
                            if (v0 == null) {
                                return Unit.INSTANCE;
                            }
                            selectionFile = v0;
                            v1 = PsiManager.getInstance((Project)this.this$0.getProject());
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                            psiManager = v1;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)selectionFile);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)psiManager);
                            this.label = 1;
                            v2 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.psi.PsiManager com.intellij.openapi.vfs.VirtualFile ), ()Lcom/intellij/psi/PsiFile;)((PsiManager)psiManager, (VirtualFile)selectionFile), (Continuation)((Continuation)this));
                            if (v2 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl24
                        }
                        case 1: {
                            psiManager = (PsiManager)this.L$1;
                            selectionFile = (VirtualFile)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl24:
                            // 2 sources

                            v3 = (PsiFile)v2;
                            if (v3 == null) {
                                return Unit.INSTANCE;
                            }
                            psiFile = v3;
                            if (Intrinsics.areEqual((Object)ExtensionsKtKt.getPrivacySafe((PsiNamedElement)((PsiNamedElement)psiFile)).getText().unwrap(), (Object)psiFile.getText())) {
                                v4 = SelectionContextAttachment.access$performAction$getOpenedSelectionFile(this.this$0, (String)SelectionContextAttachment.access$getSelectedText$p(this.this$0).unwrap());
                                if (v4 == null) {
                                    v4 = (VirtualFile)new LightVirtualFile("Selection", (CharSequence)SelectionContextAttachment.access$getSelectedText$p(this.this$0));
                                }
                                if (!(file = v4).isValid()) {
                                    return Unit.INSTANCE;
                                }
                                ActionsKt.runInEdt$default(null, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$1(com.intellij.ml.llm.core.chat.ui.chat.context.attachments.SelectionContextAttachment com.intellij.openapi.vfs.VirtualFile ), ()Lkotlin/Unit;)((SelectionContextAttachment)this.this$0, (VirtualFile)file), (int)1, null);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final PsiFile invokeSuspend$lambda$0(PsiManager $psiManager, VirtualFile $selectionFile) {
                    return $psiManager.findFile($selectionFile);
                }

                private static final Unit invokeSuspend$lambda$1(SelectionContextAttachment this$0, VirtualFile $file) {
                    FileEditorManager.getInstance((Project)this$0.getProject()).openFile($file, true);
                    return Unit.INSTANCE;
                }
            }), (int)3, null);
        } else {
            VirtualFile virtualFile2 = file;
            boolean bl = virtualFile2 != null ? virtualFile2.isValid() : false;
            if (bl) {
                FileEditorManager.getInstance((Project)this.getProject()).openFile(file, true);
            }
        }
    }

    @Override
    @Nullable
    public VirtualFile virtualFile() {
        return this.editor.getVirtualFile();
    }

    private final String calculateHint() {
        return this.startPosition + "-" + this.endPosition;
    }

    private static final VirtualFile performAction$getOpenedSelectionFile(SelectionContextAttachment this$0, String currentText) {
        Object object;
        block3: {
            VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)this$0.getProject()).getOpenFiles();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
            for (Object object2 : (Object[])virtualFileArray) {
                VirtualFile it = (VirtualFile)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)PREFIX)) continue;
                object = object2;
                break block3;
            }
            object = null;
        }
        VirtualFile virtualFile2 = (VirtualFile)object;
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)VfsUtil.loadText((VirtualFile)it), (Object)currentText)) {
                return it;
            }
        }
        return null;
    }

    public static final /* synthetic */ Editor access$getEditor$p(SelectionContextAttachment $this) {
        return $this.editor;
    }

    public static final /* synthetic */ VirtualFile access$performAction$getOpenedSelectionFile(SelectionContextAttachment this$0, String currentText) {
        return SelectionContextAttachment.performAction$getOpenedSelectionFile(this$0, currentText);
    }

    public static final /* synthetic */ PSString access$getSelectedText$p(SelectionContextAttachment $this) {
        return $this.selectedText;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/SelectionContextAttachment$Companion;", "", "<init>", "()V", "PREFIX", "", "ID", "intellij.ml.llm.chat"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

